﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using System.Runtime.Serialization;
using System.Runtime.Serialization.Formatters.Binary;

namespace nispi.WriteToThread
{
    [Serializable]
    class WriteData
    {
        public string threadDatAddress = "";
        public string titleName = "";
        public string writeAddress = "";
        public string boardID = "";
        public string boardName = "";
        public string boardUrl = "";
        public string threadID = "";
        public string threadUrl = "";
        //public string threadName = "";
        public string serverTime = "";
        public string postData = "";
        public string buttonText = "書き込む";

        public string htmlData = "";

        public string nameText = "";
        public string mailText = "";
        public string contentsText = "";

        //next2ch用
        public string token = "";

        public WriteData(string threadDatAddress, string titleName)
        {
            this.threadDatAddress = threadDatAddress;
            this.boardID = Util.DatUrlToBoardID(threadDatAddress);
            this.boardUrl = Util.DatUrlToBoardUrl(threadDatAddress);
            this.boardName = BoardDataBase.GetName(boardUrl);
            this.threadID = Util.DatUrlToThreadID(threadDatAddress);
            this.threadUrl = Util.DatUrlToThreadUrl(threadDatAddress);
            //this.threadName = threadName;
            this.writeAddress = Util.DatUrlToWriteUrl(threadDatAddress);

            this.titleName = titleName;

            //if (Util.BoardType(threadDatAddress) == Util.TYPE_NEXT2CH)
            //    buttonText = "投稿";
        }

        //クローン作製で参考に使用したサイト：http://smdn.jp/programming/netfx/cloning/
        public T CloneObject<T>(T source)
        {
            // バイナリシリアライズによってsourceの複製を作成する
            using (MemoryStream stream = new MemoryStream())
            {
                BinaryFormatter f = new BinaryFormatter();

                f.Serialize(stream, source);

                stream.Position = 0L;

                return (T)f.Deserialize(stream);
            }
        }
    }
}
