﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.Threading;

using System.Windows.Forms;
using nispi.controlclass;

namespace nispi
{
    class BoardIndexTreeViewMainMenu:BoardIndexTreeViewMenuMethod
    {
        //TreeViewParts treeView = null;

        public ToolStripMenuItemParts menuItemOpenParts;
        public ToolStripMenuItemParts menuItemAddFavoriteParts;
        public ToolStripMenuItemParts menuItemCopyURLParts;
        public ToolStripMenuItemParts menuItemCopyTitleParts;
        public ToolStripMenuItemParts menuItemOpenBrowserParts;
        public ToolStripMenuItemParts menuItemReloadParts;

        public BoardIndexTreeViewMenuEvent boardIndexTreeViewMenuEvent;

        public BoardIndexTreeViewMainMenu(ToolStripMenuItemParts menuItem)
        {
            //メインメニューセットアップ
            menuItemOpenParts = ToolStripMenuItemPartsManager.Pop();
            menuItemAddFavoriteParts = ToolStripMenuItemPartsManager.Pop();
            menuItemCopyURLParts = ToolStripMenuItemPartsManager.Pop();
            menuItemCopyTitleParts = ToolStripMenuItemPartsManager.Pop();
            menuItemOpenBrowserParts = ToolStripMenuItemPartsManager.Pop();
            menuItemReloadParts = ToolStripMenuItemPartsManager.Pop();


            menuItemOpenParts.Text = "開く(&E)";

            menuItemAddFavoriteParts.Text = "お気に入りに追加する(&F)(CTRL+F)";

            menuItemCopyURLParts.Text = "URLをコピー(&C)";

            menuItemCopyTitleParts.Text = "板の名前をコピー(&T)";

            menuItemOpenBrowserParts.Text = "ブラウザで開く(&B)";
            menuItemOpenBrowserParts.Image = Resources.browser;
            menuItemOpenBrowserParts.ImageTransparentColor = Color.White;

            menuItemReloadParts.Text = "再読み込み(&R)(CTRL+R)";
            menuItemReloadParts.Image = Resources.reload;
            menuItemReloadParts.ImageTransparentColor = Color.White;

            menuItem.DropDownItemsAdd(menuItemOpenParts);
            menuItem.DropDownItemsAdd(menuItemOpenBrowserParts);
            menuItem.DropDownItemsAdd(menuItemAddFavoriteParts);
            menuItem.DropDownItemsAdd("-");
            menuItem.DropDownItemsAdd(menuItemCopyURLParts);
            menuItem.DropDownItemsAdd(menuItemCopyTitleParts);
            menuItem.DropDownItemsAdd("-");
            menuItem.DropDownItemsAdd(menuItemReloadParts);

            boardIndexTreeViewMenuEvent = new BoardIndexTreeViewMenuEvent(this);
        }

        public void SetMainMenu()
        {
            //お気に入りか、２ｃｈのインデックスか
            if (Const.form.boardIndexTabControlParts.SelectedIndex <= 8)
            {
                if (Const.form.boardIndexTabControlParts.SelectedIndex == 0)
                    treeViewParts = MainFormConst.boardIndexTabMain.boardIndexView.boardIndexControls.treeViewParts;
                else if (Const.form.boardIndexTabControlParts.SelectedIndex == 1)
                    treeViewParts = MainFormConst.boardIndexTabMain.scBoardIndexView.boardIndexControls.treeViewParts;
                else if (Const.form.boardIndexTabControlParts.SelectedIndex == 2)
                    treeViewParts = MainFormConst.boardIndexTabMain.open2chBoardIndexView.boardIndexControls.treeViewParts;
                else if (Const.form.boardIndexTabControlParts.SelectedIndex == 3)
                    treeViewParts = MainFormConst.boardIndexTabMain.next2chBoardIndexView.boardIndexControls.treeViewParts;

                else if (Const.form.boardIndexTabControlParts.SelectedIndex == 4)
                    treeViewParts = MainFormConst.boardIndexTabMain.jikkyoBoardIndexView.boardIndexControls.treeViewParts;
                else if (Const.form.boardIndexTabControlParts.SelectedIndex == 5)
                    treeViewParts = MainFormConst.boardIndexTabMain.blogbanBoardIndexView.boardIndexControls.treeViewParts;
                else if (Const.form.boardIndexTabControlParts.SelectedIndex == 6)
                    treeViewParts = MainFormConst.boardIndexTabMain.shizuBoardIndexView.boardIndexControls.treeViewParts;

                else if (Const.form.boardIndexTabControlParts.SelectedIndex == 7)
                    treeViewParts = MainFormConst.boardIndexTabMain.vip2chBoardIndexView.boardIndexControls.treeViewParts;
                else if (Const.form.boardIndexTabControlParts.SelectedIndex == 8)
                    treeViewParts = MainFormConst.boardIndexTabMain.machibbsBoardIndexView.boardIndexControls.treeViewParts;

                if ((treeViewParts.SelectedNodeGetBool() == false) || (treeViewParts.SelectedNodeName.Length == 0))
                {
                    menuItemOpenParts.Enabled = false;
                    menuItemAddFavoriteParts.Enabled = false;
                    menuItemOpenBrowserParts.Enabled = false;
                    menuItemCopyURLParts.Enabled = false;
                    menuItemCopyTitleParts.Enabled = false;
                }
                else
                {
                    menuItemOpenParts.Enabled = true;
                    menuItemAddFavoriteParts.Enabled = true;
                    menuItemOpenBrowserParts.Enabled = true;
                    menuItemCopyURLParts.Enabled = true;
                    menuItemCopyTitleParts.Enabled = true;
                }
            }
            else
            {
                TreeViewParts treeViewParts = MainFormConst.boardIndexTabMain.favoriteBoardIndexView.boardIndexControls.treeViewParts;

                if ((treeViewParts.SelectedNodeGetBool() == false) || (treeViewParts.SelectedNodeName.Length == 0))
                {
                    menuItemOpenParts.Enabled = false;
                    menuItemAddFavoriteParts.Enabled = false;
                    menuItemOpenBrowserParts.Enabled = false;
                    menuItemCopyURLParts.Enabled = false;
                    menuItemCopyTitleParts.Enabled = false;
                }
                else
                {
                    menuItemOpenParts.Enabled = true;
                    menuItemAddFavoriteParts.Enabled = false;
                    menuItemOpenBrowserParts.Enabled = true;
                    menuItemCopyURLParts.Enabled = true;
                    menuItemCopyTitleParts.Enabled = true;
                }
            }
        }
    }
}