﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.Threading;
using System.Diagnostics;

using System.Windows.Forms;
using mshtml;

using nispi.Menu;

namespace nispi.controlclass
{
    class TextMenuEvent:TextMenuMethod
    {
        public BrowserTextMenu browserTextMenu;
        public BrowserTextMainMenu browserTextMainMenu;

        public TextMenuEvent(BrowserTextMenu browserTextMenu)
        {
            this.browserTextMenu = browserTextMenu;
            browserTextMenu.menuItemOpenGoogleParts.Click += new EventHandler(menuItemOpenGoogle_Click);
            browserTextMenu.menuItemOpenWikiParts.Click += new EventHandler(menuItemOpenWiki_Click);
            browserTextMenu.menuItemCopyParts.Click += new EventHandler(menuItemCopy_Click);
            browserTextMenu.menuItemSamplingParts.Click += new EventHandler(menuItemSampling_Click);
        }
        public TextMenuEvent(BrowserTextMainMenu browserTextMainMenu)
        {
            this.browserTextMainMenu = browserTextMainMenu;
            this.browserTextMainMenu.menuItemOpenGoogleParts.Click += new EventHandler(menuItemOpenGoogle_Click);
            this.browserTextMainMenu.menuItemOpenWikiParts.Click += new EventHandler(menuItemOpenWiki_Click);
            this.browserTextMainMenu.menuItemCopyParts.Click += new EventHandler(menuItemCopy_Click);
            this.browserTextMainMenu.menuItemSamplingParts.Click += new EventHandler(menuItemSampling_Click);
        }

        public void Show(BrowserParts browserParts, Point point, string selectedText)
        {
            if (selectedText.Length > 0)
            {
                browserTextMenu.menuItemOpenGoogleParts.Enabled = true;
                browserTextMenu.menuItemOpenWikiParts.Enabled = true;
                browserTextMenu.menuItemCopyParts.Enabled = true;

                browserTextMenu.menuItemSamplingParts.Enabled = true;
            }
            else
            {
                browserTextMenu.menuItemOpenGoogleParts.Enabled = false;
                browserTextMenu.menuItemOpenWikiParts.Enabled = false;
                browserTextMenu.menuItemCopyParts.Enabled = false;
                browserTextMenu.menuItemSamplingParts.Enabled = false;
            }

            browserTextMenu.menuItemOpenGoogleParts.Text = '\"' + Util.TruncatStr(selectedText, 20) + '\"' + "をGoogleで検索(&G)";
            browserTextMenu.menuItemOpenWikiParts.Text = '\"' + Util.TruncatStr(selectedText, 20) + '\"' + "をWikiで開く(&W)";
            browserTextMenu.menuItemCopyParts.Text = "コピー(&C)";
            browserTextMenu.menuItemSamplingParts.Text = '\"' + Util.TruncatStr(selectedText, 20) + '\"' + "を抽出表示(&T)";

            this.selectedText = selectedText;
            browserTextMenu.contextMenuStripParts.Show(browserParts, point);
        }
    }
    class TextMenuMethod
    {
        public string selectedText;
        public BrowserParts browserParts;
        public ThreadViewCommon threadViewCommon;

        public TextMenuMethod()
        {
        }

        public bool CheckConsistency()
        {
            try
            {
                int index = Const.form.threadListTabControlParts.SelectedIndex;
                browserParts = MainFormConst.threadListTabMain.viewList[index].threadViewControls.browserParts;
                threadViewCommon = MainFormConst.threadListTabMain.viewList[index];
                return true;
            }
            catch
            {
                return false;
            }
        }

        public void menuItemOpenGoogle_Click(object sender, EventArgs e)
        {
            if (CheckConsistency() == false)
                return;

            Process.Start("http://www.google.co.jp/search?q=" + selectedText);
        }

        public void menuItemOpenWiki_Click(object sender, EventArgs e)
        {
            if (CheckConsistency() == false)
                return;

            Process.Start("http://ja.wikipedia.org/wiki/" + selectedText);
        }

        public void menuItemCopy_Click(object sender, EventArgs e)
        {
            if (CheckConsistency() == false)
                return;

            Clipboard.SetDataObject(selectedText, true);
        }

        public void menuItemSampling_Click(object sender, EventArgs e)
        {
            if (CheckConsistency() == false)
                return;

            MainFormConst.PopUpWindow(Cursor.Position, threadViewCommon, threadViewCommon.datUrl, selectedText, "WORD");
        }
    }
}