﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.Threading;

using System.Windows.Forms;
using mshtml;


using nispi.Menu;

namespace nispi.controlclass
{

    class NonTextMenuEvent:NonTextMenuMethod
    {
        BrowserNonTextMenu browserNonTextMenu;
        BrowserNonTextMainMenu browserNonTextMainMenu;

        public NonTextMenuEvent(BrowserNonTextMenu browserNonTextMenu)
        {
            this.browserNonTextMenu = browserNonTextMenu;

            browserNonTextMenu.menuItemSetShioriParts.Click += new EventHandler(menuItemSetShiori_Click);
            browserNonTextMenu.menuItemGoToShioriParts.Click += new EventHandler(menuItemGoToShiori_Click);

            browserNonTextMenu.menuItem0Parts.Click += new EventHandler(menuItem0_Click);

            browserNonTextMenu.menuItem100Parts.Click += new EventHandler(menuItem0_Click);

            browserNonTextMenu.menuItem200Parts.Click += new EventHandler(menuItem0_Click);

            browserNonTextMenu.menuItem300Parts.Click += new EventHandler(menuItem0_Click);

            browserNonTextMenu.menuItem400Parts.Click += new EventHandler(menuItem0_Click);

            browserNonTextMenu.menuItem500Parts.Click += new EventHandler(menuItem0_Click);

            browserNonTextMenu.menuItem600Parts.Click += new EventHandler(menuItem0_Click);

            browserNonTextMenu.menuItem700Parts.Click += new EventHandler(menuItem0_Click);

            browserNonTextMenu.menuItem800Parts.Click += new EventHandler(menuItem0_Click);

            browserNonTextMenu.menuItem900Parts.Click += new EventHandler(menuItem0_Click);

            browserNonTextMenu.menuItemEndParts.Click += new EventHandler(menuItemEnd_Click);
        }
        public NonTextMenuEvent(BrowserNonTextMainMenu browserNonTextMainMenu)
        {
            this.browserNonTextMainMenu = browserNonTextMainMenu;

            this.browserNonTextMainMenu.menuItemSetShioriParts.Click += new EventHandler(menuItemSetShiori_Click);
            this.browserNonTextMainMenu.menuItemGoToShioriParts.Click += new EventHandler(menuItemGoToShiori_Click);

            this.browserNonTextMainMenu.menuItem0Parts.Click += new EventHandler(menuItem0_Click);

            this.browserNonTextMainMenu.menuItem100Parts.Click += new EventHandler(menuItem0_Click);

            this.browserNonTextMainMenu.menuItem200Parts.Click += new EventHandler(menuItem0_Click);

            this.browserNonTextMainMenu.menuItem300Parts.Click += new EventHandler(menuItem0_Click);

            this.browserNonTextMainMenu.menuItem400Parts.Click += new EventHandler(menuItem0_Click);

            this.browserNonTextMainMenu.menuItem500Parts.Click += new EventHandler(menuItem0_Click);

            this.browserNonTextMainMenu.menuItem600Parts.Click += new EventHandler(menuItem0_Click);

            this.browserNonTextMainMenu.menuItem700Parts.Click += new EventHandler(menuItem0_Click);

            this.browserNonTextMainMenu.menuItem800Parts.Click += new EventHandler(menuItem0_Click);

            this.browserNonTextMainMenu.menuItem900Parts.Click += new EventHandler(menuItem0_Click);

            this.browserNonTextMainMenu.menuItemEndParts.Click += new EventHandler(menuItemEnd_Click);
        }
        public void Show(BrowserParts browserParts, Point point)
        {
            browserNonTextMenu.contextMenuStripParts.Show(browserParts, point);
        }
    }
    class NonTextMenuMethod
    {
        public BrowserParts browserParts;
        public int index;
        public ThreadViewCommon threadViewCommon;

        public NonTextMenuMethod()
        {
        }

        public bool CheckConsistency()
        {
            try
            {
                index = Const.form.threadListTabControlParts.SelectedIndex;
                browserParts = MainFormConst.threadListTabMain.viewList[index].threadViewControls.browserParts;
                threadViewCommon = MainFormConst.threadListTabMain.viewList[index];

                return true;
            }
            catch
            {
                return false;
            }
        }

        public void menuItemSetShiori_Click(object sender, EventArgs e)
        {
            if (CheckConsistency() == false)
                return;

            threadViewCommon.shiori.RemoveShiori();

            HtmlElement pos = this.browserParts.Document.GetElementFromPoint(this.browserParts.mouseDownPoint);

            //Point scrollpos = this.browserParts.GetScrollRectangle();
            //Point scrollpos = this.browserParts.control.PointToClient(Cursor.Position);
            //List<Point> points = HtmlUtil.GetResPoints(this.browserParts.Document);

            string resStr = pos.GetAttribute("name");

            if (resStr.Length == 0)
            {
                //ピアレントのＤＩＶのnameの値を得たい
                resStr = pos.Parent.GetAttribute("name");
                Const.debugForm.Print(resStr + "::");

                if (resStr.Length == 0)
                {
                    try
                    {
                        resStr = pos.Parent.Parent.GetAttribute("name");
                        Const.debugForm.Print(resStr + ":::");
                    }
                    catch
                    {
                        return;
                    }
                }
            }
            else
            {
                Const.debugForm.Print(resStr + ":");
            }

            if (resStr.Length == 0)
                return;


            threadViewCommon.shiori.SetShiori(resStr);

            return;
        }

        public void menuItemGoToShiori_Click(object sender, EventArgs e)
        {
            if (CheckConsistency() == false)
                return;

            HtmlUtil.GoToResNumInBrowser(browserParts, ">>" + threadViewCommon.shiori.beforeShioriStr);
            return;
        }

        public void menuItem0_Click(object sender, EventArgs e)
        {
            if (CheckConsistency() == false)
                return;

            string resNum = ((ToolStripMenuItem)sender).Name;
            HtmlUtil.GoToResNumInBrowser(browserParts, resNum);
        }


        public void menuItemEnd_Click(object sender, EventArgs e)
        {
            if (CheckConsistency() == false)
                return;

            try
            {
                HtmlUtil.GoToEndInBrowser(browserParts);
            }
            catch { ;}
        }
    }
}