﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Drawing;

using nispi.controlclass;
using nispi.Analysis;

namespace nispi
{
    class ThreadListControls
    {
        public TabPageExParts tabPageExParts;

        public BrowserParts browserParts;

        public TextBoxParts searchTextBoxParts;
        public ButtonParts searchButtonParts;
        public ButtonParts extractionButtonParts;

        public PictureBoxParts separator1Pic;

        public ButtonParts reloadButtonParts;
        public ButtonParts favoriteButtonParts;
        public ButtonParts postButtonParts;

        public PictureBoxParts separator2Pic;

        public ButtonParts analysisMecabParts;
        public ButtonParts analysisImageButtonParts;
        public ButtonParts analysisLinkButtonParts;
        public ButtonParts analysisMagicButtonParts;

        public PictureBoxParts separator3Pic;

        public WithInCBoxParts withInCBoxParts;
        public ButtonParts pinPointDateButtonParts;
        public ButtonParts timeOffButtonParts;

        public PictureBoxParts separator4Pic;

        public ButtonParts closeTabButtonParts;

        public ToolTipParts toolTipParts;

        public ThreadListControlsEvent threadListControlsEvent;

        ThreadViewCommon threadViewCommon;

        public AnalysisMagic analysisMagic;
        
        public ThreadListControls(ThreadViewCommon threadViewCommon)
        {
            this.threadViewCommon = threadViewCommon;

            tabPageExParts = TabPageExPartsManager.Pop();
            tabPageExParts.Size = new Size(0,0);

            browserParts = BrowserCtrlManager.Pop();
            browserParts.ownerForm = Const.form.mainForm;
            browserParts.Name = "ThreadList";
            browserParts.Location = new Point(0, 27);

            searchTextBoxParts = TextBoxPartsManager.Pop();
            searchTextBoxParts.Location = new Point(2, 2);
            searchTextBoxParts.Name = "button";
            searchTextBoxParts.Size = new Size(150, -1);

            searchButtonParts = ButtonPartsManager.Pop();
            searchButtonParts.Location = new Point(155, 1);
            searchButtonParts.Name = "control";
            searchButtonParts.Size = new Size(26, 26);
            searchButtonParts.SetToolTip("検索");
            searchButtonParts.Image = Resources.search;

            //抽出ボタンの設定
            extractionButtonParts = ButtonPartsManager.Pop();
            extractionButtonParts.Location = new System.Drawing.Point(185, 1);
            extractionButtonParts.Name = "search";
            extractionButtonParts.Size = new Size(26, 26);
            extractionButtonParts.Image = Resources.extraction;
            extractionButtonParts.SetToolTip("抽出");

            //セパレーター
            separator1Pic = PictureBoxPartsManager.Pop();
            separator1Pic.Image = Resources.separator;
            separator1Pic.Location = new Point(220, 8);
            separator1Pic.Name = "separator";
            separator1Pic.Size = new Size(2, 16);

            reloadButtonParts = ButtonPartsManager.Pop();
            reloadButtonParts.Location = new Point(230, 1);
            reloadButtonParts.Name = "control";
            reloadButtonParts.Size = new Size(26, 26);
            reloadButtonParts.SetToolTip("再読み込み");
            reloadButtonParts.Image = Resources.reload;

            favoriteButtonParts = ButtonPartsManager.Pop();
            favoriteButtonParts.Location = new Point(260, 1);
            favoriteButtonParts.Name = "control";
            favoriteButtonParts.Size = new Size(26, 26);
            favoriteButtonParts.SetToolTip("お気に入りに登録");
            favoriteButtonParts.Image = Resources.favorite;

            postButtonParts = ButtonPartsManager.Pop();
            postButtonParts.Location = new Point(290, 1);
            postButtonParts.Name = "control";
            postButtonParts.Size = new Size(26, 26);
            postButtonParts.SetToolTip("書き込む");
            postButtonParts.Image = Resources.write2;

            //セパレーター
            separator2Pic = PictureBoxPartsManager.Pop();
            separator2Pic.Image = Resources.separator;
            separator2Pic.Location = new Point(325, 8);
            separator2Pic.Name = "separator";
            separator2Pic.Size = new Size(2, 16);

            analysisMecabParts = ButtonPartsManager.Pop();
            analysisMecabParts.Location = new Point(335, 1);
            analysisMecabParts.Name = "control";
            analysisMecabParts.Size = new Size(26, 26);
            analysisMecabParts.SetToolTip("単語抽出");
            analysisMecabParts.Image = Resources.word;

            analysisImageButtonParts = ButtonPartsManager.Pop();
            analysisImageButtonParts.Location = new Point(365, 1);
            analysisImageButtonParts.Name = "control";
            analysisImageButtonParts.Size = new Size(26, 26);
            analysisImageButtonParts.SetToolTip("画像抽出");
            analysisImageButtonParts.Image = Resources.analysisimage;

            analysisLinkButtonParts = ButtonPartsManager.Pop();
            analysisLinkButtonParts.Location = new Point(395, 1);
            analysisLinkButtonParts.Name = "control";
            analysisLinkButtonParts.Size = new Size(26, 26);
            analysisLinkButtonParts.SetToolTip("リンク抽出");
            analysisLinkButtonParts.Image = Resources.analysislink;

            //セパレーター
            separator3Pic = PictureBoxPartsManager.Pop();
            separator3Pic.Image = Resources.separator;
            separator3Pic.Location = new Point(430, 8);
            separator3Pic.Name = "separator";
            separator3Pic.Size = new Size(2, 16);

            analysisMagicButtonParts = ButtonPartsManager.Pop();
            analysisMagicButtonParts.Location = new Point(440, 1);
            analysisMagicButtonParts.Name = "control";
            analysisMagicButtonParts.Size = new Size(26, 26);
            analysisMagicButtonParts.SetToolTip("レスカット機能");
            analysisMagicButtonParts.Image = Resources.magic;

            withInCBoxParts = WithInCBoxPartsManager.Pop();
            withInCBoxParts.Location = new Point(470, 0);
            withInCBoxParts.Name = "ThreadView";

            pinPointDateButtonParts = ButtonPartsManager.Pop();
            pinPointDateButtonParts.Location = new Point(585, 1);
            pinPointDateButtonParts.Name = "pinPointDateButtonParts";
            pinPointDateButtonParts.Size = new Size(26, 26);
            pinPointDateButtonParts.Image = Resources.calendar;
            pinPointDateButtonParts.SetToolTip("日にちを指定");


            timeOffButtonParts = ButtonPartsManager.Pop();
            timeOffButtonParts.Location = new Point(615, 1);
            timeOffButtonParts.Name = "control";
            timeOffButtonParts.Size = new Size(60, 26);
            timeOffButtonParts.SetToolTip("日時での抽出解除");
            timeOffButtonParts.Text = "リセット";

            //セパレーター
            separator4Pic = PictureBoxPartsManager.Pop();
            separator4Pic.Image = Resources.separator;
            separator4Pic.Location = new Point(685, 8);
            separator4Pic.Name = "separator";
            separator4Pic.Size = new Size(2, 16);

            closeTabButtonParts = ButtonPartsManager.Pop();
            closeTabButtonParts.Location = new System.Drawing.Point(695, 1);
            closeTabButtonParts.Name = "search";
            closeTabButtonParts.Size = new Size(26, 26);
            closeTabButtonParts.Image = Resources.close;
            closeTabButtonParts.SetToolTip("タブを閉じる");

            //進捗状況をみるツールチップ
            this.toolTipParts = ToolTipPartsManager.Pop();

            tabPageExParts.AddControl(browserParts);

            tabPageExParts.AddControl(searchTextBoxParts);
            tabPageExParts.AddControl(searchButtonParts);
            tabPageExParts.AddControl(extractionButtonParts);

            tabPageExParts.AddControl(separator1Pic);

            tabPageExParts.AddControl(reloadButtonParts);
            tabPageExParts.AddControl(favoriteButtonParts);
            tabPageExParts.AddControl(postButtonParts);

            tabPageExParts.AddControl(separator2Pic);

            tabPageExParts.AddControl(analysisMecabParts);
            tabPageExParts.AddControl(analysisImageButtonParts);
            tabPageExParts.AddControl(analysisLinkButtonParts);
            tabPageExParts.AddControl(analysisMagicButtonParts);

            tabPageExParts.AddControl(separator3Pic);

            tabPageExParts.AddControl(withInCBoxParts);
            tabPageExParts.AddControl(pinPointDateButtonParts);
            tabPageExParts.AddControl(timeOffButtonParts);

            tabPageExParts.AddControl(separator4Pic);

            tabPageExParts.AddControl(closeTabButtonParts);

            threadListControlsEvent = new ThreadListControlsEvent(threadViewCommon, this);

            analysisMagic = new AnalysisMagic(threadViewCommon);
        }

        public void RemoveAllControls()
        {
            threadListControlsEvent.RemoveEvent();

            withInCBoxParts.SelectedIndex = 0;

            Const.form.threadListTabControlParts.ControlsRemove(this.tabPageExParts);

            tabPageExParts.control.ImageIndex = -1;

            BrowserCtrlManager.Push(browserParts);

            ButtonPartsManager.Push(searchButtonParts);
            TextBoxPartsManager.Push(searchTextBoxParts);
            ButtonPartsManager.Push(extractionButtonParts);

            PictureBoxPartsManager.Push(separator1Pic);

            ButtonPartsManager.Push(reloadButtonParts);
            ButtonPartsManager.Push(favoriteButtonParts);
            ButtonPartsManager.Push(postButtonParts);

            PictureBoxPartsManager.Push(separator2Pic);

            ButtonPartsManager.Push(analysisMecabParts);
            ButtonPartsManager.Push(analysisImageButtonParts);
            ButtonPartsManager.Push(analysisLinkButtonParts);
            ButtonPartsManager.Push(analysisMagicButtonParts);

            PictureBoxPartsManager.Push(separator3Pic);
            
            WithInCBoxPartsManager.Push(withInCBoxParts);
            ButtonPartsManager.Push(pinPointDateButtonParts);
            ButtonPartsManager.Push(timeOffButtonParts);

            PictureBoxPartsManager.Push(separator4Pic);

            ButtonPartsManager.Push(closeTabButtonParts);

            ToolTipPartsManager.Push(toolTipParts);

            //tabPageExParts.Update();
            //コントロールを元に戻す
            TabPageExPartsManager.Push(tabPageExParts);
            //タブに登録されているコントロールを全削除
            tabPageExParts.RemoveAllCtrl();



            //マジックコントロールを削除処理
            analysisMagic.Close();
            analysisMagic = null;

            //null化
            tabPageExParts = null;

            browserParts = null;

            searchButtonParts = null;
            searchTextBoxParts = null;
            extractionButtonParts = null;

            reloadButtonParts = null;
            favoriteButtonParts = null;

            analysisMecabParts = null;
            analysisImageButtonParts = null;
            analysisLinkButtonParts = null;
            analysisMagicButtonParts = null;

            postButtonParts = null;

            withInCBoxParts = null;
            pinPointDateButtonParts = null;
            timeOffButtonParts = null;

            closeTabButtonParts = null;
        }
    }
}