﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.IO;
using System.Diagnostics;
using nispi;

namespace nispi.GetBoardIndexNS
{
    class GetBoardIndex
    {
        ProgressBarForm progressBarForm;

        private bool stoppingBool;

        int progressMax = 0;

        public static Mutex mutex = new Mutex(false, "GetBoardIndex");

        public string fileStr = "";
        public string downloadStr = "";

        public string fileStrSC = "";
        public string downloadStrSC = "";

        public string fileStrOPEN2CH = "";
        public string downloadStrOPEN2CH = "";

        public string fileStrNEXT2CH = "";
        public string downloadStrNEXT2CH = "";

        public string fileStrJIKKYO = "";
        public string downloadStrJIKKYO = "";

        public string fileStrBLOGBAN = "";
        public string downloadStrBLOGBAN = "";

        public string fileStrSHIZU = "";
        public string downloadStrSHIZU = "";

        public string fileStrVIP2CH = "";
        public string downloadStrVIP2CH = "";

        public string fileStrMACHIBBS = "";
        public string downloadStrMACHIBBS = "";
        
        public GetBoardIndex()
        {
            stoppingBool = false;

            if ((FileIO.CheckIsFile(Const.DataDir + Path.DirectorySeparatorChar + ".ageon" + Path.DirectorySeparatorChar +
                "cache" + Path.DirectorySeparatorChar + "2ch" + Path.DirectorySeparatorChar + "bbsindex.html") == false) ||
                (FileIO.CheckIsFile(Const.DataDir + Path.DirectorySeparatorChar + ".ageon" + Path.DirectorySeparatorChar +
                "cache" + Path.DirectorySeparatorChar + "2chsc" + Path.DirectorySeparatorChar + "bbsindex.html") == false) ||
                (FileIO.CheckIsFile(Const.DataDir + Path.DirectorySeparatorChar + ".ageon" + Path.DirectorySeparatorChar +
                "cache" + Path.DirectorySeparatorChar + "open2ch" + Path.DirectorySeparatorChar + "bbsindex.html") == false) ||
                (FileIO.CheckIsFile(Const.DataDir + Path.DirectorySeparatorChar + ".ageon" + Path.DirectorySeparatorChar +
                "cache" + Path.DirectorySeparatorChar + "next2ch" + Path.DirectorySeparatorChar + "bbsindex.html") == false) ||
                
                (FileIO.CheckIsFile(Const.DataDir + Path.DirectorySeparatorChar + ".ageon" + Path.DirectorySeparatorChar +
                "cache" + Path.DirectorySeparatorChar + "jikkyo" + Path.DirectorySeparatorChar + "bbsindex.html") == false) ||
                (FileIO.CheckIsFile(Const.DataDir + Path.DirectorySeparatorChar + ".ageon" + Path.DirectorySeparatorChar +
                "cache" + Path.DirectorySeparatorChar + "blogban" + Path.DirectorySeparatorChar + "bbsindex.html") == false) ||
                (FileIO.CheckIsFile(Const.DataDir + Path.DirectorySeparatorChar + ".ageon" + Path.DirectorySeparatorChar +
                "cache" + Path.DirectorySeparatorChar + "shizu" + Path.DirectorySeparatorChar + "bbsindex.html") == false) ||

                /*(FileIO.CheckIsFile(Const.DataDir + Path.DirectorySeparatorChar + ".ageon" + Path.DirectorySeparatorChar +
                "cache" + Path.DirectorySeparatorChar + "vip2ch" + Path.DirectorySeparatorChar + "bbsindex.html") == false) ||*/
                (FileIO.CheckIsFile(Const.DataDir + Path.DirectorySeparatorChar + ".ageon" + Path.DirectorySeparatorChar +
                "cache" + Path.DirectorySeparatorChar + "machibbs" + Path.DirectorySeparatorChar + "bbsindex.html") == false))
            {
                progressBarForm = new ProgressBarForm(new ProgressBarForm.SimpleMethod(StopDownloading));
                //progressBarForm.SetUpTwo();
                Thread t = new Thread(new ThreadStart(progressBarForm.SetUpTwo));
                t.IsBackground = true;
                t.Start();

                Const.form.mainForm.Invoke((Action)(() => progressBarForm.progressBar.Maximum = 100));

                //受信
                Const.form.mainForm.Invoke((Action)(() => progressBarForm.textLabel.Text = "メニューを受信しています"));
                GetBoardIndexMethod();
                Const.form.mainForm.Invoke((Action)(() => progressBarForm.progressBar.Value  = 30));


                //解析
                Const.form.mainForm.Invoke((Action)(() => progressBarForm.textLabel.Text =  "SCのメニューを受信しています"));
                GetSCBoardIndexMethod();
                Const.form.mainForm.Invoke((Action)(() => progressBarForm.progressBar.Value = 20));
                System.Threading.Thread.Sleep(1000);

                //受信
                Const.form.mainForm.Invoke((Action)(() => progressBarForm.textLabel.Text = "Open2chのメニューを受信しています"));
                GetOPEN2CHBoardIndexMethod();
                Const.form.mainForm.Invoke((Action)(() => progressBarForm.progressBar.Value = 30));


                //受信
                Const.form.mainForm.Invoke((Action)(() => progressBarForm.textLabel.Text = "Next2chのメニューを受信しています"));
                GetNEXT2CHBoardIndexMethod();
                Const.form.mainForm.Invoke((Action)(() => progressBarForm.progressBar.Value = 40));


                //受信
                Const.form.mainForm.Invoke((Action)(() => progressBarForm.textLabel.Text = "jikkyo.orgのメニューを受信しています"));
                GetJIKKYOBoardIndexMethod();
                Const.form.mainForm.Invoke((Action)(() => progressBarForm.progressBar.Value = 50));
                
                //受信
                Const.form.mainForm.Invoke((Action)(() => progressBarForm.textLabel.Text = "blogbanのメニューを受信しています"));
                GetBLOGBANBoardIndexMethod();
                Const.form.mainForm.Invoke((Action)(() => progressBarForm.progressBar.Value = 60));
                
                //受信
                Const.form.mainForm.Invoke((Action)(() => progressBarForm.textLabel.Text = "しずちゃんのメニューを受信しています"));
                GetSHIZUBoardIndexMethod();
                Const.form.mainForm.Invoke((Action)(() => progressBarForm.progressBar.Value = 70));


                //
                //受信
                Const.form.mainForm.Invoke((Action)(() => progressBarForm.textLabel.Text = "VIP2chのメニューを受信しています"));
                GetVIP2CHBoardIndexMethod();
                Const.form.mainForm.Invoke((Action)(() => progressBarForm.progressBar.Value = 70));

                //受信
                Const.form.mainForm.Invoke((Action)(() => progressBarForm.textLabel.Text = "まちBBSのメニューを受信しています"));
                GetMACHIBBSBoardIndexMethod();
                Const.form.mainForm.Invoke((Action)(() => progressBarForm.progressBar.Value = 70));


                //終了
                Const.form.mainForm.Invoke((Action)(() => progressBarForm.progressBar.Value = 100));
                Const.form.mainForm.Invoke((Action)(() => progressBarForm.textLabel.Text = "受信しました"));
                System.Threading.Thread.Sleep(1000);

                //Const.form.mainForm.Invoke(new ProgressBarForm.SimpleMethod(progressBarForm.Closing));
                progressBarForm.popUp.Invoke((Action)(() => progressBarForm.Closing()));
            }
            else
            {
                fileStr = FileIO.ReadUnicode(".ageon" + Path.DirectorySeparatorChar +
                    "cache" + Path.DirectorySeparatorChar + "2ch", "bbsindex.html");

                fileStrSC = FileIO.ReadUnicode(".ageon" + Path.DirectorySeparatorChar +
                    "cache" + Path.DirectorySeparatorChar + "2chsc", "bbsindex.html");

                fileStrOPEN2CH = FileIO.ReadUnicode(".ageon" + Path.DirectorySeparatorChar +
                    "cache" + Path.DirectorySeparatorChar + "open2ch", "bbsindex.html");

                fileStrNEXT2CH = FileIO.ReadUnicode(".ageon" + Path.DirectorySeparatorChar +
                    "cache" + Path.DirectorySeparatorChar + "next2ch", "bbsindex.html");


                fileStrJIKKYO = FileIO.ReadUnicode(".ageon" + Path.DirectorySeparatorChar +
                    "cache" + Path.DirectorySeparatorChar + "jikkyo", "bbsindex.html");

                fileStrBLOGBAN = FileIO.ReadUnicode(".ageon" + Path.DirectorySeparatorChar +
                    "cache" + Path.DirectorySeparatorChar + "blogban", "bbsindex.html");

                fileStrSHIZU = FileIO.ReadUnicode(".ageon" + Path.DirectorySeparatorChar +
                    "cache" + Path.DirectorySeparatorChar + "shizu", "bbsindex.html");


                fileStrVIP2CH = FileIO.ReadUnicode(".ageon" + Path.DirectorySeparatorChar +
                    "cache" + Path.DirectorySeparatorChar + "vip2ch", "bbsindex.html");

                fileStrMACHIBBS = FileIO.ReadUnicode(".ageon" + Path.DirectorySeparatorChar +
                    "cache" + Path.DirectorySeparatorChar + "machibbs", "bbsindex.html");
            }
        }

        public void StopDownloading()
        {
            mutex.WaitOne();
            this.stoppingBool = true;
            mutex.ReleaseMutex();
        }

        public void GetBoardIndexMethod()
        {
            //2ch
            try
            {
                DownloadIndex di = new DownloadIndex();
                if (true == di.DownloadIndexText(Const.BOARD_INDEX_ADDRESS))
                {
                    downloadStr = di.httpResData;
                    FileIO.SaveUnicode(".ageon" + Path.DirectorySeparatorChar + "cache" + Path.DirectorySeparatorChar + "2ch", "bbsindex.html", downloadStr);
                }
                else
                    ;
            }
            catch (System.Exception ex)
            {
                Const.debugForm.OutPutDebug("BoardIndex", ex);
            }
        }
        
        public void GetSCBoardIndexMethod()
        {
            //sc
            try
            {
                DownloadIndex di = new DownloadIndex();
                if (true == di.DownloadIndexText(Const.SC_BOARD_INDEX_ADDRESS))
                {
                    downloadStrSC = di.httpResData;
                    FileIO.SaveUnicode(".ageon" + Path.DirectorySeparatorChar + "cache" + Path.DirectorySeparatorChar + "2chsc", "bbsindex.html", downloadStrSC);
                }
                else
                    ;
            }
            catch (System.Exception ex)
            {
                Const.debugForm.OutPutDebug("BoardIndex", ex);
            }
        }

        public void GetOPEN2CHBoardIndexMethod()
        {
            //open2ch
            try
            {
                DownloadIndex di = new DownloadIndex();
                if (true == di.DownloadIndexText(Const.OPEN2CH_BOARD_INDEX_ADDRESS))
                {
                    downloadStrOPEN2CH = di.httpResData;
                    FileIO.SaveUnicode(".ageon" + Path.DirectorySeparatorChar + "cache" + Path.DirectorySeparatorChar + "open2ch", "bbsindex.html", downloadStrOPEN2CH);
                }
                else
                    ;
            }
            catch (System.Exception ex)
            {
                Const.debugForm.OutPutDebug("BoardIndex", ex);
            }
        }

        public void GetNEXT2CHBoardIndexMethod()
        {
            //next2ch
            try
            {
                DownloadIndex di = new DownloadIndex();
                if (true == di.DownloadIndexText(Const.NEXT2CH_BOARD_INDEX_ADDRESS))
                {
                    downloadStrNEXT2CH = di.httpResData;
                    FileIO.SaveUnicode(".ageon" + Path.DirectorySeparatorChar + "cache" + Path.DirectorySeparatorChar + "next2ch", "bbsindex.html", downloadStrNEXT2CH);
                }
                else
                    ;
            }
            catch (System.Exception ex)
            {
                Const.debugForm.OutPutDebug("BoardIndex", ex);
            }
        }

        public void GetJIKKYOBoardIndexMethod()
        {
            //jikkyo
            try
            {
                DownloadIndex di = new DownloadIndex();
                if (true == di.DownloadIndexText(Const.JIKKYO_BOARD_INDEX_ADDRESS))
                {
                    downloadStrJIKKYO = di.httpResData;
                    FileIO.SaveUnicode(".ageon" + Path.DirectorySeparatorChar + "cache" + Path.DirectorySeparatorChar + "jikkyo", "bbsindex.html", downloadStrJIKKYO);
                }
                else
                    ;
            }
            catch (System.Exception ex)
            {
                Const.debugForm.OutPutDebug("BoardIndex", ex);
            }
        }

        public void GetBLOGBANBoardIndexMethod()
        {
            //blogban
            try
            {
                DownloadIndex di = new DownloadIndex();
                if (true == di.DownloadIndexText(Const.BLOGBAN_BOARD_INDEX_ADDRESS))
                {
                    downloadStrBLOGBAN = di.httpResData;
                    FileIO.SaveUnicode(".ageon" + Path.DirectorySeparatorChar + "cache" + Path.DirectorySeparatorChar + "blogban", "bbsindex.html", downloadStrBLOGBAN);
                }
                else
                    ;
            }
            catch (System.Exception ex)
            {
                Const.debugForm.OutPutDebug("BoardIndex", ex);
            }
        }

        public void GetSHIZUBoardIndexMethod()
        {
            //shizu
            try
            {
                DownloadIndex di = new DownloadIndex();
                if (true == di.DownloadIndexText(Const.SHIZU_BOARD_INDEX_ADDRESS))
                {
                    downloadStrSHIZU = di.httpResData;
                    FileIO.SaveUnicode(".ageon" + Path.DirectorySeparatorChar + "cache" + Path.DirectorySeparatorChar + "shizu", "bbsindex.html", downloadStrSHIZU);
                }
                else
                    ;
            }
            catch (System.Exception ex)
            {
                Const.debugForm.OutPutDebug("BoardIndex", ex);
            }
        }
        //

        public void GetVIP2CHBoardIndexMethod()
        {
            //vip2ch
            try
            {
                DownloadIndex di = new DownloadIndex();
                if (true == di.DownloadIndexText(Const.VIP2CH_BOARD_INDEX_ADDRESS))
                {
                    downloadStrVIP2CH = di.httpResData;
                    FileIO.SaveUnicode(".ageon" + Path.DirectorySeparatorChar + "cache" + Path.DirectorySeparatorChar + "vip2ch", "bbsindex.html", downloadStrVIP2CH);
                }
                else
                    ;
            }
            catch (System.Exception ex)
            {
                Const.debugForm.OutPutDebug("BoardIndex", ex);
            }
        }

        public void GetMACHIBBSBoardIndexMethod()
        {
            //machi
            try
            {
                DownloadIndex di = new DownloadIndex();
                if (true == di.DownloadIndexText(Const.MACHIBBS_BOARD_INDEX_ADDRESS))
                {
                    downloadStrMACHIBBS = di.httpResData;
                    FileIO.SaveUnicode(".ageon" + Path.DirectorySeparatorChar + "cache" + Path.DirectorySeparatorChar + "machibbs", "bbsindex.html", downloadStrMACHIBBS);
                }
                else
                    ;
            }
            catch (System.Exception ex)
            {
                Const.debugForm.OutPutDebug("BoardIndex", ex);
            }
        }
    }
}
