﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.Windows.Forms;

using nispi.controlclass;
namespace nispi
{
    class AddFavoriteForm
    {
        public FormParts addFavoriteFormParts;

        public LabelParts boardNameLabelParts;
        public TextBoxParts boardNameTBoxParts;

        public LabelParts boardAddressLabelParts;
        public TextBoxParts boardAddressTBoxParts;
        
        public ButtonParts submitButtonParts;
        public ButtonParts closeButtonParts;

        public AddFavoriteForm()
        {
            addFavoriteFormParts = FormPartsManager.Pop();
            boardNameLabelParts = LabelPartsManager.Pop();
            boardNameTBoxParts = TextBoxPartsManager.Pop();
            boardAddressLabelParts = LabelPartsManager.Pop();
            boardAddressTBoxParts = TextBoxPartsManager.Pop();
            submitButtonParts = ButtonPartsManager.Pop();
            closeButtonParts = ButtonPartsManager.Pop();

            addFavoriteFormParts.Text = "板の登録";
            addFavoriteFormParts.Name = "optionFormPart";
            //optionFormParts.Hide();
            //optionFormParts.Owner = Const.form.mainForm.control;//.control.TopMost = true;
            addFavoriteFormParts.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedToolWindow;// ;////.FixedSingle;
            //optionFormParts.Location = new Point(Const.form.mainForm.Location.X + 50, Const.form.mainForm.Location.Y + 50);
            addFavoriteFormParts.SetFormClosing(new FormPartsDelegate.MultiFormClosingEventHandler(addFavoriteFormParts_FormClosing));//.FormClosing += new FormClosingEventHandler(optionFormParts_FormClosing);
            //optionFormParts.SetFont(fontName, fontSize);
            addFavoriteFormParts.Size = new Size(570, 240);
            //addFavoriteFormParts.Show();

            boardNameLabelParts.Location = new Point(30, 30);
            boardNameLabelParts.Size = new Size(80, 20);
            boardNameLabelParts.Text = "板名:";

            boardNameTBoxParts.Location = new Point(120, 30);
            boardNameTBoxParts.Size = new Size(400, 16);

            boardAddressLabelParts.Location = new Point(30, 80);
            boardAddressLabelParts.Size = new Size(80, 20);
            boardAddressLabelParts.Text = "アドレス:";

            boardAddressTBoxParts.Location = new Point(120, 80);
            boardAddressTBoxParts.Size = new Size(400, 16);

            submitButtonParts.Location = new Point(100,150);
            submitButtonParts.Size = new Size(80, 30);
            submitButtonParts.Text = "登録する";
            submitButtonParts.Click += new EventHandler(submitButtonPartsClick);

            closeButtonParts.Location = new Point(200, 150);
            closeButtonParts.Size = new Size(80, 30);
            closeButtonParts.Text = "閉じる";
            closeButtonParts.Click += new EventHandler(closeButtonPartsClick);

            addFavoriteFormParts.AddControl(boardNameLabelParts);
            addFavoriteFormParts.AddControl(boardNameTBoxParts);
            addFavoriteFormParts.AddControl(boardAddressLabelParts);
            addFavoriteFormParts.AddControl(boardAddressTBoxParts);
            addFavoriteFormParts.AddControl(submitButtonParts);
            addFavoriteFormParts.AddControl(closeButtonParts);
        }

        //お気に入りに追加する
        delegate void WriteFavoriteBoardList_Delegate(TreeViewParts treeViewParts);

        private void submitButtonPartsClick(object sender, EventArgs e)
        {
            string url = this.boardAddressTBoxParts.Text;
            string boardName = this.boardNameTBoxParts.Text;

            if ((boardName.Length == 0) || (url.Length == 0))
                return;

            string type = Util.BoardUrlToBoardTypeName(url);

            //お気に入りに加える
            FavoriteBoardManager.Add(boardName, url, type);
            FavoriteBoardManager.Save();

            //お気に入りを再読み込みする
            FavoriteBoardManager.LoadFavorite();
            //GUIに再出力する4
            //if (FavoriteBoardManager.favoriteBoardList.Count == 0)
            //    return; ;
            Const.form.mainForm.Invoke(
                new WriteFavoriteBoardList_Delegate(
                    MainFormConst.boardIndexTabMain.favoriteBoardIndexView.boardIndexControls.treeViewParts.WriteFavoriteBoardList),
                    MainFormConst.boardIndexTabMain.favoriteBoardIndexView.boardIndexControls.treeViewParts);

            //this.ClearText();
            addFavoriteFormParts.Hide();
        }

        private void closeButtonPartsClick(object sender, EventArgs e)
        {
            this.ClearText();
            addFavoriteFormParts.Hide();
        }

        private void addFavoriteFormParts_FormClosing(object sender, FormClosingEventArgs e)
        {
            e.Cancel = true;

            this.addFavoriteFormParts.Owner = null;

            this.ClearText();
            addFavoriteFormParts.Hide();
        }

        public void ClearText()
        {
            this.boardNameTBoxParts.Text = "";
            this.boardAddressTBoxParts.Text = "";
        }
    }
}
