﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using System.Windows.Forms;

namespace nispi.VersionCheck
{
    class VersionCheck
    {
        //古いバージョンのログと設定フォルダ
        string oldVersionFolder;
        
        public VersionCheck()
        {
            //GetUpdateFile getUpdateFile = new GetUpdateFile();
            oldVersionFolder = System.Environment.GetFolderPath(Environment.SpecialFolder.ApplicationData) + Path.DirectorySeparatorChar + "AgeOn";
        }

        public void CopyOldDataToNewFolder()
        {
            if ((FileIO.CheckIsFolder(oldVersionFolder)) &&
                (FileIO.CheckIsFile(oldVersionFolder + Path.DirectorySeparatorChar + "CopyOldData.flag") == false))
            {
                DialogResult result = MessageBox.Show(
                    "AgeOn v0.9.5から設定とログファイルの保存場所が\r\n" +
                    "変わりました。以前のバージョンのデータを引き継ぎ" +
                    "してもよろしいですか？\r\n" +
                    "(v0.9.4.5をご使用の方はキャンセルを押下して下さい)",
                    "ログと設定の引き継ぎについて",
                    MessageBoxButtons.OKCancel,
                    MessageBoxIcon.Question,
                    MessageBoxDefaultButton.Button2);

                if (result == DialogResult.OK)
                {
                    string settingFolder = oldVersionFolder + Path.DirectorySeparatorChar + "setting";
                    string ageonFolder = oldVersionFolder + Path.DirectorySeparatorChar + ".ageon";

                    Microsoft.VisualBasic.FileIO.FileSystem.CopyDirectory(
                        settingFolder, Const.CurrentDir + Path.DirectorySeparatorChar + "setting",
                        Microsoft.VisualBasic.FileIO.UIOption.AllDialogs,
                        Microsoft.VisualBasic.FileIO.UICancelOption.DoNothing);

                    Microsoft.VisualBasic.FileIO.FileSystem.CopyDirectory(
                        ageonFolder, Const.CurrentDir + Path.DirectorySeparatorChar + ".ageon",
                        Microsoft.VisualBasic.FileIO.UIOption.AllDialogs,
                        Microsoft.VisualBasic.FileIO.UICancelOption.DoNothing);

                    this.SetFlag();

                    DialogResult result2 = MessageBox.Show("コピーを完了しました","コピーを完了しました",
                        MessageBoxButtons.OK,
                        MessageBoxIcon.Information,
                        MessageBoxDefaultButton.Button2);
                }
                else
                {
                    this.SetFlag();
                }
            }
        }

        private void SetFlag()
        {
            using (FileStream fsw = new FileStream(this.oldVersionFolder + Path.DirectorySeparatorChar + "CopyOldData.flag", FileMode.Create))
            {
                using (StreamWriter sw = new StreamWriter(fsw, System.Text.Encoding.GetEncoding("shift-jis")))
                {
                    sw.Write("True");
                    sw.Flush();
                    sw.Close();
                    fsw.Close();
                }
            }
        }
    }
}