﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Drawing;
using System.Xml.Linq;

namespace nispi.OptionControl
{
    partial class OutWardMenu : CommonInEvent
    {
        private byte menuSample1ForeColorRed;
        private byte menuSample1ForeColorGreen;
        private byte menuSample1ForeColorBlue;

        private byte menuSample1BackColorRed;
        private byte menuSample1BackColorGreen;
        private byte menuSample1BackColorBlue;

        private byte menuSample2ForeColorRed;
        private byte menuSample2ForeColorGreen;
        private byte menuSample2ForeColorBlue;

        private byte menuSample2BackColorRed;
        private byte menuSample2BackColorGreen;
        private byte menuSample2BackColorBlue;

        private byte menuSample3ForeColorRed;
        private byte menuSample3ForeColorGreen;
        private byte menuSample3ForeColorBlue;

        private byte menuSample3BackColorRed;
        private byte menuSample3BackColorGreen;
        private byte menuSample3BackColorBlue;

        private Mutex mutex = new Mutex(false, "OutWardMenuData");

        private string isUseRenderer;

        private void GetXMLData()
        {
            mutex.WaitOne();

            string str = FileIO.ReadShiftJis("setting", "outward_menu.xml");

            if ((str == null) || (str.Length == 0))
                str = ResetXML();

            try
            {
                XNamespace ns = "OutWard_Menu";
                XDocument doc = XDocument.Parse(str);
                XElement doc2 = doc.Element(ns + "Option");

                MenuSample1ForeColorRed = Byte.Parse(doc2.Element(ns + "MenuSample1ForeColorRed").Value);
                MenuSample1ForeColorGreen = Byte.Parse(doc2.Element(ns + "MenuSample1ForeColorGreen").Value);
                MenuSample1ForeColorBlue = Byte.Parse(doc2.Element(ns + "MenuSample1ForeColorBlue").Value);

                MenuSample1BackColorRed = Byte.Parse(doc2.Element(ns + "MenuSample1BackColorRed").Value);
                MenuSample1BackColorGreen = Byte.Parse(doc2.Element(ns + "MenuSample1BackColorGreen").Value);
                MenuSample1BackColorBlue = Byte.Parse(doc2.Element(ns + "MenuSample1BackColorBlue").Value);


                MenuSample2ForeColorRed = Byte.Parse(doc2.Element(ns + "MenuSample2ForeColorRed").Value);
                MenuSample2ForeColorGreen = Byte.Parse(doc2.Element(ns + "MenuSample2ForeColorGreen").Value);
                MenuSample2ForeColorBlue = Byte.Parse(doc2.Element(ns + "MenuSample2ForeColorBlue").Value);

                MenuSample2BackColorRed = Byte.Parse(doc2.Element(ns + "MenuSample2BackColorRed").Value);
                MenuSample2BackColorGreen = Byte.Parse(doc2.Element(ns + "MenuSample2BackColorGreen").Value);
                MenuSample2BackColorBlue = Byte.Parse(doc2.Element(ns + "MenuSample2BackColorBlue").Value);

                IsUseRenderer = doc2.Element(ns + "IsUseRenderer").Value;
            }
            catch { ;}
            mutex.ReleaseMutex();
        }

        public string ResetXML()
        {
            XNamespace ns = "OutWard_Menu";
            XElement doc = new XElement(ns + "Option",

                new XElement(ns + "MenuSample1ForeColorRed", SystemColors.WindowText.R.ToString()),
                new XElement(ns + "MenuSample1ForeColorGreen", SystemColors.WindowText.G.ToString()),
                new XElement(ns + "MenuSample1ForeColorBlue", SystemColors.WindowText.B.ToString()),

                new XElement(ns + "MenuSample1BackColorRed", SystemColors.Control.R.ToString()),
                new XElement(ns + "MenuSample1BackColorGreen", SystemColors.Control.G.ToString()),
                new XElement(ns + "MenuSample1BackColorBlue", SystemColors.Control.B.ToString()),

                new XElement(ns + "MenuSample2ForeColorRed", SystemColors.WindowText.R.ToString()),
                new XElement(ns + "MenuSample2ForeColorGreen", SystemColors.WindowText.G.ToString()),
                new XElement(ns + "MenuSample2ForeColorBlue", SystemColors.WindowText.B.ToString()),

                new XElement(ns + "MenuSample2BackColorRed", Color.FromArgb(255,209,226,242).R.ToString()),//SystemColors.Control.R.ToString()),
                new XElement(ns + "MenuSample2BackColorGreen", Color.FromArgb(255,209,226,242).G.ToString()),//SystemColors.Control.G.ToString()),
                new XElement(ns + "MenuSample2BackColorBlue", Color.FromArgb(255,209,226,242).B.ToString()),//SystemColors.Control.B.ToString()),

                new XElement(ns + "IsUseRenderer", "True"));

            FileIO.SaveShiftJis("setting", "outward_menu.xml", doc.ToString());

            return doc.ToString();
        }

        public void SaveFormToFile()
        {
            mutex.WaitOne();

            XNamespace ns = "OutWard_Menu";
            XElement doc = new XElement(ns + "Option",

                new XElement(ns + "MenuSample1ForeColorRed", MenuSample1ForeColorRed.ToString()),
                new XElement(ns + "MenuSample1ForeColorGreen", MenuSample1ForeColorGreen.ToString()),
                new XElement(ns + "MenuSample1ForeColorBlue", MenuSample1ForeColorBlue.ToString()),

                new XElement(ns + "MenuSample1BackColorRed", MenuSample1BackColorRed.ToString()),
                new XElement(ns + "MenuSample1BackColorGreen", MenuSample1BackColorGreen.ToString()),
                new XElement(ns + "MenuSample1BackColorBlue", MenuSample1BackColorBlue.ToString()),
                
                new XElement(ns + "MenuSample2ForeColorRed", MenuSample2ForeColorRed.ToString()),
                new XElement(ns + "MenuSample2ForeColorGreen", MenuSample2ForeColorGreen.ToString()),
                new XElement(ns + "MenuSample2ForeColorBlue", MenuSample2ForeColorBlue.ToString()),

                new XElement(ns + "MenuSample2BackColorRed", MenuSample2BackColorRed.ToString()),
                new XElement(ns + "MenuSample2BackColorGreen", MenuSample2BackColorGreen.ToString()),
                new XElement(ns + "MenuSample2BackColorBlue", MenuSample2BackColorBlue.ToString()),

                new XElement(ns + "IsUseRenderer", "True"));//this.IsUseRenderer));

            FileIO.SaveShiftJis("setting", "outward_menu.xml", doc.ToString());

            mutex.ReleaseMutex();
        }

        /*public Font FormFont
        {
            set
            {
                mutex.WaitOne();
                this.formFont = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                Font data = this.formFont;
                mutex.ReleaseMutex();
                return data;
            }
        }
        public String FormFontName
        {
            set
            {
                mutex.WaitOne();
                this.formFontName = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                string data = this.formFontName;
                mutex.ReleaseMutex();
                return data;
            }
        }

        public float FormFontSize
        {
            set
            {
                mutex.WaitOne();
                this.formFontSize = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                float data = this.formFontSize;
                mutex.ReleaseMutex();
                return data;
            }
        }*/

        //-------------------------------------
        public byte MenuSample1ForeColorRed
        {
            set
            {
                //if (CheckBool(value) == false) return;
                mutex.WaitOne();
                this.menuSample1ForeColorRed = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                byte data = this.menuSample1ForeColorRed;
                mutex.ReleaseMutex();
                return data;
            }
        }
        public byte MenuSample1ForeColorGreen
        {
            set
            {
                //if (CheckBool(value) == false) return;
                mutex.WaitOne();
                this.menuSample1ForeColorGreen = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                byte data = this.menuSample1ForeColorGreen;
                mutex.ReleaseMutex();
                return data;
            }
        }
        public byte MenuSample1ForeColorBlue
        {
            set
            {
                //if (CheckBool(value) == false) return;
                mutex.WaitOne();
                this.menuSample1ForeColorBlue = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                byte data = this.menuSample1ForeColorBlue;
                mutex.ReleaseMutex();
                return data;
            }
        }
        //-------------------------------------
        public byte MenuSample1BackColorRed
        {
            set
            {
                //if (CheckBool(value) == false) return;
                mutex.WaitOne();
                this.menuSample1BackColorRed = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                byte data = this.menuSample1BackColorRed;
                mutex.ReleaseMutex();
                return data;
            }
        }
        public byte MenuSample1BackColorGreen
        {
            set
            {
                //if (CheckBool(value) == false) return;
                mutex.WaitOne();
                this.menuSample1BackColorGreen = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                byte data = this.menuSample1BackColorGreen;
                mutex.ReleaseMutex();
                return data;
            }
        }
        public byte MenuSample1BackColorBlue
        {
            set
            {
                //if (CheckBool(value) == false) return;
                mutex.WaitOne();
                this.menuSample1BackColorBlue = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                byte data = this.menuSample1BackColorBlue;
                mutex.ReleaseMutex();
                return data;
            }
        }
        //-------------------------------------

        //-------------------------------------
        public byte MenuSample2ForeColorRed
        {
            set
            {
                //if (CheckBool(value) == false) return;
                mutex.WaitOne();
                this.menuSample2ForeColorRed = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                byte data = this.menuSample2ForeColorRed;
                mutex.ReleaseMutex();
                return data;
            }
        }
        public byte MenuSample2ForeColorGreen
        {
            set
            {
                //if (CheckBool(value) == false) return;
                mutex.WaitOne();
                this.menuSample2ForeColorGreen = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                byte data = this.menuSample2ForeColorGreen;
                mutex.ReleaseMutex();
                return data;
            }
        }
        public byte MenuSample2ForeColorBlue
        {
            set
            {
                //if (CheckBool(value) == false) return;
                mutex.WaitOne();
                this.menuSample2ForeColorBlue = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                byte data = this.menuSample2ForeColorBlue;
                mutex.ReleaseMutex();
                return data;
            }
        }
        //-------------------------------------
        public byte MenuSample2BackColorRed
        {
            set
            {
                //if (CheckBool(value) == false) return;
                mutex.WaitOne();
                this.menuSample2BackColorRed = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                byte data = this.menuSample2BackColorRed;
                mutex.ReleaseMutex();
                return data;
            }
        }
        public byte MenuSample2BackColorGreen
        {
            set
            {
                //if (CheckBool(value) == false) return;
                mutex.WaitOne();
                this.menuSample2BackColorGreen = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                byte data = this.menuSample2BackColorGreen;
                mutex.ReleaseMutex();
                return data;
            }
        }
        public byte MenuSample2BackColorBlue
        {
            set
            {
                //if (CheckBool(value) == false) return;
                mutex.WaitOne();
                this.menuSample2BackColorBlue = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                byte data = this.menuSample2BackColorBlue;
                mutex.ReleaseMutex();
                return data;
            }
        }
        //-------------------------------------

        //-------------------------------------
        public byte MenuSample3ForeColorRed
        {
            set
            {
                //if (CheckBool(value) == false) return;
                mutex.WaitOne();
                this.menuSample3ForeColorRed = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                byte data = this.menuSample3ForeColorRed;
                mutex.ReleaseMutex();
                return data;
            }
        }
        public byte MenuSample3ForeColorGreen
        {
            set
            {
                //if (CheckBool(value) == false) return;
                mutex.WaitOne();
                this.menuSample3ForeColorGreen = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                byte data = this.menuSample3ForeColorGreen;
                mutex.ReleaseMutex();
                return data;
            }
        }
        public byte MenuSample3ForeColorBlue
        {
            set
            {
                //if (CheckBool(value) == false) return;
                mutex.WaitOne();
                this.menuSample3ForeColorBlue = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                byte data = this.menuSample3ForeColorBlue;
                mutex.ReleaseMutex();
                return data;
            }
        }
        //-------------------------------------
        public byte MenuSample3BackColorRed
        {
            set
            {
                //if (CheckBool(value) == false) return;
                mutex.WaitOne();
                this.menuSample3BackColorRed = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                byte data = this.menuSample3BackColorRed;
                mutex.ReleaseMutex();
                return data;
            }
        }
        public byte MenuSample3BackColorGreen
        {
            set
            {
                //if (CheckBool(value) == false) return;
                mutex.WaitOne();
                this.menuSample3BackColorGreen = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                byte data = this.menuSample3BackColorGreen;
                mutex.ReleaseMutex();
                return data;
            }
        }
        public byte MenuSample3BackColorBlue
        {
            set
            {
                //if (CheckBool(value) == false) return;
                mutex.WaitOne();
                this.menuSample3BackColorBlue = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                byte data = this.menuSample3BackColorBlue;
                mutex.ReleaseMutex();
                return data;
            }
        }
        //-------------------------------------

        public string IsUseRenderer
        {
            set
            {
                this.isUseRenderer = value;
            }
            get
            {
                return this.isUseRenderer;
            }
        }
    }
}
