﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.Threading;

using System.Windows.Forms;

namespace nispi.controlclass
{
    /// <summary>
    /// ボタンのパーツ。ラッピング。
    /// </summary>
    class CheckBoxParts : ControlBase
    {
        private CheckBox control;

        public CheckBoxParts()
        {
            control = new CheckBox();
            controlBase = (System.Windows.Forms.Control)control;
        }

        public bool Checked
        {
            set
            {
                this.control.Checked = value;
            }
            get
            {
                return this.control.Checked;
            }
        }
    }

    class CheckBoxPartsManager
    {
        public static Stack<CheckBoxParts> buttonStack = new Stack<CheckBoxParts>();
        public static Mutex mutex = new Mutex(false, "CheckBoxPartsManager");

        public static CheckBoxParts Pop()
        {
            mutex.WaitOne();

            if (buttonStack.Count == 0)
                buttonStack.Push(new CheckBoxParts());

            CheckBoxParts buttonParts = buttonStack.Pop();

            mutex.ReleaseMutex();

            return buttonParts;
        }

        public static void Push(CheckBoxParts buttonParts)
        {
            buttonParts.ResetControlBase();

            mutex.WaitOne();

            buttonStack.Push(buttonParts);

            mutex.ReleaseMutex();
        }
    }
}