﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.Threading;
using System.Diagnostics;

using System.Windows.Forms;
using mshtml;

using nispi.Menu;

namespace nispi.controlclass
{
    class AddressMenuEvent
    {
        public string address;
        public BrowserAddressMenu browserAddressMenu;

        public AddressMenuEvent(BrowserAddressMenu browserAddressMenu)
        {
            this.browserAddressMenu = browserAddressMenu;

            browserAddressMenu.menuItemOpenBrowserParts.Click += new EventHandler(menuItemOpenBrowser_Click);
 
            browserAddressMenu.menuItemCopyURLParts.Click += new EventHandler(menuItemCopyURL_Click);
        }

        public void Show(BrowserParts browserParts, Point point, string address)
        {
            this.address = address;
            browserAddressMenu.contextMenuStripParts.Show(browserParts, point);
        }

        public bool CheckConsistency()
        {
            return true;
        }

        public void menuItemOpenBrowser_Click(object sender, EventArgs e)
        {
            if (CheckConsistency() == false)
                return;

            Process.Start(address);
        }

        public void menuItemCopyURL_Click(object sender, EventArgs e)
        {
            if (CheckConsistency() == false)
                return;

            Clipboard.SetDataObject(address, true);
        }
    }
}