//CZXAgeOntH_LISENCEtH_QƂĂ

using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;

namespace nispi
{
    class Board
    {
        public string title = "";
        public string url = "";

        public Board(string url, string title)
        {
            this.url = url;
            this.title = title;
        }
    }

    class BoardGroup
    {
        public string name = "";
        public List<Board> list = new List<Board>();

        public BoardGroup(string name)
        {
            this.name = name;
            //this.list = null;
        }

        public void Push(Board board)
        {
            this.list.Add(board);
        }

    }

    class BoardDataBase
    {
        private static Dictionary<string, string> nameDic = new Dictionary<string, string>();
        private static Dictionary<string, string> urlDic = new Dictionary<string, string>();

        //private static Dictionary<string[], string> urlDicFromNameAndType = new Dictionary<string[], string>();
        private static Mutex mutex = new Mutex(false, "BoardDataBase");

        public BoardDataBase()
        {
            //BoardManager.name_hash = null;
            //BoardManager.url_hash = null;
        }

        public static void MyClear()
        {
            mutex.WaitOne();

            nameDic.Clear();
            urlDic.Clear();

            mutex.ReleaseMutex();
        }

        public static void RegisterName(string url, string name)
        {
            mutex.WaitOne();

            if (nameDic.ContainsKey(url) == false)
            {
                nameDic.Add(url, name);
            }

            mutex.ReleaseMutex();
        }

        public static bool RegisterUrl(string type, string id, string url)
        {
            string key = type + id;

            mutex.WaitOne();

            if (urlDic.ContainsKey(key))
            {
                mutex.ReleaseMutex();
                return false;
            }
            else
            {
                urlDic.Add(key, url);

                mutex.ReleaseMutex();
                return true;
            }
        }
        //public static bool RegisterUrlFromNameAndType(s

        public static string GetName(string url)
        {
            mutex.WaitOne();
            
            if (Util.BoardUrlToBoardTypeName(url).Equals("screening") == true)
            {
                string temp = Util.BoardUrlToBoardID(url);
                string temp2 = BasicMapData.simpleNameDic[temp];

                mutex.ReleaseMutex();
                return temp2;
            }
            
            if (nameDic.ContainsKey(url) == true)
            {
                string value = StrUtil.GetStrCopy(nameDic[url]);
                mutex.ReleaseMutex();
                return value;
            }
            else
            {
                mutex.ReleaseMutex();
                return "";
            }
        }


        public static string GetUrl(string type, string id)
        {
            string key = type + id;

            mutex.WaitOne();

            if (type.Equals("screening") == true)
            {
                mutex.ReleaseMutex();

                string temp2 = "local://screening/" + id;
                return temp2;
            }

            if (urlDic.ContainsKey(key) == true)
            {
                string value = StrUtil.GetStrCopy(urlDic[key]);
                mutex.ReleaseMutex();
                return value;
            }
            else
            {
                mutex.ReleaseMutex();
                return "";
            }
        }
    }
}