﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;

using nispi.controlclass;

namespace nispi
{
    class Scale
    {
        static float dx = 0;
        static float dy = 0;
        static bool gBool = false;

        //引き算するための、引く方の値を得る。値が大きいほど引き算の結果は小さくなる
        public static Size GetMainSplitContainerMinusSize()
        {
            if (GetScale().Width == 96.0)
            {
                return new Size(16, 126);
            }
            else if (GetScale().Width == 120.0)
            {
                return new Size(18, 133);
            }
            else if (GetScale().Width == 144.0)
            {
                return new Size(22, 142);
            }
            else
            {
                return new Size(16, 117);
            }
        }
        //引き算するための、引く方の値を得る。値が大きいほど引き算の結果は小さくなる
        public static Size GetBrowserControlMinusSize()
        {
            if (GetScale().Width == 96.0)
            {
                return new Size(18, 41);
            }
            else if (GetScale().Width == 120.0)
            {
                return new Size(20, 49);
            }
            else if (GetScale().Width == 144.0)
            {
                return new Size(24, 58);
            }
            else
            {
                return new Size(18, 41);
            }
        }
        //スレッドのタブには常に３つタブを表示する。そのための計算。
        public static int GetTabSpaceWidth()
        {
            if (GetScale().Width == 96.0)
                return 50;
            else if (GetScale().Width == 120.0)
                return 60;
            else if (GetScale().Width == 144.0)
                return 70;
            else
                return 70;
        }
        public static SizeF GetScale()
        {
            if (gBool == false)
            {
                gBool = true;

                FormParts main = new FormParts();

                try
                {
                    using (Graphics g = main.CreateGraphics())
                    {
                        dx = g.DpiX;
                        dy = g.DpiY;
                        g.Dispose();
                    }
                }
                catch { ;}
            }
            return new SizeF(dx, dy);
        }
        //メインフォームのフォントのサイズのスケール後のサイズを計算する
        public static float GetScaledFloat()
        {
            float dpi = (float)(GetScale().Width);
            float realSize = 0F;
            float scaledFloat = 0F;
            float temp = 0F;

            if (dpi == 96.0)
                realSize = 100.0F;
            else if (dpi == 120.0)
                realSize = 125.0F;
            else if (dpi == 144)
                realSize = 150.0F;

            temp = 100.0F / realSize;
            scaledFloat = temp * Const.form.mainForm.GetFontSize();

            return scaledFloat;
        }
        //カレンダーの大きさ
        public static Size GetCalendarSize()
        {
            float dpi = (float)(GetScale().Width);
            Size size;

            if (dpi == 96.0)
                size = new Size(220, 166);
            else if (dpi == 120.0)
                size = new Size(273, 201);
            else if (dpi == 144)
                size = new Size(319, 238);
            else
                size = new Size(220, 166);

            return size;
        }
        //サイズを指定して、そのスケール後のサイズを計算する
        public static float GetScaledFloat(float fSize)
        {
            float dpi = (float)(GetScale().Width);
            float realSize = 0F;
            float scaledFloat = 0F;
            float temp = 0F;

            if (dpi == 96.0)
                realSize = 100.0F;
            else if (dpi == 120.0)
                realSize = 125.0F;
            else if (dpi == 144)
                realSize = 150.0F;

            temp = 100.0F / realSize;
            scaledFloat = temp * fSize;

            return scaledFloat;
        }

        //ツールチップのスケール。表示位置を割り出す。
        public static float GetMinusScaleToolTip()
        {
            float dpi = (float)(GetScale().Width);
            float minusLocationY = 0F;

            if (dpi == 96.0)
                minusLocationY = 20.0F;
            else if (dpi == 120.0)
                minusLocationY = 24.0F;
            else if (dpi == 144)
                minusLocationY = 29.0F;

            return minusLocationY;
        }
    }
}