﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Text;
using System.Text.RegularExpressions;
using System.Diagnostics;
using System.Threading;
//using System.Threading.Tasks;
using mshtml;
using System.Windows.Forms;

using MecInfoDll;
using nispi.OptionControl;

namespace nispi
{
    class CommentUtil
    {
        private string datUrl;

        public CommentUtil()
        {
        }
        public string to_html(Comment comment, string datUrl)
        {
            this.datUrl = datUrl;
            string html = string.Format("<div class='res_title' name='{0}'><a name='res{0}' href='javascript:void(0);#num{0}#{1}'>{0} </a> ",
                comment.num, datUrl);

            if (Const.opt.outWardBrowser.BrowserType.Equals("ageon") == true)
                html += string.Format("(<a name='resPop{0}' href='javascript:void(0);#POPNUM:#{0}#{1}'>ﾚｽ</a>)", comment.num, datUrl);
            else
                html += string.Format("<!--(<a name='resPop{0}' href='javascript:void(0);#POPNUM:#{0}#{1}'>ﾚｽ</a>)-->", comment.num, datUrl);

            if ((comment.mail != null) && (comment.mail.Length != 0))
                html += string.Format("名前:<a href='mailto:{0}' title='{1}'><b>{2}</b></a> : ",
                    comment.mail, comment.mail, comment.name);
            else
                html += string.Format("名前:<b>{0}</b> : ", comment.name);

            html += string.Format("{0} <a href='javascript:void(0);#ID:{1}#{2}'>{1}</a>", comment.date, comment.id, datUrl);
            
            //beの行//ほにゃ
            if (comment.beID.Length > 0)
                html += string.Format(" <a href='javascript:void(0);#BE:{2}#{3}'>{0}({1})</a>", 
                comment.beType,comment.bePoint, comment.beID, datUrl);


            html += string.Format("<div class='res_body'>{0}</div>", parse_body(comment.body));
            html += "<br>\r\n";
            html += string.Format("<table name='shiori{0}x' width='0' height='0' border='0' cellspacing='1' bgcolor='#ff6633'>" +
                "</table></div>", comment.num);
            return html;
        }

        public string ToAbonHtml(Comment comment, string datUrl)
        {
            this.datUrl = datUrl;
            string html = string.Format("<div class='res_title' name='{0}'><a name='res{0}' href='javascript:void(0);#num{0}#{1}'>{0} </a> ",
                comment.num, datUrl);

            if (Const.opt.outWardBrowser.BrowserType.Equals("ageon") == true)
                html += string.Format("(<a name='resPop{0}' href='javascript:void(0);#POPNUM:#{0}#{1}'>ﾚｽ</a>)", comment.num, datUrl);
            else
                html += string.Format("<!--(<a name='resPop{0}' href='javascript:void(0);#POPNUM:#{0}#{1}'>ﾚｽ</a>)-->", comment.num, datUrl);
            if ((comment.mail != null) && (comment.mail.Length != 0))
                html += string.Format("名前:<a href='mailto:{0}' title='{1}'><b>{2}</b></a> : ",
                    "あぼん", "あぼん", "あぼん");
            else
                html += string.Format("名前:<b>{0}</b> : ", "あぼん");

            html += string.Format("{0} <a href='javascript:void(0);#ID:{1}#{2}'>{1}</a>", comment.date, comment.id, datUrl);
            html += string.Format("<div class='res_body'>{0}</div>", GetAbonBody(comment, datUrl));
            html += "<br>\r\n";
            html += string.Format("<table name='shiori{0}x' width='0' height='0' border='0' cellspacing='1' bgcolor='#ff6633'>" +
                "</table></div>", comment.num);
            return html;
        }
        /*public string to_plain()
        {
            string text = string.Format("{0} 名前:{1} {2}\r\n", num, Util.to_palin(name), date);
            text += Util.to_palin(body);
            return text;
        }*/
        public string GetAbonBody(Comment comment, string datUrl)
        {
            return string.Format("<a name='resAbon{0}' href='javascript:void(0);#ABON:#{0}#{1}'>あぼんを表示</a>", comment.num, datUrl);

        }
        public string CapText1(Match m)
        {
            //return string.Format("<a href=\"http://{0}\" target=\"_blank\">{1}</a>", m.Groups[1].Value, m.Value.ToString());
            return string.Format("<a href='javascript:void(0);'>{1}</a>", m.Groups[1].Value, m.Value.ToString());
        }

        public string CapText2(Match m)
        {
            return string.Format("<a href='javascript:void(0);#res{0}#{2}'>{1}</a>", m.Groups[1].Value, m.Groups[2].Value, datUrl);
        }

        public string CapText3(Match m)
        {
            return string.Format("<a href='javascript:void(0);#res{0}#{2}'>{1}</a>", m.Groups[1].Value, m.Groups[2].Value, datUrl);
        }

        public string CapText4(Match m)
        {
            return string.Format("<a href='javascript:void(0);#res{0}#{2}'>{1}</a>", m.Groups[0].Value.Substring(8), m.Groups[0].Value, datUrl);
        }

        public string parse_body(string body)
        {
            //http
            Regex rgx = new Regex("h?t?tp://([-_.!~*\'()a-zA-Z0-9;/?:@&=+$$,%#]+)");
            string body2 = rgx.Replace(body, new MatchEvaluator(CapText1));
            //ttp
            rgx = new Regex("^ht?tp://([-_.!~*\'()a-zA-Z0-9;/?:@&=+$$,%#]+)");
            body2 = rgx.Replace(body2, new MatchEvaluator(CapText1));
            //https
            rgx = new Regex("https://([-_.!~*\'()a-zA-Z0-9;/?:@&=+$$,%#]+)");
            body2 = rgx.Replace(body2, new MatchEvaluator(CapText1));
            //ttps
            rgx = new Regex("^https://([-_.!~*\'()a-zA-Z0-9;/?:@&=+$$,%#]+)");
            body2 = rgx.Replace(body2, new MatchEvaluator(CapText1));
            //ftp
            rgx = new Regex("ftp://([-_.!~*\'()a-zA-Z0-9;/?:@&=+$$,%#]+)");
            body2 = rgx.Replace(body2, new MatchEvaluator(CapText1));

            //２ｃｈ内部
            rgx = new Regex("<a href=\"\\.\\./[^\"]*/([0-9]+)\" target=\"_blank\">([^<]+)</a>");
            body2 = rgx.Replace(body2, new MatchEvaluator(CapText2));
            //２ｃｈ内部(連番)
            rgx = new Regex("<a href=\"\\.\\./[^\"]*/([0-9]+\\-[0-9]+)\" target=\"_blank\">([^<]+)</a>");
            body2 = rgx.Replace(body2, new MatchEvaluator(CapText3));
            
            //2ch=> <a href="/test/read.cgi/newsplus/1421070861/1" target="_blank">
            //SC => <a href="../test/read.cgi/newsplus/1421049119/1" target="_blank">


           

            //2chSC内部
            rgx = new Regex("<a href=\"/[^\"]*/([0-9]+)\" target=\"_blank\">([^<]+)</a>");
            body2 = rgx.Replace(body2, new MatchEvaluator(CapText2));
            //2chSC内部(連番)
            rgx = new Regex("<a href=\"/[^\"]*/([0-9]+\\-[0-9]+)\" target=\"_blank\">([^<]+)</a>");
            body2 = rgx.Replace(body2, new MatchEvaluator(CapText3));


            //Open2ch内部
            if ( (Util.BoardType(Util.DatUrlToBoardUrl(this.datUrl)) == Util.TYPE_OPEN2CH) ||
                (Util.BoardType(Util.DatUrlToBoardUrl(this.datUrl)) == Util.TYPE_NEXT2CH) ||
                (Util.BoardType(Util.DatUrlToBoardUrl(this.datUrl)) == Util.TYPE_SHIZU) ||
                (Util.BoardType(Util.DatUrlToBoardUrl(this.datUrl)) == Util.TYPE_VIP2CH) ||
                (Util.BoardType(Util.DatUrlToBoardUrl(this.datUrl)) == Util.TYPE_MACHIBBS))
            {
                rgx = new Regex("&gt;&gt;([0-9]+)");
                body2 = rgx.Replace(body2, new MatchEvaluator(CapText4));
            }
            return body2;
        }

        //参考にさせて頂いたサイト
        //研Q5.文章を枠で囲む方法（HTML<div>タグのstyle属性で色､太さ､線種など自由自在に）
        //http://aminamura.blog.fc2.com/blog-entry-5.html
    }
}
