﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace nispi.OptionControl
{
    class BrowserOptionEvent
    {
        public BrowserOption browserOption;

        private bool changeFlag = false;

        public BrowserOptionEvent(BrowserOption browserOption)
        {
            this.browserOption = browserOption;
            SetEvent();
        }
        public void SetEvent()
        {
            this.browserOption.imageViewerRButtonParts.Click += new EventHandler(ChangeFlag);
            this.browserOption.imageOpenFileRButtonParts.Click += new EventHandler(ChangeFlag);
            this.browserOption.imageUsuallyViewerRButtonParts.Click += new EventHandler(ChangeFlag);
            this.browserOption.imageNotOpenRButtonParts.Click += new EventHandler(ChangeFlag);

            this.browserOption.linkUseallyViewerRButtonParts.Click += new EventHandler(ChangeFlag);
            this.browserOption.linkOpenFileRButtonParts.Click += new EventHandler(ChangeFlag);
            this.browserOption.linkNotOpenRButtonParts.Click += new EventHandler(ChangeFlag);

            this.browserOption.imageOpenTBoxParts.TextChanged += new EventHandler(ChangeFlag);
            this.browserOption.linkOpenTBoxParts.TextChanged += new EventHandler(ChangeFlag);

            this.browserOption.imageOpenFileRButtonParts.Click += new EventHandler(OpenImageFileButtonParts_Click);
            this.browserOption.imageOpenButtonParts.Click += new EventHandler(OpenImageFileButtonParts_Click);

            this.browserOption.linkOpenFileRButtonParts.Click += new EventHandler(OpenLinkFileButtonParts_Click);
            this.browserOption.linkOpenButtonParts.Click += new EventHandler(OpenLinkFileButtonParts_Click);
        }

        public void ResetEvent()
        {
            this.browserOption.imageViewerRButtonParts.Click -= new EventHandler(ChangeFlag);
            this.browserOption.imageOpenFileRButtonParts.Click -= new EventHandler(ChangeFlag);
            this.browserOption.imageUsuallyViewerRButtonParts.Click -= new EventHandler(ChangeFlag);
            this.browserOption.imageNotOpenRButtonParts.Click -= new EventHandler(ChangeFlag);

            this.browserOption.linkUseallyViewerRButtonParts.Click -= new EventHandler(ChangeFlag);
            this.browserOption.linkOpenFileRButtonParts.Click -= new EventHandler(ChangeFlag);
            this.browserOption.linkNotOpenRButtonParts.Click -= new EventHandler(ChangeFlag);

            this.browserOption.imageOpenTBoxParts.TextChanged -= new EventHandler(ChangeFlag);
            this.browserOption.linkOpenTBoxParts.TextChanged -= new EventHandler(ChangeFlag);

            this.browserOption.imageOpenFileRButtonParts.Click -= new EventHandler(OpenImageFileButtonParts_Click);
            this.browserOption.imageOpenButtonParts.Click -= new EventHandler(OpenImageFileButtonParts_Click);

            this.browserOption.linkOpenFileRButtonParts.Click -= new EventHandler(OpenLinkFileButtonParts_Click);
            this.browserOption.linkOpenButtonParts.Click -= new EventHandler(OpenLinkFileButtonParts_Click);

            //this.browserOption = null;
        }

        private void ChangeFlag(object sender, EventArgs e)
        {
            this.changeFlag = true;
        }

        private void OpenImageFileButtonParts_Click(object sender, EventArgs e)
        {
            string file = FormGUI.GetTargetFile(this.browserOption.optionTabMain.optionFormParts);

            //ダイアログを表示する
            if (file.Length > 0)
            {
                this.browserOption.imageOpenTBoxParts.Text = file;
                this.browserOption.imageOpenFileRButtonParts.Checked = true;
            }
        }
        private void OpenLinkFileButtonParts_Click(object sender, EventArgs e)
        {
            string file = FormGUI.GetTargetFile(this.browserOption.optionTabMain.optionFormParts);

            //ダイアログを表示する
            if (file.Length > 0)
            {
                this.browserOption.linkOpenTBoxParts.Text = file;
                this.browserOption.linkOpenFileRButtonParts.Checked = true;
            }
        }

        public void SetAllOption()
        {
            if (changeFlag == true)
            {
                changeFlag = false;

                if (this.browserOption.imageOpenFileRButtonParts.Checked == true)
                    this.browserOption.ImageBrowser = "file";
                else if (this.browserOption.imageViewerRButtonParts.Checked == true)
                    this.browserOption.ImageBrowser = "ageon";
                else if (this.browserOption.imageUsuallyViewerRButtonParts.Checked == true)
                    this.browserOption.ImageBrowser = "usually";
                else if (this.browserOption.imageNotOpenRButtonParts.Checked == true)
                    this.browserOption.ImageBrowser = "notopen";

                if (this.browserOption.linkOpenFileRButtonParts.Checked == true)
                    this.browserOption.LinkBrowser = "file";
                else if (this.browserOption.linkUseallyViewerRButtonParts.Checked == true)
                    this.browserOption.LinkBrowser = "usually";
                else if (this.browserOption.linkNotOpenRButtonParts.Checked == true)
                    this.browserOption.LinkBrowser = "notopen";

                this.browserOption.ImageBrowserFile = this.browserOption.imageOpenTBoxParts.Text;
                this.browserOption.LinkBrowserFile = this.browserOption.linkOpenTBoxParts.Text;

                this.browserOption.SaveToFile();
            }
            else
            {
                ;
            }
        }
    }
}
