﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using nispi.controlclass;

namespace nispi.OptionControl
{
    class OutWardEventTab
    {
        private OutWardTab outWardOption;
        public bool changeFlag = false;

        public OutWardEventTab(OutWardTab outWardOption)
        {
            this.outWardOption = outWardOption;
            SetEvent();
        }
        public void SetEvent()
        {
            this.outWardOption.tabFontButtonParts.Click += new EventHandler(tabFontButtonParts_Click);
            this.outWardOption.tabBackColorButtonParts.Click += new EventHandler(tabBackColorButtonParts_Click);

            this.outWardOption.tabColorStartButtonParts.Click += new EventHandler(tabColorStartButtonParts_Click);
            this.outWardOption.tabColorEndButtonParts.Click += new EventHandler(tabColorEndButtonParts_Click);

            this.outWardOption.tabResetButtonParts.Click += new EventHandler(tabResetButtonParts_Click);

            //チェンジイベント
            this.outWardOption.tabFontButtonParts.Click += new EventHandler(ChangeFlag);
            this.outWardOption.tabBackColorButtonParts.Click += new EventHandler(ChangeFlag);

            this.outWardOption.tabColorStartButtonParts.Click += new EventHandler(ChangeFlag);
            this.outWardOption.tabColorEndButtonParts.Click += new EventHandler(ChangeFlag);

            this.outWardOption.tabResetButtonParts.Click += new EventHandler(ChangeFlag);
        }
        public void ResetEvent()
        {
            this.outWardOption.tabFontButtonParts.Click -= new EventHandler(tabFontButtonParts_Click);
            this.outWardOption.tabBackColorButtonParts.Click -= new EventHandler(tabBackColorButtonParts_Click);

            this.outWardOption.tabColorStartButtonParts.Click -= new EventHandler(tabColorStartButtonParts_Click);
            this.outWardOption.tabColorEndButtonParts.Click -= new EventHandler(tabColorEndButtonParts_Click);

            this.outWardOption.tabResetButtonParts.Click -= new EventHandler(tabResetButtonParts_Click);

            //チェンジイベント
            this.outWardOption.tabFontButtonParts.Click -= new EventHandler(ChangeFlag);
            this.outWardOption.tabBackColorButtonParts.Click -= new EventHandler(ChangeFlag);

            this.outWardOption.tabColorStartButtonParts.Click -= new EventHandler(ChangeFlag);
            this.outWardOption.tabColorEndButtonParts.Click -= new EventHandler(ChangeFlag);

            this.outWardOption.tabResetButtonParts.Click -= new EventHandler(ChangeFlag);
        }

        private void ChangeFlag(object sender, EventArgs e)
        {
            this.changeFlag = true;
        }

        //フォントのウィンドウを開く
        //サイズによってはタブの大きさを変える
        public void tabFontButtonParts_Click(object sender, EventArgs e)
        {
            ColorSet colorSet = new ColorSet();
            if (true == FormGUI.GetColor(colorSet))
            {
                //ラベルを書き換える。実データは書き換えない
                this.outWardOption.tabSampleTabControlParts.TabGradient_TabPageSelectedTextColor = Color.FromArgb(
                    colorSet.red,
                    colorSet.green,
                    colorSet.blue);
            }
        }
        //キャプションウィンドウも作り変える


        //背景色を得る
        public void tabBackColorButtonParts_Click(object sender, EventArgs e)
        {
            ColorSet colorSet = new ColorSet();
            if (true == FormGUI.GetColor(colorSet))
            {
                //ラベルを書き換える
                this.outWardOption.sampleTabPageParts.BackColor = Color.FromArgb(
                    colorSet.red,
                    colorSet.green,
                    colorSet.blue);
            }
        }

        //タブのグラデーション開始色
        public void tabColorStartButtonParts_Click(object sender, EventArgs e)
        {
            ColorSet colorSet = new ColorSet();
            if (true == FormGUI.GetColor(colorSet))
            {
                //ラベルを書き換える
                this.outWardOption.tabSampleTabControlParts.TabGradient_ColorStart = Color.FromArgb(
                    colorSet.red,
                    colorSet.green,
                    colorSet.blue);
            }
        }
        //タブのグラデーション終了色
        public void tabColorEndButtonParts_Click(object sender, EventArgs e)
        {
            ColorSet colorSet = new ColorSet();
            if (true == FormGUI.GetColor(colorSet))
            {
                //ラベルを書き換える
                this.outWardOption.tabSampleTabControlParts.TabGradient_ColorEnd = Color.FromArgb(
                    colorSet.red,
                    colorSet.green,
                    colorSet.blue);
            }
        }
        //リセットをする
        public void tabResetButtonParts_Click(object sender, EventArgs e)
        {
            this.outWardOption.sampleTabPageParts.SetFont(outWardOption.optionTabMain.fontNameStd, outWardOption.optionTabMain.fontSizeStd);

            this.outWardOption.tabSampleTabControlParts.TabGradient_TabPageSelectedTextColor = SystemColors.WindowText;

            this.outWardOption.sampleTabPageParts.BackColor = SystemColors.Control;

            this.outWardOption.tabSampleTabControlParts.TabGradient_ColorStart = SystemColors.Control;

            this.outWardOption.tabSampleTabControlParts.TabGradient_ColorEnd = SystemColors.Control;
        }

        public void SetAllOption()
        {
            if (changeFlag == true)
            {
                changeFlag = false;
                {
                    this.outWardOption.TabFontName = this.outWardOption.sampleTabPageParts.GetFontName();
                    this.outWardOption.TabFontSize = this.outWardOption.sampleTabPageParts.GetFontSize();

                    this.outWardOption.TabForeColorRed = this.outWardOption.tabSampleTabControlParts.TabGradient_TabPageSelectedTextColor.R;
                    this.outWardOption.TabForeColorGreen = this.outWardOption.tabSampleTabControlParts.TabGradient_TabPageSelectedTextColor.G;
                    this.outWardOption.TabForeColorBlue = this.outWardOption.tabSampleTabControlParts.TabGradient_TabPageSelectedTextColor.B;

                    this.outWardOption.TabBackColorRed = this.outWardOption.sampleTabPageParts.BackColor.R;
                    this.outWardOption.TabBackColorGreen = this.outWardOption.sampleTabPageParts.BackColor.G;
                    this.outWardOption.TabBackColorBlue = this.outWardOption.sampleTabPageParts.BackColor.B;

                    this.outWardOption.TabColorStartRed = this.outWardOption.tabSampleTabControlParts.TabGradient_ColorStart.R;
                    this.outWardOption.TabColorStartGreen = this.outWardOption.tabSampleTabControlParts.TabGradient_ColorStart.G;
                    this.outWardOption.TabColorStartBlue = this.outWardOption.tabSampleTabControlParts.TabGradient_ColorStart.B;

                    this.outWardOption.TabColorEndRed = this.outWardOption.tabSampleTabControlParts.TabGradient_ColorEnd.R;
                    this.outWardOption.TabColorEndGreen = this.outWardOption.tabSampleTabControlParts.TabGradient_ColorEnd.G;
                    this.outWardOption.TabColorEndBlue = this.outWardOption.tabSampleTabControlParts.TabGradient_ColorEnd.B;

                    this.outWardOption.SaveTabToFile();

                    //TabControlPartsManager.ChangeOutWard();
                }
            }
        }
    }
}
