﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.Threading;

using System.Windows.Forms;

namespace nispi.controlclass
{
    class ToolStripParts:ControlBase
    {
        private ToolStrip control;

        public ToolStripParts()
        {
            control = new ToolStrip();
            this.control.ImageScalingSize = new Size(24, 24);
            //this.control.Location = new Point(0, 0);
            this.control.Name = "toolStrip1";
            //this.control.GripStyle = ToolStripGripStyle.Hidden;
            this.controlBase = (Control)control;
        }
        public void AddItem(ToolStripButtonParts controls)//(ToolStripButtonParts parts1, ToolStripButtonParts parts2, ToolStripButtonParts parts3, ToolStripTextBoxParts  parts4)
        {
            this.control.Items.Add(controls.control as ToolStripItem);
        }
        public void AddItemToolStripText(ToolStripTextBoxParts controlParts)
        {
            this.control.Items.Add(controlParts.control as ToolStripItem);
        }
        public void RemoveAllItem()
        {
            this.control.Items.Clear();
        }
    }
    /// <summary>
    /// タブページのスタックを作る。足りなければ新たに作成する。
    /// 多すぎればある程度まで削減する機能があってもいい
    /// </summary>
    class ToolStripPartsManager
    {
        public static LinkedList<ToolStripParts> allFormList = new LinkedList<ToolStripParts>();
        public static Stack<ToolStripParts> tabPageStack = new Stack<ToolStripParts>();
        public static Mutex mutex = new Mutex(false, "ToolStripPartsManager");

        public static ToolStripParts Pop()
        {
            mutex.WaitOne();

            if (tabPageStack.Count == 0)
                tabPageStack.Push(new ToolStripParts());

            ToolStripParts tabPage = tabPageStack.Pop();

            //GUIのリストを作成する
            if (null == allFormList.Find(tabPage))
            {
                ChangeOutWard(tabPage);
                allFormList.AddLast(tabPage);
            }

            mutex.ReleaseMutex();

            return tabPage;
        }

        public static void Push(ToolStripParts tabPage)
        {
            mutex.WaitOne();

            tabPageStack.Push(tabPage);

            mutex.ReleaseMutex();
        }

        public static void ChangeOutWard()
        {
            mutex.WaitOne();

            Const.form.mainForm.SuspendLayout();
            Const.mapForm.mapMainForm.SuspendLayout();

            foreach (ToolStripParts parts in allFormList)
            {
                parts.ForeColor = Color.FromArgb(
                    Const.opt.outWardForm.FormForeColorRed,
                    Const.opt.outWardForm.FormForeColorGreen,
                    Const.opt.outWardForm.FormForeColorBlue);
                parts.BackColor = Color.FromArgb(
                    Const.opt.outWardForm.FormBackColorRed,
                    Const.opt.outWardForm.FormBackColorGreen,
                    Const.opt.outWardForm.FormBackColorBlue);
            }

            Const.form.mainForm.Refresh();
            Const.mapForm.mapMainForm.Refresh();
            Const.form.mainForm.Update();
            Const.mapForm.mapMainForm.Update();

            Const.mapForm.mapMainForm.ResumeLayout();
            Const.form.mainForm.ResumeLayout();


            mutex.ReleaseMutex();
        }

        public static void ChangeOutWard(ToolStripParts parts)
        {
            parts.ForeColor = Color.FromArgb(
                Const.opt.outWardForm.FormForeColorRed,
                Const.opt.outWardForm.FormForeColorGreen,
                Const.opt.outWardForm.FormForeColorBlue);
            parts.BackColor = Color.FromArgb(
                Const.opt.outWardForm.FormBackColorRed,
                Const.opt.outWardForm.FormBackColorGreen,
                Const.opt.outWardForm.FormBackColorBlue);

            float scaledFloat = Scale.GetScaledFloat();

            parts.SetFont(Const.form.mainForm.GetFontName(), scaledFloat);
        }
    }
}
