﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.Threading;

using System.Windows.Forms;


namespace nispi.controlclass
{


    class TabControlParts : ControlBase
    {
        public KRBTabControl control;

        public TabControlParts()
        {
            control = new KRBTabControl();

            this.control.AllowDrop = false;
            this.control.ItemSize = new Size(0, 26);
            this.control.TabStyles = KRBTabControl.TabStyle.KRBStyle;
            this.control.BackgroundColor = Color.LightSteelBlue;
            this.control.IsDrawHeader = true;
            this.control.HeaderStyle = KRBTabControl.TabHeaderStyle.Texture; ;
            this.control.IsCaptionVisible = false;
            this.control.Location = new Point(1, 1);
            this.control.TabGradient.ColorEnd = SystemColors.Control;
            this.control.TabGradient.ColorStart = Color.AliceBlue;
            this.control.IsDrawEdgeBorder = false;
            this.control.TabGradient.GradientStyle = System.Drawing.Drawing2D.LinearGradientMode.Vertical;
            this.control.IsDrawTabSeparator = true;

            this.control.MouseDoubleClick += new MouseEventHandler(tabPageMouseDoubleClick);
            this.control.UpDownStyle = nispi.KRBTabControl.UpDown32Style.OfficeBlue;////.Default;
            this.control.Font = new Font("ＭＳ Ｐゴシック", 12.0F, FontStyle.Regular, GraphicsUnit.Point, ((byte)(128)));
            this.controlBase = (Control)control;

        }
        public void tabPageMouseDoubleClick(object sender, MouseEventArgs e)
        {
            if (this.Name.Equals("threadListTabControlParts") == true)
                MainFormConst.threadListTabMain.viewList[this.control.SelectedIndex].Reload();
            else if (this.Name.Equals("boardListTabControlParts") == true)
                MainFormConst.boardListTabMain.view_list[this.control.SelectedIndex].reload();
            else if (this.Name.Equals("boardIndexTabControlParts") == true)
            {
                if (Const.form.boardIndexTabControlParts.SelectedIndex == 0)
                    MainFormConst.boardIndexTabMain.boardIndexView.LoadBoardList();
                else if (Const.form.boardIndexTabControlParts.SelectedIndex == 1)
                    MainFormConst.boardIndexTabMain.scBoardIndexView.LoadBoardList();
                else if (Const.form.boardIndexTabControlParts.SelectedIndex == 2)
                    MainFormConst.boardIndexTabMain.open2chBoardIndexView.LoadBoardList();
                else if (Const.form.boardIndexTabControlParts.SelectedIndex == 3)
                    MainFormConst.boardIndexTabMain.next2chBoardIndexView.LoadBoardList();

                else if (Const.form.boardIndexTabControlParts.SelectedIndex == 4)
                    MainFormConst.boardIndexTabMain.jikkyoBoardIndexView.LoadBoardList();
                else if (Const.form.boardIndexTabControlParts.SelectedIndex == 5)
                    MainFormConst.boardIndexTabMain.blogbanBoardIndexView.LoadBoardList();
                else if (Const.form.boardIndexTabControlParts.SelectedIndex == 6)
                    MainFormConst.boardIndexTabMain.shizuBoardIndexView.LoadBoardList();

                else if (Const.form.boardIndexTabControlParts.SelectedIndex == 7)
                    MainFormConst.boardIndexTabMain.vip2chBoardIndexView.LoadBoardList();
                else if (Const.form.boardIndexTabControlParts.SelectedIndex == 8)
                    MainFormConst.boardIndexTabMain.machibbsBoardIndexView.LoadBoardList();

                else
                    MainFormConst.boardIndexTabMain.favoriteBoardIndexView.LoadFavoriteBoardList();
            }
        }

        public event TabControlEventHandler Selected
        {
            add
            {
                this.control.Selected += value;
            }
            remove
            {
                this.control.Selected -= value;
            }
        }

        public Control.ControlCollection Controls
        {
            get
            {
                return this.control.Controls;
            }
        }

        //オプション（設定）用の外観を作る
        public void SetOptionParts()
        {
            this.control.TabGradient.ColorEnd = Color.RoyalBlue;
            this.control.TabGradient.ColorStart = Color.White;
        }
        public void Set_TabSizeMode_Fixed()
        {
            this.control.SizeMode = TabSizeMode.Fixed;
        }

        //選択する時のイベント
        /*public TabControlCancelEventHandler currentTabControlCancelEventHandler;
        public void SetTabSelecting(TabControlPartsDelegate.MultiTabControlCancelEventHandler method)
        {
            currentTabControlCancelEventHandler = new TabControlCancelEventHandler(method);
            this.control.Selecting += currentTabControlCancelEventHandler;
        }

        public void ReSetTabSelecting()
        {
            this.control.Selecting -= currentTabControlCancelEventHandler;
        }
        public event TabControlPartsDelegate.MultiTabControlCancelEventHandler Selecting
        {
            add
            {
                currentTabControlCancelEventHandler = new TabControlCancelEventHandler(value);
                this.control.Selecting += currentTabControlCancelEventHandler;
            }
            remove
            {
                this.control.Selecting -= currentTabControlCancelEventHandler;
            }
        }*/
        public int Count
        {
            get
            {
                return this.control.Controls.Count;
            }
        }
        public TabPageExParts SelectedTab
        {
            set
            {
                this.control.SelectedTab = (TabPageEx)value.control;
            }
        }
        public TabPage GetSelectedTab()
        {
            return this.control.SelectedTab;
        }
        public Rectangle GetTabRect(int num)
        {
            return this.control.GetTabRect(num);
        }
        public ImageList ImageList
        {
            set
            {
                this.control.ImageList = value;
            }
            get
            {
                return this.control.ImageList;
            }
        }

        public int SelectedIndex
        {
            set
            {
                this.control.SelectedIndex = value;
            }
            get
            {
                return this.control.SelectedIndex;
            }
        }

        public bool IsCaptionVisible
        {
            set
            {
                this.control.IsCaptionVisible = value;
            }
        }
        public string SelectedTabName
        {
            set
            {
                this.control.SelectedTab.Name = value;
            }
            get
            {
                return this.control.SelectedTab.Name;
            }
        }
        public string SelectedTabText
        {
            set
            {
                this.control.SelectedTab.Text = value;
            }
            get
            {
                return this.control.SelectedTab.Text;
            }
        }
        public Size ItemSize
        {
            set
            {
                this.control.ItemSize = value;
            }
        }

        public Color TabGradient_ColorStart
        {
            set
            {
                this.control.TabGradient.ColorStart = value;
            }
            get
            {
                return this.control.TabGradient.ColorStart;
            }
        }
        public Color TabGradient_ColorEnd
        {
            set
            {
                this.control.TabGradient.ColorEnd = value;
            }
            get
            {
                return this.control.TabGradient.ColorEnd;
            }
        }

        public Color TabGradient_TabPageSelectedTextColor
        {
            set
            {
                this.control.TabGradient.TabPageSelectedTextColor = value;
            }
            get
            {
                return this.control.TabGradient.TabPageSelectedTextColor;
            }
        }
        public Color TabGradient_TabPageTextColor
        {
            set
            {
                this.control.TabGradient.TabPageTextColor = value;
            }
            get
            {
                return this.control.TabGradient.TabPageTextColor;
            }
        }

        public void RemoveIndex(int index)
        {
            this.control.Controls.RemoveAt(index);
        }
    }
    /// <summary>
    /// タブページのスタックを作る。足りなければ新たに作成する。
    /// 多すぎればある程度まで削減する機能があってもいい
    /// </summary>
    class TabControlPartsManager
    {
        public static LinkedList<TabControlParts> allFormList = new LinkedList<TabControlParts>();
        public static Stack<TabControlParts> tabPageStack = new Stack<TabControlParts>();
        public static Mutex mutex = new Mutex(false, "TabControlPartsManager");

        public static TabControlParts Pop()
        {
            mutex.WaitOne();

            if (tabPageStack.Count == 0)
            {
                TabControlParts tempParts = new TabControlParts();
                ChangeOutWard(tempParts);
                tabPageStack.Push(tempParts);
            }
            TabControlParts tabPage = tabPageStack.Pop();

            //GUIのリストを作成する
            if (null == allFormList.Find(tabPage))
                allFormList.AddLast(tabPage);

            mutex.ReleaseMutex();

            return tabPage;
        }

        public static void Push(TabControlParts tabPage)
        {
            tabPage.ResetControlBase();

            mutex.WaitOne();

            tabPageStack.Push(tabPage);

            mutex.ReleaseMutex();
        }

        public static void ChangeOutWard()
        {
            mutex.WaitOne();

            Const.form.mainForm.SuspendLayout();
            Const.mapForm.mapMainForm.SuspendLayout();

            foreach (TabControlParts parts in allFormList)
            {
                parts.SuspendLayout();

                parts.SetFont(Const.opt.outWardTab.TabFontName, Const.opt.outWardTab.TabFontSize);

                parts.ForeColor = Color.FromArgb(
                    Const.opt.outWardTab.TabForeColorRed,
                    Const.opt.outWardTab.TabForeColorGreen,
                    Const.opt.outWardTab.TabForeColorBlue);

                parts.BackColor = Color.FromArgb(
                    Const.opt.outWardTab.TabBackColorRed,
                    Const.opt.outWardTab.TabBackColorGreen,
                    Const.opt.outWardTab.TabBackColorBlue);

                parts.TabGradient_ColorStart = Color.FromArgb(
                    Const.opt.outWardTab.TabColorStartRed,
                    Const.opt.outWardTab.TabColorStartGreen,
                    Const.opt.outWardTab.TabColorStartBlue);

                parts.TabGradient_ColorEnd = Color.FromArgb(
                    Const.opt.outWardTab.TabColorEndRed,
                    Const.opt.outWardTab.TabColorEndGreen,
                    Const.opt.outWardTab.TabColorEndBlue);

                parts.TabGradient_TabPageSelectedTextColor = Color.FromArgb(
                    Const.opt.outWardTab.TabForeColorRed,
                    Const.opt.outWardTab.TabForeColorGreen,
                    Const.opt.outWardTab.TabForeColorBlue);

                //タブの詮索されてない時の色はFormの文字色にする
                parts.TabGradient_TabPageTextColor = Color.FromArgb(
                    Const.opt.outWardForm.FormForeColorRed,
                    Const.opt.outWardForm.FormForeColorGreen,
                    Const.opt.outWardForm.FormForeColorBlue);

                parts.ResumeLayout();
            }
            Const.form.mainForm.Refresh();
            Const.mapForm.mapMainForm.Refresh();
            Const.form.mainForm.Update();
            Const.mapForm.mapMainForm.Update();

            Const.mapForm.mapMainForm.ResumeLayout();
            Const.form.mainForm.ResumeLayout();



            mutex.ReleaseMutex();
        }

        public static void ChangeOutWard(TabControlParts parts)
        {
            Const.form.mainForm.Invoke((Action)(() => parts.SetFont(Const.opt.outWardTab.TabFontName, Const.opt.outWardTab.TabFontSize)));

            parts.ForeColor = Color.FromArgb(
                Const.opt.outWardTab.TabForeColorRed,
                Const.opt.outWardTab.TabForeColorGreen,
                Const.opt.outWardTab.TabForeColorBlue);

            parts.BackColor = Color.FromArgb(
                Const.opt.outWardTab.TabBackColorRed,
                Const.opt.outWardTab.TabBackColorGreen,
                Const.opt.outWardTab.TabBackColorBlue);

            parts.TabGradient_ColorStart = Color.FromArgb(
                Const.opt.outWardTab.TabColorStartRed,
                Const.opt.outWardTab.TabColorStartGreen,
                Const.opt.outWardTab.TabColorStartBlue);

            parts.TabGradient_ColorEnd = Color.FromArgb(
                Const.opt.outWardTab.TabColorEndRed,
                Const.opt.outWardTab.TabColorEndGreen,
                Const.opt.outWardTab.TabColorEndBlue);

            parts.TabGradient_TabPageSelectedTextColor = Color.FromArgb(
                Const.opt.outWardTab.TabForeColorRed,
                Const.opt.outWardTab.TabForeColorGreen,
                Const.opt.outWardTab.TabForeColorBlue);

            //タブの詮索されてない時の色はFormの文字色にする
            parts.TabGradient_TabPageTextColor = Color.FromArgb(
                Const.opt.outWardForm.FormForeColorRed,
                Const.opt.outWardForm.FormForeColorGreen,
                Const.opt.outWardForm.FormForeColorBlue);

            //float scaledFloat = Scale.GetScaledFloat();

            //parts.SetFont(Const.form.mainForm.GetFontName(), scaledFloat);
        }
    }
}
