﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.Threading;

using System.Windows.Forms;


namespace nispi.controlclass
{
    public class TabControlPartsDelegate
    {
        public delegate void MultiTabControlCancelEventHandler(object sender, TabControlCancelEventArgs e);
    }

    class NormalTabControlParts : ControlBase
    {
        public TabControl control;

        public NormalTabControlParts()
        {
            control = new TabControl();

            this.control.AllowDrop = false;
            this.control.ItemSize = new Size(0, 26);
            this.control.Location = new Point(1, 1);
            this.control.Font = new Font("ＭＳ Ｐゴシック", 12.0F, FontStyle.Regular, GraphicsUnit.Point, ((byte)(128)));
            this.controlBase = (Control)control;
            this.control.Multiline = true;
        }

        public event TabControlEventHandler Selected
        {
            add
            {
                this.control.Selected += value;
            }
            remove
            {
                this.control.Selected -= value;
            }
        }

        public Control.ControlCollection Controls
        {
            get
            {
                return this.control.Controls;
            }
        }

        public void Set_TabSizeMode_Fixed()
        {
            this.control.SizeMode = TabSizeMode.Fixed;
        }

        public int Count
        {
            get
            {
                return this.control.Controls.Count;
            }
        }
        public TabPageExParts SelectedTab
        {
            set
            {
                this.control.SelectedTab = (TabPageEx)value.control;
            }
        }
        public TabPage GetSelectedTab()
        {
            return this.control.SelectedTab;
        }
        public Rectangle GetTabRect(int num)
        {
            return this.control.GetTabRect(num);
        }
        public ImageList ImageList
        {
            set
            {
                this.control.ImageList = value;
            }
            get
            {
                return this.control.ImageList;
            }
        }

        public int SelectedIndex
        {
            set
            {
                this.control.SelectedIndex = value;
            }
            get
            {
                return this.control.SelectedIndex;
            }
        }

        public bool IsCaptionVisible
        {
            set
            {
                ;
            }
        }
        public string SelectedTabName
        {
            set
            {
                this.control.SelectedTab.Name = value;
            }
            get
            {
                return this.control.SelectedTab.Name;
            }
        }
        public string SelectedTabText
        {
            set
            {
                this.control.SelectedTab.Text = value;
            }
            get
            {
                return this.control.SelectedTab.Text;
            }
        }
        public Size ItemSize
        {
            set
            {
                this.control.ItemSize = value;
            }
        }

        public Color TabGradient_ColorStart
        {
            set
            {
                ;
            }
        }
        public Color TabGradient_ColorEnd
        {
            set
            {
                ;
            }
        }

        public Color TabGradient_TabPageSelectedTextColor
        {
            set
            {
                ;
            }

        }
        public Color TabGradient_TabPageTextColor
        {
            set
            {
                ;
            }
        }

        public void RemoveIndex(int index)
        {
            this.control.Controls.RemoveAt(index);
        }
    }
    /// <summary>
    /// タブページのスタックを作る。足りなければ新たに作成する。
    /// 多すぎればある程度まで削減する機能があってもいい
    /// </summary>
    class NormalTabControlPartsManager
    {
        public static LinkedList<NormalTabControlParts> allFormList = new LinkedList<NormalTabControlParts>();
        public static Stack<NormalTabControlParts> tabPageStack = new Stack<NormalTabControlParts>();
        public static Mutex mutex = new Mutex(false, "NormalTabControlPartsManager");

        public static NormalTabControlParts Pop()
        {
            mutex.WaitOne();

            if (tabPageStack.Count == 0)
            {
                NormalTabControlParts tempParts = new NormalTabControlParts();
                //ChangeOutWard(tempParts);
                tabPageStack.Push(tempParts);
            }
            NormalTabControlParts tabPage = tabPageStack.Pop();

            //GUIのリストを作成する
            if (null == allFormList.Find(tabPage))
                allFormList.AddLast(tabPage);

            mutex.ReleaseMutex();

            return tabPage;
        }

        public static void Push(NormalTabControlParts tabPage)
        {
            tabPage.ResetControlBase();

            mutex.WaitOne();

            tabPageStack.Push(tabPage);

            mutex.ReleaseMutex();
        }

        public static void ChangeOutWard()
        {
            mutex.WaitOne();

            Const.form.mainForm.SuspendLayout();
            Const.mapForm.mapMainForm.SuspendLayout();

            foreach (NormalTabControlParts parts in allFormList)
            {
                parts.SuspendLayout();

                parts.SetFont(Const.opt.outWardTab.TabFontName, Const.opt.outWardTab.TabFontSize);

                parts.ForeColor = Color.FromArgb(
                    Const.opt.outWardTab.TabForeColorRed,
                    Const.opt.outWardTab.TabForeColorGreen,
                    Const.opt.outWardTab.TabForeColorBlue);

                parts.BackColor = Color.FromArgb(
                    Const.opt.outWardTab.TabBackColorRed,
                    Const.opt.outWardTab.TabBackColorGreen,
                    Const.opt.outWardTab.TabBackColorBlue);

                parts.TabGradient_ColorStart = Color.FromArgb(
                    Const.opt.outWardTab.TabColorStartRed,
                    Const.opt.outWardTab.TabColorStartGreen,
                    Const.opt.outWardTab.TabColorStartBlue);

                parts.TabGradient_ColorEnd = Color.FromArgb(
                    Const.opt.outWardTab.TabColorEndRed,
                    Const.opt.outWardTab.TabColorEndGreen,
                    Const.opt.outWardTab.TabColorEndBlue);

                parts.TabGradient_TabPageSelectedTextColor = Color.FromArgb(
                    Const.opt.outWardTab.TabForeColorRed,
                    Const.opt.outWardTab.TabForeColorGreen,
                    Const.opt.outWardTab.TabForeColorBlue);

                //タブの詮索されてない時の色はFormの文字色にする
                parts.TabGradient_TabPageTextColor = Color.FromArgb(
                    Const.opt.outWardForm.FormForeColorRed,
                    Const.opt.outWardForm.FormForeColorGreen,
                    Const.opt.outWardForm.FormForeColorBlue);

                parts.ResumeLayout();
            }
            Const.form.mainForm.Refresh();
            Const.mapForm.mapMainForm.Refresh();
            Const.form.mainForm.Update();
            Const.mapForm.mapMainForm.Update();

            Const.mapForm.mapMainForm.ResumeLayout();
            Const.form.mainForm.ResumeLayout();



            mutex.ReleaseMutex();
        }

        public static void ChangeOutWard(TabControlParts parts)
        {
            Const.form.mainForm.Invoke((Action)(() => parts.SetFont(Const.opt.outWardTab.TabFontName, Const.opt.outWardTab.TabFontSize)));

            parts.ForeColor = Color.FromArgb(
                Const.opt.outWardTab.TabForeColorRed,
                Const.opt.outWardTab.TabForeColorGreen,
                Const.opt.outWardTab.TabForeColorBlue);

            parts.BackColor = Color.FromArgb(
                Const.opt.outWardTab.TabBackColorRed,
                Const.opt.outWardTab.TabBackColorGreen,
                Const.opt.outWardTab.TabBackColorBlue);

            parts.TabGradient_ColorStart = Color.FromArgb(
                Const.opt.outWardTab.TabColorStartRed,
                Const.opt.outWardTab.TabColorStartGreen,
                Const.opt.outWardTab.TabColorStartBlue);

            parts.TabGradient_ColorEnd = Color.FromArgb(
                Const.opt.outWardTab.TabColorEndRed,
                Const.opt.outWardTab.TabColorEndGreen,
                Const.opt.outWardTab.TabColorEndBlue);

            parts.TabGradient_TabPageSelectedTextColor = Color.FromArgb(
                Const.opt.outWardTab.TabForeColorRed,
                Const.opt.outWardTab.TabForeColorGreen,
                Const.opt.outWardTab.TabForeColorBlue);

            //タブの詮索されてない時の色はFormの文字色にする
            parts.TabGradient_TabPageTextColor = Color.FromArgb(
                Const.opt.outWardForm.FormForeColorRed,
                Const.opt.outWardForm.FormForeColorGreen,
                Const.opt.outWardForm.FormForeColorBlue);

            //float scaledFloat = Scale.GetScaledFloat();

            //parts.SetFont(Const.form.mainForm.GetFontName(), scaledFloat);
        }
    }
}
