﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Drawing;
using System.Threading;
using MecInfoDll;
using System.Runtime.InteropServices;
using System.Linq;

using nispi.controlclass;

namespace nispi
{
    class MapMainForm
    {
        public FormParts mapMainForm;

        public SplitContainerParts mainSplitContainerParts;
        //public SplitContainerParts subMainSplitContainerParts;

        public TabControlParts CountryIndexTabControlParts;
        public TabControlParts MapControlTabControlParts;

        public StatusStripParts statusStripParts;
        public ToolStripStatusLabel lastUpdateToolStripStatusLabel;
        
        public ToolStripParts toolStripParts;
        public ToolStripTextBoxParts toolStripTextBoxParts;
        public ToolStripButtonParts toolStripReloadButtonParts;

        public ImageList imageList;

        public MapMainForm()
        {
            if (mapMainForm == null)
            {
                ///メインフォーム
                mapMainForm = FormPartsManager.Pop();
                //mapMainForm.control.Parent = Const.form.mainForm.control;
                mapMainForm.Size = Const.MapMainFormSize;
                mapMainForm.MinimumSize = new Size(900, 400);
                mapMainForm.Name = "MapMainForm";
                mapMainForm.Text = "マップアナライズ";
                mapMainForm.control.Icon = Resources.icon;

                mapMainForm.control.FormClosing += new FormClosingEventHandler(popUp_FormClosing);

                mapMainForm.SuspendLayout();

                ///ストリップコンテナ
                mainSplitContainerParts = SplitContainerPartsManager.Pop();
                mainSplitContainerParts.Size =
                    new Size(Const.MapMainFormSize.Width - Scale.GetMainSplitContainerMinusSize().Width,
                        Const.MapMainFormSize.Height - Scale.GetMainSplitContainerMinusSize().Height);
                mainSplitContainerParts.SplitterDistance = 250;
                mainSplitContainerParts.SetVertical();
                mainSplitContainerParts.Location = new Point(0, 58);
                //mainSplitContainerParts.SetFixedPanel(1);

                /*subMainSplitContainerParts = SplitContainerPartsManager.Pop();
                subMainSplitContainerParts.Size = new Size(mainSplitContainerParts.Size.Width - mainSplitContainerParts.SplitterDistance - 2,
                    mainSplitContainerParts.Size.Height);
                subMainSplitContainerParts.SplitterDistance = 347;
                subMainSplitContainerParts.SetHorizontal();*/

                ///ステータスバー
                statusStripParts = StatusStripPartsManager.Pop();
                //statusStripParts.SetPadding(1, 0, 20, 0);
                //statusStripParts.Location = new Point(0, 840);
                statusStripParts.Name = "ステータスバー";
                statusStripParts.Size = new Size(0, 30);

                lastUpdateToolStripStatusLabel = new ToolStripStatusLabel();
                statusStripParts.control.Items.Add(lastUpdateToolStripStatusLabel);
                
                string lastUpdateStr = FileIO.ReadUnicode("setting","lastupdate.txt");
                if (lastUpdateStr.Length > 0)
                    lastUpdateToolStripStatusLabel.Text = lastUpdateStr;
                else
                    lastUpdateToolStripStatusLabel.Text = "最終更新：";// +DateTime.Now.ToLongDateString() + " " + DateTime.Now.ToLongTimeString();


                ///ツールバー
                toolStripParts = ToolStripPartsManager.Pop();

                toolStripReloadButtonParts = ToolStripButtonPartsManager.Pop();
                toolStripReloadButtonParts.Text = "解析データ更新";
                toolStripReloadButtonParts.Image = new Bitmap(Resources.reload);
                toolStripReloadButtonParts.Click += new EventHandler((new MapControlTabMethod()).menuItemUpdate_Click);
 
                toolStripTextBoxParts = ToolStripTextBoxPartsManager.Pop();
                toolStripTextBoxParts.Size = new Size(mainSplitContainerParts.Size.Width - 350, 0);
                toolStripTextBoxParts.Text = "";

                imageList = new ImageList();
                imageList.ImageSize = new Size(24, 24);
                imageList.TransparentColor = Color.White;
                imageList.Images.Add(Resources.Japan);
                imageList.Images.Add(Resources.un);

                //タブコントロール
                CountryIndexTabControlParts = TabControlPartsManager.Pop();
                CountryIndexTabControlParts.Name = "CountryIndexTabControlParts";
                CountryIndexTabControlParts.ImageList = imageList;

                MapControlTabControlParts = TabControlPartsManager.Pop();
                MapControlTabControlParts.Name = "MapControlTabControlParts";
                MapControlTabControlParts.ImageList = imageList;

                //コントロールに登録
                mapMainForm.AddControl(statusStripParts);
                toolStripParts.AddItem(toolStripReloadButtonParts);
                toolStripParts.AddItemToolStripText(toolStripTextBoxParts);
                mapMainForm.AddControl(toolStripParts);

                mapMainForm.AddControl(mainSplitContainerParts);
                
                //スプリットコンテナ左
                mainSplitContainerParts.AddToPanel1(CountryIndexTabControlParts);
                //mainSplitContainerParts.AddToPanel1(subMainSplitContainerParts);
                mainSplitContainerParts.AddToPanel2(MapControlTabControlParts);

                //スプリットコンテナ右の上と下
                //subMainSplitContainerParts.AddToPanel1(CountryIndexTabControlParts);
                //subMainSplitContainerParts.AddToPanel2();



                Const.mapForm = this;

                mapMainForm.control.Resize += new EventHandler(FormResize);

                mainSplitContainerParts.Panel1_Resize += new EventHandler(MainPanelResize);
                //subMainSplitContainerParts.Panel1_Resize += new EventHandler(SubPanelResize);
                mapMainForm.ResumeLayout();
            }
        }

        private void popUp_FormClosing(object sender, FormClosingEventArgs e)
        {
            e.Cancel = true;
           
            //この作業をしないとマップウィンドウが閉じた後に、メインウィンドウが閉じない。
            //mapMainForm.control.Owner = null;

            mapMainForm.control.Hide();
        }

        public void SetUpTwo()
        {
            mapMainForm.control.Show();

            //ポップアップウィンドウの大きさをページの大きさに合わせる。
            mapMainForm.Size =
                new Size((Const.form.mainForm.Size.Width) / 3 * 2,
                    Const.form.mainForm.Size.Height);

            //ウィンドウの外に出ないように調節する
            if ((mapMainForm.Size.Height + mapMainForm.Location.Y) > Const.DisplayY)
            {
                mapMainForm.Location =
                    new Point(mapMainForm.Location.X,
                    mapMainForm.Location.Y - ((mapMainForm.Size.Height + mapMainForm.Location.Y) - Const.DisplayY));

                if (mapMainForm.Size.Height > Const.DisplayY)
                {
                    mapMainForm.Location = new Point(mapMainForm.Location.X, 0);
                    mapMainForm.Size = new Size(mapMainForm.Size.Width, Const.DisplayY);
                }
            }
            if ((mapMainForm.Size.Width + mapMainForm.Location.X) > Const.DisplayX)
            {
                mapMainForm.Location =
                    new Point(mapMainForm.Location.X - ((mapMainForm.Size.Width + mapMainForm.Location.X) - Const.DisplayX),
                    mapMainForm.Location.Y);
            }
        }

        public void MainPanelResize(object sender, EventArgs e)
        {
            Control control = (Control)sender;
            //mainSplitContainerParts.SplitterDistance = control.Width;
            mainSplitContainerParts.Size = new Size(Const.MapMainFormSize.Width - Scale.GetMainSplitContainerMinusSize().Width,
                Const.MapMainFormSize.Height - Scale.GetMainSplitContainerMinusSize().Height);

            //subMainSplitContainerParts.Size = new Size(mainSplitContainerParts.SplitterDistance - 2,
            //    mainSplitContainerParts.Size.Height);

            MapMainFormConst.mapFormShowStyle.ReSize();
        }
        public void SubPanelResize(object sender, EventArgs e)
        {
            Control control = (Control)sender;
            //mainSplitContainerParts.SplitterDistance = control.Width;
            mainSplitContainerParts.Size = new Size(Const.MapMainFormSize.Width - Scale.GetMainSplitContainerMinusSize().Width,
                Const.MapMainFormSize.Height - Scale.GetMainSplitContainerMinusSize().Height);

            //subMainSplitContainerParts.Size = new Size(mainSplitContainerParts.SplitterDistance - 2,
            //    mainSplitContainerParts.Size.Height);

            MapMainFormConst.mapFormShowStyle.ReSize();
        }

        public void FormResize(object sender, EventArgs e)
        {
            Control control = (Control)sender;
            Const.MapMainFormSize = control.Size;

            //ToolStrip
            toolStripParts.Size = new Size(mainSplitContainerParts.Size.Width - 200, toolStripTextBoxParts.Size.Height);
            //toolStripTextBoxParts.Size = new Size(mainSplitContainerParts.Size.Width - 250, toolStripTextBoxParts.Size.Height);

            mainSplitContainerParts.Panel1_Resize -= new EventHandler(MainPanelResize);
            //subMainSplitContainerParts.Panel1_Resize -= new EventHandler(SubPanelResize);

            mainSplitContainerParts.Size = new Size(Const.MapMainFormSize.Width - Scale.GetMainSplitContainerMinusSize().Width,
                Const.MapMainFormSize.Height - Scale.GetMainSplitContainerMinusSize().Height);

            //subMainSplitContainerParts.Size = new Size(mainSplitContainerParts.Size.Width - mainSplitContainerParts.SplitterDistance - 2,
            //    mainSplitContainerParts.Size.Height);

            mainSplitContainerParts.Panel1_Resize += new EventHandler(MainPanelResize);
            //subMainSplitContainerParts.Panel1_Resize += new EventHandler(SubPanelResize);

            MapMainFormConst.mapFormShowStyle.ReSize();
        }
    }
}