﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Text;
using System.Text.RegularExpressions;
using System.Windows.Forms;
using System.Threading;
using System.Drawing;
using System.Linq;

using nispi.controlclass;

namespace nispi
{
    class CountryIndexView:BoardIndexViewCommon
    {
        public CountryIndexView()
        {
            countryIndexControls = new CountryIndexControls(this);
            countryIndexControls.AddControls();
            Const.mapForm.CountryIndexTabControlParts.AddControl(countryIndexControls.tabPageExParts);
        }

        public override void Cloose()
        {
            countryIndexControls.RemoveControls();
        }

        public override void ShowBoard(string yomi)
        {
            try
            {
                MapMainFormConst.mapListTabMain.worldMapControlView.DrawFill(yomi);
            }
            catch (System.Exception ex)
            {
                Const.debugForm.OutPutDebug("Map", ex);
                return;
            }
        }

        private void reload_button_Click(object sender, EventArgs e)
        {
                Thread t2 = new Thread(new ThreadStart(LoadKokkaListThread));
                t2.IsBackground = true;
                t2.Start();
        }

        public void LoadKokkaListThread()
        {
            string str = FileIO.ReadCurrentShiftJis("data", "国家と読みのペア.txt");

            Const.form.mainForm.Invoke(new WriteBoardList_Delegate(countryIndexControls.treeViewParts.WriteCountryBoardList), countryIndexControls.treeViewParts, str);
        }

        public void LoadKenListThread()
        {
            string str = FileIO.ReadCurrentShiftJis("data", "県と読みのペア.txt");

            Const.form.mainForm.Invoke(new WriteBoardList_Delegate(countryIndexControls.treeViewParts.WriteCountryBoardList), countryIndexControls.treeViewParts, str);
        }

        delegate void WriteBoardList_Delegate(TreeViewParts treeView, string str);
    }
}
