﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System.Linq;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Runtime.InteropServices;
using System.Drawing;
using System.Windows.Forms;

using nispi.controlclass;

namespace nispi
{
    class CopyRightForm
    {
        //メインウィンドウ
        FormParts formParts;
        //ラベル（AgeOn(C) CopyRight Naoki MAEDA）
        LabelParts copyRightLabelParts;
        //ラベル（ライセンス条項）
        LabelParts lisenceLabelParts;
        //テキストボックス（ライセンス条項の中身）
        TextBoxParts lisenceTextParts;
        //閉じるボタン
        ButtonParts closeButtonParts;

        public CopyRightForm()
        {
            formParts = new FormParts();
            copyRightLabelParts = new LabelParts();
            lisenceLabelParts = new LabelParts();
            lisenceTextParts = new TextBoxParts();
            closeButtonParts = new ButtonParts();

            formParts.Hide();
            formParts.Size = new Size(640, 330);
            formParts.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedSingle;
            formParts.Text = "CopyRight";
            formParts.control.FormClosing += new FormClosingEventHandler(formParts_FormClosing);

            copyRightLabelParts.Size = new Size(580, 210);
            copyRightLabelParts.Location = new Point(30, 30);
            System.Diagnostics.FileVersionInfo ver =
                System.Diagnostics.FileVersionInfo.GetVersionInfo(
                System.Reflection.Assembly.GetExecutingAssembly().Location);
            copyRightLabelParts.Text =
                "AgeOn" + ver.FileVersion.ToString() + "\r\n" + 
                "・AgeOn Copyright(C) 2014 Naoki MAEDA\r\n" +
                "・kita Copyright (c) 2008 Hideki Ikemoto\r\n" +
                "・Tsuyoshi Komuta氏が制作したNMeCabを使用しています \r\n" +
                "・Taku Kudo <taku@chasen.org>氏とNippon Telegraph \r\n" +
                "　and Telephone Corporationが制作したMecabに由来します\r\n" +
                "・Copyright 2006 CraftMAP All Rights Reserved\r\n" +
                "・Burak Ozdiken氏が制作したKRBTabControlを使用しています\r\n" +
                "\r\n" +
                "<ライセンスの詳細はLISENCEフォルダを参照してください>";
            copyRightLabelParts.SetFont("", 10);

            lisenceLabelParts.Size = new Size(580, 30);
            lisenceLabelParts.Location = new Point(30, 160);
            lisenceLabelParts.Text = "詳細なライセンス条項";
            lisenceLabelParts.SetFont("", 10);

            lisenceTextParts.Size = new Size(560, 210);
            lisenceTextParts.Location = new Point(30, 190);
            lisenceTextParts.SetFont("", 10);
            lisenceTextParts.Multiline = true;

            closeButtonParts.Size = new Size(100, 30);
            closeButtonParts.Location = new Point(270, 240);
            closeButtonParts.Text = "閉じる";
            closeButtonParts.Click += new EventHandler(closeButtonParts_Click);

            formParts.AddControl(copyRightLabelParts);
            formParts.AddControl(lisenceLabelParts);
            //formParts.AddControl(lisenceTextParts);
            formParts.AddControl(closeButtonParts);

            ReadAndSetLisence();
        }
        public void Show()
        {
            formParts.Show();
        }
        public void Hide()
        {
            formParts.Hide();
        }
        private void formParts_FormClosing(object sender, FormClosingEventArgs e)
        {
            e.Cancel = true;
            Hide();
            
        }
        //閉じるボタンのイベント
        private void closeButtonParts_Click(object sender, EventArgs e)
        {
            Hide();
        }
        //ライセンス条項を読み込んでテキストボックスに表示するメソッド
        private void ReadAndSetLisence()
        {
            this.lisenceTextParts.Text = FileIO.ReadShiftJis("", "LISENCE.txt");
            this.lisenceLabelParts.Focus();

        }
    }
}
