﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;

using nispi.controlclass;

namespace nispi
{
    class BoardIndexControls
    {
        public TabPageExParts tabPageExParts;
        public TextBoxParts searchTextBoxParts;
        public ButtonParts searchButtonParts;
        public ButtonParts reloadButtonParts;
        public TreeViewParts treeViewParts;
        public ToolTipParts toolTipParts;

        public BoardIndexControlEvent boardIndexControlEvent;

        public BoardIndexControls(BoardIndexViewCommon boardIndexViewCommon)
        {
            tabPageExParts = TabPageExPartsManager.Pop();

            searchTextBoxParts = TextBoxPartsManager.Pop();
            searchTextBoxParts.Location = new Point(2, 2);
            searchTextBoxParts.Name = "button";
            searchTextBoxParts.Size = new Size(90, -1);

            searchButtonParts = ButtonPartsManager.Pop();
            searchButtonParts.Location = new Point(100, 1);
            searchButtonParts.Name = "control";
            searchButtonParts.Size = new Size(26, 26);
            searchButtonParts.SetToolTip("検索");
            searchButtonParts.Image = Resources.search;

            reloadButtonParts = ButtonPartsManager.Pop();
            reloadButtonParts.Location = new Point(130, 1);
            reloadButtonParts.Name = "control";
            reloadButtonParts.Size = new Size(26, 26);
            reloadButtonParts.SetToolTip("再読み込み");
            reloadButtonParts.Image = Resources.reload;

            treeViewParts = TreeViewPartsManager.Pop(boardIndexViewCommon);
            treeViewParts.Size = new Size(Const.form.boardIndexTabControlParts.Size.Width,
                Const.form.boardIndexTabControlParts.Size.Height - 28);

            tabPageExParts.AddControl(searchTextBoxParts);
            tabPageExParts.AddControl(searchButtonParts);
            tabPageExParts.AddControl(reloadButtonParts);
            tabPageExParts.AddControl(treeViewParts);

            //進捗状況をみるツールチップ
            this.toolTipParts = ToolTipPartsManager.Pop();

            boardIndexControlEvent = new BoardIndexControlEvent(this);
        }

        public void RemoveControls()
        { 
            //イベントを削除
            boardIndexControlEvent.RemoveEvent();

            //タブページの中身を削除
            tabPageExParts.RemoveAllCtrl();
            
            //タブからタブページを削除
            Const.form.boardIndexTabControlParts.ControlsRemove(tabPageExParts);

            TabPageExPartsManager.Push(tabPageExParts);
            TextBoxPartsManager.Push(searchTextBoxParts);
            ButtonPartsManager.Push(searchButtonParts);
            ButtonPartsManager.Push(reloadButtonParts);
            TreeViewPartsManager.Push(treeViewParts);

            ToolTipPartsManager.Push(toolTipParts);

            tabPageExParts = null;
            searchTextBoxParts = null;
            searchButtonParts = null;
            reloadButtonParts = null;
            treeViewParts = null;
        }
    }
}
