﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.Windows.Forms;

using nispi.Analysis;

namespace nispi.controlclass
{
    class AnalysisLinkControlsEvent
    {
        AnalysisLink analysisLinkView;
        AnalysisLinkControls analysisLinkControls;

        public AnalysisLinkControlsEvent(AnalysisLink analysisLinkView, AnalysisLinkControls analysisLinkControls)
        {
            this.analysisLinkView = analysisLinkView;
            this.analysisLinkControls = analysisLinkControls;

            this.analysisLinkControls.alFormParts.control.SizeChanged += new EventHandler(control_SizeChanged);

            this.analysisLinkControls.alFormParts.SetFormClosing(new FormPartsDelegate.MultiFormClosingEventHandler(alForm_FormClosing));//..FormClosing += new FormClosingEventHandler(alForm_FormClosing);
            //this.analysisLinkControls.browserParts.Document.MouseUp += new HtmlElementEventHandler(Document_MouseUp);
        }

        public void control_SizeChanged(object sender, EventArgs e)
        {
            Form form = (Form)sender;
            this.analysisLinkControls.browserParts.Size = new Size(form.Size.Width - Scale.GetBrowserControlMinusSize().Width,
                form.Size.Height - Scale.GetBrowserControlMinusSize().Height);
        }

        public void RemoveEvent()
        {
            this.analysisLinkControls.alFormParts.control.SizeChanged -= new EventHandler(control_SizeChanged);
            //this.analysisLinkControls.alFormParts.FormClosing -= new FormClosingEventHandler(alForm_FormClosing);
            this.analysisLinkControls.alFormParts.ReSetFormClosing();
            //this.analysisLinkControls.browserParts.Document.MouseUp -= new HtmlElementEventHandler(Document_MouseUp);
        }

        private void alForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            e.Cancel = true;

            //この作業をしないとメインウィンドウが閉じない。
            this.analysisLinkControls.alFormParts.Owner = null;

            this.analysisLinkView.Cloose();

            this.analysisLinkView = null;
            this.analysisLinkControls = null;
        }
        /*public void Document_MouseUp(object sender, HtmlElementEventArgs e)
        {
            HtmlElement clickedElement = analysisLinkControls.browserParts.control.Document.GetElementFromPoint(e.MousePosition);
            string link = null;
            string href = null;

            HtmlUtil.GetClickTagInfo(clickedElement, ref href, ref link);
        }*/
    }
}
