unit IdHTTP2;

(* Indy9.0.3B IdHTTP.pasoߏ肾߂̃TuNX *)
(*
   To override 'TIdHTTP.DoRequest', almost all codes are copied from
   TIdHTTP.DoRequest in IdHTTP.pas.

@̃R[hIndy \tgEFȀCɊY邽߁AIndyLicenseɏ]܂B
@plIndy Modified BSD License܂Indy MPL (Mozilla Public License)
@LicenseCӂɑIł_lłB

   Copyright
   Portions of this software are Copyright (c) 1993 - 2001,
   Chad Z. Hower (Kudzu) and the Indy Pit Crew - http://www.nevrona.com/Indy/

   License
   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:

      Redistributions of source code must retain the above copyright notice,
      this list of conditions and the following disclaimer.

      Redistributions in binary form must reproduce the above copyright notice,
      this list of conditions and the following disclaimer in the documentation,
      about box and/or other materials provided with the distribution.

      No personal names or organizations names associated with the Indy project
      may be used to endorse or promote products derived from this software
      without specific prior written permission of the specific individual or
      organization.

   THIS SOFTWARE IS PROVIDED BY Chad Z. Hower (Kudzu) and the Indy Pit Crew
   "AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
   TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
   PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE.

 *)

(*
  IdHTTP.pas
  Author: Hadi Hariri (hadi@urusoft.com)
  Copyright: (c) Chad Z. Hower and The Winshoes Working Group.

  modifier for IdHTTP2.pas: Twiddle (hetareprog@hotmail.com)
*)

interface

uses
  Classes,
  IdAssignedNumbers,
  IdHeaderList,
  IdHTTPHeaderInfo,
  IdIOHandlerSocket,
  IdSSLOpenSSL,
  IdTCPClient,
  IdURI,
  IdCookie,
  IdCookieManager,
  IdAuthentication,
  IdHTTP;


type
  (* Types to override IdHTTP.DoRequest procedure. *)
  TIdHTTP2NotifyCode = (idHttp2nConnecting,
                        idHttp2nRequest,
                        idHttp2nResponse
                        );

  TIdHTTP2Notify = procedure(sender: TObject; notifyCode: TIdHTTP2NotifyCode)
                   of object;
  TIdHTTP2 = class(TIdHTTP)
  protected
    FIdHTTP2Notify: TIdHTTP2Notify;
  public
    constructor Create(AOwner: TComponent); override;
    procedure DoRequest(const AMethod: TIdHTTPMethod; AURL: string;
                        const ASource, AResponseContent: TStream); override;
    property OnNotify: TIdHTTP2Notify read FIdHTTP2Notify write FIdHTTP2Notify;
  end;

implementation

uses
  IdComponent, IdCoderMIME,
  IdTCPConnection,
  IdException,
  IdGlobal,
  IdResourceStrings,
  SysUtils;


constructor TIdHTTP2.Create(AOwner: TComponent);
begin
  inherited;
  FIdHTTP2Notify := nil;
end;

procedure TIdHTTP2.DoRequest(const AMethod: TIdHTTPMethod; AURL: string;
  const ASource, AResponseContent: TStream);
var
  LResponseLocation: Integer;
begin
  if Assigned(AResponseContent) then
  begin
    LResponseLocation := AResponseContent.Position;
  end
  else
    LResponseLocation := 0; // Just to avoid the waringing message

  FAuthRetries := 0;
  FAuthProxyRetries := 0;

  Request.URL := AURL;
  Request.Method := AMethod;
  Request.Source := ASource;
  Response.ContentStream := AResponseContent;

  try
    repeat
      Inc(FRedirectCount);

      (* NOTIFY code inserted by Twiddle  *)
      if Assigned(FIdHTTP2Notify) then
        FIdHTTP2Notify(self, idHttp2nConnecting);
      (* end of the inserted code. *)

      PrepareRequest(Request);
      ConnectToHost(Request, Response);

      (* NOTIFY code inserted by Twiddle  *)
      if Assigned(FIdHTTP2Notify) then
        FidHTTP2Notify(self, idHttp2nRequest);
      (* end of the inserted code. *)

      // Workaround for servers wich respond with 100 Continue on GET and HEAD
      // This workaround is just for temporary use until we have final HTTP 1.1
      // realisation
      repeat
        Response.ResponseText := ReadLn;
        FHTTPProto.RetrieveHeaders;
        ProcessCookies(Request, Response);
      until Response.ResponseCode <> 100;

      (* NOTIFY code inserted by Twiddle *)
      if Assigned(FIdHTTP2Notify) then
        FIdHTTP2Notify(self, idHttp2nResponse);
      (* end of the inserted code. *)

      case FHTTPProto.ProcessResponse of
        wnAuthRequest: begin
            Dec(FRedirectCount);
            Request.URL := AURL;
          end;
        wnReadAndGo: begin
            ReadResult(Response);
            if Assigned(AResponseContent) then
            begin
              AResponseContent.Position := LResponseLocation;
              AResponseContent.Size := LResponseLocation;
            end;
            FAuthRetries := 0;
            FAuthProxyRetries := 0;
          end;
        wnGoToURL: begin
            if Assigned(AResponseContent) then
            begin
              AResponseContent.Position := LResponseLocation;
              AResponseContent.Size := LResponseLocation;
            end;
            FAuthRetries := 0;
            FAuthProxyRetries := 0;
          end;
        wnJustExit: begin
            break;
          end;
        wnDontKnow:
          // TODO: This is for temporary use. Will remove it for final release
          raise EIdException.Create('Undefined situation');
      end;
    until false;
  finally
    if not Response.KeepAlive then begin
      Disconnect;
    end;
  end;
  FRedirectCount := 0;
end;



end.
