unit UConfig;

interface

uses
  SysUtils, Forms, Classes, IniFiles, HTTPSub;

type
  TAgeConfig = class(TObject)
  public
    BasePath:           string;
    IniPath:            string;

    (* Sʃ^u *)
    netOpenAtOnce:      integer;
    netOpenNew:         boolean;
    winOpenApp:         boolean;
    winOpenAppPath:     string;

    winMinimized:       boolean;
    winUseTaskTray:     boolean;
    winRefreshFirst:    boolean;

    (* ^XNgC *)
    winStdAction:       integer; // 0:̃TCYɖ߂ 1:XV 2:ڂJ

    (* ڑ^u *)
    netUseProxyToGet:   boolean;
    netProxyToGet:      string;

    netUseProxyToPost:  boolean;
    netProxyListToPost: TStringList;
    netRandomProxy:     boolean; // true: _ false: O珇

    (* XV^u *)
    netAutoRefresh:     boolean;
    netRefreshWait:     integer;

    netNotifyIfUpdate:  boolean;
    netBeepIfUpdate:    boolean;
    netBeepPath:        string;
    netOpenIfUpdate:    boolean;
    netOpenImmediately: boolean;
    netSaveEveryTime:   boolean;

    (* ێ^u *)
    netAutoMaintain:    boolean;
    netMaintainWait:    integer;

    netMaintainName:    string;
    netMaintainMail:    string;
    netMaintainBody:    TStringList;

    (* x^u *)
    netOpenBefore:      integer;
    netOpenControl:     integer;
    winSendUrl:         boolean;
    winSendUrlHWnd:     string;

    netUserAgent:       string;
    netReadTimeout:     integer;
    netRecvBufferSize:  integer;
    netConnectionNum:   integer;

    (* tB^O *)
    filActive:          boolean;
    filKeywordList:     TStringList;

    constructor Create;
    destructor Destroy; override;
    procedure Initialize;
    procedure Load;
    procedure Save;
  end;

const
  INI_WIN_SECT: string = 'Window';
  INI_NET_SECT: string = 'Net';
  INI_ITM_SECT: string = 'Items';
  INI_FIL_SECT: string = 'Filter';

implementation

uses
  Main;

constructor TAgeConfig.Create;
begin
  inherited;
  Initialize;
end;

destructor TAgeConfig.Destroy;
begin
  netProxyListToPost.Free;
  netMaintainBody.Free;
  inherited;
end;

procedure TAgeConfig.Initialize;
begin
  BasePath           := ExtractFilePath(Application.ExeName);
  IniPath            := BasePath + 'Age2ch.ini';

  (* Sʃ^u *)
  netOpenAtOnce      := 1;
  netOpenNew         := true;
  winOpenApp         := false;
  winOpenAppPath     := '';

  winMinimized       := false;
  winUseTaskTray     := false;
  winRefreshFirst    := false;

  (* ^XNgC *)
  winStdAction       := 0;

  (* ڑ^u *)
  netUseProxyToGet   := False;
  netProxyToGet      := '';

  netUseProxyToPost  := False;
  netProxyListToPost := TStringList.Create;
  netRandomProxy     := False;

  (* XV^u *)
  netAutoRefresh     := False;
  netRefreshWait     := 5 * 60;

  netNotifyIfUpdate  := False;
  netBeepIfUpdate    := False;
  netBeepPath        := '';
  netOpenIfUpdate    := False;
  netOpenImmediately := True;
  netSaveEveryTime   := False;

  (* ێ^u *)
  netAutoMaintain    := False;
  netMaintainWait    := 3 * 24;

  netMaintainName    := 'Age2ch';
  netMaintainMail    := 'sage';
  netMaintainBody    := TStringList.Create;

  (* x^u *)
  netOpenBefore      := 0;
  netOpenControl     := 50;
  winSendUrl         := false;
  winSendUrlHWnd     := '';

  netUserAgent       := 'Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0)';
  netReadTimeout     := 30;
  netRecvBufferSize  := 32; // GRecvBufferSizeDefault==1024*32
  netConnectionNum   := 10;

  (* tB^O *)
  filActive          := False;
  filKeywordList     := TStringList.Create;
end;

procedure TAgeConfig.Load;
var
  ini: TIniFile;
begin
  ini := TIniFile.Create(IniPath);

  (* Sʃ^u *)
  netOpenAtOnce     := ini.ReadInteger(INI_NET_SECT, 'OpenAtOnce',     netOpenAtOnce);
  netOpenNew        := ini.ReadBool   (INI_NET_SECT, 'OpenNew',        netOpenNew);
  winOpenApp        := ini.ReadBool   (INI_WIN_SECT, 'OpenApp',        winOpenApp);
  winOpenAppPath    := ini.ReadString (INI_WIN_SECT, 'OpenAppPath',    winOpenAppPath);

  winMinimized      := ini.ReadBool   (INI_WIN_SECT, 'Minimized',      winMinimized);
  winUseTaskTray    := ini.ReadBool   (INI_WIN_SECT, 'UseTaskTray',    winUseTaskTray);
  winRefreshFirst   := ini.ReadBool   (INI_WIN_SECT, 'RefreshFirst',   winRefreshFirst);

  (* ^XNgC *)
  winStdAction      := ini.ReadInteger(INI_WIN_SECT, 'StdAction',      winStdAction);

  (* ڑ^u *)
  netUseProxyToGet  := ini.ReadBool   (INI_NET_SECT, 'UseProxyToGet',  netUseProxyToGet);
  netProxyToGet     := ini.ReadString (INI_NET_SECT, 'ProxyToGet',     netProxyToGet);

  netUseProxyToPost := ini.ReadBool   (INI_NET_SECT, 'UseProxyToPost', netUseProxyToPost);
  netProxyListToPost.CommaText := ini.ReadString(INI_NET_SECT, 'ProxyListToPost', '');
  netRandomProxy    := ini.ReadBool   (INI_NET_SECT, 'RandomProxy',    netRandomProxy);

  (* XV^u *)
  netAutoRefresh     := ini.ReadBool   (INI_NET_SECT, 'AutoRefresh',     netAutoRefresh);
  netRefreshWait     := ini.ReadInteger(INI_NET_SECT, 'RefreshWait',     netRefreshWait);

  netNotifyIfUpdate  := ini.ReadBool   (INI_NET_SECT, 'NotifyIfUpdate',  netNotifyIfUpdate);
  netBeepIfUpdate    := ini.ReadBool   (INI_NET_SECT, 'BeepIfUpdate',    netBeepIfUpdate);
  netBeepPath        := ini.ReadString (INI_NET_SECT, 'BeepPath',        netBeepPath);;
  netOpenIfUpdate    := ini.ReadBool   (INI_NET_SECT, 'OpenIfUpdate',    netOpenIfUpdate);
  netOpenImmediately := ini.ReadBool   (INI_NET_SECT, 'OpenImmediately', netOpenImmediately);
  netSaveEveryTime   := ini.ReadBool   (INI_NET_SECT, 'SaveEveryTime',   netSaveEveryTime);

  (* ێ^u *)
  netAutoMaintain   := ini.ReadBool   (INI_NET_SECT, 'AutoMaintain',   netAutoMaintain);
  netMaintainWait   := ini.ReadInteger(INI_NET_SECT, 'MaintainWait',   netMaintainWait);

  netMaintainName   := ini.ReadString (INI_NET_SECT, 'MaintainName',   netMaintainName);
  netMaintainMail   := ini.ReadString (INI_NET_SECT, 'MaintainMail',   netMaintainMail);
  netMaintainBody.Text := URLDecode(ini.ReadString(INI_NET_SECT, 'MaintainBody', 'ێ'));

  (* x^u *)
  netOpenBefore     := ini.ReadInteger(INI_NET_SECT, 'OpenBefore',     netOpenBefore);
  netOpenControl    := ini.ReadInteger(INI_NET_SECT, 'OpenControl',    netOpenControl);
  winSendUrl        := ini.ReadBool   (INI_WIN_SECT, 'SendUrl',        winSendUrl);
  winSendUrlHWnd    := ini.ReadString (INI_WIN_SECT, 'SendUrlHWnd',    winSendUrlHWnd);

  netUserAgent      := ini.ReadString (INI_NET_SECT, 'UserAgent',      netUserAgent);
  netReadTimeout    := ini.ReadInteger(INI_NET_SECT, 'ReadTimeout',    netReadTimeout);
  netRecvBufferSize := ini.ReadInteger(INI_NET_SECT, 'RecvBufferSize', netRecvBufferSize);
  netConnectionNum  := ini.ReadInteger(INI_NET_SECT, 'ConnectionNum',  netConnectionNum);

  (* tB^O *)
  filActive         := ini.ReadBool   (INI_FIL_SECT, 'Active',         filActive);
  filKeywordList.Text := URLDecode(ini.ReadString(INI_FIL_SECT, 'KeywordList', ''));

  ini.Free;
end;

procedure TAgeConfig.Save;
var
  ini: TIniFile;
begin
  ini := TIniFile.Create(IniPath);

  (* Sʃ^u *)
  ini.WriteInteger(INI_NET_SECT, 'OpenAtOnce',      netOpenAtOnce);
  ini.WriteBool   (INI_NET_SECT, 'OpenNew',         netOpenNew);
  ini.WriteBool   (INI_WIN_SECT, 'OpenApp',         winOpenApp);
  ini.WriteString (INI_WIN_SECT, 'OpenAppPath',     winOpenAppPath);

  ini.WriteBool   (INI_WIN_SECT, 'Minimized',       winMinimized);
  ini.WriteBool   (INI_WIN_SECT, 'UseTaskTray',     winUseTaskTray);
  ini.WriteBool   (INI_WIN_SECT, 'RefreshFirst',    winRefreshFirst);

  (* ^XNgC *)
  ini.WriteInteger(INI_WIN_SECT, 'StdAction',       winStdAction);

  (* ڑ^u *)
  ini.WriteBool   (INI_NET_SECT, 'UseProxyToGet',   netUseProxyToGet);
  ini.WriteString (INI_NET_SECT, 'ProxyToGet',      netProxyToGet);

  ini.WriteBool   (INI_NET_SECT, 'UseProxyToPost',  netUseProxyToPost);
  ini.WriteString (INI_NET_SECT, 'ProxyListToPost', netProxyListToPost.CommaText);
  ini.WriteBool   (INI_NET_SECT, 'RandomProxy',     netRandomProxy);

  (* XV^u *)
  ini.WriteBool   (INI_NET_SECT, 'AutoRefresh',     netAutoRefresh);
  ini.WriteInteger(INI_NET_SECT, 'RefreshWait',     netRefreshWait);

  ini.WriteBool   (INI_NET_SECT, 'NotifyIfUpdate',  netNotifyIfUpdate);
  ini.WriteBool   (INI_NET_SECT, 'BeepIfUpdate',    netBeepIfUpdate);
  ini.WriteString (INI_NET_SECT, 'BeepPath',        netBeepPath);;
  ini.WriteBool   (INI_NET_SECT, 'OpenIfUpdate',    netOpenIfUpdate);
  ini.WriteBool   (INI_NET_SECT, 'OpenImmediately', netOpenImmediately);
  ini.WriteBool   (INI_NET_SECT, 'SaveEveryTime',   netSaveEveryTime);
  
  (* ێ^u *)
  ini.WriteBool   (INI_NET_SECT, 'AutoMaintain',    netAutoMaintain);
  ini.WriteInteger(INI_NET_SECT, 'MaintainWait',    netMaintainWait);

  ini.WriteString (INI_NET_SECT, 'MaintainName',    netMaintainName);
  ini.WriteString (INI_NET_SECT, 'MaintainMail',    netMaintainMail);
  ini.WriteString (INI_NET_SECT, 'MaintainBody',    URLEncode(netMaintainBody.Text));

  (* x^u *)
  ini.WriteInteger(INI_NET_SECT, 'OpenBefore',      netOpenBefore);
  ini.WriteInteger(INI_NET_SECT, 'OpenControl',     netOpenControl);
  ini.WriteBool   (INI_WIN_SECT, 'SendUrl',         winSendUrl);
  ini.WriteString (INI_WIN_SECT, 'SendUrlHWnd',     winSendUrlHWnd);

  ini.WriteString (INI_NET_SECT, 'UserAgent',       netUserAgent);
  ini.WriteInteger(INI_NET_SECT, 'ReadTimeout',     netReadTimeout);
  ini.WriteInteger(INI_NET_SECT, 'RecvBufferSize',  netRecvBufferSize);
  ini.WriteInteger(INI_NET_SECT, 'ConnectionNum',   netConnectionNum);

  (* tB^O *)
  ini.WriteBool   (INI_FIL_SECT, 'Active',          filActive);
  ini.WriteString (INI_FIL_SECT, 'KeywordList',     URLEncode(filKeywordList.Text));

  ini.Free;
end;

end.

