unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Menus, StdCtrls, StrUtils, DateUtils, ShellAPI, mmSystem,
  IniFiles, Clipbrd, ComCtrls, CommCtrl, ExtCtrls, ImgList, ToolWin,
  UOption, UProperty, UAbout, UConfig, UAsync, UXTime, HTTPSub;

const
  SCRIPT = 'Age2ch';
  VERSION = '0.3.49';
  WM_NotifyTasktray = WM_USER + 100;
  MAX_BUF1 = 512; // URL 󂯓npőobt@TCY

type
  TAge2chMainWnd = class(TForm)
    MainMenu: TMainMenu;
    File1: TMenuItem;
    Exit1: TMenuItem;
    New1: TMenuItem;
    N1: TMenuItem;
    Tool1: TMenuItem;
    Option1: TMenuItem;
    StatusBar: TStatusBar;
    UrlListView: TListView;
    Help1: TMenuItem;
    About1: TMenuItem;
    Edit1: TMenuItem;
    Cut1: TMenuItem;
    Copy1: TMenuItem;
    Paste1: TMenuItem;
    Show1: TMenuItem;
    Refresh1: TMenuItem;
    Open1: TMenuItem;
    M1: TMenuItem;
    Delete1: TMenuItem;
    N2: TMenuItem;
    Property1: TMenuItem;
    N3: TMenuItem;
    MainPopupMenu: TPopupMenu;
    Open2: TMenuItem;
    M2: TMenuItem;
    New2: TMenuItem;
    Delete2: TMenuItem;
    Property2: TMenuItem;
    Cut2: TMenuItem;
    Copy2: TMenuItem;
    Paste2: TMenuItem;
    Refresh2: TMenuItem;
    N4: TMenuItem;
    N5: TMenuItem;
    N6: TMenuItem;
    N7: TMenuItem;
    N8: TMenuItem;
    N9: TMenuItem;
    UrlImageList: TImageList;
    N10: TMenuItem;
    ArrangeIcon1: TMenuItem;
    SortBySize1: TMenuItem;
    SortByName1: TMenuItem;
    SortByDate1: TMenuItem;
    SortByUrl1: TMenuItem;
    ArrangeIcon2: TMenuItem;
    SortByName2: TMenuItem;
    SortBySize2: TMenuItem;
    SortByDate2: TMenuItem;
    SortByUrl2: TMenuItem;
    RefreshTimer: TTimer;
    AutoRefreshTimer: TTimer;
    PostTimer: TTimer;
    AutoMaintainTimer: TTimer;
    N11: TMenuItem;
    SelectAll1: TMenuItem;
    TrayPopupMenu: TPopupMenu;
    R1: TMenuItem;
    O1: TMenuItem;
    Refresh3: TMenuItem;
    N13: TMenuItem;
    Exit2: TMenuItem;
    U1: TMenuItem;
    M3: TMenuItem;
    N12: TMenuItem;
    S1: TMenuItem;
    Refresh4: TMenuItem;
    O2: TMenuItem;
    R2: TMenuItem;
    N14: TMenuItem;
    ToolBar1: TToolBar;
    ToolButton1: TToolButton;
    ToolImageList: TImageList;
    ToolButton2: TToolButton;
    ToolButton3: TToolButton;
    ToolButton4: TToolButton;
    ToolButton5: TToolButton;
    ToolButton6: TToolButton;
    U2: TMenuItem;
    I1: TMenuItem;
    New3: TMenuItem;
    Paste3: TMenuItem;
    N15: TMenuItem;
    ToolButton7: TToolButton;
    ToolButton8: TToolButton;
    ToolButton9: TToolButton;
    ToolButton10: TToolButton;
    Contents1: TMenuItem;
    N16: TMenuItem;
    T1: TMenuItem;
    B1: TMenuItem;
    N17: TMenuItem;
    ColumnPopupMenu: TPopupMenu;
    N18: TMenuItem;
    N19: TMenuItem;
    N20: TMenuItem;
    ToolButton11: TToolButton;
    P1: TMenuItem;
    procedure Exit1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure New1Click(Sender: TObject);
    procedure Delete1Click(Sender: TObject);
    procedure Option1Click(Sender: TObject);
    procedure Paste1Click(Sender: TObject);
    procedure Cut1Click(Sender: TObject);
    procedure Copy1Click(Sender: TObject);
    procedure Open1Click(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure Property1Click(Sender: TObject);
    procedure UrlListViewSelectItem(Sender: TObject; Item: TListItem;
      Selected: Boolean);
    procedure M1Click(Sender: TObject);
    procedure UrlListViewColumnClick(Sender: TObject; Column: TListColumn);
    procedure SortByName1Click(Sender: TObject);
    procedure SortBySize1Click(Sender: TObject);
    procedure SortByDate1Click(Sender: TObject);
    procedure SortByUrl1Click(Sender: TObject);
    procedure RefreshTimerTimer(Sender: TObject);
    procedure AutoRefreshTimerTimer(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure PostTimerTimer(Sender: TObject);
    procedure AutoMaintainTimerTimer(Sender: TObject);
    procedure SelectAll1Click(Sender: TObject);
    procedure R1Click(Sender: TObject);
    procedure O1Click(Sender: TObject);
    procedure U1Click(Sender: TObject);
    procedure M3Click(Sender: TObject);
    procedure Refresh4Click(Sender: TObject);
    procedure O2Click(Sender: TObject);
    procedure R2Click(Sender: TObject);
    procedure I1Click(Sender: TObject);
    procedure Contents1Click(Sender: TObject);
    procedure T1Click(Sender: TObject);
    procedure B1Click(Sender: TObject);
    procedure UrlListViewColumnRightClick(Sender: TObject;
      Column: TListColumn; Point: TPoint);
    procedure StatusBarResize(Sender: TObject);
    procedure P1Click(Sender: TObject);
  private
    { Private 錾 }
    (* ListView ̖ *)
    ACanvas: TCanvas;
    HHeader: HWND;
    TmpDis: TDrawItemStruct;
    FOldWndProc: TWndMethod;

    (* ^XNgC *)
    IsLiveTasktray: boolean;
    NotifyIcon: TNotifyIconData;

    (* ProgressBar *)
    ProgressBar: TProgressBar;
    FBarWidths: array of Integer;

    (* XV`FbN *)
    RefreshPreQueue:    TStringList; // HEAD dat Jn҂
    RefreshingPreQueue: TStringList; // HEAD dat ҂
    RefreshQueue:       TStringList; // GET read.cgi Jn҂
    RefreshingQueue:    TStringList; // GET read.cgi ҂
    RefreshLock:        Boolean;     // bNp
    RefreshOpened:      Integer;     // URL J

    (* ێ *)
    PostQueue: TStringList;          // POST ҂
    PostLock: Boolean;               // POST bN
    PostNum: integer;                // ݉
    PostCookie: string;              // NbL[ SPID, PON ێ
    PostTime: integer;               // Date wb_ ێ
    PostProxyNum: integer;           // Proxy ԍ
    PostingURL: string;              // POST  URL (XVʒmȂ߂)

    (* ListView ̖ *)
    procedure NewWndProc(var Msg: TMessage);
    procedure DrawItem(const dis: TDrawItemStruct);
    procedure DrawSortHeader(ARect: TRect; Selected: Boolean);
    procedure DrawSortArrow(ARect: TRect);

    (* ^XNgC *)
    procedure InitTasktray;
    procedure FinishTasktray;
    procedure HideMainWnd;
    procedure ShowMainWnd;
    procedure AppMinimize(Sender: TObject);

    (* XV`FbN *)
    procedure AddUrlListView(URL: string);
    function UpdateUrlListViewItem(URL: string): boolean;
    procedure OnUpdate(Sender: TAsyncReq);
    function CheckUrlListViewItem(URL: string): boolean;
    procedure OnCheck(Sender: TAsyncReq);
    function ChangeUrlListViewItemImage(ItemIndex: integer;
      const Action: integer): boolean;
    procedure OpenUrlListViewItem(ItemIndex: integer);

    (* ێ *)
    function Post(const URL, NAME, MAIL, BODY, PROXY: string): boolean;
    procedure OnWrite(Sender: TAsyncReq);
    procedure OnNotify(Sender: TAsyncReq; code: TAsyncNotifyCode);

    (* XV`FbÑj[̓ *)
    procedure NotifyIfUpdate(UrlListIndex: integer);
    procedure NotifyAllIfUpdate;
    function IsUpdate: boolean;
    procedure SyncMenu;
    procedure UpdateToolBar;

    (* ݒ̓Ǎƕۑ *)
    procedure LoadWindowPos;
    procedure SaveWindowPos;
    procedure LoadUrlList;
    procedure SaveUrlList;

    (* hbO & hbvp[^n *)
    procedure WMDropFiles(Var Msg: TWMDropFiles); Message WM_DropFiles;

    (* R}hCp[^n *)
    procedure WMCopyData(var Msg: TWMCopyData); message WM_COPYDATA;

  protected
    (* ^XNgC *)
    procedure WndProc(var Message: TMessage); override;

    (* hbO & hbv *)
    procedure CreateParams(var Params: TCreateParams);override;

  public
    { Public 錾 }
    (* ListView ̖󑀍 *)
    SortCol: Integer; // \[gΏۂColumn
    IsUpperSort: Boolean;

    (* ListView ̖󑀍 *)
    procedure SetOwnerDrawColumn(Idx: Integer; OwnerDraw: Boolean);

    (* Xe[^Xo[ɃeLXg\ *)
    procedure WriteStatus(const s: string);

    constructor Create(AOwner: TComponent); override;
  end;

var
  Age2chMainWnd: TAge2chMainWnd;
  AsyncManager: TAsyncManager;
  FOldHDWndProc: TFNWndProc;
  Config: TAgeConfig;

function CustomSortProc(Item1, Item2: TListItem;
                        ParamSort: integer):integer;stdcall;
function NewHeaderWndProc(TheWindow: HWND;
                          Msg: Integer;
                          wParam: WPARAM;
                          lParam: LPARAM): Longint; stdcall;
procedure WriteStatus(const str: string);
function BetweenStrs(const S, fromStr, toStr: string):string;
function SplitThreadURI(const URI: string; var host, bbs: string): integer;
procedure Get2chInfo(const URI: string; var host, bbs, datnum: string;
                     var index: integer;
                     var oldLog: boolean);
procedure OpenURL(URL: string);
function ExecuteProc(ExePath,
                     CmdLine: PChar;
                     dwWait: Cardinal;
                     Console: Boolean;
                     var ProcHandle: THandle): Boolean;
procedure CopyDataToOld(Wnd: HWnd;
                        aParamCount: integer);
procedure ParamsToData(
          aParamCount: integer;  {=ParamCount}
          var pcData: PChar);    {[ϐ}

implementation

{$R *.dfm}

const
  (* ڂɑ΂鑀 *)
  ACT_OPEN         = 0; // J
  ACT_START_UPDATE = 1; // XVJn
  ACT_END_UPDATE   = 2; // XVI
  ACT_UPDATED      = 3; // XV肩XVI
  ACT_START_POST   = 4; // eJn
  ACT_END_POST     = 5; // eI

  (* ڂ̏ *)
  STT_NRM          = 0; // XVȂ
  STT_NRM_UPDATING = 1; // XVȂXV
  STT_NRM_POSTING  = 2; // XVȂe
  STT_UPD          = 3; // XV
  STT_UPD_UPDATING = 4; // XV肩XV
  STT_UPD_POSTING  = 5; // XV肩e

(* ------------------------------------------------------------------------- *)

procedure TAge2chMainWnd.FormCreate(Sender: TObject);
  procedure SetStatusBarWidth;
  var  //EڌŒStatusBarׂ̈ɐ݌vpanelWidthۑ
    i: Integer;
  begin
    with StatusBar do
    begin
      SetLength(FBarWidths,Panels.Count);
      for i:=0 to Panels.Count-1 do
        FBarWidths[i]:=  Panels[i].Width;
    end;
  end;
var
  i: integer;
begin
  Caption := SCRIPT + ' ' + VERSION;

  Config := TAgeConfig.Create;
  Config.Load;
  LoadUrlList;
  LoadWindowPos;

  // UrlListView ̃\[g
  UrlListViewSelectItem(Sender, nil, false);

  // ListViewHeaderGet
  HHeader := ListView_GetHeader(UrlListView.Handle);
  // ListView Message
  FOldWndProc := UrlListView.WindowProc;
  UrlListView.WindowProc := NewWndProc;
  // HeaderMessage
  FOldHDWndProc := TFNWndProc(SetWindowLong(HHeader, GWL_WNDPROC,
                              Longint(@NewHeaderWndProc)));

  SetOwnerDrawColumn(SortCol, True);

  (* 񓯊擾 *)
  AsyncManager := TAsyncManager.Create;

  (* XV *)
  if Config.netAutoRefresh then
  begin
    AutoRefreshTimer.Enabled  := false;
    AutoRefreshTimer.Interval := Config.netRefreshWait * 1000;
    AutoRefreshTimer.Enabled  := true;
  end
  else
  begin
    AutoRefreshTimer.Enabled := false;
  end;
  RefreshPreQueue    := TStringList.Create;
  RefreshingPreQueue := TStringList.Create;
  RefreshQueue       := TStringList.Create;
  RefreshingQueue    := TStringList.Create;
  RefreshLock        := false;
  RefreshOpened      := 0;
  
  (* ێ *)
  if Config.netAutoMaintain then
  begin
    AutoMaintainTimer.Enabled := true;
    AutoMaintainTimer.Interval := 60 * 1000;
  end
  else
  begin
    AutoMaintainTimer.Enabled := false;
  end;

  PostQueue := TStringList.Create;
  PostNum := 0;
  PostCookie := '';
  PostTime := DateTimeToUnix(Now);
  PostProxyNum := 0;
  PostingURL := '';
  
  (* ^XNgC *)
  if Config.winUseTaskTray then
  begin
    Application.OnMinimize := AppMinimize;
    InitTasktray;
    if Config.winMinimized then
      AppMiniMize(Sender);
  end;

  (* c[o[ *)
  SyncMenu;
  UpdateToolBar;

  (* Xe[^Xo[ *)
  SetStatusBarWidth;

  (* vOXo[ *)
  ProgressBar := TProgressBar.Create(Self);
  with ProgressBar do begin
    Parent := StatusBar;
    Visible := False;
    Smooth := True;
    Step := 1;
  end;

  (* NɍXV`FbN *)
  if Config.winRefreshFirst then
    AutoRefreshTimerTimer(Sender)
  else
  begin
    if ParamCount > 0 then
    begin
      for i := 1 to ParamCount do
      begin
        if ParamStr(i) = '/C' then
        begin
          AutoRefreshTimerTimer(Sender);
          Break;
        end;
      end;
    end;
  end;
end;

procedure TAge2chMainWnd.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  Visible := False;

  FinishTasktray;

  SaveWindowPos;
  SaveUrlList;
  Config.Save;

  CanClose := true;
end;

procedure TAge2chMainWnd.FormDestroy(Sender: TObject);
begin
  Config.Free;

  (* obNOEhI *)
  AsyncManager.WaitForTerminateAll;
  AsyncManager.Free;

  ProgressBar.Free;

  RefreshPreQueue.Free;
  RefreshingPreQueue.Free;
  RefreshQueue.Free;
  RefreshingQueue.Free;
  PostQueue.Free;
end;

(* ------------------------------------------------------------------------- *)

procedure TAge2chMainWnd.SaveUrlList;
var
  iniFile: TIniFile;
  i: integer;
begin
  iniFile := TIniFile.Create(Config.IniPath);

  iniFile.EraseSection(INI_ITM_SECT);

  for i := 0 to UrlListView.Items.Count - 1 do
  begin
    IniFile.WriteString(INI_ITM_SECT, 'Name'+IntToStr(i), UrlListView.Items[i].Caption);
    IniFile.WriteString(INI_ITM_SECT, 'Size'+IntToStr(i), UrlListView.Items[i].SubItems[0]);
    IniFile.WriteString(INI_ITM_SECT, 'Date'+IntToStr(i), UrlListView.Items[i].SubItems[1]);
    IniFile.WriteString(INI_ITM_SECT, 'Url' +IntToStr(i), UrlListView.Items[i].SubItems[2]);
    IniFile.WriteString(INI_ITM_SECT, 'Last'+IntToStr(i), UrlListView.Items[i].SubItems[3]);
    IniFile.WriteString(INI_ITM_SECT, 'Read'+IntToStr(i), UrlListView.Items[i].SubItems[4]);
    IniFile.WriteString(INI_ITM_SECT, 'Attr'+IntToStr(i), UrlListView.Items[i].SubItems[5]);
  end;

  IniFile.Free;
end;

procedure TAge2chMainWnd.LoadUrlList;
var
  iniFile: TIniFile;
  strList: TStringList;
  i: integer;
  NewItem: TListItem;
  cntSize, cntDate, cntUrl, cntLast, cntRead, cntAttr: integer;
begin
  iniFile := TIniFile.Create(Config.IniPath);
  strList := TStringList.Create;

  IniFile.ReadSection(INI_ITM_SECT, strList);

  for i := 0 to strList.Count - 1 do
  begin
    if LeftStr(strList[i], 4) = 'Name' then
    begin
      NewItem := UrlListView.Items.Add();
      NewItem.Caption := IniFile.ReadString(INI_ITM_SECT, strList[i], '');
      NewItem.SubItems.Add('');
      NewItem.SubItems.Add('');
      NewItem.SubItems.Add('');
      NewItem.SubItems.Add('');
      NewItem.SubItems.Add('');
      NewItem.SubItems.Add('');
    end;
  end;

  cntSize := 0;
  cntDate := 0;
  cntUrl  := 0;
  cntLast := 0;
  cntRead := 0;
  cntAttr := 0;
  for i := 0 to strList.Count - 1 do
  begin
    if LeftStr(strList[i], 4) = 'Size' then
    begin
      UrlListView.Items[cntSize].SubItems[0] := IniFile.ReadString(INI_ITM_SECT, strList[i], '');
      cntSize := cntSize + 1;
    end
    else if LeftStr(strList[i], 4) = 'Date' then
    begin
      UrlListView.Items[cntDate].SubItems[1] := IniFile.ReadString(INI_ITM_SECT, strList[i], '');
      cntDate := cntDate + 1;
    end
    else if LeftStr(strList[i], 3) = 'Url' then
    begin
      UrlListView.Items[cntUrl].SubItems[2]  := IniFile.ReadString(INI_ITM_SECT, strList[i], '');
      cntUrl := cntUrl + 1;
    end
    else if LeftStr(strList[i], 4) = 'Last' then
    begin
      UrlListView.Items[cntLast].SubItems[3] := IniFile.ReadString(INI_ITM_SECT, strList[i], '');
      cntLast := cntLast + 1;
    end
    else if LeftStr(strList[i], 4) = 'Read' then
    begin
      UrlListView.Items[cntRead].SubItems[4] := IniFile.ReadString(INI_ITM_SECT, strList[i], '');
      cntRead := cntRead + 1;
    end
    else if LeftStr(strList[i], 4) = 'Attr' then
    begin
      UrlListView.Items[cntAttr].SubItems[5] := IniFile.ReadString(INI_ITM_SECT, strList[i], 'r');
      cntAttr := cntAttr + 1;
    end;
  end;

  strList.Free;
  iniFile.Free;
end;

(* EBhEʒu *)
procedure TAge2chMainWnd.LoadWindowPos;
var
  iniFile: TIniFile;
  i: integer;
  Placement: TWindowPlacement;
  R: PRect;
begin
  iniFile := TIniFile.Create(Config.IniPath);

  (* MainWindow *)
  // ^XNo[ɂ悤̃o[ƍő剻ċNƒʏɂǂ
  // Top̂łĂĂ݂
  Placement.length := SizeOf(Placement);
  R := @Placement.rcNormalPosition;
  R^.Left := iniFile.ReadInteger(INI_WIN_SECT, 'Left',  (Screen.Width - Width) div 2);
  R^.Top := iniFile.ReadInteger(INI_WIN_SECT, 'Top',   (Screen.Height - Height) div 2);
  R^.Right := R^.Left + iniFile.ReadInteger(INI_WIN_SECT, 'Width', Width);
  R^.Bottom := R^.Top + iniFile.ReadInteger(INI_WIN_SECT, 'Height',Height);
  SetWindowPlacement(Self.Handle, @Placement);
  // Ȃ񂩍ő剻ɂ̂ WindowState ύXO
  // Position  poDefault ɖ߂Ă݂
  // http://www.borland.co.jp/qanda/delphi/d0000216.html ?
  Position := poDefault;
  WindowState := TWindowState(iniFile.ReadInteger(INI_WIN_SECT, 'WindowState', Ord(WindowState)));
  Position := poDesigned;

  (* Columns *)
  for i := 0 to UrlListView.Columns.Count - 1 do
  begin
    if iniFile.ReadInteger(INI_WIN_SECT, 'Column' + IntToStr(i),
       UrlListView.Columns.Items[i].Width) > 0 then
    begin
      UrlListView.Columns.Items[i].Width := iniFile.ReadInteger(INI_WIN_SECT,
        'Column' + IntToStr(i), UrlListView.Columns.Items[i].Width);
    end;
  end;

  IsUpperSort := IniFile.ReadBool(INI_WIN_SECT, 'IsUpperSort', false);
  SortCol := IniFile.ReadInteger(INI_WIN_SECT, 'SortCol', 2);

  (* ToolBar *)
  ToolBar1.Visible := IniFile.ReadBool(INI_WIN_SECT, 'ToolBar', True);
  T1.Checked := ToolBar1.Visible;

  (* StatusBar *)
  StatusBar.Visible := IniFile.ReadBool(INI_WIN_SECT, 'StatusBar', True);
  B1.Checked := StatusBar.Visible;
  
  iniFile.Free;
end;

procedure TAge2chMainWnd.SaveWindowPos;
var
  iniFile: TIniFile;
  i: integer;
  Placement: TWindowPlacement;
  R: PRect;
begin
  iniFile := TIniFile.Create(Config.IniPath);

  (* MainWindow *)
  Placement.length := SizeOf(Placement);
  R := @Placement.rcNormalPosition;
  GetWindowPlacement(Self.Handle, @Placement);
  iniFile.WriteInteger(INI_WIN_SECT, 'Top',   R^.Top);
  iniFile.WriteInteger(INI_WIN_SECT, 'Left',  R^.Left);
  iniFile.WriteInteger(INI_WIN_SECT, 'Width', R^.Right - R^.Left);
  iniFile.WriteInteger(INI_WIN_SECT, 'Height',R^.Bottom - R^.Top);
  iniFile.WriteInteger(INI_WIN_SECT, 'WindowState', Ord(WindowState));

  (* Columns *)
  for i := 0 to UrlListView.Columns.Count - 1 do
    iniFile.WriteInteger(INI_WIN_SECT, 'Column' + IntToStr(i), UrlListView.Columns.Items[i].Width);

  iniFile.WriteBool   (INI_WIN_SECT, 'IsUpperSort', IsUpperSort);
  iniFile.WriteInteger(INI_WIN_SECT, 'SortCol', SortCol);

  (* ToolBar *)
  IniFile.WriteBool   (INI_WIN_SECT, 'ToolBar', ToolBar1.Visible);

  (* StatusBar *)
  IniFile.WriteBool   (INI_WIN_SECT, 'StatusBar', StatusBar.Visible);

  iniFile.Free;
end;

(* ------------------------------------------------------------------------- *)

procedure TAge2chMainWnd.Property1Click(Sender: TObject);
var
  i, int: integer;
begin
  if UrlListView.SelCount < 2 then
  begin
    PropertyPagesDlg.Label5.Visible  := true;
    PropertyPagesDlg.Label6.Visible  := true;
    PropertyPagesDlg.Edit1.Visible   := true;
    PropertyPagesDlg.Edit2.Visible   := true;
    PropertyPagesDlg.Label8.Visible  := true;
    PropertyPagesDlg.Label10.Visible := true;
    PropertyPagesDlg.Bevel2.Visible  := true;
    PropertyPagesDlg.Label1.Visible  := true;
    PropertyPagesDlg.Label2.Visible  := true;
    PropertyPagesDlg.Label3.Visible  := true;
    PropertyPagesDlg.Label4.Visible  := true;
    PropertyPagesDlg.Image1.Visible  := false;
    PropertyPagesDlg.Label11.Visible := false;
    PropertyPagesDlg.Label12.Visible := false;
    PropertyPagesDlg.CheckBox1.AllowGrayed := false;
    PropertyPagesDlg.CheckBox2.AllowGrayed := false;

    PropertyPagesDlg.Edit1.Text      := UrlListView.Selected.Caption;
    PropertyPagesDlg.Edit2.Text      := UrlListView.Selected.SubItems[2];
    PropertyPagesDlg.Label9.Caption  := UrlListView.Selected.SubItems[0];
    PropertyPagesDlg.Label10.Caption := UrlListView.Selected.SubItems[1];
    PropertyPagesDlg.Label3.Caption  := UrlListView.Selected.SubItems[3];
    PropertyPagesDlg.Label4.Caption  := UrlListView.Selected.SubItems[4];
    if Pos('r', UrlListView.Selected.SubItems[5]) > 0 then
      PropertyPagesDlg.CheckBox1.Checked := true
    else
      PropertyPagesDlg.CheckBox1.Checked := false;
    if Pos('m', UrlListView.Selected.SubItems[5]) > 0 then
      PropertyPagesDlg.CheckBox2.Checked := true
    else
      PropertyPagesDlg.CheckBox2.Checked := false;

    if PropertyPagesDlg.ShowModal = mrOK then
    begin
      UrlListView.Selected.Caption := PropertyPagesDlg.Edit1.Text;
      UrlListView.Selected.SubItems[2] := PropertyPagesDlg.Edit2.Text;
      UrlListView.Selected.SubItems[5] := '';
      if PropertyPagesDlg.CheckBox1.Checked then
        UrlListView.Selected.SubItems[5] := 'r';
      if PropertyPagesDlg.CheckBox2.Checked then
        UrlListView.Selected.SubItems[5] := UrlListView.Selected.SubItems[5] + 'm';
    end;
  end
  else
  begin
    PropertyPagesDlg.Label5.Visible  := false;
    PropertyPagesDlg.Label6.Visible  := false;
    PropertyPagesDlg.Edit1.Visible   := false;
    PropertyPagesDlg.Edit2.Visible   := false;
    PropertyPagesDlg.Label8.Visible  := false;
    PropertyPagesDlg.Label10.Visible := false;
    PropertyPagesDlg.Bevel2.Visible  := false;
    PropertyPagesDlg.Label1.Visible  := false;
    PropertyPagesDlg.Label2.Visible  := false;
    PropertyPagesDlg.Label3.Visible  := false;
    PropertyPagesDlg.Label4.Visible  := false;
    PropertyPagesDlg.Image1.Visible  := true;
    PropertyPagesDlg.Label11.Visible := true;
    PropertyPagesDlg.Label12.Visible := true;

    // t@C
    PropertyPagesDlg.Label12.Caption := IntToStr(UrlListView.SelCount);

    // TCY
    int := 0;
    for i := 0 to UrlListView.Items.Count - 1 do
    begin
      with UrlListView.Items[i] do
        if Selected then
          int := int + StrToInt(LeftStr(SubItems[0], Pos(' KB', SubItems[0]) - 1));
    end;
    PropertyPagesDlg.Label9.Caption  := IntToStr(int) + ' KB';

    // XV
    int := 0;
    for i := 0 to UrlListView.Items.Count - 1 do
    begin
      with UrlListView.Items[i] do
        if Selected and (Pos('r', SubItems[5]) > 0) then
          int := int + 1;
    end;
    if int = 0 then
      PropertyPagesDlg.CheckBox1.Checked := false
    else if int = UrlListView.SelCount then
      PropertyPagesDlg.CheckBox1.Checked := true
    else
    begin
      PropertyPagesDlg.CheckBox1.AllowGrayed := true;
      PropertyPagesDlg.CheckBox1.State := cbGrayed;
    end;

    // ێ瑮
    int := 0;
    for i := 0 to UrlListView.Items.Count - 1 do
    begin
      with UrlListView.Items[i] do
        if Selected and (Pos('m', SubItems[5]) > 0) then
          int := int + 1;
    end;
    if int = 0 then
      PropertyPagesDlg.CheckBox2.Checked := false
    else if int = UrlListView.SelCount then
      PropertyPagesDlg.CheckBox2.Checked := true
    else
    begin
      PropertyPagesDlg.CheckBox2.AllowGrayed := true;
      PropertyPagesDlg.CheckBox2.State := cbGrayed;
    end;

    if PropertyPagesDlg.ShowModal = mrOK then
    begin
      for i := 0 to UrlListView.Items.Count - 1 do
      begin
        if UrlListView.Items[i].Selected then
        begin
          if PropertyPagesDlg.CheckBox1.State <> cbGrayed then
            if PropertyPagesDlg.CheckBox1.Checked then
              if (Pos('m', UrlListView.Items[i].SubItems[5]) > 0) then
                UrlListView.Items[i].SubItems[5] := 'rm'
              else
                UrlListView.Items[i].SubItems[5] := 'r'
            else
              if (Pos('m', UrlListView.Items[i].SubItems[5]) > 0) then
                UrlListView.Items[i].SubItems[5] := 'm'
              else
                UrlListView.Items[i].SubItems[5] := '';

          if PropertyPagesDlg.CheckBox2.State <> cbGrayed then
            if PropertyPagesDlg.CheckBox2.Checked then
              if (Pos('r', UrlListView.Items[i].SubItems[5]) > 0) then
                UrlListView.Items[i].SubItems[5] := 'rm'
              else
                UrlListView.Items[i].SubItems[5] := 'm'
            else
              if (Pos('r', UrlListView.Items[i].SubItems[5]) > 0) then
                UrlListView.Items[i].SubItems[5] := 'r'
              else
                UrlListView.Items[i].SubItems[5] := '';
        end;
      end;

      PropertyPagesDlg.CheckBox1.State := cbUnchecked;
      PropertyPagesDlg.CheckBox2.State := cbUnchecked;
      PropertyPagesDlg.CheckBox1.AllowGrayed := false;
      PropertyPagesDlg.CheckBox2.AllowGrayed := false;
    end;
  end;
end;

procedure TAge2chMainWnd.Option1Click(Sender: TObject);
begin
  with OptionPagesDlg do
  begin
    (* ȈՃtB^O *)
    CheckBox14.Checked  := Config.filActive;
    ListBox1.Items.Text := Config.filKeywordList.Text;
    Edit8.Text          := '';

    if CheckBox14.Checked then
    begin
      Label25.Enabled  := true;
      Edit8.Enabled    := true;
      Edit8.Color      := clWindow;
      Button3.Enabled  := true;
      ListBox1.Enabled := true;
      ListBox1.Color   := clWindow;
    end
    else
    begin
      Label25.Enabled  := false;
      Edit8.Enabled    := false;
      Edit8.Color      := cl3DLight;
      Button3.Enabled  := false;
      ListBox1.Enabled := false;
      ListBox1.Color   := cl3DLight;
    end;

    (* Sʃ^u *)
    SpinEdit6.Value   := Config.netOpenAtOnce;
    CheckBox6.Checked := Config.netOpenNew;
    CheckBox8.Checked := Config.winOpenApp;
    Edit5.Text        := Config.winOpenAppPath;

    CheckBox7.Checked  := Config.winUseTaskTray;
    CheckBox3.Checked  := Config.winMinimized;
    CheckBox10.Checked := Config.winRefreshFirst;

    if CheckBox7.Checked then
      CheckBox3.Enabled := true
    else
      CheckBox3.Enabled := false;

    (* ڑ^u *)
    CheckBox1.Checked    := Config.netUseProxyToGet;
    Edit2.Text           := Config.netProxyToGet;

    CheckBox2.Checked    := Config.netUseProxyToPost;
    Memo1.Text           := Config.netProxyListToPost.Text;
    RadioButton3.Checked := not Config.netRandomProxy;
    RadioButton4.Checked := Config.netRandomProxy;

    if CheckBox1.Checked then
    begin
      Label3.Enabled := true;
      Edit2.Enabled  := true;
      Edit2.Color    := clWindow;
    end
    else
    begin
      Label3.Enabled := false;
      Edit2.Enabled  := false;
      Edit2.Color    := cl3DLight;
    end;
    if CheckBox2.Checked then
    begin
      Label1.Enabled       := true;
      Memo1.Enabled        := true;
      Memo1.Color          := clWindow;
      RadioButton3.Enabled := true;
      RadioButton4.Enabled := true;
    end
    else
    begin
      Label1.Enabled       := false;
      Memo1.Enabled        := false;
      Memo1.Color          := cl3DLight;
      RadioButton3.Enabled := false;
      RadioButton4.Enabled := false;
    end;

    (* XV^u *)
    CheckBox5.Checked    := Config.netAutoRefresh;
    SpinEdit2.Value      := Config.netRefreshWait div 60;
    SpinEdit9.Value      := Config.netRefreshWait mod 60;

    CheckBox9.Checked    := Config.netNotifyIfUpdate;
    CheckBox11.Checked   := Config.netBeepIfUpdate;
    Edit6.Text           := Config.netBeepPath;
    CheckBox12.Checked   := Config.netOpenIfUpdate;
    RadioButton1.Checked := Config.netOpenImmediately;
    RadioButton2.Checked := not Config.netOpenImmediately;

    CheckBox15.Checked   := Config.netSaveEveryTime;

    if CheckBox5.Checked then
    begin
      Label6.Enabled    := true;
      SpinEdit2.Enabled := true;
      SpinEdit2.Color   := clWindow;
      Label7.Enabled    := true;
      SpinEdit9.Enabled := true;
      SpinEdit9.Color   := clWindow;
      Label23.Enabled   := true;
    end
    else
    begin
      Label6.Enabled    := false;
      SpinEdit2.Enabled := false;
      SpinEdit2.Color   := cl3DLight;
      Label7.Enabled    := false;
      SpinEdit9.Enabled := false;
      SpinEdit9.Color   := cl3DLight;
      Label23.Enabled   := false;
    end;

    if CheckBox9.Checked then
    begin
      CheckBox11.Enabled := true;

      if CheckBox11.Checked then
      begin
        Label17.Enabled := true;
        Edit6.Enabled   := true;
        Edit6.Color     := clWindow;
        Button2.Enabled := true;
      end
      else
      begin
        Label17.Enabled := false;
        Edit6.Enabled   := false;
        Edit6.Color     := cl3DLight;
        Button2.Enabled := false;
      end;

      CheckBox12.Enabled := true;

      if CheckBox12.Checked then
      begin
        RadioButton1.Enabled := true;
        RadioButton2.Enabled := true;
      end
      else
      begin
        RadioButton1.Enabled := false;
        RadioButton2.Enabled := false;
      end;
    end
    else
    begin
      CheckBox11.Enabled   := false;
      Label17.Enabled      := false;
      Edit6.Enabled        := false;
      Edit6.Color          := cl3DLight;
      Button2.Enabled      := false;
      CheckBox12.Enabled   := false;
      RadioButton1.Enabled := false;
      RadioButton2.Enabled := false;
    end;

    (* ێ^u *)
    CheckBox4.Checked := Config.netAutoMaintain;
    SpinEdit1.Value   := Config.netMaintainWait div 24;
    SpinEdit10.Value  := Config.netMaintainWait mod 24;

    Edit3.Text        := Config.netMaintainName;
    Edit4.Text        := Config.netMaintainMail;
    Memo2.Text        := Config.netMaintainBody.Text;

    if CheckBox4.Checked then
    begin
      Label8.Enabled          := true;
      SpinEdit1.EditorEnabled := true;
      SpinEdit1.Color         := clWindow;
      Label9.Enabled          := true;
      SpinEdit10.Enabled      := true;
      SpinEdit10.Color        := clWindow;
      Label24.Enabled         := true;
    end
    else
    begin
      Label8.Enabled          := false;
      SpinEdit1.EditorEnabled := false;
      SpinEdit1.Color         := cl3DLight;
      Label9.Enabled          := false;
      SpinEdit10.Enabled      := false;
      SpinEdit10.Color        := cl3DLight;
      Label24.Enabled         := false;
    end;

    (* x^u *)
    SpinEdit7.Value    := Config.netOpenBefore;
    SpinEdit8.Value    := Config.netOpenControl;
    CheckBox13.Checked := Config.winSendUrl;
    Edit7.Text         := Config.winSendUrlHWnd;

    Edit1.Text         := Config.netUserAgent;
    SpinEdit5.Value    := Config.netReadTimeout;
    SpinEdit3.Value    := Config.netRecvBufferSize;
    SpinEdit4.Value    := Config.netConnectionNum;

    if CheckBox8.Checked then
    begin
      Label14.Enabled    := true;
      Edit5.Enabled      := true;
      Edit5.Color        := clWindow;
      Button1.Enabled    := true;
      CheckBox13.Enabled := true;
      if CheckBox13.Checked then
      begin
        Label20.Enabled := true;
        Edit7.Enabled   := true;
        Edit7.Color     := clWindow;
      end;
    end
    else
    begin
      Label14.Enabled    := false;
      Edit5.Enabled      := false;
      Edit5.Color        := cl3DLight;
      Button1.Enabled    := false;
      CheckBox13.Enabled := false;
      Label20.Enabled    := false;
      Edit7.Enabled      := false;
      Edit7.Color        := cl3DLight;
    end;

    if OptionPagesDlg.ShowModal = mrOK then
    begin
      (* ȈՃtB^O *)
      Config.filActive           := CheckBox14.Checked;
      Config.filKeywordList.Text := ListBox1.Items.Text;

      (* Sʃ^u *)
      Config.netOpenAtOnce   := SpinEdit6.Value;
      Config.netOpenNew      := CheckBox6.Checked;
      Config.winOpenApp      := CheckBox8.Checked;
      Config.winOpenAppPath  := Edit5.Text;

      Config.winMinimized    := CheckBox3.Checked;
      Config.winUseTaskTray  := CheckBox7.Checked;
      Config.winRefreshFirst := CheckBox10.Checked;

      if Config.winUseTaskTray then
      begin
        Application.OnMinimize := AppMinimize;
        InitTasktray;
      end
      else
      begin
        FinishTasktray;
        ShowMainWnd;
      end;

      (* ڑ^u *)
      Config.netUseProxyToGet        := CheckBox1.Checked;
      Config.netProxyToGet           := Edit2.Text;
      
      Config.netUseProxyToPost       := CheckBox2.Checked;
      Config.netProxyListToPost.Text := Memo1.Text;
      Config.netRandomProxy          := RadioButton4.Checked;

      (* XV^u *)
      Config.netAutoRefresh     := CheckBox5.Checked;
      Config.netRefreshWait     := SpinEdit2.Value * 60 + SpinEdit9.Value;

      Config.netNotifyIfUpdate  := CheckBox9.Checked;
      Config.netBeepIfUpdate    := CheckBox11.Checked;
      Config.netBeepPath        := Edit6.Text;
      Config.netOpenIfUpdate    := CheckBox12.Checked;
      Config.netOpenImmediately := RadioButton1.Checked;

      Config.netSaveEveryTime   := CheckBox15.Checked;

      if Config.netAutoRefresh then
      begin
        AutoRefreshTimer.Enabled  := false;
        AutoRefreshTimer.Interval := Config.netRefreshWait * 1000;
        AutoRefreshTimer.Enabled  := true;
      end
      else
      begin
        AutoRefreshTimer.Enabled := false;
      end;

      (* ێ^u *)
      Config.netAutoMaintain      := CheckBox4.Checked;
      Config.netMaintainWait      := SpinEdit1.Value * 24 + SpinEdit10.Value;

      Config.netMaintainName      := Edit3.Text;
      Config.netMaintainMail      := Edit4.Text;
      Config.netMaintainBody.Text := Memo2.Text;

      if Config.netAutoMaintain then
      begin
        AutoMaintainTimer.Enabled := false;
        AutoMaintainTimer.Enabled := true;
      end
      else
      begin
        AutoMaintainTimer.Enabled := false;
      end;

      (* x^u *)
      Config.netOpenBefore     := SpinEdit7.Value;
      Config.netOpenControl    := SpinEdit8.Value;
      Config.winSendUrl        := CheckBox13.Checked;
      Config.winSendUrlHWnd    := Edit7.Text;

      Config.netUserAgent      := Edit1.Text;
      Config.netReadTimeout    := SpinEdit5.Value;
      Config.netRecvBufferSize := SpinEdit3.Value;
      Config.netConnectionNum  := SpinEdit4.Value;

      (* c[o[ *)
      UpdateToolBar;

      Config.Save;
    end;
  end;
end;

procedure TAge2chMainWnd.About1Click(Sender: TObject);
begin
  AboutBox.ShowModal;
end;

procedure TAge2chMainWnd.Contents1Click(Sender: TObject);
begin
  ShellExecute(Handle, 'Open',
               PChar('"' + Config.BasePath + 'help/contents.html"'),
               nil, nil, SW_SHOW);
end;

(* ------------------------------------------------------------------------- *)

procedure TAge2chMainWnd.Open1Click(Sender: TObject);
var
  i: integer;
begin
  for i := 0 to UrlListView.Items.Count - 1 do
    if UrlListView.Items[i].Selected then
      OpenUrlListViewItem(i);

  SyncMenu;
end;

procedure TAge2chMainWnd.O1Click(Sender: TObject);
var
  i, Opened: integer;
begin
  Opened := 0;
  ToolButton3.Enabled := False;
  for i := 0 to UrlListView.Items.Count - 1 do
  begin
    case UrlListView.Items[i].ImageIndex of
      STT_UPD,
      STT_UPD_UPDATING,
      STT_UPD_POSTING:
        begin
          OpenUrlListViewItem(i);

          Opened := Opened + 1;
          if Opened >= Config.netOpenAtOnce then
            break;
        end
    end;
  end;
  ToolButton3.Enabled := True;
  SyncMenu;
end;

procedure TAge2chMainWnd.New1Click(Sender: TObject);
var
  stUrl: string;
begin
  if InputQuery('VK쐬', 'URL ͂ĂB', stUrl) then
  begin
    AddUrlListView(stURL);
  end;
  SyncMenu;
end;

procedure TAge2chMainWnd.Delete1Click(Sender: TObject);
var
  i: integer;
begin
  for i := UrlListView.Items.Count - 1 downto 0 do
  begin
    if UrlListView.Items[i].Selected then
      UrlListView.Items[i].Delete;
  end;
  SyncMenu;
end;

procedure TAge2chMainWnd.Exit1Click(Sender: TObject);
begin
  Close;
end;

(* ------------------------------------------------------------------------- *)

procedure TAge2chMainWnd.Cut1Click(Sender: TObject);
var
  i: integer;
begin
  ClipBoard.Clear;

  for i := UrlListView.Items.Count - 1 downto 0 do
  begin
    if UrlListView.Items[i].Selected then
    begin
      ClipBoard.AsText := UrlListView.Items[i].SubItems[2] + #13#10 + ClipBoard.AsText;
      UrlListView.Items[i].Delete;
    end;
  end;

  SyncMenu;
end;

procedure TAge2chMainWnd.Copy1Click(Sender: TObject);
var
  i: integer;
begin
  ClipBoard.Clear;

  for i := UrlListView.Items.Count - 1 downto 0 do
  begin
    if UrlListView.Items[i].Selected then
    begin
      ClipBoard.AsText := UrlListView.Items[i].SubItems[2] + #13#10 + ClipBoard.AsText;
    end;
  end;
end;

procedure TAge2chMainWnd.Paste1Click(Sender: TObject);
var
  strList: TStringList;
  i: integer;
begin
  strList := TStringList.Create;
  strList.Text := ClipBoard.AsText;
  for i := 0 to strList.Count - 1 do
    AddUrlListView(strList[i]);
  SyncMenu;
  strList.Free;
end;

procedure TAge2chMainWnd.SelectAll1Click(Sender: TObject);
var
  i: integer;
begin
  for i := 0 to UrlListView.Items.Count - 1 do
    UrlListView.Items[i].Selected := true;
end;

(* ------------------------------------------------------------------------- *)

procedure TAge2chMainWnd.AddUrlListView(URL: string);
var
  NewItem: TListItem;
  i, index: integer;
  host, bbs, datnum: string;
  oldLog: boolean;
begin
  (* PURL`FbN *)
  if LeftStr(URL, 4) <> 'http' then
  begin
    WriteStatus('URLł͂܂ : ' + URL);
    Exit;
  end;

  (* 2ch ̃Xbh͌`𓝈 *)
  Get2chInfo(URL, host, bbs, datnum, index, oldLog);
  if datnum <> '' then
    URL := 'http://' + host + '/test/read.cgi/' + bbs + '/' + datnum + '/';

  (* d`FbN *)
  for i := 0 to UrlListView.Items.Count - 1 do
  begin
    if URL = UrlListView.Items[i].SubItems[2] then
    begin
      WriteStatus('łɓo^Ă܂ : ' + URL);
      Exit;
    end;
  end;

  NewItem := UrlListView.Items.Add();
  NewItem.Caption := URL;
  UrlListView.Items[NewItem.Index].SubItems.Add('');
  UrlListView.Items[NewItem.Index].SubItems.Add(DateTimeToStr(UnixToDateTime(1)));
  UrlListView.Items[NewItem.Index].SubItems.Add(URL);
  UrlListView.Items[NewItem.Index].SubItems.Add('');
  UrlListView.Items[NewItem.Index].SubItems.Add('');
  UrlListView.Items[NewItem.Index].SubItems.Add('r');
  NewItem.ImageIndex := STT_NRM;

  RefreshQueue.Add(URL);

  if RefreshLock then exit;

  Refresh1.Enabled     := false;
  Refresh2.Enabled     := false;
  Refresh3.Enabled     := false;
  ToolButton2.Enabled  := false;
  RefreshTimer.Enabled := true;
  RefreshLock          := true;
  RefreshOpened        := 0;

  RefreshTimerTimer(Self);
end;

(* XV *)
procedure TAge2chMainWnd.AutoRefreshTimerTimer(Sender: TObject);
var
  i: integer;
begin
  if RefreshLock then exit;

  WriteStatus('XV');

  with ProgressBar do begin
    Position := 0;
    Top := 2;
    Height := StatusBar.Height -2 ;
    Width := StatusBar.Panels[1].Width -2;
    Left := StatusBar.Panels[0].Width +2;
    Max := UrlListView.Items.Count;
    Visible := True;
  end;

  for i := 0 to UrlListView.Items.Count - 1 do
  begin
    if Pos('r', UrlListView.Items[i].SubItems[5]) > 0 then
      RefreshPreQueue.Add(UrlListView.Items[i].SubItems[2]);
  end;

  Refresh1.Enabled     := false;
  Refresh2.Enabled     := false;
  Refresh3.Enabled     := false;
  ToolButton2.Enabled  := false;
  RefreshTimer.Enabled := true;
  RefreshLock          := true;
  RefreshOpened        := 0;

  RefreshTimerTimer(Sender);
end;

(* XV *)
procedure TAge2chMainWnd.RefreshTimerTimer(Sender: TObject);
begin
  // ڑ
  if AsyncManager.Count >= Config.netConnectionNum then
    exit;

  // GET read.cgi L[̏
  if RefreshQueue.Count > 0 then
  begin
    if UpdateUrlListViewItem(RefreshQueue[0]) then
    begin
      RefreshingQueue.Add(RefreshQueue[0]);
      RefreshQueue.Delete(0);
    end;
    exit;
  end;

  // HEAD dat L[̏
  if RefreshPreQueue.Count > 0 then
  begin
    if CheckUrlListViewItem(RefreshPreQueue[0]) then
    begin
      RefreshingPreQueue.Add(RefreshPreQueue[0]);
      RefreshPreQueue.Delete(0);
    end;
    exit;
  end;

  if RefreshingQueue.Count > 0 then
    exit;
  if RefreshingPreQueue.Count > 0 then
    exit;

  if IsUpperSort then
    UrlListView.CustomSort(@CustomSortProc, SortCol + 1)
  else
    UrlListView.CustomSort(@CustomSortProc, -(SortCol + 1));

  WriteStatus('XV');
  NotifyAllIfUpdate;

  // Xgr[ڂt@Cɕۑ
  if Config.netSaveEveryTime then
    SaveUrlList;

  ProgressBar.Visible  := false;
  Refresh1.Enabled     := true;
  Refresh2.Enabled     := true;
  Refresh3.Enabled     := true;
  ToolButton2.Enabled  := true;
  RefreshTimer.Enabled := false;
  RefreshLock          := false;
  RefreshOpened        := 0;

  RefreshQueue.Clear;
  RefreshingQueue.Clear;

  // XVԊu𐔂Ȃ
  if Config.netAutoRefresh then
  begin
    AutoRefreshTimer.Enabled := false;
    AutoRefreshTimer.Enabled := true;
  end;
end;

(* XVʒm *)
procedure TAge2chMainWnd.NotifyIfUpdate(UrlListIndex: integer);
begin
  // XV?
  case UrlListView.Items[UrlListIndex].ImageIndex of
    STT_UPD,
    STT_UPD_UPDATING,
    STT_UPD_POSTING:
    else
      exit;
  end;

  // ^XNgCACRύX
  if Config.winUseTaskTray then
  begin
    NotifyIcon.hIcon := LoadICON(HInstance, 'NOTIFY');
    Shell_NotifyIcon(NIM_MODIFY, @NotifyIcon);
  end;

  // ێ珑݌̍XVʒmȂ΂ŏI
  if UrlListView.Items[UrlListIndex].SubItems[2] = PostingURL then
  begin
    PostingURL := '';
    SyncMenu;
    Exit;
  end;

  if Config.netOpenImmediately then
  begin
    if Config.netNotifyIfUpdate and
       (RefreshOpened < Config.netOpenAtOnce) then
    begin
      // x炵ĂȂȂTEh炷
      if Config.netBeepIfUpdate and (RefreshOpened = 0) then
      begin
        if Config.netBeepPath = '' then
          sndPlaySound('notify.wav', SND_ASYNC)
        else
          sndPlaySound(PChar(Config.netBeepPath), SND_ASYNC);
      end;

      // J
      if Config.netOpenIfUpdate and Config.netOpenImmediately then
        OpenUrlListViewItem(UrlListIndex);

      RefreshOpened := RefreshOpened + 1;
    end;
  end;

  SyncMenu;
end;

procedure TAge2chMainWnd.NotifyAllIfUpdate;
var
  i, Opened: integer;
begin
  if Config.netOpenImmediately then exit;
  if not IsUpdate then exit;

  //^XNgCACRύX
  if Config.winUseTaskTray then
  begin
    NotifyIcon.hIcon := LoadICON(HInstance, 'NOTIFY');
    Shell_NotifyIcon(NIM_MODIFY, @NotifyIcon);
  end;

  if Config.netNotifyIfUpdate then
  begin
    //TEh炷
    if Config.netBeepIfUpdate then
    begin
      if Config.netBeepPath = '' then
        sndPlaySound('notify.wav', SND_ASYNC)
      else
        sndPlaySound(PChar(Config.netBeepPath), SND_ASYNC);
    end;

    //J
    if Config.netOpenIfUpdate then
    begin
      Opened := 0;
      for i := 0 to UrlListView.Items.Count - 1 do
      begin
        case UrlListView.Items[i].ImageIndex of
          STT_UPD,
          STT_UPD_UPDATING,
          STT_UPD_POSTING:
            begin
              OpenUrlListViewItem(i);

              Opened := Opened + 1;
              if Opened >= Config.netOpenAtOnce then break;
            end;
        end;
      end;
    end;
  end;

  SyncMenu;
end;

(* XV? *)
function TAge2chMainWnd.IsUpdate: boolean;
var
  i: integer;
begin
  for i := 0 to UrlListView.Items.Count - 1 do
  begin
    case UrlListView.Items[i].ImageIndex of
      STT_UPD,
      STT_UPD_UPDATING,
      STT_UPD_POSTING:
        begin
          Result := true;
          exit;
        end;
    end;
  end;

  Result := false;
end;

(* XV󋵂c[o[Ȃǂɔf *)
procedure TAge2chMainWnd.SyncMenu;
begin
  if IsUpdate then
  begin
    U2.Enabled := true;
    ToolButton3.Enabled := true;
  end
  else
  begin
    U2.Enabled := false;
    ToolButton3.Enabled := false;

    if Config.winUseTaskTray then
    begin
      NotifyIcon.hIcon := LoadICON(HInstance, 'TRAY');
      Shell_NotifyIcon(NIM_MODIFY, @NotifyIcon);
    end;
  end;
end;

function TAge2chMainWnd.UpdateUrlListViewItem(URL: string): boolean;
var
  host, bbs, datnum: string;
  i, UrlListIndex, index: integer;
  oldLog: boolean;
  procCheck: TAsyncReq;
  ProxyServer, datetime: string;
  ProxyPort: integer;
begin
  UrlListIndex := -1;
  for i := 0 to UrlListView.Items.Count - 1 do
  begin
    if UrlListView.Items[i].SubItems[2] = URL then
    begin
      UrlListIndex := i;
      break;
    end;
  end;
  if UrlListIndex < 0 then
  begin
    ProgressBar.StepIt;
    ProgressBar.Update;
    Result := False;
    exit;
  end;

  ChangeUrlListViewItemImage(UrlListIndex, ACT_START_UPDATE);

  (* 2ch ̃XbhȂ l1 IvV *)
  Get2chInfo(URL, host, bbs, datnum, index, oldLog);
  if datnum <> '' then
    URL := 'http://'+host+'/test/read.cgi/'+bbs+'/'+datnum+'/l1n';

  // vNV̐ݒ
  if Config.netUseProxyToGet then
  begin
    if Pos(':', Config.netProxyToGet) > 0 then
    begin
      ProxyServer := LeftStr(Config.netProxyToGet, Pos(':', Config.netProxyToGet)-1);
      ProxyPort := StrToInt(Copy(Config.netProxyToGet, Pos(':', Config.netProxyToGet)+1, 5));
    end
    else
    begin
      ProxyServer := Config.netProxyToGet;
      ProxyPort   := 8080;
    end;
  end
  else
  begin
    ProxyServer := '';
    ProxyPort := 8080;
  end;

  procCheck := AsyncManager.Get(URL, OnUpdate, nil, datetime, ProxyServer, ProxyPort, 0, 0, agrtGet);

  Result := Assigned(procCheck);
end;

procedure TAge2chMainWnd.OnUpdate(Sender: TAsyncReq);
var
  dat2ch: boolean;
  i, UrlListIndex: integer;
  host1, bbs1, datnum1, host2, bbs2, datnum2: string;
  index1, index2: integer;
  oldLog1, oldLog2: boolean;
  content, title, number, size, datetime: string;
  body: string;
  oldnum: integer;
begin
  dat2ch := false;    // 2chURL?
  UrlListIndex := -1; // -1̂܂܂Ȃ獀ڂ݂Ȃ̂ŏI

  (* 2ch̃XȂ̂ӂ[̃TCgȂ̂`FbN *)
  for i := 0 to UrlListView.Items.Count - 1 do
  begin
    UrlListIndex := i;
    Get2chInfo(UrlListView.Items[i].SubItems[2], host1, bbs1, datnum1, index1, oldLog1);
    Get2chInfo(Sender.URI, host2, bbs2, datnum2, index2, oldLog2);
    if (datnum1 <> '') and
       (host1 = host2) and
       (bbs1 = bbs2) and
       (datnum1 = datnum2) then
    begin
      dat2ch := true;
      Break;
    end
    else if (UrlListView.Items[i].SubItems[2] = Sender.URI) then
    begin
      dat2ch := false;
      Break;
    end;
  end;

  (* ڂ݂Ȃ̂ŏI *)
  // XVƒɍڂ폜ꍇ
  if UrlListIndex = -1 then
  begin
    WriteStatus('No exist: ' + Sender.URI);
    ProgressBar.StepIt;
    ProgressBar.Update;
    exit;
  end;

  RefreshingQueue.Delete(RefreshingQueue.IndexOf(UrlListView.Items[UrlListIndex].SubItems[2]));

  (* ResponseCode `FbN *)
  if Sender.GetAsyncResponseCode = 302 then
  begin
    // l吙΍
    ChangeUrlListViewItemImage(UrlListIndex, ACT_UPDATED);
    ProgressBar.StepIt;
    ProgressBar.Update;
    NotifyIfUpdate(UrlListIndex);
    exit;
  end
  else if Sender.GetAsyncResponseCode <> 200 then
  begin
    WriteStatus('ڑł܂łB');
    ChangeUrlListViewItemImage(UrlListIndex, ACT_END_UPDATE);
    ProgressBar.StepIt;
    ProgressBar.Update;
    NotifyIfUpdate(UrlListIndex);
    exit;
  end;

  (* GetLastModified݂ȂƂ͎擾ŏIXVƂĈ *)
  // ͊ԈȂ̂ōTCYCRCł̃`FbNɕύXׂ
  if Length(Sender.GetLastModified) > 10 then
    datetime := Sender.GetLastModified
  else
    datetime := Sender.GetDate;

  (* ŏIXṼ`FbN *)
  if (DateTimeToUnix(Str2DateTime(datetime)) + 9 * 3600 <=
     DateTimeToUnix(StrToDateTime(UrlListView.Items[UrlListIndex].SubItems[1]))) then
  begin
    ChangeUrlListViewItemImage(UrlListIndex, ACT_END_UPDATE);
    ProgressBar.StepIt;
    ProgressBar.Update;
    NotifyIfUpdate(UrlListIndex);
    exit;
  end;

  content := Sender.Content;

  (* {Ǝꂽ̂`FbN *)
  if content = '' then
  begin
    ChangeUrlListViewItemImage(UrlListIndex, ACT_END_UPDATE);
    ProgressBar.StepIt;
    ProgressBar.Update;
    exit;
  end;

  (* XV *)

  title := BetweenStrs(content, '<title>', '</title>');
  title := AnsiReplaceStr(title, #13, '');
  title := AnsiReplaceStr(title, #10, '');

  if dat2ch then
  begin
    if UrlListView.Items[UrlListIndex].SubItems[3] <> '' then
      oldnum := StrToInt(UrlListView.Items[UrlListIndex].SubItems[3])
    else
      oldnum := 0;

    number := BetweenStrs(content, '<dt>', ' F');
    if number = '' then
      number := BetweenStrs(content, '<dt>', ' OF');
    number := AnsiReplaceStr(number, #13, '');
    number := AnsiReplaceStr(number, #10, '');

    size := BetweenStrs(content, '<font color=red face="Arial"><b>', '</b></font>&nbsp;&nbsp;');

    if content = '' then
    begin
      if size = '' then
        size := '0 KB';
      UrlListView.Items[UrlListIndex].Caption := UrlListView.Items[UrlListIndex].SubItems[2]
    end
    else
    begin
      UrlListView.Items[UrlListIndex].Caption := title;
      if size = '' then
        size := IntToStr(StrLen(PChar(content)) div 1024) + ' KB';
      if number <> '' then
        UrlListView.Items[UrlListIndex].SubItems[3] := number;
    end;
    UrlListView.Items[UrlListIndex].SubItems[0] := size;
    UrlListView.Items[UrlListIndex].SubItems[1] := DateTimeToStr(UnixToDateTime(DateTimeToUnix(Str2DateTime(datetime)) + 9 * 3600));

    (* tB^O *)
    if Config.filActive and (Config.filKeywordList.Text <> '') then
    begin
      if number = '' then number := '0';
      if StrToInt(number) - oldnum = 1 then
      begin
        body := BetweenStrs(content, '<dl>', '</dl>');
        for i := 0 to Config.filKeywordList.Count - 1 do
          if AnsiContainsText(body, Config.filKeywordList[i]) then
          begin
            ChangeUrlListViewItemImage(UrlListIndex, ACT_END_UPDATE);
            ProgressBar.StepIt;
            ProgressBar.Update;
            exit;
          end;
      end;
    end;
  end
  else
  begin
    if content = '' then
      UrlListView.Items[UrlListIndex].Caption := UrlListView.Items[UrlListIndex].SubItems[2]
    else
      UrlListView.Items[UrlListIndex].Caption := title;
    UrlListView.Items[UrlListIndex].SubItems[0] := IntToStr(StrLen(PChar(content)) div 1024) + ' KB';
    UrlListView.Items[UrlListIndex].SubItems[1] := DateTimeToStr(UnixToDateTime(DateTimeToUnix(Str2DateTime(datetime)) + 9 * 3600));
  end;

  ChangeUrlListViewItemImage(UrlListIndex, ACT_UPDATED);
  ProgressBar.StepIt;
  ProgressBar.Update;
  SyncMenu;
  NotifyIfUpdate(UrlListIndex);
end;

function TAge2chMainWnd.CheckUrlListViewItem(URL: string): boolean;
var
  host, bbs, datnum: string;
  i, UrlListIndex, index: integer;
  oldLog: boolean;
  procCheck: TAsyncReq;
  ProxyServer, datetime: string;
  ProxyPort: integer;
begin
  UrlListIndex := -1;
  for i := 0 to UrlListView.Items.Count - 1 do
  begin
    if UrlListView.Items[i].SubItems[2] = URL then
    begin
      UrlListIndex := i;
      break;
    end;
  end;
  if UrlListIndex < 0 then
  begin
    ProgressBar.StepIt;
    ProgressBar.Update;
    Result := False;
    exit;
  end;

  ChangeUrlListViewItemImage(UrlListIndex, ACT_START_UPDATE);

  (* 2ch ̃XbhȂ dat 擾 *)
  Get2chInfo(URL, host, bbs, datnum, index, oldLog);
  if datnum <> '' then
    URL := 'http://'+host+'/'+bbs+'/dat/'+datnum+'.dat';

  // vNV̐ݒ
  if Config.netUseProxyToGet then
  begin
    if Pos(':', Config.netProxyToGet) > 0 then
    begin
      ProxyServer := LeftStr(Config.netProxyToGet, Pos(':', Config.netProxyToGet)-1);
      ProxyPort := StrToInt(Copy(Config.netProxyToGet, Pos(':', Config.netProxyToGet)+1, 5));
    end
    else
    begin
      ProxyServer := Config.netProxyToGet;
      ProxyPort   := 8080;
    end;
  end
  else
  begin
    ProxyServer := '';
    ProxyPort := 8080;
  end;

  procCheck := AsyncManager.Get(URL, OnCheck, nil, datetime, ProxyServer, ProxyPort, 0, 0, agrtHead);

  Result := Assigned(procCheck);
end;

procedure TAge2chMainWnd.OnCheck(Sender: TAsyncReq);
var
  dat2ch: boolean;
  i, UrlListIndex: integer;
  host1, bbs1, datnum1, host2, bbs2, datnum2: string;
  index1, index2: integer;
  oldLog1, oldLog2: boolean;
  datetime: string;
begin
  dat2ch := false;    // 2chURL?
  UrlListIndex := -1; // -1̂܂܂Ȃ獀ڂ݂Ȃ̂ŏI

  (* 2ch̃XȂ̂ӂ[̃TCgȂ̂`FbN *)
  for i := 0 to UrlListView.Items.Count - 1 do
  begin
    UrlListIndex := i;
    Get2chInfo(UrlListView.Items[i].SubItems[2], host1, bbs1, datnum1, index1, oldLog1);
    Get2chInfo(Sender.URI, host2, bbs2, datnum2, index2, oldLog2);
    if (datnum1 <> '') and
       (host1 = host2) and
       (bbs1 = bbs2) and
       (datnum1 = datnum2) then
    begin
      dat2ch := true;
      Break;
    end
    else if (UrlListView.Items[i].SubItems[2] = Sender.URI) then
    begin
      dat2ch := false;
      Break;
    end;
  end;

  (* ڂ݂Ȃ̂ŏI *)
  // XVƒɍڂ폜ꍇ
  if UrlListIndex = -1 then
  begin
    WriteStatus('No exist: ' + Sender.URI);
    ProgressBar.StepIt;
    ProgressBar.Update;
    exit;
  end;

  RefreshingPreQueue.Delete(RefreshingPreQueue.IndexOf(UrlListView.Items[UrlListIndex].SubItems[2]));

  (* ResponseCode `FbN *)
  if Sender.GetAsyncResponseCode <> 200 then
  begin
    // 2ch ̃XȂ玟 GET read.cgi 
    // ӂ[̃TCgȂI
    if dat2ch then
      RefreshQueue.Add(UrlListView.Items[UrlListIndex].SubItems[2])
    else
    begin
      WriteStatus('ڑł܂łB');
      ChangeUrlListViewItemImage(UrlListIndex, ACT_END_UPDATE);
      ProgressBar.StepIt;
      ProgressBar.Update;
      NotifyIfUpdate(UrlListIndex);
    end;
    exit;
  end;

  (* GetLastModified݂ȂƂ͎擾ŏIXVƂĈ *)
  // ͊ԈȂ̂ōTCYCRCł̃`FbNɕύXׂ
  if Length(Sender.GetLastModified) > 10 then
    datetime := Sender.GetLastModified
  else
    datetime := Sender.GetDate;

  (* ŏIXṼ`FbN *)
  if (DateTimeToUnix(Str2DateTime(datetime)) + 9 * 3600 <=
     DateTimeToUnix(StrToDateTime(UrlListView.Items[UrlListIndex].SubItems[1]))) then
  begin
    ChangeUrlListViewItemImage(UrlListIndex, ACT_END_UPDATE);
    ProgressBar.StepIt;
    ProgressBar.Update;
    NotifyIfUpdate(UrlListIndex);
    exit;
  end;

  (* XV *)
  UrlListView.Items[UrlListIndex].SubItems[1] := DateTimeToStr(UnixToDateTime(DateTimeToUnix(Str2DateTime(datetime)) + 9 * 3600));
  UrlListView.Items[UrlListIndex].SubItems[0] := IntToStr(StrToInt(Sender.GetContentLength) div 1024) + ' KB';

  RefreshQueue.Add(UrlListView.Items[UrlListIndex].SubItems[2]);
end;

(* ------------------------------------------------------------------------- *)

procedure TAge2chMainWnd.AutoMaintainTimerTimer(Sender: TObject);
var
  i: integer;
  iNow, iSub: integer;
begin
  iNow := DateTimeToUnix(Now);
  iSub := Config.netMaintainWait * 60 * 60;

  for i := 0 to UrlListView.Items.Count - 1 do
  begin
    if Pos('m', UrlListView.Items[i].SubItems[5]) > 0 then
      if iNow - DateTimeToUnix(StrToDateTime(UrlListView.Items[i].SubItems[1])) > iSub then
        PostQueue.Add(UrlListView.Items[i].SubItems[2]);
  end;

  PostTimer.Enabled := true;
end;

procedure TAge2chMainWnd.M1Click(Sender: TObject);
var
  i: integer;
begin
  for i := 0 to UrlListView.Items.Count - 1 do
  begin
    if UrlListView.Items[i].Selected then
      PostQueue.Add(UrlListView.Items[i].SubItems[2]);
  end;

  PostTimer.Enabled := true;
end;

procedure TAge2chMainWnd.PostTimerTimer(Sender: TObject);
var
  i: integer;
  Proxy: string;
begin
  if PostQueue.Count < 1 then
  begin
    PostTimer.Enabled := false;
    PostLock := false;
    exit;
  end;

  if PostLock then exit;

  PostLock := true;

  for i := 0 to UrlListView.Items.Count - 1 do
  begin
    if UrlListView.Items[i].SubItems[2] = PostQueue[0] then
    begin
      ChangeUrlListViewItemImage(i, ACT_START_POST);
      break;
    end;
  end;

  if Config.netUseProxyToPost then
    Proxy := Config.netProxyListToPost[PostProxyNum];

  Post(PostQueue[0],
       Config.netMaintainName,
       Config.netMaintainMail,
       TrimRight(Config.netMaintainBody.Text),
       Proxy);
end;

function TAge2chMainWnd.Post(const URL, NAME, MAIL, BODY, PROXY: string): boolean;
var
  host, bbs, datnum: string;
  i, index: integer;
  oldLog: boolean;

  hstURL: string;
  postDat: string;
  referer: string;
  list: TStringList;
  procPost: TAsyncReq;

  ProxyServer: string;
  ProxyPort: integer;
begin
  Get2chInfo(URL, host, bbs, datnum, index, oldLog);

  if (0 < Pos('.2ch.net', host)) or
          (0 < Pos('.bbspink.com', host)) then
  begin
    hstURL := 'http://' + host + '/test/bbs.cgi';
    postDat := 'submit=' + URLEncode('')
             + '&FROM=' + URLEncode(NAME)
             + '&mail=' + URLEncode(MAIL)
             + '&MESSAGE=' + URLEncode(BODY + DupeString(' ', PostNum mod 13))
             + '&bbs='  + bbs
             + '&key='  + datnum
             + '&time=' + IntToStr(PostTime);
  end
  else
  begin
    WriteStatus('fƂĒ`Ă܂');

    if PostQueue.Count < 1 then
    begin
      PostTimer.Enabled := false;
      PostLock := false;
      Result := false;
      exit;
    end;

    for i := 0 to UrlListView.Items.Count - 1 do
    begin
      if UrlListView.Items[i].SubItems[2] = PostQueue[0] then
      begin
        if ChangeUrlListViewItemImage(i, ACT_END_POST) then
          break
        else
        begin
          WriteStatus('ImageIndex Error.');
          break;
        end;
      end;
    end;

    PostQueue.Delete(0);
    PostLock := false;
    Result := false;
    exit;
  end;

  referer := URL + 'l50';

  list := TStringList.Create;

  // Cookie ǉ
  list.Add('Cookie: NAME=' + URLEncode(NAME) + '; MAIL=' + URLEncode(MAIL));
  if PostCookie <> '' then
    list.Add('Cookie: PON=' + PostCookie);

  // vNVݒ
  if Config.netUseProxyToPost then
  begin
    if Pos(':', Proxy) > 0 then
    begin
      ProxyServer := LeftStr(Proxy, Pos(':', Proxy)-1);
      ProxyPort   := StrToInt(Copy(Proxy, Pos(':', Proxy)+1, 5));
    end
    else
    begin
      ProxyServer := Proxy;
      ProxyPort   := 8080;
    end;
  end
  else
  begin
    ProxyServer := '';
    ProxyPort   := 8080;
  end;

  procPost := AsyncManager.Post(hstURL, postDat, referer, list, OnWrite,
                                OnNotify, ProxyServer, ProxyPort);

  if procPost <> nil then
    WriteStatus('ݒ');

  list.Free;

  Result := Assigned(procPost);
end;

procedure TAge2chMainWnd.OnNotify(Sender: TAsyncReq; code: TAsyncNotifyCode);
begin
  case code of
  ancPRECONNECT:
    begin
      sender.IdHTTP.AllowCookies := True;
    end;
  end;
end;

procedure TAge2chMainWnd.OnWrite(Sender: TAsyncReq);
var
  content, resttl, rescnt: string;
  i: integer;
  tmp: integer;
begin
  // ~{^Ƃ̓L[
  if PostQueue.Count < 1 then
  begin
    PostTimer.Enabled := false;
    PostLock := false;
    exit;
  end;

  if sender.IdHTTP.ResponseCode = 200 then
  begin
    tmp := DateTimeToUnix(Str2DateTime(sender.GetDate));
    if PostTime > tmp then
      PostTime := tmp - 30;

    content := sender.GetString;

    if Pos('<title>', content) > 0 then
      resttl := BetweenStrs(content, '<title>', '</title>');

    if Pos('<font size=+1 color=#FF0000><b>', content) > 0 then
      rescnt := BetweenStrs(content, '<font size=+1 color=#FF0000><b>', '</b></font>');

    if (resttl = ' ݊mF ') or (resttl = 'emF') then
    begin
      WriteStatus('݊mF');

      with sender.IdHTTP.CookieManager.CookieCollection do
      begin
        for i := 0 to Count -1 do
        begin
          if (Items[i].CookieName = 'SPID') or (Items[i].CookieName = 'PON') then
          begin
            PostCookie := Items[i].Value;
            break;
          end;
        end;
      end;

      PostLock := false;

      // gC
      Exit;
    end
    else
    begin
      // ݐ
      WriteStatus(resttl+' '+rescnt);

      // XVXV
      PostingURL := PostQueue[0];
      RefreshPreQueue.Add(PostQueue[0]);
      if not RefreshLock then
      begin
        RefreshTimer.Enabled := true;
        RefreshTimerTimer(Sender);
      end;
    end;
  end
  else
    WriteStatus('ݎs');

  PostLock := false;
  PostNum := PostNum + 1;

  if Config.netUseProxyToPost then
    if Config.netRandomProxy then
      PostProxyNum := (PostProxyNum + Random(99))
                      mod Config.netProxyListToPost.Count
    else
      PostProxyNum := (PostProxyNum + 1) mod Config.netProxyListToPost.Count;

  // ~{^Ƃ̓L[
  if PostQueue.Count < 1 then
  begin
    PostTimer.Enabled := false;
    exit;
  end;

  for i := 0 to UrlListView.Items.Count - 1 do
  begin
    if UrlListView.Items[i].SubItems[2] = PostQueue[0] then
    begin
      if ChangeUrlListViewItemImage(i, ACT_END_POST) then
        break
      else
      begin
        WriteStatus('ImageIndex Error.');
        break;
      end;
    end;
  end;

  PostQueue.Delete(0);
end;

(* ------------------------------------------------------------------------- *)

(* ~ *)
procedure TAge2chMainWnd.P1Click(Sender: TObject);
var
  i: integer;
begin
  if AsyncManager.Count < 1 then
    exit;

  (* XV~ *)
  RefreshQueue.Clear;
  RefreshPreQueue.Clear;
  ProgressBar.Position := ProgressBar.Max - AsyncManager.Count;

  (* ێ璆~ *)
  for i := 0 to UrlListView.Items.Count - 1 do
  begin
    if UrlListView.Items[i].SubItems[2] = PostQueue[0] then
    begin
      if ChangeUrlListViewItemImage(i, ACT_END_POST) then
        break
      else
      begin
        WriteStatus('ImageIndex Error.');
        break;
      end;
    end;
  end;
  PostQueue.Clear;

  AsyncManager.WaitForTerminateAll;

  WriteStatus('~܂');
end;

(* ------------------------------------------------------------------------- *)

procedure TAge2chMainWnd.UrlListViewSelectItem(Sender: TObject; Item: TListItem;
  Selected: Boolean);
begin
  if UrlListView.SelCount > 0 then
  begin
    (* Cj[ *)
    Open1.Enabled := True;
    M1.Enabled := True;
    Delete1.Enabled := True;
    Property1.Enabled := True;
    Cut1.Enabled := True;
    Copy1.Enabled := True;
    if ClipBoard.AsText <> '' then
      Paste1.Enabled := True
    else
      Paste1.Enabled := False;

    (* |bvAbvj[ *)
    ArrangeIcon2.Visible := False;
    Refresh2.Visible := False;
    Paste2.Visible := False;
    New2.Visible := False;
    Open2.Visible := True;
    M2.Visible := True;
    Cut2.Visible := True;
    Copy2.Visible := True;
    Delete2.Visible := True;
    Property2.Visible := True;

    (* Xe[^Xo[ *)
    if UrlListView.SelCount = 1 then
      WriteStatus('URL: ' + UrlListView.Selected.SubItems[2])
    else
      WriteStatus(IntToStr(UrlListView.SelCount) + ' ̃IuWFNgI');
  end
  else
  begin
    (* Cj[ *)
    Open1.Enabled := False;
    M1.Enabled := False;
    Delete1.Enabled := False;
    Property1.Enabled := False;
    Cut1.Enabled := False;
    Copy1.Enabled := False;
    if ClipBoard.AsText <> '' then
      Paste1.Enabled := True
    else
      Paste1.Enabled := False;

    (* |bvAbvj[ *)
    ArrangeIcon2.Visible := True;
    Refresh2.Visible := True;
    if ClipBoard.AsText <> '' then
    begin
      Paste2.Visible := True;
      Paste2.Enabled := True;
    end
    else
    begin
      Paste2.Visible := True;
      Paste2.Enabled := False;
    end;
    New2.Visible := True;
    Open2.Visible := False;
    M2.Visible := False;
    Cut2.Visible := False;
    Copy2.Visible := False;
    Delete2.Visible := False;
    Property2.Visible := False;

    (* Xe[^Xo[ *)
    WriteStatus(IntToStr(UrlListView.Items.Count) + ' ̃IuWFNgo^Ă܂');
  end;
end;

(* ------------------------------------------------------------------------- *)

procedure TAge2chMainWnd.UrlListViewColumnClick(Sender: TObject;
  Column: TListColumn);
var
  Index: integer;
begin
  if SortCol <> Column.Index then
  begin
    IsUpperSort := True;
  end
  else
  begin
    IsUpperSort := not IsUpperSort;
  end;

  if IsUpperSort then
   Index:=Column.Index+1                     //
  else
   Index:=-(Column.Index+1);                 //~

  UrlListView.CustomSort(@CustomSortProc, Index);

  //ȑÕ\[gColumnDefaultŕ`
  SetOwnerDrawColumn(SortCol, False);
  //SortCol̕`NewHeaderWndProcŏ
  SortCol := Column.Index;
end;

function CustomSortProc(Item1, Item2: TListItem; ParamSort: integer): integer; stdcall;
var
 Value: integer;
 Index: integer;
 i, j:  integer;
begin
  Index:=Abs(ParamSort);  //}CiXƂ

  case Index of
  1:
    //[̃Jp
    Value := lstrcmp(PChar(TListItem(Item1).Caption),
                     PChar(TListItem(Item2).Caption));
  2:
    //TCY
    begin
      if TListItem(Item1).SubItems[Index-2] = '' then i := 0
      else i := StrToInt(LeftStr(TListItem(Item1).SubItems[Index-2],
                         Pos(' KB', TListItem(Item1).SubItems[Index-2]) - 1));
      if TListItem(Item2).SubItems[Index-2] = '' then j := 0
      else j := StrToInt(LeftStr(TListItem(Item2).SubItems[Index-2],
                         Pos(' KB', TListItem(Item2).SubItems[Index-2]) - 1));

      if i > j then Value := 1
      else if i = j then Value := 0
      else Value := -1;
    end;
  3:
    //tƎ
    Value := CompareDateTime(StrToDateTime(TListItem(Item1).SubItems[Index-2]),
                         StrToDateTime(TListItem(Item2).SubItems[Index-2]));
  5, 6:
    //Ǝ擾
    begin
      if TListItem(Item1).SubItems[Index-2] = '' then i := 0
      else i := StrToInt(TListItem(Item1).SubItems[Index-2]);
      if TListItem(Item2).SubItems[Index-2] = '' then j := 0
      else j := StrToInt(TListItem(Item2).SubItems[Index-2]);

      if i > j then Value := 1
      else if i = j then Value := 0
      else Value := -1;
    end;
  else
    //ȊÕJp
    Value := lstrcmp(PChar(TListItem(Item1).SubItems[Index-2]),
                     PChar(TListItem(Item2).SubItems[Index-2]));
  end;

  if ParamSort>0 then   //vX
    Result:=Value          //ɂ
  else
    Result:=-Value;        //~ɂ
end;

procedure TAge2chMainWnd.DrawItem( const dis: TDrawItemStruct );
var
  SavedDC: Integer;
begin
  if HHeader = 0 then Exit;
  TmpDis := dis;
  ACanvas := TCanvas.Create;
  try
    SavedDC := SaveDC(dis.hDC);
    try
      ACanvas.Handle := dis.hDC;
      ACanvas.Font := UrlListView.Font;
      ACanvas.Brush.Color := clBtnFace;
      ACanvas.FillRect(dis.rcItem);
      DrawSortHeader(dis.rcItem, dis.itemState = ODS_SELECTED);
    finally
      ACanvas.Handle := 0;
      RestoreDC(dis.hDC, SavedDC);
    end;
  finally
    ACanvas.Free;
  end;
end;

//ListView̃bZ[WOwnerDraŵݔ
procedure TAge2chMainWnd.NewWndProc(var Msg: TMessage);
var
  dis: TDrawItemStruct;
begin
  if Msg.Msg = WM_DRAWITEM then
  begin
    dis := TWMDrawItem(Msg).DrawItemStruct^;
    DrawItem(dis);
  end;
  FOldWndProc(Msg);
end;

//HeaderMessage Column̕ύX̕`揈
function NewHeaderWndProc(TheWindow: HWND; Msg: Integer;
  wParam: WPARAM; lParam: LPARAM): Longint;
begin
  Result := CallWindowProc( FOldHDWndProc, TheWindow,
                                    Msg, wParam, lParam );
  case Msg of
    WM_CAPTURECHANGED: Age2chMainWnd.SetOwnerDrawColumn(Age2chMainWnd.SortCol, True );
  end;
end;

//Sortwb_[`悷
procedure TAge2chMainWnd.DrawSortHeader(ARect: TRect; Selected: Boolean);
var
  Rct, ArrowRct: TRect;
  uformat: Cardinal;
  theColumn: TListColumn;
begin
  Rct := ARect;
  inflateRect(Rct, -6,-1);
  Rct.Top := Rct.Top + 1;
  //\[g̑傫Əꏊݒ
  //ArrowRct := Rect(Rct.Right - 8, Rct.Top + 2, Rct.Right, Rct.Bottom -4);
  theColumn := UrlListView.Columns[SortCol];
  case theColumn.Index of
  0: ArrowRct := Rect(Rct.Left + 32, Rct.Top + 2, Rct.Left + 40, Rct.Bottom -4);
  1: ArrowRct := Rect(Rct.Right - 8, Rct.Top + 2, Rct.Right, Rct.Bottom -4);
  2: ArrowRct := Rect(Rct.Left + 58, Rct.Top + 2, Rct.Left + 66, Rct.Bottom -4);
  3: ArrowRct := Rect(Rct.Left + 32, Rct.Top + 2, Rct.Left + 40, Rct.Bottom -4);
  else
    ArrowRct := Rect(Rct.Right - 8, Rct.Top + 2, Rct.Right, Rct.Bottom -4);
  end;

  Rct.Right := ArrowRct.Left;
  //ColumnNbNꂽƂ̏
  if Selected then
  begin
    OffsetRect(Rct, 1,1);
    OffsetRect(ArrowRct, 1,1);
  end;
  //theColumn := UrlListView.Columns[SortCol];
  uformat := DT_SINGLELINE or DT_NOPREFIX or DT_NOCLIP or
                   DT_VCENTER or DT_END_ELLIPSIS;
  case theColumn.Alignment of
    taRightJustify: uformat := uformat or DT_RIGHT;
    taCenter:       uformat := uformat or DT_CENTER;
    else            uformat := uformat or DT_LEFT;
  end;
  DrawText(ACanvas.Handle,  PChar(theColumn.Caption), -1, Rct, uformat);
  //\[g`悷
  DrawSortArrow(ArrowRct);
end;

//\[gp`
procedure TAge2chMainWnd.DrawSortArrow(ARect: TRect);
var
  c: Integer;
begin
  c := (ARect.Right - ARect.Left) div 2 + ARect.Left;
  with ACanvas do
  begin
    Pen.Style := psSolid;
    if IsUpperSort then
    begin
      Pen.Color := clBtnHighlight;
      MoveTo(c, ARect.Top);
      LineTo(ARect.Right, ARect.Bottom);
      LineTo(ARect.Left, ARect.Bottom);
      Pen.Color := clBtnShadow;
      LineTo(c, ARect.Top);
    end else
    begin
      Pen.Color := clBtnHighlight;
      MoveTo(ARect.Right, ARect.Top);
      LineTo(c, ARect.Bottom);
      Pen.Color := clBtnShadow;
      LineTo(ARect.Left, ARect.Top);
      LineTo(ARect.Right, ARect.Top);
    end;
  end;
end;

{HeaderOwnerDrawOn/Off
OwnerDraw=TrueListViewMessageWM_DRAWITEM}
procedure TAge2chMainWnd.SetOwnerDrawColumn(Idx: Integer; OwnerDraw: Boolean);
var
  hdi: THDItem;
begin
  if HHeader = INVALID_HANDLE_VALUE then Exit;
  hdi.Mask := HDI_FORMAT;
  Header_GetItem(HHeader, Idx, hdi);
  if OwnerDraw then
  begin
    hdi.fmt := hdi.fmt or HDF_OWNERDRAW;
    hdi.fmt := hdi.fmt and not HDF_STRING;
  end else
  begin
    hdi.fmt := hdi.fmt and not HDF_OWNERDRAW;
    hdi.fmt := hdi.fmt or HDF_STRING;
  end;
  Header_SetItem(HHeader, Idx, hdi);
end;

procedure TAge2chMainWnd.SortByName1Click(Sender: TObject);
begin
  if SortCol = 0 then Exit;
  SetOwnerDrawColumn(SortCol, false);
  SortCol := 0;
  IsUpperSort := true;
  UrlListView.CustomSort(@CustomSortProc, SortCol + 1);
  SetOwnerDrawColumn(SortCol, true);
end;

procedure TAge2chMainWnd.SortBySize1Click(Sender: TObject);
begin
  if SortCol = 1 then Exit;
  SetOwnerDrawColumn(SortCol, false);
  SortCol := 1;
  IsUpperSort := true;
  UrlListView.CustomSort(@CustomSortProc, SortCol + 1);
  SetOwnerDrawColumn(SortCol, true);
end;

procedure TAge2chMainWnd.SortByDate1Click(Sender: TObject);
begin
  if SortCol = 2 then Exit;
  SetOwnerDrawColumn(SortCol, false);
  SortCol := 2;
  IsUpperSort := true;
  UrlListView.CustomSort(@CustomSortProc, SortCol + 1);
  SetOwnerDrawColumn(SortCol, true);
end;

procedure TAge2chMainWnd.SortByUrl1Click(Sender: TObject);
begin
  if SortCol = 3 then Exit;
  SetOwnerDrawColumn(SortCol, false);
  SortCol := 3;
  IsUpperSort := true;
  UrlListView.CustomSort(@CustomSortProc, SortCol + 1);
  SetOwnerDrawColumn(SortCol, true);
end;

(* ------------------------------------------------------------------------- *)

function BetweenStrs(const S, fromStr, toStr: string):string;
var
  upS,upfromStr, uptoStr: string;
begin
  Result := '';

  upS := AnsiUpperCase(S);
  upfromStr := AnsiUpperCase(fromStr);
  uptoStr := AnsiUpperCase(toStr);

  if (AnsiPos(upfromStr, upS) = 0) or (AnsiPos(uptoStr, upS) = 0) then
    exit;

  Result := Copy(S, AnsiPos(upfromStr, upS) + Length(upfromStr), AnsiPos(uptoStr, upS) - AnsiPos(upfromStr, upS) - Length(upfromStr));
end;

function SplitThreadURI(const URI: string; var host, bbs: string): integer;
var
  tmpStr: TStringList;
  i: integer;
begin
  tmpStr := TStringList.Create;
  tmpStr.Delimiter := '/';
  tmpStr.DelimitedText := URI;
  host := '';
  for i := 2 to tmpStr.Count -2 do
  begin
    if 0 < length(host) then
      host := host + '/';
    host := host + tmpStr.Strings[i];
  end;
  bbs := tmpStr.Strings[tmpStr.Count -1];
  result := tmpStr.Count;
  tmpStr.Free;
end;

(* URI2ch֘Ao  *)
procedure Get2chInfo(const URI: string; var host, bbs, datnum: string;
                     var index: integer;
                     var oldLog: boolean);
  function GetMulti(startPos, endPos: integer; strList: TStringList): string;
  var
    i: integer;
  begin
    result := '';
    for i := startPos to endPos do
    begin
      if 0 < length(result) then
        result := result + '/';
      result := result + strList.Strings[i];
    end;
  end;

  function Str2Int(const AString: string): Integer;
  var
    i, len, sign: integer;
  begin
    result := 0;
    len := length(AString);
    if len <= 0 then
      exit;
    i := 1;
    if AString[i] = '-' then
    begin
      sign := -1;
      Inc(i);
    end
    else
      sign := 1;
    for i := i to len do
    begin
      case AString[i] of
      '0'..'9': result := result * 10 + Ord(AString[i]) - Ord('0');
      else break;
      end;
    end;
    result := result * sign;
  end;
var
  strList, tmp: TStringList;
  i: integer;
begin
  host := '';
  bbs := '';
  datnum := '';
  index := -1;
  oldLog := false;
  strList := TStringList.Create;
  strList.Delimiter := '/';
  strList.DelimitedText := URI;

  (* sample format *)
  (* http://server.2ch.net/bbs/ *)
  (* http://server.2ch.net/test/read.cgi/bbs/?opt  *)
  (* http://server.2ch.net/test/read.cgi/bbs/dat/opt  *)
  (* http://server.2ch.net/bbs/dat/nnn.dat  *)
  (* http://server.2ch.net/bbs/kako/nnn/dat.html  *)
  (* http://server.2ch.net/bbs/kako/nnn/nnnn/dat.html  *)
  (* http://server.2ch.net/test/read.cgi?bbs=bbs&key=dat  *)
  (* http://server.2ch.net/sub/bbs/kako/nnn/dat.html  *)
  (* http://server.2ch.net/sub/test/read.cgi?bbs=bbs&key=dat  *)

  for i := 4 to strList.Count -1 do
  begin
    if strList.Strings[i] = 'kako' then
    begin
      oldLog := true;
      bbs := strList.Strings[i -1];
      host := GetMulti(2, i - 2, strList);
      datnum := ChangeFileExt(strList.Strings[strList.Count -1], '');
      break;
    end
    else if strList.Strings[i] = 'read.cgi' then
    begin
      host := GetMulti(2, i - 2, strList);
      if i + 1 <= strList.Count -1 then
      begin
        bbs := strList.Strings[i + 1];
        if (i + 2 <= strList.Count -1) and
           (not AnsiStartsStr('?', strList.Strings[i + 2])) then
        begin
          datnum := strList.Strings[i + 2];
          if (i + 3 <= strList.Count -1) then
            index := Str2Int(strList.Strings[i+3]);
        end;
      end;
      break;
    end
    else if AnsiStartsStr('read.cgi?', strList.Strings[i]) or
            AnsiStartsStr('read.pl?', strList.Strings[i]) then
    begin
      host := GetMulti(2, i - 2, strList);
      tmp := TStringList.Create;
      tmp.Delimiter := '?';
      tmp.DelimitedText := strList.Strings[i];
      if 1 < tmp.Count then
      begin
        tmp.Delimiter := '&';
        tmp.DelimitedText := tmp.Strings[1];
        tmp.Delimiter := '=';
        bbs  := tmp.Values['bbs'];
        if length(bbs) <= 0 then
          bbs := tmp.Values['ampbbs'];
        datnum := tmp.Values['key'];
        if length(datnum) <= 0 then
          datnum := tmp.Values['ampkey'];
        if tmp.Count > 2 then
        begin
          index := StrToIntDef(tmp.Values['st'], index);
          if index <= 0 then
            index := StrToIntDef(tmp.Values['ampst'], index);
          index := StrToIntDef(tmp.Values['START'], index);
          if index <= 0 then
            index := StrToIntDef(tmp.Values['ampSTART'], index);
        end;
      end;
      tmp.Free;
      break;
    end
    else if strList.Strings[i] = 'dat' then
    begin
      bbs := strList.Strings[i -1];
      host := GetMulti(2, i - 2, strList);
      datnum := ChangeFileExt(strList.Strings[strList.Count -1], '');
      break;
    end;
  end;
  if (length(host) <= 0) and (5 <= strList.Count) then
  begin
    bbs := strList.Strings[strList.Count -2];
    host := GetMulti(2, strList.Count -3, strList);
  end;
  strList.Free;
end;

(* ------------------------------------------------------------------------- *)

procedure TAge2chMainWnd.R1Click(Sender: TObject);
begin
  ShowMainWnd;
end;

procedure TAge2chMainWnd.U1Click(Sender: TObject);
begin
  Config.netAutoRefresh := not Config.netAutoRefresh;
  if Config.netAutoRefresh then
  begin
    AutoRefreshTimer.Enabled  := false;
    AutoRefreshTimer.Interval := Config.netRefreshWait * 1000;
    AutoRefreshTimer.Enabled  := true;
  end
  else
  begin
    AutoRefreshTimer.Enabled := false;
  end;
  UpdateToolBar;
end;

procedure TAge2chMainWnd.I1Click(Sender: TObject);
begin
  Config.netNotifyIfUpdate := not Config.netNotifyIfUpdate;
  UpdateToolBar;
end;

procedure TAge2chMainWnd.M3Click(Sender: TObject);
begin
  Config.netAutoMaintain := not Config.netAutoMaintain;
  if Config.netAutoMaintain then
  begin
    AutoMaintainTimer.Enabled := false;
    AutoMaintainTimer.Enabled := true;
  end
  else
  begin
    AutoMaintainTimer.Enabled := false;
  end;
  UpdateToolBar;
end;

procedure TAge2chMainWnd.Refresh4Click(Sender: TObject);
begin
  Config.winStdAction := 1;
end;

procedure TAge2chMainWnd.O2Click(Sender: TObject);
begin
  Config.winStdAction := 2;
end;

procedure TAge2chMainWnd.R2Click(Sender: TObject);
begin
  Config.winStdAction := 0;
end;

(* ------------------------------------------------------------------------- *)

procedure TAge2chMainWnd.UpdateToolBar;
begin
  if Config.netAutoRefresh then
    ToolButton7.Down := true
  else
    ToolButton7.Down := false;

  if Config.netNotifyIfUpdate then
    ToolButton8.Down := true
  else
    ToolButton8.Down := false;

  if Config.netAutoMaintain then
    ToolButton9.Down := true
  else
    ToolButton9.Down := false;
end;

procedure TAge2chMainWnd.T1Click(Sender: TObject);
begin
  ToolBar1.Visible := not ToolBar1.Visible;
  T1.Checked := not T1.Checked;
end;

procedure TAge2chMainWnd.B1Click(Sender: TObject);
begin
  StatusBar.Visible := not StatusBar.Visible;
  B1.Checked := not B1.Checked;
end;

(* ------------------------------------------------------------------------- *)

(* Xgr[ ImageIndex ̏ԑJ *)
function TAge2chMainWnd.ChangeUrlListViewItemImage(ItemIndex: integer;
  const Action: integer): boolean;
begin
  Result := False;
  case Action of
    // J
    ACT_OPEN:
    begin
      case UrlListView.Items[ItemIndex].ImageIndex of
        STT_UPD:
          UrlListView.Items[ItemIndex].ImageIndex := STT_NRM;
        STT_UPD_UPDATING:
          UrlListView.Items[ItemIndex].ImageIndex := STT_NRM_UPDATING;
        STT_UPD_POSTING:
          UrlListView.Items[ItemIndex].ImageIndex := STT_NRM_POSTING;
      end;
      Result := True;
    end;
    // XVJn
    ACT_START_UPDATE:
    begin
      case UrlListView.Items[ItemIndex].ImageIndex of
        STT_NRM:
          UrlListView.Items[ItemIndex].ImageIndex := STT_NRM_UPDATING;
        STT_UPD:
          UrlListView.Items[ItemIndex].ImageIndex := STT_UPD_UPDATING;
      end;
      Result := True;
    end;
    // XVI
    ACT_END_UPDATE:
    begin
      case UrlListView.Items[ItemIndex].ImageIndex of
        STT_NRM_UPDATING:
          UrlListView.Items[ItemIndex].ImageIndex := STT_NRM;
        STT_UPD_UPDATING:
          UrlListView.Items[ItemIndex].ImageIndex := STT_UPD;
      end;
      Result := True;
    end;
    // XV肩XVI
    ACT_UPDATED:
    begin
      case UrlListView.Items[ItemIndex].ImageIndex of
        STT_NRM,
        STT_NRM_UPDATING,
        STT_UPD_UPDATING:
          UrlListView.Items[ItemIndex].ImageIndex := STT_UPD;
        STT_NRM_POSTING:
          UrlListView.Items[ItemIndex].ImageIndex := STT_UPD_POSTING;
      end;
      Result := True;
    end;
    // eJn
    ACT_START_POST:
    begin
      case UrlListView.Items[ItemIndex].ImageIndex of
        // XVtO͓etOŏ㏑
        STT_NRM,
        STT_NRM_UPDATING:
          UrlListView.Items[ItemIndex].ImageIndex := STT_NRM_POSTING;
        STT_UPD,
        STT_UPD_UPDATING:
          UrlListView.Items[ItemIndex].ImageIndex := STT_UPD_POSTING;
        // eȂ̂ɏԂeꍇ
        STT_NRM_POSTING,
        STT_UPD_POSTING:
          exit;
      end;
      Result := True;
    end;
    // eI
    ACT_END_POST:
    begin
      case UrlListView.Items[ItemIndex].ImageIndex of
        STT_NRM_POSTING:
          UrlListView.Items[ItemIndex].ImageIndex := STT_NRM;
        STT_UPD_POSTING:
          UrlListView.Items[ItemIndex].ImageIndex := STT_UPD;
        // êɏԂeȂꍇ
        STT_NRM,
        STT_NRM_UPDATING,
        STT_UPD,
        STT_UPD_UPDATING:
          exit;
      end;
      Result := True;
    end;
    else
    begin
      WriteStatus('No such action.');
    end;
  end;
end;

(* ------------------------------------------------------------------------- *)

procedure TAge2chMainWnd.UrlListViewColumnRightClick(Sender: TObject;
  Column: TListColumn; Point: TPoint);
var
 P : TPOINT;
begin
  GetCursorPos(P);
  SetForegroundWindow(Handle);
  ColumnPopupMenu.Popup(P.x,P.y);
end;

(* ------------------------------------------------------------------------- *)

procedure TAge2chMainWnd.OpenUrlListViewItem(ItemIndex: integer);
var
  startnum, endnum: string;
begin
  ChangeUrlListViewItemImage(ItemIndex, ACT_OPEN);

  if (UrlListView.Items[ItemIndex].SubItems[3] = '') then
    OpenURL(UrlListView.Items[ItemIndex].SubItems[2])
  else
  begin
    if (UrlListView.Items[ItemIndex].SubItems[4] = '') or
       (UrlListView.Items[ItemIndex].SubItems[4] = UrlListView.Items[ItemIndex].SubItems[3]) or
       not Config.netOpenNew then
      OpenURL(UrlListView.Items[ItemIndex].SubItems[2]+'l'+IntToStr(Config.netOpenControl))
    else
    begin
      startnum := IntToStr(StrToInt(UrlListView.Items[ItemIndex].SubItems[4])-Config.netOpenBefore+1);
      if StrToInt(startnum) < 0 then startnum := '1';
      endnum := IntToStr(StrToInt(startnum)+Config.netOpenControl-1);
      if StrToInt(endnum) > 1000 then endnum := '';
      OpenURL(UrlListView.Items[ItemIndex].SubItems[2]+startnum+'-'+endnum+'n');
    end;

    UrlListView.Items[ItemIndex].SubItems[4] := UrlListView.Items[ItemIndex].SubItems[3];
  end;
end;

procedure OpenURL(URL: string);
var
  host, bbs, datnum: string;
  index: integer;
  oldLog: boolean;
  CH: THandle;
  wnd: HWND;
  cd: TCopyDataStruct;
begin
  Get2chInfo(URL, host, bbs, datnum, index, oldLog);

  //  URL  2ch ̃XbhŁA̃AvP[VŊJȂ
  if (datnum <> '') and Config.winOpenApp and (Config.winOpenAppPath <> '') then
  begin
    // WM_COPYDATA  URL nȂ
    if Config.winSendUrl and (Config.winSendUrlHWnd <> '') then
    begin
      wnd := FindWindow(PChar(Config.winSendUrlHWnd), nil);
      if wnd <> 0 then
      begin
        cd.dwData := 0;
        cd.cbData := Length(URL) + 1;
        cd.lpData := StrAlloc(cd.cbData);
        StrCopy(cd.lpData, PChar(URL));
        SendMessage(wnd, WM_COPYDATA, Application.Handle, LPARAM(@cd));
        StrDispose(cd.lpData);
        //SetForegroundWindow(wnd);//ݒEChEȂǂoĂƂɖ肠
        Exit;
      end;
    end;

    ExecuteProc(nil, PChar('"' + Config.winOpenAppPath + '" "' + URL + '"'),
      100, False, CH);
  end
  else
    ShellExecute(0, nil, PChar(URL), nil, nil, SW_SHOW);
end;

function ExecuteProc(ExePath,                 // s\t@C̃pXiʏ nil ŗǂj
                     CmdLine: PChar;          // R}hC
                     dwWait: Cardinal;        // N҂
                     Console: Boolean;        // R\[ƂċN邩ۂ
                     var ProcHandle: THandle  // vZXnhi[ϐ
                     ): Boolean;
var
  Rtn       : Cardinal;
  StartInfo : TStartupInfo;
  ProcInfo  : TProcessInformation;
begin

  Result:= False; // ߂l
  ProcHandle:= 0; // vZXnh

  // vZXNݒ
  ZeroMemory(@StartInfo, Sizeof(StartInfo));
  GetStartupInfo(StartInfo);
  with StartInfo do
  begin

    // TCYݒ
    cb:= Sizeof(StartInfo);

    // \}AWnh̕ύXLɂ
    dwFlags:= STARTF_USESTDHANDLES or STARTF_USESHOWWINDOW;

    //R\[[h̏ꍇ͔\ŋN
    if Console then wShowWindow:= SW_HIDE;

  end;

  // OvZXN
  if CreateProcess(ExePath,
                   CmdLine,
                   nil,
                   nil,
                   True,
                   0,
                   nil,
                   nil,
                   StartInfo,
                   ProcInfo) then
  begin
    // OvZXN҂
    Rtn:= WaitForInputIdle(ProcInfo.hProcess, dwWait);
    if Rtn <> 0 then Exit; // Ns
    ProcHandle:= ProcInfo.hProcess; // vZXnhԂ
    CloseHandle(ProcHandle);
    Result:= True; // 한AiNj
  end;
end;

(* ------------------------------------------------------------------------- *)

procedure WriteStatus(const str: string);
begin
  Age2chMainWnd.WriteStatus(str);
end;

procedure TAge2chMainWnd.WriteStatus(const s: string);
begin
  StatusBar.Panels.Items[0].Text := s;
end;

procedure TAge2chMainWnd.StatusBarResize(Sender: TObject);
var
  BarWidth,i,PointPanel: Integer;
begin
  BarWidth:=0;
  with StatusBar do
  begin
    PointPanel := Panels.Count;
    repeat
      dec(PointPanel);    //Ԃ̃plTCYׂ肷
      BarWidth := BarWidth + FBarWidths[PointPanel];
    until (Width < BarWidth)or(PointPanel=0) ;

    for i:=0 to PointPanel-1 do  //ׂplWidth:=0ɂ
      Panels[i].Width := 0;

    BarWidth := 0;
    for i:=PointPanel+1 to Panels.Count-1 do
    begin
      Panels[i].Width := FBarWidths[i];
      BarWidth := BarWidth + FBarWidths[i];
    end;
    Panels[PointPanel].Width := StatusBar.Width - BarWidth;
  end;

  // vOXo[Xe[^Xo[ɒǏ]
  with ProgressBar do begin
    Top := 2;
    Height := StatusBar.Height -2 ;
    Width := StatusBar.Panels[1].Width -2;
    Left := StatusBar.Panels[0].Width +2;
  end;
end;

(* ------------------------------------------------------------------------- *)

(* hbO & hbvp[^n *)
procedure TAge2chMainWnd.CreateParams(var Params: TCreateParams);
begin
  inherited CreateParams(Params);
  // 󂯎鏀
  Params.ExStyle := Params.EXStyle or WS_EX_ACCEPTFILES;
end;

procedure TAge2chMainWnd.WMDropFiles(Var Msg: TWMDropFiles);
Var
  FileName: Array[0..MAX_PATH] of Char;
  i, Count: integer;
  strList: TStringList;
Begin
  strList := TStringList.Create;

  // p[^-1ɂƃhbv擾ł
  Count := DragQueryFile(Msg.Drop, DWord(-1), FileName, SizeOf(FileName));
  for i := 0 to Count - 1 do
  begin
    DragQueryFile(Msg.Drop, i, FileName, SizeOf(FileName));
    strList.LoadFromFile(FileName);
    if strList[0] = '[InternetShortcut]' then
      AddUrlListView(MidStr(strList[1], 5, Length(strList[1]) - 4));
    strList.Clear;
  end;

  strList.Free;
  DragFinish(Msg.Drop);
End;

(* R}hCp[^n *)
procedure TAge2chMainWnd.WMCopyData(var Msg: TWMCopyData);
var
  pcData: PChar;
  strList: TStringList;
  i,j,k: integer;
begin
  pcData:=StrAlloc(MAX_BUF1+1);
  StrCopy(pcData,PChar(Msg.CopyDataStruct^.lpData));

  strList := TStringList.Create;
  strList.Text := pcData;

  // ɍXV
  for i := 0 to strList.Count - 1 do
  begin
    if strList[i] = '/C' then
    begin
      strList.Delete(i);
      AutoRefreshTimerTimer(Self);
      Break;
    end;
  end;

  // ANeBû܂܍(ł͉Ȃ)
  for i := 0 to strList.Count - 1 do
  begin
    if strList[i] = '/D' then
    begin
      strList.Delete(i);
      Break;
    end;
  end;

  // XVꂽڂJ
  for i := 0 to strList.Count - 1 do
  begin
    if strList[i] = '/O' then
    begin
      strList.Delete(i);
      O1Click(Self);
      Break;
    end;
  end;

  // XV`FbN~
  for i := 0 to strList.Count - 1 do
  begin
    if strList[i] = '/S' then
    begin
      strList.Delete(i);
      P1Click(Self);
      Break;
    end;
  end;

  // URL 폜
  for i := 0 to strList.Count - 1 do
  begin
    if strList[i] = '/E' then
    begin
      strList.Delete(i);

      for j := 0 to strList.Count - 1 do
      begin
        for k := 0 to UrlListView.Items.Count - 1 do
        begin
          if strList[j] = UrlListView.Items[k].SubItems[2] then
          begin
            UrlListView.Items[k].Delete;
            WriteStatus('폜܂ : ' + strList[j]);
            Break;
          end;
        end;
      end;
      strList.Clear;

      Break;
    end;
  end;

  // URL o^
  for i := 0 to strList.Count - 1 do
    AddUrlListView(strList[i]);

  strList.Free;

  SyncMenu;

  StrDispose(pcData);
end;

procedure CopyDataToOld(Wnd: HWnd;
                        aParamCount: integer);
var
  pcData: PChar;
  CDS: TCopyDataStruct;
begin
  pcData:=StrAlloc(MAX_BUF1+1);
  ParamsToData(aParamCount,pcData);

  CDS.cbData:=MAX_BUF1+1;
  CDS.lpData:=pcData;
  SendMessage(Wnd,WM_COPYDATA,0,LongInt(@CDS));
  StrDispose(pcData);
end;

procedure ParamsToData(
          aParamCount: integer;
          var pcData: PChar);
var
  i: integer;
begin
  StrCopy(pcData,'');
  for i:=1 to aParamCount do begin
    if i=1 then
      StrCat(pcData,PChar(ParamStr(i)))
    else begin
      StrCat(pcData,#13#10);
      StrCat(pcData,PChar(ExtractFilename(ParamStr(i))));
    end;
  end;
end;

(* ------------------------------------------------------------------------- *)

(* ^XNgC *)
constructor TAge2chMainWnd.Create(AOwner: TComponent);
begin
  inherited;
  IsLiveTaskTray := False;
end;

procedure TAge2chMainWnd.WndProc(var Message: TMessage);
var
 P : TPOINT;
begin
  if Message.Msg = WM_NotifyTasktray then
  begin
    case Message.LParam of
      WM_LBUTTONDOWN:
        case Config.winStdAction of
          0: ShowMainWnd;
          1: AutoRefreshTimerTimer(Age2chMainWnd);
          2: O1Click(Age2chMainWnd);
        end;
      WM_RBUTTONDOWN:
        begin
          (* ^XNgC̃|bvAbvj[ *)
          if Age2chMainWnd.Visible then
          begin
            R1.Visible := false;
            N14.Visible := false;
          end
          else
          begin
            R1.Visible := true;
            N14.Visible := true;
          end;
          if Config.netAutoRefresh then
            U1.Checked := true
          else
            U1.Checked := false;
          if Config.netNotifyIfUpdate then
            I1.Checked := true
          else
            I1.Checked := false;
          if Config.netAutoMaintain then
            M3.Checked := true
          else
            M3.Checked := false;
          case Config.winStdAction of
            0:
              begin
                R2.Checked := true;
                R1.Default := true;
                Refresh4.Checked := false;
                Refresh3.Default := false;
                O2.Checked := false;
                O1.Default := false;
              end;
            1:
              begin
                R2.Checked := false;
                R1.Default := false;
                Refresh4.Checked := true;
                Refresh3.Default := true;
                O2.Checked := false;
                O1.Default := false;
              end;
            2:
              begin
                R2.Checked := false;
                R1.Default := false;
                Refresh4.Checked := false;
                Refresh3.Default := false;
                O2.Checked := true;
                O1.Default := true;
              end;
          end;

          GetCursorPos(P);
          SetForegroundWindow(Handle);
          TrayPopupMenu.Popup(P.x,P.y);
        end;
    end;
  end
  else
    inherited;
end;

procedure TAge2chMainWnd.InitTasktray;
begin
  if IsLiveTasktray then exit;
  with NotifyIcon do
  begin
    cbSize := SizeOf(TNotifyIconData);
    Wnd := Handle;
    uID := 1;
    uFlags := NIF_ICON or NIF_MESSAGE or NIF_TIP;
    uCallbackMessage := WM_NotifyTasktray;
    hIcon := LoadIcon(HInstance, 'TRAY');
    szTip := SCRIPT;
  end;
  Shell_NotifyIcon(NIM_ADD,@NotifyIcon);
  IsLiveTasktray := True;
end;

procedure TAge2chMainWnd.FinishTasktray;
begin
  if IsLiveTasktray = False then exit;
  with NotifyIcon do
  begin
    cbSize := SizeOf(TNotifyIconData);
    Wnd := Handle;
    uID := 1;
  end;
  Shell_NotifyIcon(NIM_DELETE,@NotifyIcon);
  IsLiveTasktray := False;
end;

procedure TAge2chMainWnd.HideMainWnd;
begin
  Application.ShowMainForm := False;
  ShowWindow(Application.Handle, SW_HIDE);
  Hide;
end;

procedure TAge2chMainWnd.ShowMainWnd;
begin
  SetForegroundWindow(Age2chMainWnd.Handle);
  Application.Restore;
  Show;
end;

procedure TAge2chMainWnd.AppMinimize(Sender: TObject);
begin
  if Config.winUseTaskTray then
    HideMainWnd
  else
    Application.Minimize;
end;

end.



