unit HTTPSub;

(* PersonalłɂHTTPEncodeȂ *)
(* Copyright (c) 2001,2002 hetareprog@hotmail.com *)
(* Copyright (c) 2003 age2ch@users.sourceforge.jp *)

interface

uses
  SysUtils;

function URLEncode(const str: string; plus: boolean = true): string;
function URLDecode(const str: string): string;

implementation

{$B-} (* short circuit *)

function URLEncode(const str: string; plus: boolean = true): string;
var
  i: integer;
begin
  result := '';
  for i := 1 to length(str) do
  begin
    case str[i] of
    '0'..'9','A'..'Z','a'..'z':
      result := result + str[i];
    ' ':
      if plus then
        result := result + '+'
      else
        result := result + '%20';
    else
      result := result + Format('%%%2.2X', [Ord(str[i])]);
    end;
  end;
end;

function URLDecode(const str: string): string;
var
  i: integer;
begin
  result := '';
  if Length(str) > 0 then
  begin
    i := 1;
    while i <= Length(str) do
    begin
      if str[i] = '%' then
        begin
          result := result + Chr(StrToInt('$' + str[i+1] + str[i+2]));
          i := Succ(Succ(i));
        end
      else if str[i] = '+' then
        result := result + ' '
      else
        result := result + str[i];
      i := Succ(i);
    end;
  end;
end;

end.
