program Age2ch;

uses
  Windows,
  Messages,
  Forms,
  zlib in '..\jane2ch\gzip_delphi2\zlib.pas',
  gzip in '..\jane2ch\gzip_delphi2\gzip.pas',
  crc in '..\jane2ch\gzip_delphi2\crc.pas',
  IdHTTP in '..\jane2ch\derived\IdHTTP.pas',
  IdHTTP2 in '..\jane2ch\derived\IdHTTP2.pas',
  HTTPSub in 'HTTPSub.pas',
  USynchro in '..\jane2ch\src\USynchro.pas',
  UXTime in '..\jane2ch\src\UXTime.pas',
  Main in 'Main.pas' {Age2chMainWnd},
  UOption in 'UOption.pas' {OptionPagesDlg},
  UAbout in 'UAbout.pas' {AboutBox},
  UProperty in 'UProperty.pas' {PropertyPagesDlg},
  UAsync in 'UAsync.pas',
  UConfig in 'UConfig.pas';

{$R *.res}

var
  hMutex: THandle;
  Wnd, AppWnd: HWnd;
  Activate: boolean;
  i: integer;
begin
  hMutex := OpenMutex(MUTEX_ALL_ACCESS, False, 'hAge2chPrevInst');

  if hMutex <> 0 then
  begin
    Wnd := FindWindow('TAge2chMainWnd', nil);

    if Wnd <> 0 then
    begin
      (* R}hCp[^n *)
      Activate     := True;
      if ParamCount > 0 then
      begin
        CopyDataToOld(Wnd,ParamCount);

        for i := 1 to ParamCount do
        begin
          if ParamStr(i) = '/D' then
            Activate := False;
        end;
      end;

      (* ANeBu *)
      if Activate then
      begin
        Wnd := FindWindow('TAge2chMainWnd', nil);

        if Wnd <> 0 then
        begin
          // ANeBu
          SetForegroundWindow(Wnd);
          // ACRԂȂ猳ɖ߂
          AppWnd := GetWindowLong(Wnd, GWL_HWNDPARENT);
          if AppWnd <> 0 then Wnd := AppWnd;
          if IsIconic(Wnd) then
            SendMessage(AppWnd, WM_SYSCOMMAND, SC_RESTORE, -1);
        end;
      end;
    end;

    CloseHandle(hMutex);
  end
  else
  begin
    hMutex := CreateMutex(nil, False, 'hAge2chPrevInst');

    Application.Initialize;
    Application.Title := 'Age2ch';
    Application.CreateForm(TAge2chMainWnd, Age2chMainWnd);
  Application.CreateForm(TOptionPagesDlg, OptionPagesDlg);
  Application.CreateForm(TAboutBox, AboutBox);
  Application.CreateForm(TPropertyPagesDlg, PropertyPagesDlg);
  Application.Run;

    ReleaseMutex(hMutex);
  end;
end.
