/*
 *  ADP (Another Data Processor) www.adp.la
 *  Copyright (C) 2010 Katsuhisa Ohfuji <katsuhisa@ohfuji.name>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 *  MA 02110-1301, USA.
 */
#include "adp.h"

extern ExecContext_Factory newExecContext_Catch;
extern ExecContext_Factory newExecContext_Next;
extern ExecContext_Factory newExecContext_Pipe;


inline bool ExecContextRoot::setmessage(PException &excp, const char *klass, const char *msg) { 
	if ( klass ) excp.exception_class = klass;
	if ( msg ) excp.message = msg;
	if ( pred ) {
		stringstream	str;
		pred->recompile(str);
		excp.where = str.str();
		ExecContext *p = this->p;
		excp.in.clear();
		while ( p != 0 && p->pred != 0 ) {
			stringstream	str;
			p->pred->recompile(str);
			excp.in += " in ";
			excp.in += str.str();
			p = p->p;
		}
	}
	return false;
}


bool ExecContextRoot::call(PObjectArray *, PException &excp) { 
	bool result;
	if ( firstflg ) {
		firstflg = false;
		result = first(excp);
		if ( result == false && !excp.iserr() ) {
			if ( pred->getOpt().first_true ) {
				return ASSERT_assert_number_of_times_unificate_error(excp);
			}
		}
	} else {
		result = backtrack(excp);
		if ( result == true ) {
			if ( pred->getOpt().backtrack_false ) {
				return ASSERT_assert_number_of_times_unificate_error(excp);
			}
		}
	}
	if ( !pred->opt.result_return || excp.iserr() ) {
		return result;
	} else {
		p->last_result = result;
		return true;
	}
}


bool ExecContextBase::call(PObjectArray *mtobjs, PException &excp) { 
	bool result;
	if ( firstflg ) {
		firstflg = false;
		// LbV
		if ( pred->opt.cachable ) {
			pred_a = dynamic_cast<const PPredicate*>(pred->getval( this, gl));
			PINTEGER	hash = pred_a->chash();
			pcmap::iterator	i = pccache.find(hash);
			if ( i != pccache.end() && i->second.key->cmatch(pred_a) ) {
				// I
				ccount = 0;
				cache = &i->second;
				record = false;
				result = play_cache();
				if ( !result ) {
					if ( p ) { (*gl) = backup; } // ɖ߂
					cleanup();
				}
				if ( !pred->opt.result_return ) {
					return result;
				} else {
					p->last_result = result;
					return true;
				}
			} else {
				// Ȃ
				pccache[hash] = PredicateCache( hash, pred_a);
				pcmap::iterator	i = pccache.find(hash);
				cache = &i->second;
				ccount = 0;
				record = true;
			}
			result = first(excp);
			record_cache(result,excp);	// ʂLbVɕۑ
		} else {
			result = first(excp);
		}
		
		if ( result == false ) {
			if ( p ) { (*gl) = backup; } // ɖ߂
			cleanup();
			if ( !excp.iserr() && pred->getOpt().first_true ) {
				return ASSERT_assert_number_of_times_unificate_error(excp);
			}
		}
	} else {
		assert( gl->size() == backup.size() );
		*gl = backup;	// ۑĂϐ̕
		if ( !objs.empty() ) {
			if ( mtobjs ) {
				// spɈꎞIɕێĂmۂ 
				// ArrayNXɈړp̃\bhǉǂ 
				for_each(objs.begin(), objs.end(), MoveObject(*mtobjs));	
			} else {
				for_each(objs.begin(), objs.end(), PMMDeleteObject());
			}
			objs.clear();
		}
		if ( cache != 0 && !record ) {
			result = play_cache();
			if ( !result ) { 
				if ( p ) { (*gl) = backup; } // ɖ߂
				cleanup();
			}
			if ( !pred->opt.result_return ) {
				return result;
			} else {
				p->last_result = result;
				return true;
			}
		}
		result = backtrack(excp);
		if ( pred->opt.cachable ) record_cache(result,excp);	// ʂLbVɕۑ
		if ( result == true ) {
			if ( pred->getOpt().backtrack_false ) {
				if ( p ) { (*gl) = backup; } // ɖ߂
				cleanup();
				return ASSERT_assert_number_of_times_unificate_error(excp);
			}
		} else {
			if ( p ) { (*gl) = backup; } // ɖ߂
			cleanup();
		}
	}
	if ( !result ) {
		if ( p ) { (*gl) = backup; } // ɖ߂
		cleanup();
	}
	if ( !pred->opt.result_return || excp.iserr() ) {
		return result;
	} else {
		p->last_result = result;
		return true;
	}
}


// PipeXbh֐
thread_return __stdcall pipe_thread( void *args )
{
	thread_count++;	
	ExecContext_Pipe	*pargs = (ExecContext_Pipe*)args;
	set_gc(pargs->gc);		// O[oReNXg̐ݒ
	pargs->prefetch_backtrack(pargs->excp);

	MyLog( cformat( "tid=%8x:pipe_thread_wait:%p\n", GetCurrentThreadId(), pargs).c_str(), "pipe");

	//while ( pargs->fl == false ) waitamoment;
	waitflg(pargs->fl);
	pargs->fl = false;

	pargs->ecs.clear();

	// spɈꎞIɕێĂJ 
	for_each( pargs->mtobjs.begin(), pargs->mtobjs.end(), PMMDeleteObject());
	pargs->mtobjs.clear();

	pargs->done = true;
	//SetEvent(pargs->ehr);
	pargs->fr = true;

	MyLog( cformat( "tid=%8x:pipe_thread_exit:%p\n", GetCurrentThreadId(), pargs).c_str(), "pipe");

	thread_count--;
	return 0;
}


bool ExecContext_Pipe::first(PException &excp)
{
	MyLog( cformat( "tid=%8x:first:%p(pipe=%d)\n", GetCurrentThreadId(), this, pipe).c_str(), "pipe");

	if ( pipe ) {
		// TuXbh̏i͎sȂj 
		return false;
	} else {
		// ReNXg̕ۑ
		hlocal = p->hlocal;
		substitutepair = p->substitutepair;
		goal = p->goal;
		vcnt = p->vcnt;
		g = p->g;
		lastpobjs = p->lastpobjs;
		ecs = p->ecs;
		goalidx = p->goalidx - 1;

		// [Jϐ̏
		for ( int i = goalidx; i >= 0; i-- ) {
			ExecContextRoot* ec = ecs[i];
			if ( ec ) {
				if ( ec->gl == p->gl ) {
					ec->gl = hl;
				}
				if ( ec->hl == p->hl ) {
					ec->hl = hl;
				}
				if ( ec == p->pipe ) break;
			}
		}

		// Rs[obN̏
		d = p;

		// pipeidx̍XV
		if ( p->pipe ) {
			p->pipe->d = this;	// OpipẽRs[obN̐ݒ 
		}
		p->pipe = this;

		// tO֌W̏
		fl = false;
		fr = false;
		pipe = true;
		done = false;

		// O[oReNXg̕ۑ
		this->gc = get_gc();

		if ( !start_thread( &th, pipe_thread, this) ) return RERR_Createthread(excp);
		return true;
	}
}

bool ExecContext_Pipe::prefetch_backtrack(PException &excp)
{
	MyLog( cformat( "tid=%8x:prefetch_backtrack:%p\n", GetCurrentThreadId(), this).c_str(), "pipe");


	// TuXbh̏
	bool forward = false;

	while ( !done ) {
		ExecContextRoot*		ec = 0;
		ExecContext_Factory*	f = 0;
		if ( !forward ) {	// obNgbN 
			ec = ecs[goalidx];	// LbV͂ 
			g = getPredicate(goalidx); // Ăяȍq̃vtBbNX݂ 
			if ( ec == 0 || (g != 0 && g->opt.only_one_call == true) ) {
				if ( goalidx == 0 ) {
					// {\bhłnextq͍̏sȂ 
					return false;
				} else {
					--goalidx;
				}
				continue; // [v̐擪 
			}
			f = ec->f;
			// backtrack
		} else {
			// gpipeq܂œBB 
			if ( this == ecs[goalidx] ) {
				// backtrackɂȂ 

				// REXbh҂
				MyLog( cformat( "tid=%8x:prefetch_backtrack_wait:%p \n", GetCurrentThreadId(), this).c_str(), "pipe");

				//while ( fl == false ) waitamoment;
				waitflg(fl);
				fl = false;

				MyLog( cformat( "tid=%8x:prefetch_backtrack:%p done=%d\n", GetCurrentThreadId(), this, done).c_str(), "pipe");

				if ( done ) return false;

				// ReNXg̃Rs[obN
				d->hlocal = hlocal;
				d->substitutepair = substitutepair;
				//d->goal = goal;
				//d->vcnt = vcnt;
				//d->g = g;
				//d->lastpobjs = lastpobjs;
				for ( size_t i = 0; i < goalidx; i++ ) {
					d->ecs[i] = ecs[i];
				}

				// spɈꎞIɕێĂJ 
				// pipeAĂꍇ́AA֓n
				if ( d != p ) {
					ExecContext_Pipe *pipe = dynamic_cast<ExecContext_Pipe*>(d);
					pipe->mtobjs.insert( pipe->mtobjs.end(), mtobjs.begin(), mtobjs.end());
					mtobjs.clear();
				} else {
					for_each( mtobjs.begin(), mtobjs.end(), PMMDeleteObject());
					mtobjs.clear();
				}

				// REXbȟp
				fr = true;

				--goalidx;
				forward = false;
				continue;
			}
			// ʏ̃tH[hV[PX 
			g = getPredicate(goalidx);
			if ( g == 0 ) return RERR_predicate_name(excp);	// catch߂ɍsȂ΂ȂȂH 
			f = g->factory;
			if ( f == 0 ) {
				bool cache = true;
				const string *name = g->getNamePtr()->getPredicateName(cache, hl);
				f = search_ExecContext_Factory(name, g->nspace);
				if ( cache ) g->factory = f; // Nameύ̎g->factoryɕۑłȂ 
			}
			if ( (ec = ecs[goalidx]) == 0 ) {
				ec = f->create(this);
				ecs[goalidx] = ec;
			} else if ( f != ec->f ) {
				// TCNŎgq͕ʂ
				//delete ecs[goalidx];
				ec->f->del(ec);
				ec = f->create(this);
				ecs[goalidx] = ec;
			} else {
				ec->reinit(g, hl);	// TCN
			}
			// ꎞϐ̕ۑꏊ̌
			if ( ec->pobjs == 0 ) {
				if ( lastpobjs == 0 ) {
					for ( size_t i = goalidx - 1; i < goalidx; i-- ) {
						if ( ecs[i] ) {
							lastpobjs = ecs[i]->pobjs;
							break;
						}
					}
					if ( lastpobjs == 0 ) lastpobjs = &objs;
				}
				ec->pobjs = lastpobjs;
			} else {
				lastpobjs = ec->pobjs;
			}

			// first
		}
	
		if ( f == &newExecContext_Next ) {	// prefetch́ANextq܂ŃobNgbNIƂB 
			if ( goalidx == 0 ) {
				return false;
			} else {
				--goalidx;
			}
		} else if ( (forward = ec->call(&mtobjs, excp)) == true ) {
			if ( ec->delflg ) {	// This code helps performance up. 
				ec->f->del(ec);
				ecs[goalidx] = 0;
				lastpobjs = 0;
			}
			goalidx++;
			assert( !excp.iserr() );
		} else {
			if ( nobacktrack ) {
				return false;
			}
			ec->firstflg = false;
			if ( ec->pobjs == lastpobjs ) lastpobjs = 0;
			// O
			if ( excp.iserr() ) {
				// {\bhł͗Ȍ͍sȂB i^[Abacktracǩ̐eexecuteŏEj
				return false;
			} else {
				if ( goalidx == 0 ) {
					return false;
				} else {
					--goalidx;
				}
			}
		}
	}
	return false;
}


bool ExecContext_Pipe::backtrack(PException &excp)
{
	MyLog( cformat( "tid=%8x:backtrack:%p\n", GetCurrentThreadId(), this).c_str(), "pipe");

	// CXbh̏
	// pipe == turefirstĂяo܂ő҂ 
	MyLog( cformat( "tid=%8x:backtrack_wait:%p\n", GetCurrentThreadId(), this).c_str(), "pipe");
	if ( done ) {
		if ( this->excp.iserr() ) excp = this->excp;
		MyLog( cformat( "tid=%8x:backtrack_done_true:%p\n", GetCurrentThreadId(), this).c_str(), "pipe");
		return false;
	}

	fl = true;
	//while ( fr == false ) waitamoment;
	waitflg(fr);
	fr = false;

	if ( done == false ) {
		MyLog( cformat( "tid=%8x:backtrack_done_false:%p\n", GetCurrentThreadId(), this).c_str(), "pipe");
		return true;
	} else {
		if ( this->excp.iserr() ) excp = this->excp;
		MyLog( cformat( "tid=%8x:backtrack_done_true:%p\n", GetCurrentThreadId(), this).c_str(), "pipe");
		return false;
	}
}


inline void ExecContext::setppoutbuf()
{
	if ( p ) {
		p->ppoutbuf += ppoutbuf;
	} else {
		if ( !ppoutbuf.empty() ) {
			if ( print_header() ) {
				if ( dispwarn == true && (ppoutbuf[0] == ' ' || ppoutbuf[0] == '\r' || ppoutbuf[0] == '\n') ) {
					stringstream	str;
					goal->recompile(str);
					string msg = "W8002: output space before html/templete string ";
					msg += " At ";
					msg += str.str();
					msg += "\n";
					err(msg);
				}
			}
			fwrite( ppoutbuf.data(), 1, ppoutbuf.size(), stdout);	
			// 摜̏o͓A̓oCif[^o͂ꍇ  
 		}
	}
	ppoutbuf.clear();
}

bool ExecContext::execute(PException &excp, bool forward)
{
	while ( true ) {
		ExecContextRoot*  ec = 0;
		ExecContext_Factory*  f = 0;
		if ( !forward ) {	// obNgbN
			ec = ecs[goalidx];	// LbV͂
			g = getPredicate(goalidx); // Ăяȍq̃vtBbNX݂
			if ( ec == 0 || (g != 0 && g->opt.only_one_call == true) ) {
				if ( goalidx == 0 ) {
					if ( nextidx != -1 ) {
						goalidx = nextidx + 1;
						forward = true;
						if ( goalidx >= goal->size() ) {
							--goalidx;
							setppoutbuf();
							// goal->nobacktracktruêƂecs̑SẴIuWFNgdel邪XIuWFNgȂꍇ̃[vȂ̂del͕sv 
							return true;
						}
					} else {
						return false;
					}
				} else {
					--goalidx;
				}
				continue; // [v̐擪
			}
			f = ec->f;
			// backtrack
		} else {
			g = getPredicate(goalidx);
			if ( g == 0 ) return RERR_predicate_name(excp);	// catch߂ɍsȂ΂ȂȂH 
			f = g->factory;
			if ( f == 0 ) {
				bool cache = true;
				const string *name = g->getNamePtr()->getPredicateName(cache, hl);
				f = search_ExecContext_Factory(name, g->nspace);
				if ( cache ) g->factory = f; // Nameύ̎g->factoryɕۑłȂ
			}
			if ( (ec = ecs[goalidx]) == 0 ) {
				ec = f->create(this);
				ecs[goalidx] = ec;
			} else if ( f != ec->f ) {
				// TCNŎgq͕ʂ
				//delete ecs[goalidx];
				ec->f->del(ec);
				ec = f->create(this);
				ecs[goalidx] = ec;
			} else {
				ec->reinit(g, hl);	// TCN
			}
			// ꎞϐ̕ۑꏊ̌
			if ( ec->pobjs == 0 ) {
				if ( lastpobjs == 0 ) {
					for ( size_t i = goalidx - 1; i < goalidx; i-- ) {
						if ( ecs[i] && ecs[i]->pobjs ) {
							lastpobjs = ecs[i]->pobjs;
							break;
						}
					}
					if ( lastpobjs == 0 ) lastpobjs = &objs;
				}
				ec->pobjs = lastpobjs;
			} else {
				lastpobjs = ec->pobjs;
			}

			// first
		}
	
		if ( f == &newExecContext_Catch ) {
			--goalidx;
			setppoutbuf();
			return true;
		} else if ( (forward = ec->call(0, excp)) == true ) {
			ec->firstflg = false;
			if ( ec->delflg ) {	// This code helps performance up. 
				ec->f->del(ec);
				ecs[goalidx] = 0;
				lastpobjs = 0;
			}
			goalidx++;
			assert( !excp.iserr() );
		} else {
			if ( nobacktrack ) return false;
			ec->firstflg = false;
			size_t backidx = goalidx;
			if ( ec->pobjs == lastpobjs ) lastpobjs = 0;
			// O
			if ( excp.iserr() ) {
				const PPredicate*  catch_pred = newCatchCaller(excp);
				bool result = false;
				while ( goalidx < goal->size() && result == false ) {
					const PPredicate*  p = getPredicate(goalidx);
					if ( p && p->ncmp("catch") ) {
						VLocal	backup(*hl);
						result = p->unify( *catch_pred, this, hl, hl);
						if ( !result ) {
							*hl = backup;
						}
					}
					assert(goalidx < ecs.size() );
					ExecContextRoot	*e = ecs[goalidx];
					if ( e ) {
						e->f->del(e);
						ecs[goalidx] = 0;
					}
					++goalidx;
				}
				if ( result ) {
					excp.clear();
					forward = true;
				} else {
					return false;	// OĂяoɓ`d
				}
			} else {
				if ( goalidx == 0 ) {
					if ( nextidx != -1 ) {
						while ( goalidx < nextidx ) {
							ExecContextRoot	*e = ecs[goalidx];
							if ( e ) {
								e->f->del(e);
								ecs[goalidx] = 0;
							}
							++goalidx;
						}
						goalidx = nextidx + 1;
						forward = true;
					} else {
						return false;
					}
				} else {
					--goalidx;
				}
			}
		}
		if ( goalidx >= goal->size() ) {
			--goalidx;
			setppoutbuf();
			return true;
		}
	}
	return false;
}


bool ExecContext::first(PException &excp)
{
	if ( pred->horns != 0 ) {
		horns = pred->horns;
		skipnamechk = true;
	} else {
		bool		  cache = true;
		const string *name;
		if ( (name = getPredicateName(cache)) == 0 ) return RERR_nothing_match_predicate(excp);		
		horns = get_gc()->hbase.upHorns(*name);
		if ( cache ) {
			pred->horns = horns;
		}
		skipnamechk = true;
		if ( horns == 0 && !name->empty() ) {
			horns = get_gc()->hbase.upHorns(string(""));
			skipnamechk = false;
		}
		if ( !pred->nspace.empty() ) {
			skipnamechk = false;
		}
		if ( horns == 0 ) return RERR_nothing_match_predicate(excp);		
	}
	// z[߂̌ 
	while ( true ) {
		goal = 0;
		PHorn	&horn = horns->upHorn(hornidx);
		hl->assign( horn.getVcnt(), 0);
		substitutepair.clear();
		if ( horn.upHorn(*pred, *this, skipnamechk) ) {
			goal = &horn.getGoal();
			if ( goal->empty() ) {
				if ( goal->nobacktrack == true ) delflg = true;
				return true;
			}
			goalidx = 0;			// qꌟ֌W̕ϐ̏ 
			nextidx = (size_t)-1;	// qꌟ֌W̕ϐ̏ 
			ppoutbuf.clear();		// ʂɏKvȂ 
			size_t s = goal->size();
			for_each( ecs.begin(), ecs.end(), MyDeleteObject()); // cĂ̂
			ecs.assign(s,0);		// ̗\ 
			bool flg = execute(excp, true);
			if ( flg ) {
				// s̑
				for ( Array<SubstitutePair>::iterator i = substitutepair.begin(); i < substitutepair.end(); i++ ) {
					const PObject *g = (*gl)[(*i).idxg];
					if ( g ) {
						g->unify( *(*hl)[(*i).idxh], this, gl, hl);
						flg = g->unify( *(*hl)[(*i).idxh], this->p, gl, hl);
						if ( !flg ) break;
					} else {
						const PObject *n = (*hl)[(*i).idxh];
						if ( n ) { 
							(*gl)[(*i).idxg] = n->getval(this->p, hl);
						}
					}
				}
				if ( flg ) {
					if ( goal->nobacktrack == true ) {
						// ϐ̎󂯓nclone/deleteōsĂ邪AobjsԂ̈ړ͂̕悭ȂHîł̕Hj  
						// oOtBbNX 
						for ( size_t i = 0; i < pred->arglist.size(); i++ ) {
							const PVeriable *v = dynamic_cast<const PVeriable*>((*pred)[i]);
							if ( v ) {
								const PObject *p = (*gl)[v->idx];
								if ( p ) (*gl)[v->idx] = p->getval(this->p,gl)->clone(&this->p->objs);
							}
						}
						// oOtBbNX(Jōs 
						for (size_t i = 0; i < ecs.size(); i++ ) {
							ExecContextRoot *e = ecs[i];
							if ( e ) {
								e->f->del(e);
								ecs[i] = 0;
							}
						}

						delflg = true;
					}
					return true;
				}
			}
			if ( flg == false && excp.iserr() ) { break; } // O̓`d 
			if ( flg == false && nobacktrack ) { break; } // cut
			if ( ++hornidx >= horns->size() ) {
				PHorns	*p = get_gc()->hbase.upHorns(string(""));
				if ( p == 0 || p == horns ) break;
				horns = p;
				skipnamechk = false;
				hornidx = 0;
			}
			(*gl) = backup;	// ۑĂϐ̕ 
		} else {
			if ( ++hornidx >= horns->size() ) {
				PHorns	*p = get_gc()->hbase.upHorns(string(""));
				if ( p == 0 || p == horns ) break;
				horns = p;
				skipnamechk = false;
				hornidx = 0;
			}
			(*gl) = backup;	// ۑĂϐ̕ 
		}
	}
	return false;
}

bool ExecContext::backtrack(PException &excp)
{
	bool flg = false;

	if ( horns == 0 ) return false;
	if ( goal != 0 && goal->nobacktrack ) return false;
	
	// ʃz[߂̕] 
	while ( true ) {
		// ]̃S[΂ĕ] 
		if ( goal != 0 && !goal->empty() ) {
			flg = execute(excp, flg);
		}
		// S[̕]ΑsiIjB 
		if ( flg  ) {
			// s̑
			for ( Array<SubstitutePair>::iterator i = substitutepair.begin(); i < substitutepair.end(); i++ ) {
				const PObject *g = (*gl)[(*i).idxg];
				if ( g ) {
					g->unify( *(*hl)[(*i).idxh], this, gl, hl);
					flg = g->unify( *(*hl)[(*i).idxh], this, gl, hl);
					if ( !flg ) break;
				} else {
					const PObject *n = (*hl)[(*i).idxh];
					if ( n ) { 
						(*gl)[(*i).idxg] = n->getval(this, hl);
					}
				}
			}
			if ( flg ) {
				if ( goal->nobacktrack == true ) {
					// ϐ̎󂯓nclone/deleteōsĂ邪AobjsԂ̈ړ͂̕悭ȂHîł̕Hj 
					// oOtBbNX
					for ( size_t i = 0; i < pred->arglist.size(); i++ ) {
						const PVeriable *v = dynamic_cast<const PVeriable*>((*pred)[i]);
						if ( v ) {
							const PObject *p = (*gl)[v->idx];
							if ( p ) (*gl)[v->idx] = p->getval(this->p,gl)->clone(&this->p->objs);
						}
					}
					// oOtBbNX(Jōs
					for (size_t i = 0; i < ecs.size(); i++ ) {
						ExecContextRoot *e = ecs[i];
						if ( e ) {
							e->f->del(e);
							ecs[i] = 0;
						}
					}
					delflg = true;
				}
				return true;
			}
		}
		if ( flg == false && excp.iserr() ) { break; } // O̓`d
		if ( flg == false && nobacktrack ) { break; } // cut
		if ( ++hornidx >= horns->size() ) {
			PHorns	*p = get_gc()->hbase.upHorns(string(""));
			if ( p == 0 || p == horns ) break;
			horns = p;
			skipnamechk = false;
			hornidx = 0;
		}
		// ʂ̃z[߂̌
		goal = 0;
		PHorn	&horn = horns->upHorn(hornidx);
		hl->assign( horn.getVcnt(), 0);
		(*gl) = backup;	// ۑĂϐ̕
		substitutepair.clear();
		if ( horn.upHorn(*pred, *this, skipnamechk) ) {
			goal = &horn.getGoal();
			if ( goal->empty() ) {
				if ( goal->nobacktrack == true ) delflg = true;
				return true;
			}
			goalidx = 0;			// qꌟ֌W̕ϐ̏
			nextidx = (size_t)-1;	// qꌟ֌W̕ϐ̏
			ppoutbuf.clear();		// ʂɏKvȂ
			size_t s = goal->size();
			for_each( ecs.begin(), ecs.end(), MyDeleteObject()); // cĂ̂
			ecs.assign(s, 0);		// ̗\
			flg = true;
			pobjs = &objs;
		}
	}

	return false;
}


bool GlobalContext::compile( const string &fname, bool awpflg, bool existchk) {
	CompileContext	c(fname.c_str(), existchk, awpflg);
	return compile_body( c);
	
}

bool GlobalContext::compile( const char *src, bool awpflg) {
	CompileContext	c(src, awpflg);
	return compile_body( c);
}

bool GlobalContext::compile_body( CompileContext &c)
{
	GlobalContext *bc = get_gc();
	set_gc(this);
	
	while ( !c.eof() ) {
		bool cflg = false;
		// include 
		c.skip();
		if ( *c == '@' ) {
			c.next();
			string filename;
			while ( !c.eof() && *c != '@' ) {
				filename.push_back(*c);
				c.next_noskip();
			}
			if ( *c == '@' ) {
				bool awp = isawp( filename.c_str() );
				c.next();
				c.include_file( filename.c_str(), true, first_src_base_path.c_str(), awp);
				continue;
			}
		}
		if ( hbase.isMyObject(*c) ) {
			hbase.compile(c);
			cflg = true;
			c.skip();
		}
		PGoal	goal;
		if ( goal.isMyObject(*c) || isalpha(*c) != 0 || *c == '_' || *c == '!' || *c == '=' || *c == '$'  || *c == '%' ) {
			c.vary.clear();
			goal.compile(c);
			if ( !goal.body.empty() ) {
				topgoals.addGoal(goal, c.vary);
			}
			cflg = true;
		}
		if ( cflg == false ) {
			c.err( cformat( "C0026: invalid charactor '%c' ", *c));
			c.next();
		}
	}

	for ( vector<string>::iterator i = c.ewmsg.begin(); i < c.ewmsg.end(); i++ ) {
		err(*i);
		err("\n");
	}
	if ( !c.result ) {
		compile_err = true;
	}
	set_gc(bc);
	return c.result;
}


void GlobalContext::recompile()
{
	if ( compiletrace ) {
		hbase.recompile(cerr);
		topgoals.recompile(cerr);
		cerr << endl;
	}
}


bool GlobalContext::prolog() {
	if ( compile_err ) return false;
	if ( syntaxcheck ) return true;

	bool ret = false;
	set_gc(this);
	PException excp;
	for ( goalidx = 0; goalidx < topgoals.size(); goalidx++ ) {
		PGoal &g = topgoals.upHorn(goalidx).getGoal();
		ExecContext	ec( g, topgoals.upHorn(goalidx).getVcnt());
		try {
			excp.clear();
			ret = ec.execute(excp, true);
		} catch ( exception e ) {
			cerr << e.what() << endl;
		}
		if ( !ret ) {
			if ( !excp.message.empty() ) {
				string msg = excp.exception_class + ":" + excp.message + " At " + excp.where + excp.in + "\n";
				err(msg);
			} else if ( dispwarn ) {
				stringstream	str;
				g.recompile(str);
				string msg = "W8001: return false ";
				msg += " At ";
				msg += str.str();
				msg += "\n";
				err(msg);
			}
		}
		ec.cleanup();
	}
	return ret;
}
