/*
 *  ADP (Another Data Processor) www.adp.la
 *  Copyright (C) 2010 Katsuhisa Ohfuji <katsuhisa@ohfuji.name>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 *  MA 02110-1301, USA.
 */

#ifndef __KZ_SCANREGEX__
#define __KZ_SCANREGEX__
#include <boost/regex.hpp>
#include <string>

using namespace std;

class kz_scanregex_what {
	boost::smatch	what;
	size_t			count;

public:
	kz_scanregex_what( const kz_scanregex_what &src ) : what(src.what), count(src.count) {
	}
	kz_scanregex_what(boost::smatch &what_) : what(what_), count(0) {
	}

	kz_scanregex_what& operator >> ( string &param) {
		count++;
		if ( count < what.size() ) { 
			param.assign( what[count].first, what[count].second);
		}
		return *this;
	}
};


class kz_scanregex {
	boost::regex r;

public:
	kz_scanregex(const char *r_) : r(r_) {}
	kz_scanregex(const kz_scanregex &src ) : r(src.r) {}

	kz_scanregex_what operator >> ( const string &text) {
		boost::smatch	what;
		boost::regex_search(text, what, r);
		return kz_scanregex_what(what);
	}
};

#endif
