/*
 * Decompiled with CFR 0.152.
 */
package com.qbrowser.property;

import com.jidesoft.swing.FolderChooser;
import com.qbrowser.QBrowserV2;
import com.qbrowser.container.MessageContainer;
import com.qbrowser.icons.QBrowserIconsFactory;
import com.qbrowser.property.Property;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.StreamMessage;
import javax.jms.Topic;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamMessageBytesForDownloadPropertyTable
extends DefaultTableModel {
    static ResourceBundle resources = QBrowserV2.resources;
    JDialog downloadDialog = null;
    JPanel downloadmsgPanel = null;
    JPanel temppanel = null;
    JTextField download_file_path = null;
    static FolderChooser _folderChooser;
    static List<String> _recentList;
    static File _currentFolder;
    String download_target_key = null;
    StreamMessage download_target_message = null;
    JDialog msgDialog = null;
    JButton msgconfirmbutton = null;
    JPanel oya = null;
    private Message innermessage = null;
    final String[] columnNames = new String[]{resources.getString("qkey.proptable.header.smkey"), resources.getString("qkey.proptable.header.prop_type"), resources.getString("qkey.proptable.header.download")};
    LinkedList list = null;
    ArrayList type_selection = null;

    public void setOya(JPanel value) {
        this.oya = value;
    }

    public StreamMessageBytesForDownloadPropertyTable() {
        this.init();
        this.add_one_row(new Property());
    }

    public StreamMessageBytesForDownloadPropertyTable(int number_of_initial_rows) {
        this.init();
        for (int i = 0; i < number_of_initial_rows; ++i) {
            this.add_one_row(new Property());
        }
    }

    @Override
    public int getRowCount() {
        if (this.list == null) {
            return 0;
        }
        return this.list.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    @Override
    public Class<?> getColumnClass(int column) {
        switch (column) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return Object.class;
            }
        }
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return true;
    }

    public Class<?> getCellClassAt(int row, int column) {
        return this.getColumnClass(column);
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        if (this.list == null) {
            return;
        }
        if (this.list.size() < row) {
            return;
        }
        Property p = (Property)this.list.get(row);
        if (p == null) {
            return;
        }
        try {
            switch (column) {
                case 0: {
                    if (value instanceof String) {
                        p.setKey((String)value);
                    }
                    return;
                }
                case 1: {
                    if (value instanceof String) {
                        p.setProperty_type((String)value);
                    }
                    return;
                }
                case 2: {
                    p.setProperty_value(value);
                    return;
                }
            }
            return;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            return;
        }
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (this.list == null) {
            return null;
        }
        Property p = (Property)this.list.get(row);
        if (p == null) {
            return "";
        }
        try {
            switch (column) {
                case 0: {
                    return p.getKey();
                }
                case 1: {
                    return p.getProperty_type();
                }
                case 2: {
                    return p.getProperty_value();
                }
            }
            return "Bad column value: " + column;
        }
        catch (Exception e) {
            return "Error: " + e;
        }
    }

    public int load(MessageContainer mc) {
        if (mc == null) {
            return 0;
        }
        Message msgvalue = mc.getMessage();
        if (msgvalue == null) {
            return 0;
        }
        StreamMessage msg = null;
        if (!(msgvalue instanceof StreamMessage)) {
            return 0;
        }
        msg = (StreamMessage)msgvalue;
        this.list = new LinkedList();
        try {
            msg.reset();
            Object obj = null;
            int rowcount = 0;
            while ((obj = msg.readObject()) != null) {
                String name = String.valueOf(++rowcount);
                if (!(obj instanceof byte[])) continue;
                Property ap = new Property();
                ap.setKey(name);
                ap.setProperty_type("Bytes");
                JButton db = new JButton("download");
                db.addActionListener(new DownloadButtonListener(name, msg));
                ap.setProperty_value(db);
                this.list.add(ap);
            }
        }
        catch (JMSException ex) {
        }
        catch (Throwable thex) {
            // empty catch block
        }
        this.innermessage = msg;
        return this.list.size();
    }

    public int load(Enumeration e) {
        if (e == null) {
            return 0;
        }
        this.list = new LinkedList();
        while (e.hasMoreElements()) {
            this.list.add(e.nextElement());
        }
        this.fireTableDataChanged();
        return this.list.size();
    }

    void init() {
        this.list = new LinkedList();
    }

    public void add_one_row(Property value) {
        this.list.add(value);
        this.fireTableDataChanged();
    }

    public void add_one_empty_row() {
        this.list.add(new Property());
        this.fireTableDataChanged();
    }

    public void deletePropertyAtRow(int row) {
        if (this.list == null) {
            return;
        }
        this.list.remove(row);
        this.fireTableDataChanged();
    }

    public Property getPropertyAtRow(int row) {
        if (this.list == null) {
            return null;
        }
        return (Property)this.list.get(row);
    }

    public void showDownloadWindow() {
        if (this.downloadDialog == null) {
            this.downloadDialog = new JDialog();
            this.downloadDialog.setIconImage(QBrowserIconsFactory.getImageIcon("icons/download16.png").getImage());
            this.downloadDialog.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                }
            });
            this.downloadDialog.getContentPane().setLayout(new BorderLayout());
            this.downloadmsgPanel = new JPanel();
            this.downloadmsgPanel.setLayout(new BorderLayout());
            JPanel downloadmsg = new JPanel();
            this.downloadDialog.setSize(200, 300);
            this.downloadDialog.setTitle(resources.getString("qkey.msg.msg191"));
            this.download_file_path = new JTextField(30);
            _folderChooser = new FolderChooser();
            _folderChooser.setAvailableButtons(_folderChooser.getAvailableButtons() & 0xFFFFFFFE);
            _folderChooser.setNavigationFieldVisible(true);
            JButton file_choose_button = (JButton)this.createBrowseButton();
            JLabel downloadlabel = new JLabel(resources.getString("qkey.msg.msg192"));
            JPanel expl = new JPanel();
            expl.setLayout(new BorderLayout());
            JPanel tqboxpanel = new JPanel();
            tqboxpanel.setLayout(new BorderLayout());
            expl.add("North", tqboxpanel);
            expl.add("Center", downloadlabel);
            downloadmsg.add(this.download_file_path);
            downloadmsg.add(file_choose_button);
            this.downloadmsgPanel.add("North", expl);
            this.downloadmsgPanel.add("Center", downloadmsg);
            JButton okbutton1 = new JButton("\u3000\u3000\u3000\u3000\u3000\u3000\u3000OK\u3000\u3000\u3000\u3000\u3000\u3000\u3000");
            okbutton1.addActionListener(new DownloadOKListener());
            JButton cancelbutton = new JButton("         " + resources.getString("qkey.msg.msg129") + "             ");
            cancelbutton.addActionListener(new DownloadCancelListener());
            JPanel pbuttonpanel = new JPanel();
            pbuttonpanel.setLayout(new BorderLayout());
            pbuttonpanel.add("West", okbutton1);
            pbuttonpanel.add("Center", cancelbutton);
            this.temppanel = new JPanel();
            this.temppanel.setLayout(new BorderLayout());
            this.temppanel.add("South", pbuttonpanel);
            this.downloadmsgPanel.add("South", this.temppanel);
            this.downloadDialog.getContentPane().add("North", this.downloadmsgPanel);
            this.downloadDialog.pack();
        }
        this.downloadDialog.setLocationRelativeTo(this.oya);
        this.downloadDialog.setVisible(true);
    }

    private AbstractButton createBrowseButton() {
        final JButton button = new JButton("...");
        button.setMnemonic('B');
        button.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (StreamMessageBytesForDownloadPropertyTable.this.download_file_path.getText().length() > 0) {
                    _currentFolder = _folderChooser.getFileSystemView().createFileObject(StreamMessageBytesForDownloadPropertyTable.this.download_file_path.getText());
                }
                _folderChooser.setCurrentDirectory(_currentFolder);
                _folderChooser.setRecentList(_recentList);
                _folderChooser.setFileHidingEnabled(true);
                int result = _folderChooser.showOpenDialog((Component)button.getTopLevelAncestor());
                if (result == 0) {
                    _currentFolder = _folderChooser.getSelectedFile();
                    if (_recentList.contains(_currentFolder.toString())) {
                        _recentList.remove(_currentFolder.toString());
                    }
                    _recentList.add(0, _currentFolder.toString());
                    File selectedFile = _folderChooser.getSelectedFile();
                    if (selectedFile != null) {
                        StreamMessageBytesForDownloadPropertyTable.this.download_file_path.setText(selectedFile.toString());
                    } else {
                        StreamMessageBytesForDownloadPropertyTable.this.download_file_path.setText("");
                    }
                }
            }
        });
        button.setRequestFocusEnabled(false);
        button.setFocusable(false);
        return button;
    }

    public JDialog popupMessageDialog(String title, TextArea ta, ImageIcon icon) {
        if (this.msgDialog != null && this.msgDialog.isShowing()) {
            this.msgDialog.dispose();
        }
        this.msgDialog = new JDialog();
        this.msgDialog.setIconImage(icon.getImage());
        this.msgDialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
            }
        });
        this.msgDialog.setTitle(title);
        this.msgDialog.setLocation(250, 150);
        JPanel mainmsg = new JPanel();
        mainmsg.add(ta);
        this.msgDialog.getContentPane().setLayout(new BorderLayout());
        this.msgconfirmbutton = new JButton("OK");
        this.msgconfirmbutton.addActionListener(new MsgConfirmedListener());
        this.msgDialog.getContentPane().add("North", mainmsg);
        this.msgDialog.getContentPane().add("South", this.msgconfirmbutton);
        this.msgDialog.pack();
        this.msgDialog.setLocationRelativeTo(this.oya);
        this.msgDialog.setVisible(true);
        return this.msgDialog;
    }

    static {
        _recentList = new ArrayList<String>();
        _currentFolder = null;
    }

    class MsgConfirmedListener
    implements ActionListener {
        MsgConfirmedListener() {
        }

        public void actionPerformed(ActionEvent e) {
            StreamMessageBytesForDownloadPropertyTable.this.msgDialog.setVisible(false);
        }
    }

    class DownloadOKListener
    implements ActionListener {
        DownloadOKListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            block30: {
                ByteArrayInputStream bis = null;
                FileOutputStream fo = null;
                File inputf = new File(StreamMessageBytesForDownloadPropertyTable.this.download_file_path.getText());
                try {
                    JLabel errlabel = new JLabel(resources.getString("qkey.msg.msg193"));
                    if (!inputf.exists()) {
                        errlabel.setForeground(Color.RED);
                        StreamMessageBytesForDownloadPropertyTable.this.temppanel.add("Center", errlabel);
                        StreamMessageBytesForDownloadPropertyTable.this.downloadmsgPanel.updateUI();
                        StreamMessageBytesForDownloadPropertyTable.this.downloadDialog.pack();
                        break block30;
                    }
                    StreamMessageBytesForDownloadPropertyTable.this.temppanel.add("Center", new JLabel(""));
                    StreamMessageBytesForDownloadPropertyTable.this.temppanel.updateUI();
                    StreamMessageBytesForDownloadPropertyTable.this.downloadmsgPanel.updateUI();
                    StreamMessageBytesForDownloadPropertyTable.this.downloadDialog.pack();
                    StreamMessageBytesForDownloadPropertyTable.this.downloadDialog.setVisible(false);
                    long timestamp = StreamMessageBytesForDownloadPropertyTable.this.download_target_message.getJMSTimestamp();
                    Destination dest = StreamMessageBytesForDownloadPropertyTable.this.download_target_message.getJMSDestination();
                    byte[] targetbin = null;
                    try {
                        StreamMessageBytesForDownloadPropertyTable.this.download_target_message.reset();
                        Object obj = null;
                        int rowcount = 0;
                        while ((obj = StreamMessageBytesForDownloadPropertyTable.this.download_target_message.readObject()) != null) {
                            String name;
                            if (!StreamMessageBytesForDownloadPropertyTable.this.download_target_key.equals(name = String.valueOf(++rowcount)) || !(obj instanceof byte[])) continue;
                            targetbin = (byte[])obj;
                        }
                    }
                    catch (JMSException ex) {
                    }
                    catch (Throwable thex) {
                        // empty catch block
                    }
                    String destname = "";
                    String desttype = "QUEUE";
                    if (dest != null) {
                        if (dest instanceof Queue) {
                            destname = ((Queue)dest).getQueueName();
                        } else if (dest instanceof Topic) {
                            destname = ((Topic)dest).getTopicName();
                            desttype = "TOPIC";
                        }
                    }
                    String target_file_name = timestamp + "_" + desttype + "_" + destname + "_" + StreamMessageBytesForDownloadPropertyTable.this.download_target_key + "_" + System.currentTimeMillis() + ".bin";
                    File efile = new File(inputf.getAbsolutePath() + File.separator + target_file_name);
                    byte[] bibi = new byte[1024];
                    bis = new ByteArrayInputStream(targetbin);
                    fo = new FileOutputStream(efile);
                    int len = 0;
                    long readfilesize = 0L;
                    int count = 100;
                    TextArea ta = new TextArea("", 6, 60, 1);
                    ta.setEditable(false);
                    ta.setBackground(Color.WHITE);
                    StreamMessageBytesForDownloadPropertyTable.this.popupMessageDialog(resources.getString("qkey.msg.msg194"), ta, QBrowserIconsFactory.getImageIcon("icons/download16.png"));
                    while ((len = bis.read(bibi, 0, bibi.length)) != -1) {
                        fo.write(bibi, 0, len);
                        readfilesize += (long)len;
                        if (++count <= 100) continue;
                        ta.append(readfilesize + " " + resources.getString("qkey.msg.msg098") + targetbin.length + " " + resources.getString("qkey.msg.msg099") + "\n");
                        ta.setCaretPosition(ta.getText().length());
                        count = 0;
                    }
                    if (count != 0) {
                        ta.append(readfilesize + " " + resources.getString("qkey.msg.msg098") + targetbin.length + " " + resources.getString("qkey.msg.msg099") + "\n");
                        ta.setCaretPosition(ta.getText().length());
                    }
                    ta.append(resources.getString("qkey.msg.msg195"));
                    ta.append(resources.getString("qkey.msg.msg196"));
                    ta.append(efile.getAbsolutePath());
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
                finally {
                    if (fo != null) {
                        try {
                            fo.close();
                        }
                        catch (IOException ioe) {}
                        fo = null;
                    }
                    if (bis != null) {
                        try {
                            bis.close();
                        }
                        catch (IOException ioe) {}
                        bis = null;
                    }
                }
            }
        }
    }

    class DownloadCancelListener
    implements ActionListener {
        DownloadCancelListener() {
        }

        public void actionPerformed(ActionEvent e) {
            StreamMessageBytesForDownloadPropertyTable.this.downloadDialog.setVisible(false);
        }
    }

    class DownloadButtonListener
    implements ActionListener {
        public DownloadButtonListener(String key, StreamMessage msg) {
            StreamMessageBytesForDownloadPropertyTable.this.download_target_key = key;
            StreamMessageBytesForDownloadPropertyTable.this.download_target_message = msg;
        }

        public void actionPerformed(ActionEvent e) {
            StreamMessageBytesForDownloadPropertyTable.this.showDownloadWindow();
        }
    }
}

