/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.spinner;

import com.jidesoft.spinner.SpinnerWheelSupport;
import java.text.DateFormat;
import java.text.Format;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.InternationalFormatter;

public class DateSpinner
extends JSpinner {
    public DefaultFormatter _formatter;
    public JSpinner.DateEditor _timeEditor;
    public DateFormat _format;

    public DateSpinner() {
        this("hh:mm:ss");
    }

    public DateSpinner(String string) {
        this(string, new Date());
    }

    public DateSpinner(String string, Date date) {
        super(new SpinnerDateModel(date, null, null, 5));
        this.setFormat(string);
        this.customizeSpinner();
    }

    private void customizeDateEditor() {
        Format format;
        JFormattedTextField.AbstractFormatter abstractFormatter = this._timeEditor.getTextField().getFormatter();
        if (!(abstractFormatter instanceof DefaultFormatter)) {
            throw new IllegalStateException("The formatter is not an instance of DefaultFormatter.");
        }
        this._formatter = (DefaultFormatter)abstractFormatter;
        if (abstractFormatter instanceof InternationalFormatter && (format = ((InternationalFormatter)abstractFormatter).getFormat()) instanceof DateFormat) {
            this._format = (DateFormat)format;
        }
        if (this._format == null) {
            throw new IllegalStateException("The format is not an instance of SimpleDateFormat.");
        }
    }

    public void setFormat(String string) {
        this._timeEditor = this.createDateEditor(string);
        this.customizeDateEditor();
        this.setEditor(this._timeEditor);
    }

    protected void customizeSpinner() {
        this.setLenient(false);
        this.setCommitsOnValidEdit(true);
        this.setAllowsInvalid(false);
        this.setOverwriteMode(true);
        SpinnerWheelSupport.installMouseWheelSupport(this);
    }

    protected JSpinner.DateEditor createDateEditor(String string) {
        return new JSpinner.DateEditor((JSpinner)this, string);
    }

    public void setCommitsOnValidEdit(boolean bl) {
        this._formatter.setCommitsOnValidEdit(bl);
    }

    public boolean getCommitsOnValidEdit() {
        return this._formatter.getCommitsOnValidEdit();
    }

    public void setOverwriteMode(boolean bl) {
        this._formatter.setOverwriteMode(bl);
    }

    public boolean getOverwriteMode() {
        return this._formatter.getOverwriteMode();
    }

    public void setAllowsInvalid(boolean bl) {
        this._formatter.setAllowsInvalid(bl);
    }

    public boolean getAllowsInvalid() {
        return this._formatter.getAllowsInvalid();
    }

    public void setTimeZone(TimeZone timeZone) {
        this._format.setTimeZone(timeZone);
    }

    public TimeZone getTimeZone() {
        return this._format.getTimeZone();
    }

    public void setLenient(boolean bl) {
        this._format.setLenient(bl);
    }

    public boolean isLenient() {
        return this._format.isLenient();
    }
}

