/*
 * Decompiled with CFR 0.152.
 */
package com.qbrowser.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class QBrowserUtil {
    public static final String PASSFILE_NAME = "passfile.txt";
    public static String[] pad = new String[]{"", "0", "00", "000", "0000"};
    static JDialog errDialog = null;
    static JPanel panel_parent;

    public static void setPanel_Parent(JPanel value) {
        panel_parent = value;
    }

    public static File checkIfPassFileExists() {
        File the_pass_file = new File(QBrowserUtil.getTargetPassfilePath());
        if (the_pass_file.exists()) {
            return the_pass_file;
        }
        return null;
    }

    public static void cleanupPassFile() {
        File the_pass_file = null;
        the_pass_file = QBrowserUtil.checkIfPassFileExists();
        if (the_pass_file != null) {
            try {
                the_pass_file.delete();
            }
            catch (Throwable thex) {
                System.err.println(thex.getMessage());
            }
        }
    }

    public static int getVersionAsInt() {
        String versionString = System.getProperty("java.version");
        int firstDot = versionString.indexOf(".");
        String tensString = versionString.substring(0, firstDot);
        int nextDot = versionString.indexOf(".", firstDot + 1);
        if (nextDot < 0) {
            nextDot = versionString.length();
        }
        String onesString = versionString.substring(firstDot + 1, nextDot);
        int version2 = -1;
        try {
            int tens = new Integer(tensString);
            int ones = new Integer(onesString);
            version2 = tens * 10 + ones;
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        return version2;
    }

    public static void createPassfile(String password) {
        try {
            File targetps = new File(QBrowserUtil.getQBrowserTempFileDir());
            targetps.mkdirs();
            File targetpassfile = new File(QBrowserUtil.getTargetPassfilePath());
            targetpassfile.createNewFile();
            PrintWriter pwr = new PrintWriter(new FileWriter(targetpassfile));
            pwr.println("imq.imqcmd.password=" + password);
            pwr.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getQBrowserTempFileDir() {
        return QBrowserUtil.getUserHome() + File.separator + ".qbrowserv2" + File.separator;
    }

    public static String getTargetPassfilePath() {
        return QBrowserUtil.getQBrowserTempFileDir() + PASSFILE_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File from, File to) throws IOException {
        FilterOutputStream out = null;
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(from));
            out = new BufferedOutputStream(new FileOutputStream(to));
            byte[] buff = new byte[4096];
            int len = 0;
            while ((len = in.read(buff, 0, buff.length)) >= 0) {
                ((BufferedOutputStream)out).write(buff, 0, len);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static String getUserHome() {
        return System.getProperty("user.home");
    }

    public static void ArrayListToJComboBox(ArrayList inputarray, JComboBox targetcombobox) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)targetcombobox.getModel();
        for (int i = 0; i < inputarray.size(); ++i) {
            String key = (String)inputarray.get(i);
            if (!QBrowserUtil.checkDups(key, targetcombobox)) continue;
            model.insertElementAt(key, 0);
        }
        if (targetcombobox.getItemCount() > 0) {
            targetcombobox.setSelectedIndex(0);
        }
    }

    public static ArrayList jcomboBoxToArrayList(JComboBox inputbox) {
        ArrayList<String> targetArray = new ArrayList<String>();
        try {
            for (int i = 0; i < inputbox.getItemCount(); ++i) {
                String key = (String)inputbox.getItemAt(i);
                targetArray.add(key);
            }
        }
        catch (Throwable thex) {
            System.err.println(thex.getMessage());
        }
        return targetArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveHistoryToFile(String history_name, ArrayList target_history) {
        String targetFilePath = QBrowserUtil.getQBrowserTempFileDir() + history_name;
        File targethisfile = new File(targetFilePath);
        PrintWriter pwr = null;
        try {
            if (!targethisfile.exists()) {
                targethisfile.createNewFile();
            }
            pwr = new PrintWriter(new FileWriter(targethisfile));
            for (int i = target_history.size() - 1; i > -1; --i) {
                String history_entry = (String)target_history.get(i);
                pwr.println(history_entry);
            }
            pwr.close();
        }
        catch (Exception ioe) {
            System.err.println(ioe.getMessage());
        }
        finally {
            if (pwr != null) {
                try {
                    pwr.close();
                }
                catch (Exception pwre) {}
                pwr = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getHistoryFromFile(String history_name) {
        String targetFilePath = QBrowserUtil.getQBrowserTempFileDir() + history_name;
        File ifile = new File(targetFilePath);
        ArrayList<String> retVal = new ArrayList<String>();
        BufferedReader br = null;
        try {
            if (ifile.exists()) {
                br = new BufferedReader(new FileReader(ifile));
                String line = null;
                while ((line = br.readLine()) != null) {
                    retVal.add(line);
                }
            }
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                    br = null;
                }
                catch (Exception fie) {}
            }
        }
        return retVal;
    }

    public static boolean checkDups(String hikaku, JComboBox targetcombobox) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)targetcombobox.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            String key = (String)model.getElementAt(i);
            if (!key.trim().equals(hikaku.trim())) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] extractBytes(String filepath) {
        File ftest = new File(filepath);
        if (!ftest.exists()) {
            return null;
        }
        byte[] retv = new byte[]{};
        FileInputStream fi = null;
        ByteArrayOutputStream baos = null;
        try {
            fi = new FileInputStream(filepath);
            baos = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            int len = 0;
            int filesizecount = 0;
            while ((len = fi.read(buf)) != -1) {
                filesizecount += buf.length;
                baos.write(buf, 0, len);
            }
            retv = baos.toByteArray();
            fi.close();
            baos.close();
        }
        catch (Throwable ie) {
            QBrowserUtil.popupErrorMessageDialog(ie, panel_parent);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (fi != null) {
                try {
                    fi.close();
                }
                catch (IOException iie) {}
                fi = null;
            }
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException iie) {}
                baos = null;
            }
        }
        return retv;
    }

    static String displayFloatValueKirisute(float value, int maxsyousutenketa) {
        StringBuilder result = new StringBuilder();
        Float ft = new Float(value);
        char[] chars = ft.toString().toCharArray();
        int kcount = 0;
        boolean is_syosu = false;
        for (int i = 0; chars.length > i; ++i) {
            if (chars[i] == '.') {
                is_syosu = true;
            } else if (is_syosu) {
                ++kcount;
            }
            result.append(chars[i]);
            if (kcount != maxsyousutenketa) continue;
            return result.toString();
        }
        return result.toString();
    }

    public static String bytesLengthAsString(byte[] bytes) {
        String result = "N/A";
        boolean kbflag = false;
        try {
            float lengthr = bytes.length;
            if (lengthr > 1023.0f) {
                lengthr /= 1024.0f;
                kbflag = true;
            }
            if (lengthr != -1.0f) {
                result = QBrowserUtil.displayFloatValueKirisute(lengthr, 2);
            }
            if (result.endsWith(".0")) {
                result = result.substring(0, result.length() - 2);
            }
            result = kbflag ? result + " KB" : result + " byte";
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static void addLabelAndValueComponent(GridBagConstraints valueConstraints, JPanel targetPanel, GridBagLayout valueGbag, String labelStr, Component value, int yAxis) {
        JLabel label = new JLabel(labelStr, 2);
        valueConstraints.gridx = 0;
        valueConstraints.gridy = yAxis;
        valueConstraints.weightx = 1.0;
        valueConstraints.weighty = 1.0;
        valueConstraints.anchor = 13;
        valueGbag.setConstraints(label, valueConstraints);
        targetPanel.add(label);
        valueConstraints.gridx = 1;
        valueConstraints.gridy = yAxis;
        valueConstraints.weightx = 1.0;
        valueConstraints.weighty = 1.0;
        valueConstraints.anchor = 17;
        valueGbag.setConstraints(value, valueConstraints);
        targetPanel.add(value);
    }

    public static ArrayList errorParse(String orig, String delim) {
        if (orig == null) {
            return null;
        }
        ArrayList<String> ar = new ArrayList<String>();
        try {
            int icur = -1;
            String cur = orig;
            while ((icur = cur.indexOf(delim)) != -1) {
                String token = cur.substring(0, icur);
                ar.add(token);
                cur = cur.substring(icur + delim.length());
            }
            ar.add(cur);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ar;
    }

    public static void addBlankRow(GridBagConstraints valueConstraints, JPanel targetPanel, GridBagLayout valueGbag, int yAxis) {
        JLabel label = new JLabel(" ", 2);
        valueConstraints.gridx = 0;
        valueConstraints.gridy = yAxis;
        valueConstraints.weightx = 1.0;
        valueConstraints.weighty = 1.0;
        valueConstraints.anchor = 13;
        valueGbag.setConstraints(label, valueConstraints);
        targetPanel.add(label);
    }

    public static String toHexDump(byte[] buf, int length) {
        if (buf.length % 2 != 0) {
            byte[] newarray = new byte[buf.length + 1];
            System.arraycopy(buf, 0, newarray, 0, buf.length);
            buf = newarray;
        }
        StringBuffer sb = new StringBuffer(buf.length * 2);
        int n = 0;
        while (n < buf.length && n < length) {
            int value = buf[n + 1] & 0xFF;
            String s = Integer.toHexString(value |= buf[n] << 8 & 0xFF00);
            sb.append(pad[4 - s.length()]);
            sb.append(s);
            if ((n += 2) % 16 == 0) {
                sb.append("\n");
                continue;
            }
            sb.append(" ");
        }
        return sb.toString();
    }

    static String pad(String s, int width) {
        StringBuffer sb = new StringBuffer();
        int padding = width - s.length();
        if (padding <= 0) {
            return s;
        }
        while (padding > 0) {
            sb.append(" ");
            --padding;
        }
        sb.append(s);
        return sb.toString();
    }

    public static void popupErrorMessageDialog(Throwable e, JPanel parent) {
        if (errDialog != null && errDialog.isShowing()) {
            errDialog.dispose();
        }
        errDialog = new JDialog();
        errDialog.setLocation(120, 120);
        TextArea ta = new TextArea("", 10, 50, 3);
        ta.setEditable(true);
        ta.append(e.getMessage());
        ta.append("\n");
        ta.append(e.toString());
        JPanel mainmsg = new JPanel();
        mainmsg.add(ta);
        errDialog.getContentPane().setLayout(new BorderLayout());
        JButton confirmbutton = new JButton("OK");
        confirmbutton.addActionListener(new ErrorConfirmedListener());
        JPanel buttonpanel = new JPanel();
        buttonpanel.setLayout(new BorderLayout());
        buttonpanel.add("East", confirmbutton);
        errDialog.getContentPane().add("South", buttonpanel);
        errDialog.getContentPane().add("North", mainmsg);
        errDialog.pack();
        errDialog.setLocationRelativeTo(parent);
        errDialog.setVisible(true);
    }

    static class ErrorConfirmedListener
    implements ActionListener {
        ErrorConfirmedListener() {
        }

        public void actionPerformed(ActionEvent e) {
            errDialog.setVisible(false);
        }
    }
}

