/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3board;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import jp.sourceforge.acerola3d.a3board.A3Board;

public class A3TransferHandler
extends TransferHandler {
    private static final long serialVersionUID = 1L;
    private A3Board board;

    public A3TransferHandler(A3Board board) {
        this.board = board;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        if (!support.isDrop()) {
            return false;
        }
        if (!support.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            return false;
        }
        support.setShowDropLocation(true);
        return true;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 3;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        if (!this.canImport(support)) {
            return false;
        }
        try {
            Object obj = support.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
            List files = (List)obj;
            for (File file : files) {
                this.board.loadAction3D(file);
            }
            return true;
        }
        catch (UnsupportedFlavorException ex) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

