/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Node;
import javax.media.j3d.PointLight;
import javax.media.j3d.SpotLightRetained;
import javax.vecmath.Color3f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

public class SpotLight
extends PointLight {
    public static final int ALLOW_SPREAD_ANGLE_WRITE = 22;
    public static final int ALLOW_SPREAD_ANGLE_READ = 23;
    public static final int ALLOW_CONCENTRATION_WRITE = 24;
    public static final int ALLOW_CONCENTRATION_READ = 25;
    public static final int ALLOW_DIRECTION_WRITE = 26;
    public static final int ALLOW_DIRECTION_READ = 27;
    private static final int[] readCapabilities = new int[]{23, 25, 27};

    public SpotLight() {
        this.setDefaultReadCapabilities(readCapabilities);
    }

    public SpotLight(Color3f color3f, Point3f point3f, Point3f point3f2, Vector3f vector3f, float f, float f2) {
        super(color3f, point3f, point3f2);
        this.setDefaultReadCapabilities(readCapabilities);
        ((SpotLightRetained)this.retained).initDirection(vector3f);
        ((SpotLightRetained)this.retained).initSpreadAngle(f);
        ((SpotLightRetained)this.retained).initConcentration(f2);
    }

    public SpotLight(boolean bl, Color3f color3f, Point3f point3f, Point3f point3f2, Vector3f vector3f, float f, float f2) {
        super(bl, color3f, point3f, point3f2);
        this.setDefaultReadCapabilities(readCapabilities);
        ((SpotLightRetained)this.retained).initDirection(vector3f);
        ((SpotLightRetained)this.retained).initSpreadAngle(f);
        ((SpotLightRetained)this.retained).initConcentration(f2);
    }

    void createRetained() {
        this.retained = new SpotLightRetained();
        this.retained.setSource(this);
    }

    public void setSpreadAngle(float f) {
        if (this.isLiveOrCompiled() && !this.getCapability(22)) {
            throw new CapabilityNotSetException(J3dI18N.getString("SpotLight0"));
        }
        if (this.isLive()) {
            ((SpotLightRetained)this.retained).setSpreadAngle(f);
        } else {
            ((SpotLightRetained)this.retained).initSpreadAngle(f);
        }
    }

    public float getSpreadAngle() {
        if (this.isLiveOrCompiled() && !this.getCapability(23)) {
            throw new CapabilityNotSetException(J3dI18N.getString("SpotLight1"));
        }
        return ((SpotLightRetained)this.retained).getSpreadAngle();
    }

    public void setConcentration(float f) {
        if (this.isLiveOrCompiled() && !this.getCapability(24)) {
            throw new CapabilityNotSetException(J3dI18N.getString("SpotLight2"));
        }
        if (this.isLive()) {
            ((SpotLightRetained)this.retained).setConcentration(f);
        } else {
            ((SpotLightRetained)this.retained).initConcentration(f);
        }
    }

    public float getConcentration() {
        if (this.isLiveOrCompiled() && !this.getCapability(25)) {
            throw new CapabilityNotSetException(J3dI18N.getString("SpotLight3"));
        }
        return ((SpotLightRetained)this.retained).getConcentration();
    }

    public void setDirection(float f, float f2, float f3) {
        if (this.isLiveOrCompiled() && !this.getCapability(26)) {
            throw new CapabilityNotSetException(J3dI18N.getString("SpotLight4"));
        }
        if (this.isLive()) {
            ((SpotLightRetained)this.retained).setDirection(f, f2, f3);
        } else {
            ((SpotLightRetained)this.retained).initDirection(f, f2, f3);
        }
    }

    public void setDirection(Vector3f vector3f) {
        if (this.isLiveOrCompiled() && !this.getCapability(26)) {
            throw new CapabilityNotSetException(J3dI18N.getString("SpotLight4"));
        }
        if (this.isLive()) {
            ((SpotLightRetained)this.retained).setDirection(vector3f);
        } else {
            ((SpotLightRetained)this.retained).initDirection(vector3f);
        }
    }

    public void getDirection(Vector3f vector3f) {
        if (this.isLiveOrCompiled() && !this.getCapability(27)) {
            throw new CapabilityNotSetException(J3dI18N.getString("SpotLight6"));
        }
        ((SpotLightRetained)this.retained).getDirection(vector3f);
    }

    public Node cloneNode(boolean bl) {
        SpotLight spotLight = new SpotLight();
        spotLight.duplicateNode(this, bl);
        return spotLight;
    }

    void duplicateAttributes(Node node, boolean bl) {
        super.duplicateAttributes(node, bl);
        SpotLightRetained spotLightRetained = (SpotLightRetained)node.retained;
        SpotLightRetained spotLightRetained2 = (SpotLightRetained)this.retained;
        spotLightRetained2.initSpreadAngle(spotLightRetained.getSpreadAngle());
        spotLightRetained2.initConcentration(spotLightRetained.getConcentration());
        Vector3f vector3f = new Vector3f();
        spotLightRetained.getDirection(vector3f);
        spotLightRetained2.initDirection(vector3f);
    }
}

