/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3;

import com.sun.j3d.exp.swing.JCanvas3D;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.GraphicsContext3D;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Raster;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Quat4d;
import javax.vecmath.Vector3d;
import jp.sourceforge.acerola3d.a3.A3CanvasInterface;
import jp.sourceforge.acerola3d.a3.A3Controller;
import jp.sourceforge.acerola3d.a3.A3Listener;
import jp.sourceforge.acerola3d.a3.A3Object;
import jp.sourceforge.acerola3d.a3.A3VirtualUniverse;
import jp.sourceforge.acerola3d.a3.Component2D;
import jp.sourceforge.acerola3d.a3.TimerBehavior;

public class JA3Canvas
extends JCanvas3D
implements A3CanvasInterface {
    private static final long serialVersionUID = 1L;
    A3VirtualUniverse universe;
    ArrayList<Component2D> components2D = new ArrayList();
    volatile boolean check = false;
    GraphicsContext3D gc;
    Raster readRaster;

    public static JA3Canvas createJA3Canvas() {
        return JA3Canvas.createJA3Canvas(500, 500);
    }

    public static JA3Canvas createJA3Canvas(int w, int h) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        GraphicsConfigTemplate3D gct3d = new GraphicsConfigTemplate3D();
        return JA3Canvas.createJA3Canvas(gct3d, gd, w, h);
    }

    public static JA3Canvas createJA3Canvas(GraphicsConfigTemplate3D t, GraphicsDevice d, int w, int h) {
        return new JA3Canvas(t, d, w, h);
    }

    JA3Canvas(GraphicsConfigTemplate3D t, GraphicsDevice d, int w, int h) {
        super(t, d);
        this.setPreferredSize(new Dimension(w, h));
        this.setSize(w, h);
    }

    public void addNotify() {
        super.addNotify();
        this.universe = new A3VirtualUniverse(this);
        this.enableEvents(16L);
        this.enableEvents(32L);
        this.enableEvents(131072L);
    }

    @Override
    public TimerBehavior getTimerBehavior() {
        return this.universe.getTimerBehavior();
    }

    @Override
    public void add(A3Object a) {
        this.universe.add(a);
    }

    @Override
    public void del(A3Object a) {
        this.universe.del(a);
    }

    @Override
    public void delAll() {
        this.universe.delAll();
    }

    @Override
    public void setBackground(A3Object a) {
        this.universe.setBackground(a);
    }

    @Override
    public void delBackground() {
        this.universe.delBackground();
    }

    @Override
    public void setAvatar(A3Object a) {
        this.universe.setAvatar(a);
    }

    @Override
    public A3Object getAvatar() {
        return this.universe.getAvatar();
    }

    @Override
    public void addA3Listener(A3Listener l) {
        this.universe.addA3Listener(l);
    }

    @Override
    public void removeA3Listener(A3Listener l) {
        this.universe.addA3Listener(l);
    }

    @Override
    public void setDefaultCameraLoc(double x, double y, double z) {
        this.universe.setDefaultCameraLoc(x, y, z);
    }

    @Override
    public void setDefaultCameraLoc(Vector3d loc) {
        this.universe.setDefaultCameraLoc(loc);
    }

    @Override
    public void setDefaultCameraQuat(double x, double y, double z, double w) {
        this.universe.setDefaultCameraQuat(x, y, z, w);
    }

    @Override
    public void setDefaultCameraQuat(Quat4d quat) {
        this.universe.setDefaultCameraQuat(quat);
    }

    @Override
    public void setDefaultCameraRot(double x, double y, double z) {
        this.universe.setDefaultCameraRot(x, y, z);
    }

    @Override
    public void setDefaultCameraRot(Vector3d rot) {
        this.universe.setDefaultCameraRot(rot);
    }

    @Override
    public void setDefaultCameraScale(double s) {
        this.universe.setDefaultCameraScale(s);
    }

    @Override
    public void resetCamera() {
        this.universe.resetCamera();
    }

    @Override
    public void setCameraLoc(double x, double y, double z) {
        this.universe.setCameraLoc(x, y, z);
    }

    @Override
    public void setCameraLoc(Vector3d loc) {
        this.universe.setCameraLoc(loc);
    }

    @Override
    public void setCameraLocImmediately(double x, double y, double z) {
        this.universe.setCameraLocImmediately(x, y, z);
    }

    @Override
    public void setCameraLocImmediately(Vector3d loc) {
        this.universe.setCameraLocImmediately(loc);
    }

    @Override
    public Vector3d getCameraLoc() {
        return this.universe.getCameraLoc();
    }

    @Override
    public void setCameraQuat(double x, double y, double z, double w) {
        this.universe.setCameraQuat(x, y, z, w);
    }

    @Override
    public void setCameraQuat(Quat4d quat) {
        this.universe.setCameraQuat(quat);
    }

    @Override
    public void setCameraQuatImmediately(double x, double y, double z, double w) {
        this.universe.setCameraQuatImmediately(x, y, z, w);
    }

    @Override
    public void setCameraQuatImmediately(Quat4d quat) {
        this.universe.setCameraQuatImmediately(quat);
    }

    @Override
    public Quat4d getCameraQuat() {
        return this.universe.getCameraQuat();
    }

    @Override
    public void setCameraRot(double x, double y, double z) {
        this.universe.setCameraRot(x, y, z);
    }

    @Override
    public void setCameraRot(Vector3d rot) {
        this.universe.setCameraRot(rot);
    }

    @Override
    public void setCameraRotImmediately(double x, double y, double z) {
        this.universe.setCameraRotImmediately(x, y, z);
    }

    @Override
    public void setCameraRotImmediately(Vector3d rot) {
        this.universe.setCameraRotImmediately(rot);
    }

    @Override
    public void setCameraScale(double s) {
        this.universe.setCameraScale(s);
    }

    @Override
    public void setCameraScaleImmediately(double s) {
        this.universe.setCameraScaleImmediately(s);
    }

    @Override
    public double getCameraScale() {
        return this.universe.getCameraScale();
    }

    @Override
    public void setHeadLightEnable(boolean b) {
        this.universe.setHeadLightEnable(b);
    }

    @Override
    public void setNavigationMode(A3CanvasInterface.NaviMode m) {
        this.universe.setNavigationMode(m);
    }

    @Override
    public void setNavigationSpeed(double s) {
        this.universe.setNavigationSpeed(s);
    }

    @Override
    public double getNavigationSpeed() {
        return this.universe.getNavigationSpeed();
    }

    @Override
    public void setA3Controller(A3Controller c) {
        this.universe.setA3Controller(c);
    }

    @Override
    public Point3d canvasToVirtualCS(int x, int y) {
        return this.universe.canvasToVirtualCS(x, y);
    }

    @Override
    public Point3d canvasToVirtualCS(int x, int y, double dis) {
        return this.universe.canvasToVirtualCS(x, y, dis);
    }

    @Override
    public Point3d canvasToPhysicalCS(int x, int y) {
        return this.universe.canvasToPhysicalCS(x, y);
    }

    @Override
    public Point3d canvasToPhysicalCS(int x, int y, double dis) {
        return this.universe.canvasToPhysicalCS(x, y, dis);
    }

    @Override
    public Vector3d physicalCSToVirtualCS(Vector3d v) {
        return this.universe.physicalCSToVirtualCS(v);
    }

    @Override
    public Point virtualCSToCanvas(Point3d p) {
        return this.universe.virtualCSToCanvas(p);
    }

    @Override
    public Vector3d virtualCSToPhysicalCS(Vector3d v) {
        return this.universe.virtualCSToPhysicalCS(v);
    }

    @Override
    public Vector3d getCameraUnitVecX() {
        return this.universe.getCameraUnitVecX();
    }

    @Override
    public Vector3d getCameraUnitVecY() {
        return this.universe.getCameraUnitVecY();
    }

    @Override
    public Vector3d getCameraUnitVecZ() {
        return this.universe.getCameraUnitVecZ();
    }

    @Override
    public A3Object pickA3(int x, int y) {
        return this.universe.pickingBehavior.pickA3(x, y);
    }

    @Override
    public synchronized void add(Component2D c) {
        if (!this.components2D.contains(c)) {
            this.components2D.add(c);
        }
    }

    @Override
    public synchronized void del(Component2D c) {
        this.components2D.remove(c);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D gg = (Graphics2D)g;
        for (Component2D c : this.components2D) {
            c.paint(gg, this);
        }
    }

    public void postSwap() {
        if (this.check) {
            this.gc.readRaster(this.readRaster);
            this.check = false;
        }
    }

    @Override
    public void saveImage(File file) throws IOException {
        int width = this.getWidth();
        int height = this.getHeight();
        BufferedImage bImage = new BufferedImage(width, height, 1);
        ImageComponent2D ic2d = new ImageComponent2D(1, bImage);
        this.readRaster = new Raster(new Point3f(0.0f, 0.0f, 0.0f), 1, 0, 0, width, height, ic2d, null);
        this.check = true;
        while (this.check) {
            try {
                Thread.sleep(300L);
            }
            catch (Exception e) {}
        }
        ImageComponent2D ic = this.readRaster.getImage();
        BufferedImage image = ic.getImage();
        ImageIO.write((RenderedImage)image, "png", file);
    }
}

