/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3;

import com.sun.j3d.audioengines.javasound.JavaSoundMixer;
import java.awt.Point;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.media.j3d.AudioDevice;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Light;
import javax.media.j3d.Locale;
import javax.media.j3d.Node;
import javax.media.j3d.PhysicalBody;
import javax.media.j3d.PhysicalEnvironment;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.media.j3d.ViewPlatform;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Point3d;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple4d;
import javax.vecmath.Vector3d;
import jp.sourceforge.acerola3d.a3.A3BranchGroup;
import jp.sourceforge.acerola3d.a3.A3Canvas;
import jp.sourceforge.acerola3d.a3.A3CanvasInterface;
import jp.sourceforge.acerola3d.a3.A3Controller;
import jp.sourceforge.acerola3d.a3.A3Listener;
import jp.sourceforge.acerola3d.a3.A3Object;
import jp.sourceforge.acerola3d.a3.CameraBehavior;
import jp.sourceforge.acerola3d.a3.EditController;
import jp.sourceforge.acerola3d.a3.ExamController;
import jp.sourceforge.acerola3d.a3.FlyController;
import jp.sourceforge.acerola3d.a3.JA3Canvas;
import jp.sourceforge.acerola3d.a3.NoneController;
import jp.sourceforge.acerola3d.a3.PickingBehavior;
import jp.sourceforge.acerola3d.a3.SimpleController;
import jp.sourceforge.acerola3d.a3.TimerBehavior;
import jp.sourceforge.acerola3d.a3.WalkController;
import org.jdesktop.j3d.audioengines.joal.JOALMixer;

class A3VirtualUniverse
extends VirtualUniverse {
    A3CanvasInterface canvas = null;
    Canvas3D canvas3d = null;
    Locale locale;
    View view;
    BranchGroup rootGroup;
    TransformGroup tGroup;
    Transform3D transform;
    BranchGroup vpGroup;
    ViewPlatform vp;
    BranchGroup mainGroup;
    BranchGroup bgGroup;
    TimerBehavior timerBehavior;
    PickingBehavior pickingBehavior;
    CameraBehavior cameraBehavior;
    Light headLight;
    A3Object background = null;
    A3Object avatar = null;
    Hashtable<A3Object, BranchGroup> a3Hash = new Hashtable();
    BranchGroup backgroundBG = null;
    Vector3d cameraNowV = new Vector3d(0.0, 0.0, 2.0);
    Quat4d cameraNowQ = new Quat4d(0.0, 0.0, 0.0, 1.0);
    double cameraNowS = 1.0;
    Vector3d cameraNextV = new Vector3d(0.0, 0.0, 2.0);
    Quat4d cameraNextQ = new Quat4d(0.0, 0.0, 0.0, 1.0);
    double cameraNextS = 1.0;
    Vector3d defaultV = new Vector3d(0.0, 0.0, 2.0);
    Quat4d defaultQ = new Quat4d(0.0, 0.0, 0.0, 1.0);
    double defaultS = 1.0;
    A3CanvasInterface.NaviMode naviMode = A3CanvasInterface.NaviMode.NONE;
    double naviSpeed = 1.0;
    A3Controller controller = null;

    A3VirtualUniverse(A3CanvasInterface c) {
        this.canvas = c;
        if (this.canvas instanceof A3Canvas) {
            this.init((Canvas3D)c);
        } else if (this.canvas instanceof JA3Canvas) {
            this.init(((JA3Canvas)this.canvas).getOffscreenCanvas3D());
        }
    }

    void init(Canvas3D c3d) {
        this.canvas3d = c3d;
        this.locale = new Locale((VirtualUniverse)this);
        PhysicalBody body = new PhysicalBody();
        PhysicalEnvironment environment = new PhysicalEnvironment();
        this.view = new View();
        this.view.addCanvas3D(this.canvas3d);
        this.view.setPhysicalBody(body);
        this.view.setPhysicalEnvironment(environment);
        this.view.setBackClipDistance(1000.0);
        this.view.setUserHeadToVworldEnable(true);
        this.vpGroup = new BranchGroup();
        this.tGroup = new TransformGroup();
        this.tGroup.setCapability(18);
        this.tGroup.setCapability(17);
        this.vpGroup.addChild((Node)this.tGroup);
        this.transform = new Transform3D();
        this.tGroup.setTransform(this.transform);
        this.timerBehavior = new TimerBehavior();
        BoundingSphere bs = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 10.0);
        this.timerBehavior.setSchedulingBounds((Bounds)bs);
        this.tGroup.addChild((Node)this.timerBehavior);
        this.vp = new ViewPlatform();
        this.tGroup.addChild((Node)this.vp);
        this.headLight = new DirectionalLight();
        this.headLight.setCapability(13);
        this.headLight.setInfluencingBounds((Bounds)new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0));
        this.headLight.setEnable(true);
        this.tGroup.addChild((Node)this.headLight);
        this.view.attachViewPlatform(this.vp);
        this.pickingBehavior = new PickingBehavior(this, this.view, this.tGroup, this.locale);
        this.vpGroup.addChild((Node)this.pickingBehavior);
        BoundingSphere sb = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 10.0);
        this.pickingBehavior.setSchedulingBounds((Bounds)sb);
        this.cameraBehavior = new CameraBehavior(this);
        this.vpGroup.addChild((Node)this.cameraBehavior);
        this.cameraBehavior.setSchedulingBounds((Bounds)sb);
        this.mainGroup = new BranchGroup();
        this.mainGroup.setCapability(17);
        this.mainGroup.setCapability(12);
        this.mainGroup.setCapability(14);
        this.mainGroup.setCapability(13);
        this.bgGroup = new BranchGroup();
        this.bgGroup.setCapability(17);
        this.bgGroup.setCapability(12);
        this.bgGroup.setCapability(14);
        this.bgGroup.setCapability(13);
        this.rootGroup = new BranchGroup();
        this.rootGroup.addChild((Node)this.vpGroup);
        this.rootGroup.addChild((Node)this.mainGroup);
        this.rootGroup.addChild((Node)this.bgGroup);
        this.locale.addBranchGraph(this.rootGroup);
        JOALMixer mixer = null;
        String mixerClassName = System.getProperty("j3d.audiodevice");
        System.out.println(mixerClassName);
        if (mixerClassName != null) {
            try {
                Class<?> c = Class.forName(mixerClassName);
                Class<AudioDevice> mixerClass = c.asSubclass(AudioDevice.class);
                Constructor<AudioDevice> constructor = mixerClass.getConstructor(PhysicalEnvironment.class);
                mixer = constructor.newInstance(environment);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (mixer == null) {
            try {
                mixer = new JOALMixer(environment);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (mixer == null) {
            try {
                mixer = new JavaSoundMixer(environment);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (mixer == null) {
            System.out.println("null AudioDevice!");
        } else {
            System.out.println(mixer.getClass().getName());
            environment.setAudioDevice((AudioDevice)mixer);
            mixer.initialize();
        }
    }

    TimerBehavior getTimerBehavior() {
        return this.timerBehavior;
    }

    void prepareVirtualUniverse() {
    }

    public void add(A3Object a) {
        if (this.a3Hash.containsKey(a)) {
            return;
        }
        if (this.canvas != null) {
            a.setA3CanvasInterface(this.canvas);
        }
        A3BranchGroup bg = a.getA3BranchGroup();
        this.mainGroup.addChild((Node)bg);
        this.a3Hash.put(a, bg);
    }

    public void del(A3Object a) {
        BranchGroup bg = this.a3Hash.get(a);
        if (bg == null) {
            return;
        }
        bg.detach();
        a.dispose();
        this.a3Hash.remove(a);
    }

    public void delAll() {
        Enumeration<A3Object> e = this.a3Hash.keys();
        while (e.hasMoreElements()) {
            A3Object a3 = e.nextElement();
            BranchGroup bg = this.a3Hash.get(a3);
            bg.detach();
            a3.dispose();
        }
        this.a3Hash.clear();
    }

    public void setBackground(A3Object a) {
        if (this.backgroundBG != null) {
            this.backgroundBG.detach();
        }
        A3BranchGroup n = a.getA3BranchGroup();
        this.backgroundBG = new BranchGroup();
        this.backgroundBG.setCapability(17);
        this.backgroundBG.addChild((Node)n);
        this.mainGroup.addChild((Node)this.backgroundBG);
        this.background = a;
    }

    public void delBackground() {
        if (this.backgroundBG != null) {
            this.backgroundBG.detach();
        }
        this.background = null;
    }

    public void setAvatar(A3Object a) {
        this.avatar = a;
    }

    public A3Object getAvatar() {
        return this.avatar;
    }

    public void addA3Listener(A3Listener l) {
        this.pickingBehavior.addA3Listener(l);
    }

    public void removeA3Listener(A3Listener l) {
        this.pickingBehavior.removeA3Listener(l);
    }

    public void setDefaultCameraLoc(double x, double y, double z) {
        this.defaultV = new Vector3d(x, y, z);
    }

    public void setDefaultCameraLoc(Vector3d loc) {
        this.defaultV = new Vector3d(loc);
    }

    public void setDefaultCameraQuat(double x, double y, double z, double w) {
        this.defaultQ = new Quat4d(x, y, z, w);
    }

    public void setDefaultCameraQuat(Quat4d quat) {
        this.defaultQ = new Quat4d(quat);
    }

    public void setDefaultCameraRot(double x, double y, double z) {
        this.defaultQ = this.rot2quat(x, y, z);
    }

    public void setDefaultCameraRot(Vector3d rot) {
        this.defaultQ = this.rot2quat(rot);
    }

    public void setDefaultCameraScale(double s) {
        this.defaultS = s;
    }

    public void resetCamera() {
        this.cameraNowV.set((Tuple3d)this.defaultV);
        this.cameraNowQ.set((Tuple4d)this.defaultQ);
        this.cameraNowS = this.defaultS;
        this.cameraNextV.set((Tuple3d)this.defaultV);
        this.cameraNextQ.set((Tuple4d)this.defaultQ);
        this.cameraNextS = this.defaultS;
    }

    public void setCameraLoc(double x, double y, double z) {
        this.cameraNextV.set(x, y, z);
    }

    public void setCameraLoc(Vector3d loc) {
        this.cameraNextV.set((Tuple3d)loc);
    }

    public void setCameraLocImmediately(double x, double y, double z) {
        this.cameraNowV.set(x, y, z);
        this.cameraNextV.set(x, y, z);
    }

    public void setCameraLocImmediately(Vector3d loc) {
        this.cameraNowV.set((Tuple3d)loc);
        this.cameraNextV.set((Tuple3d)loc);
    }

    public Vector3d getCameraLoc() {
        return new Vector3d(this.cameraNowV);
    }

    public void setCameraQuat(double x, double y, double z, double w) {
        this.cameraNextQ.set(x, y, z, w);
    }

    public void setCameraQuat(Quat4d quat) {
        this.cameraNextQ.set((Tuple4d)quat);
    }

    public void setCameraQuatImmediately(double x, double y, double z, double w) {
        this.cameraNowQ.set(x, y, z, w);
        this.cameraNextQ.set(x, y, z, w);
    }

    public void setCameraQuatImmediately(Quat4d quat) {
        this.cameraNowQ.set((Tuple4d)quat);
        this.cameraNextQ.set((Tuple4d)quat);
    }

    public Quat4d getCameraQuat() {
        return new Quat4d(this.cameraNowQ);
    }

    public void setCameraRot(double x, double y, double z) {
        this.setCameraQuat(this.rot2quat(x, y, z));
    }

    public void setCameraRot(Vector3d rot) {
        this.setCameraQuat(this.rot2quat(rot));
    }

    public void setCameraRotImmediately(double x, double y, double z) {
        this.setCameraQuatImmediately(this.rot2quat(x, y, z));
    }

    public void setCameraRotImmediately(Vector3d rot) {
        this.setCameraQuatImmediately(this.rot2quat(rot));
    }

    public void setCameraScale(double s) {
        this.cameraNextS = s;
    }

    public void setCameraScaleImmediately(double s) {
        this.cameraNowS = s;
        this.cameraNextS = s;
    }

    public double getCameraScale() {
        return this.cameraNowS;
    }

    Quat4d rot2quat(double x, double y, double z) {
        Transform3D t0 = new Transform3D();
        Transform3D t1 = new Transform3D();
        t1.rotX(x);
        t0.mul(t1);
        t1.rotY(y);
        t0.mul(t1);
        t1.rotZ(z);
        t0.mul(t1);
        Quat4d q = new Quat4d();
        t0.get(q);
        return q;
    }

    Quat4d rot2quat(Vector3d rot) {
        return this.rot2quat(rot.x, rot.y, rot.z);
    }

    public void setHeadLightEnable(boolean b) {
        this.headLight.setEnable(b);
    }

    public void setNavigationMode(A3CanvasInterface.NaviMode m) {
        this.naviMode = m;
        if (this.naviMode == A3CanvasInterface.NaviMode.NONE) {
            this.setA3Controller0(new NoneController());
        } else if (this.naviMode == A3CanvasInterface.NaviMode.WALK) {
            this.setA3Controller0(new WalkController());
        } else if (this.naviMode == A3CanvasInterface.NaviMode.FLY) {
            this.setA3Controller0(new FlyController());
        } else if (this.naviMode == A3CanvasInterface.NaviMode.EXAMINE) {
            this.setA3Controller0(new ExamController());
        } else if (this.naviMode == A3CanvasInterface.NaviMode.EDIT) {
            this.setA3Controller0(new EditController());
        } else if (this.naviMode == A3CanvasInterface.NaviMode.SIMPLE) {
            this.setA3Controller0(new SimpleController());
        }
    }

    public void setNavigationSpeed(double s) {
        this.naviSpeed = s;
    }

    public double getNavigationSpeed() {
        return this.naviSpeed;
    }

    void setA3Controller0(A3Controller c) {
        if (this.canvas != null) {
            c.setA3CanvasInterface(this.canvas);
        }
        if (this.controller != null) {
            this.removeA3Listener(this.controller);
            this.canvas.removeKeyListener(this.controller);
            this.controller.stop();
        }
        this.controller = c;
        this.addA3Listener(this.controller);
        this.canvas.addKeyListener(this.controller);
        this.controller.init();
    }

    public void setA3Controller(A3Controller c) {
        this.naviMode = A3CanvasInterface.NaviMode.USER;
        this.setA3Controller0(c);
    }

    public Point3d canvasToVirtualCS(int x, int y) {
        return this.pickingBehavior.canvasToVirtualCS(x, y);
    }

    public Point3d canvasToVirtualCS(int x, int y, double dis) {
        return this.pickingBehavior.canvasToVirtualCS(x, y, dis);
    }

    public Point3d canvasToPhysicalCS(int x, int y) {
        return this.pickingBehavior.canvasToPhysicalCS(x, y);
    }

    public Point3d canvasToPhysicalCS(int x, int y, double dis) {
        return this.pickingBehavior.canvasToPhysicalCS(x, y, dis);
    }

    public Vector3d physicalCSToVirtualCS(Vector3d v) {
        return this.pickingBehavior.physicalCSToVirtualCS(v);
    }

    public Point virtualCSToCanvas(Point3d p) {
        return this.pickingBehavior.virtualCSToCanvas(p);
    }

    public Vector3d virtualCSToPhysicalCS(Vector3d v) {
        return this.pickingBehavior.virtualCSToPhysicalCS(v);
    }

    public Vector3d getCameraUnitVecX() {
        return this.physicalCSToVirtualCS(new Vector3d(1.0, 0.0, 0.0));
    }

    public Vector3d getCameraUnitVecY() {
        return this.physicalCSToVirtualCS(new Vector3d(0.0, 1.0, 0.0));
    }

    public Vector3d getCameraUnitVecZ() {
        return this.physicalCSToVirtualCS(new Vector3d(0.0, 0.0, 1.0));
    }

    public A3Object pickA3(int x, int y) {
        return this.pickingBehavior.pickA3(x, y);
    }
}

