////////////////////////////////////////////////////////////////
// aaoh.sora
//    Copyright (C) 2008 - 2011 AAOh inc.
// 
// Licensed under the MIT license
//   http://www.opensource.org/licenses/mit-license.php
////////////////////////////////////////////////////////////////

/**
 * @fileOverview aaoh.sora
 * @author       $Author: fujishiro $
 */

/**
 * namespace。
 *   aaoh.sora.ControlEx
 *   aaoh.sora.ModelEx
 *   aaoh.sora.MainEx
 *   aaoh.sora.OptionEx
 *   aaoh.sora.App (static, overwrite)
 */

(function () {
/**
 * ControlEx。
 *
 * @constructor
 * @extends aaoh.sora.Control
 */
aaoh.sora.ControlEx = aaoh.kaze.Gadget.extend(
	aaoh.sora.Control, function() {
	// 更新チェック
	this.FLG_UPDATE           = false;
	this.UPDATE_URL_VISTA     = 'http://www.aaoh.co.jp/gadget/vista/gadget-vista.json';
	this.UPDATE_URL_OPERA     = 'http://www.aaoh.co.jp/gadget/opera/gadget-opera.json';
	this.UPDATE_URL_DASHBOARD = 'http://www.aaoh.co.jp/gadget/dashboard/gadget-dashboard.json';
	this.UPDATE_URL_AIR       = 'http://www.aaoh.co.jp/gadget/air/gadget-air.json';
	//this.UPDATE_URL_SBM       = 'http://www.aaoh.co.jp/gadget/sbm/gadget-sbm.json';
	//this.UPDATE_URL_IGOOGLE   = 'http://www.aaoh.co.jp/gadget/igoogle/gadget-igoogle.jsonp';
	this.UPDATE_URL_GOOGLE    = 'http://www.aaoh.co.jp/gadget/google/gadget-google.json';
	this.UPDATE_URL_YAHOO     = 'http://www.aaoh.co.jp/gadget/yahoo/gadget-yahoo.json';

	// 更新チェックインターバル
	this.UPDATE_INTERVAL_VALID_MONTH = 1;
	this.UPDATE_INTERVAL_CHECK_MSEC  = 24 * 60 * 60 * 1000;

	// 更新画像
	this.UPDATE_IMG_NONE = 'lib/images/aaoh.sora-ex.img-update-none.png';
	this.UPDATE_IMG_LOAD = 'lib/images/aaoh.sora-ex.img-update-load.png';
	this.UPDATE_IMG_UPD  = 'lib/images/aaoh.sora-ex.img-update-upd.png';

	// エレメント名
	this.IMG_UPDATE_NM  = 'imgUpdate';
	this.OPT_VERSION_NM = 'optVersion';

	this.TIP_UPDATE_NONE = 'TIP_UPDATE_NONE';
	this.TIP_UPDATE_LOAD = 'TIP_UPDATE_LOAD';
	this.TIP_UPDATE_UPD  = 'TIP_UPDATE_UPD';

	this.LST_IMG_NM = new Array('imgAAOh');
	this.LST_LNK_NM = new Array('lnkAAOh');
	this.LST_URL    = new Array();
	this.LST_URL['imgAAOh'] = 'http://www.aaoh.co.jp/';
	this.LST_URL['lnkAAOh'] = 'http://www.aaoh.co.jp/';

	// パラメータ
	this.updTimer = new aaoh.kaze.Timer();
});
	/**
	 * 更新チェック。
	 * 更新チェックはPC起動時または1日毎に行う。
	 */
	aaoh.sora.ControlEx.prototype.
	doUpdate = function() {
		if (!this.FLG_UPDATE) {
			return;
		}

		try {
			this.checkUpdate();
		} catch(ex) {
		}

		this.updTimer.setInterval(
			this.checkUpdate, this.UPDATE_INTERVAL_CHECK_MSEC
		);
	}

	/**
	 * 更新表示。
	 */
	aaoh.sora.ControlEx.prototype.
	checkUpdate = function() {
		// 更新イメージの初期設定
		if (
			aaoh.sora.App.model.data.update.url != null
			&& aaoh.sora.App.model.data.update.url != ''
		) {
			this.setUpdateUpd();

		} else {
			this.setUpdateNone();
		}

		// 更新チェックするか
		var flgUpd = this.isUpdate();
		if (!flgUpd) {
			return;
		}

		// 更新イメージをチェック中にする
		this.setUpdateLoad();

		var updateUrl = null;
		if (aaoh.kaze.Type.isOpera()) {
			updateUrl = this.UPDATE_URL_OPERA;

		} else if (aaoh.kaze.Type.isDashboard()) {
			updateUrl = this.UPDATE_URL_DASHBOARD;

		} else if (aaoh.kaze.Type.isAIR()) {
			updateUrl = this.UPDATE_URL_AIR;

		} else if (aaoh.kaze.Type.isSBM()) {
			updateUrl = this.UPDATE_URL_SBM;

		} else if (aaoh.kaze.Type.isIGoogle()) {
			updateUrl = this.UPDATE_URL_IGOOGLE;

		} else if (aaoh.kaze.Type.isGoogle()) {
			updateUrl = this.UPDATE_URL_GOOGLE;

		} else if (aaoh.kaze.Type.isYahoo()) {
			updateUrl = this.UPDATE_URL_YAHOO;

		} else {
			updateUrl = this.UPDATE_URL_VISTA;
		}

		// 最新バージョンの取得
		var params = 'name=' + this.APP_NAME
			+ '&version=' + this.APP_VERSION
			+ '&time=' + new Date().getTime();

		try {
			var ajax = new aaoh.kaze.Ajax(this);
			ajax.gets(updateUrl + '?' + params, this.setUpdateRes);

		} catch(ex) {
			this.setUpdateError(ex);
		}
	}

	/**
	 * 更新チェックするか。
	 *
	 * @return {Boolean} 更新チェックするときにはtrue
	 */
	aaoh.sora.ControlEx.prototype.
	isUpdate = function() {
		if (aaoh.sora.App.model.data.update.numTime <= 0) {
			// 未チェックだったら必ずtrue
			return true;
		}

		if (
			aaoh.sora.App.model.data.update.url != null
			&& aaoh.sora.App.model.data.update.url != ''
		) {
			// 更新イメージ表示中だったら必ずtrue
			return true;
		}

		var chkDate = new Date(aaoh.sora.App.model.data.update.numTime);
		chkDate.setMonth(
			chkDate.getMonth() + this.UPDATE_INTERVAL_VALID_MONTH
		);

		var flgUpd  = false;
		var nowTime = new Date().getTime();
		var chkTime = chkDate.getTime();
		if (nowTime > chkTime) {
			// 更新チェックを行う
			flgChkUpd = true;
		}

		return flgChkUpd;
	}

	/**
	 * 更新なしイメージの設定。
	 */
	aaoh.sora.ControlEx.prototype.
	setUpdateNone = function() {
		var imgUpdate = aaoh.kaze.Gadget.$(this.IMG_UPDATE_NM);
		if (imgUpdate == null) {
			return;
		}
		var tooltip = this.locale.getString(this.TIP_UPDATE_NONE);

		aaoh.kaze.Element.setImage(imgUpdate,   this.UPDATE_IMG_NONE);
		aaoh.kaze.Element.setTooltip(imgUpdate, tooltip);
		aaoh.kaze.Element.setOnClick(imgUpdate, {});
		aaoh.kaze.Element.setCursor(imgUpdate,  'default');
	}

	/**
	 * チェック中イメージの設定。
	 */
	aaoh.sora.ControlEx.prototype.
	setUpdateLoad = function() {
		var imgUpdate = aaoh.kaze.Gadget.$(this.IMG_UPDATE_NM);
		if (imgUpdate == null) {
			return;
		}
		var tooltip = this.locale.getString(this.TIP_UPDATE_LOAD);

		aaoh.kaze.Element.setImage(imgUpdate,   this.UPDATE_IMG_LOAD);
		aaoh.kaze.Element.setTooltip(imgUpdate, tooltip);
		aaoh.kaze.Element.setOnClick(imgUpdate, {});
		aaoh.kaze.Element.setCursor(imgUpdate,  'default');
	}

	/**
	 * 更新イメージの設定。
	 */
	aaoh.sora.ControlEx.prototype.
	setUpdateUpd = function() {
		var imgUpdate = aaoh.kaze.Gadget.$(this.IMG_UPDATE_NM);
		if (imgUpdate == null) {
			return;
		}
		var tooltip = this.locale.getString(this.TIP_UPDATE_UPD);

		aaoh.kaze.Element.setImage(imgUpdate,   this.UPDATE_IMG_UPD);
		aaoh.kaze.Element.setTooltip(imgUpdate, tooltip);
		aaoh.kaze.Element.setOnClick(imgUpdate, function() {
			aaoh.kaze.Gadget.openURL(aaoh.sora.App.model.data.update.url);
		});
		aaoh.kaze.Element.setCursor(imgUpdate,  'pointer');
	}

	/**
	 * 更新表示。
	 *
	 * @param {String} resTxt レスポンスオブジェクト
	 */
	aaoh.sora.ControlEx.prototype.
	setUpdateRes = function(resTxt) {
		// 更新チェックデータの取得
		var updData = null;
		if (resTxt != null) {
			try {
				updData = this.json.parse(resTxt);

			} catch(ex) {
				this.setUpdateException(ex);
				return;
			}
		}

		if (
			updData == null
			|| updData[this.APP_NAME] == null
		) {
			// 更新イメージを元に戻す
			this.setUpdateException();
			return;
		}
		var flgUpd = false;

		// バージョンチェック
		if (this.APP_VERSION != updData[this.APP_NAME].version) {
			var nowVerList = this.APP_VERSION.split('.');
			var updVerList = updData[this.APP_NAME].version.split('.');

			for (var cnt = 0; cnt < nowVerList.length; cnt++) {
				if (cnt >= updVerList.length) {
					break;
				}

				var nowVerSub = parseInt(nowVerList[cnt], 10);
				var updVerSub = parseInt(updVerList[cnt], 10);
				if (nowVerSub < updVerSub) {
					flgUpd = true;
					break;

				} else if (nowVerSub > updVerSub) {
					break;
				}
			} // for (var cnt = 0; cnt < nowVerList.length; cnt++)
		} // if (this.APP_VERSION != updData[this.APP_NAME].version)

		// 更新イメージ設定
		if (flgUpd) {
			// 更新イメージにする
			aaoh.sora.App.model.data.update.url = updData[this.APP_NAME].url;
			this.setUpdateUpd();

		} else {
			// 更新なしイメージにする
			aaoh.sora.App.model.data.update.url = null;
			this.setUpdateNone();
		}

		// 更新チェック日付の更新
		aaoh.sora.App.model.data.update.numTime = new Date().getTime();
		aaoh.sora.App.model.writeData(this.APP_NAME, this.APP_VERSION);
	}

	/**
	 * Ajaxエラー。
	 */
	aaoh.sora.ControlEx.prototype.
	setUpdateError = function () {
		this.setUpdateException();
	}

	/**
	 * Ajaxエラー。
	 */
	aaoh.sora.ControlEx.prototype.
	setUpdateException = function() {
		// 更新イメージを元に戻す
		if (
			aaoh.sora.App.model.data.update.url != null
			&& aaoh.sora.App.model.data.update.url != ''
		) {
			this.setUpdateUpd();

		} else {
			this.setUpdateNone();
		}
	}

	/**
	 * 初期化。
	 */
	aaoh.sora.ControlEx.prototype.
	init = function() {
		if (aaoh.kaze.Type.isSBM() || aaoh.kaze.Type.isIGoogle()) {
			this.FLG_UPDATE = false;
		}

		this.initBefore();
		if (aaoh.sora.App.main != null) {
			aaoh.sora.App.main.initBefore();
		}
		if (aaoh.sora.App.option != null) {
			aaoh.sora.App.option.initBefore();
		}

		if (aaoh.sora.App.main != null) {
			aaoh.sora.App.main.init();
		}
		if (aaoh.sora.App.option != null) {
			aaoh.sora.App.option.init();
		}

		if (aaoh.sora.App.main != null) {
			aaoh.sora.App.main.initAfter();
		}
		if (aaoh.sora.App.option != null) {
			aaoh.sora.App.option.initAfter();
		}
		this.initAfter();
	}
})();

(function () {
/**
 * ModelEx。
 *
 * @constructor
 * @extends aaoh.sora.Model
 */
aaoh.sora.ModelEx = aaoh.kaze.Gadget.extend(
	aaoh.sora.Model, function() {
	this.data.update = {
		numTime: 0,
		url:  null
	}
});
	/**
	 * 設定情報の読込みの前処理(iGoogle)。
	 * 読込みバージョンと読込んだバージョンが異なる場合には
	 * 設定情報を更新しません。
	 *
	 * @param {String} key     読込みキー
	 * @param {String} version 読込みバージョン
	 */
	aaoh.sora.ModelEx.prototype.
	readDataBeforeForIGoogle = function(key, version) {
		if (key == null) {
			throw new Error('key is null, version is ' + version);
		}

		var version_     = aaoh.sora.App.control.storage.readString('version');
		var locale       = aaoh.sora.App.control.storage.readString('locale');
		var isOnDock     = aaoh.sora.App.control.storage.readString('isOnDock');
		var numXPosition = aaoh.sora.App.control.storage.readString('numX_position');
		var numYPosition = aaoh.sora.App.control.storage.readString('numY_position');
		if (
			version != null
			&& version_ != null && version_ != ''
			&& version != version_
		) {
			return;
		}

		if (version != null) {
			this.data.version = version_;
		}
		if (locale != null) {
			this.data.locale = locale;
		}
		this.data.isOnDock = isOnDock;
		if (numXPosition > 0) {
			this.data.position.numX = numXPosition;
		}
		if (numXPosition > 0) {
			this.data.position.numX = numXPosition;
		}
		if (numYPosition > 0) {
			this.data.position.numY = numYPosition;
		}

		var numTimeUpdate = aaoh.sora.App.control.storage.readString('numTime_update');
		var urlUpdate     = aaoh.sora.App.control.storage.readString('url_update');

		if (numTimeUpdate > 0) {
			aaoh.sora.App.model.data.update.numTime = numTimeUpdate;
		}
		if (urlUpdate != null) {
			aaoh.sora.App.model.data.update.url = urlUpdate;
		}
	}

	/**
	 * 設定情報の書込みの前処理(iGoogle)。
	 *
	 * @param {String} key     書込みキー
	 * @param {String} version 書込みバージョン
	 */
	aaoh.sora.ModelEx.prototype.
	writeDataBeforeForIGoogle = function(key, version) {
		if (key == null) {
			throw new Error('key is null, version is ' + version);
		}
		this.data.version = version;

		aaoh.sora.App.control.storage.writeString(
			'version', this.data.version
		);
		aaoh.sora.App.control.storage.writeString(
			'locale', this.data.locale
		);
		aaoh.sora.App.control.storage.writeString(
			'isOnDock', this.data.isOnDock
		);
		aaoh.sora.App.control.storage.writeString(
			'numX_position', this.data.position.numX
		);
		aaoh.sora.App.control.storage.writeString(
			'numY_position', this.data.position.numY
		);

		aaoh.sora.App.control.storage.writeString(
			'numTime_update', this.data.update.numTime
		);
		aaoh.sora.App.control.storage.writeString(
			'url_update', this.data.update.url
		);
	}
})();

(function () {
/**
 * MainEx。
 *
 * @constructor
 * @extends aaoh.sora.Model
 */
aaoh.sora.MainEx = aaoh.kaze.Gadget.extend(
	aaoh.sora.Main, function() {
});
	/**
	 * 初期化の後処理。
	 */
	aaoh.sora.MainEx.prototype.
	initAfter = function() {
		if (aaoh.sora.App.control == null) {
			return;
		}

		// 更新チェック
		aaoh.sora.App.control.doUpdate();

		aaoh.sora.App.control.showMain(
			aaoh.sora.App.control.flgOnDock, true
		);
	}
})();

(function () {
/**
 * OptionEx。
 *
 * @constructor
 * @extends aaoh.sora.Model
 */
aaoh.sora.OptionEx = aaoh.kaze.Gadget.extend(
	aaoh.sora.Option, function() {
});
	/**
	 * 初期化の後処理。
	 */
	aaoh.sora.OptionEx.prototype.
	initAfter = function() {
		if (aaoh.sora.App.control == null) {
			return;
		}

		// Sidebar, Google用
		if (aaoh.sora.App.main == null) {
			// 毎回optionが生成されるので
			aaoh.sora.App.control.showOption();
		}

		// Yahoo用
		if (aaoh.kaze.Type.isYahoo()) {
			this.initDataBeforeForYahoo();
			this.initDataForYahoo();
			this.initDataAfterForYahoo();
		}

		// バージョン
		var optVersion = aaoh.kaze.Gadget.$(
			aaoh.sora.App.control.OPT_VERSION_NM
		);
		if (optVersion != null) {
			aaoh.kaze.Element.setValue(
				optVersion, 'Version: ' + aaoh.sora.App.control.APP_VERSION
			);
		}

		// コピーライト
		for (
			var cnt = 0;
			cnt < aaoh.sora.App.control.LST_IMG_NM.length;
			cnt++
		) {
			var imgNm = aaoh.sora.App.control.LST_IMG_NM[cnt];
			var lnkNm = aaoh.sora.App.control.LST_LNK_NM[cnt];

			var imgNmObj = aaoh.kaze.Gadget.$(imgNm);
			if (imgNmObj != null) {
				aaoh.kaze.Element.setOnClick(imgNmObj, function() {
					var srcId = this.id;
					if (srcId == null || srcId == '') {
						var event = aaoh.kaze.Gadget.getEvent();

						srcId = event.srcElement.id;
						if (srcId == null || srcId == '') {
							srcId = event.srcElement.name;
						}
					}
					var url = aaoh.sora.App.control.LST_URL[srcId];

					aaoh.kaze.Gadget.openURL(url);
				});
			}
			var lnkNmObj = aaoh.kaze.Gadget.$(lnkNm);
			if (lnkNmObj != null) {
				aaoh.kaze.Element.setOnClick(lnkNmObj, function() {
					var srcId = this.id;
					if (srcId == null || srcId == '') {
						var event = aaoh.kaze.Gadget.getEvent();

						srcId = event.srcElement.id;
						if (srcId == null || srcId == '') {
							srcId = event.srcElement.name;
						}
					}
					var url = aaoh.sora.App.control.LST_URL[srcId];

					aaoh.kaze.Gadget.openURL(url);
					return false;
				});
			}
		} // for (var cnt = 0; ...) 
	}
})();


(function () {
/**
 * App。
 *
 * @namespace
 */
aaoh.sora.App = {
	/**
	 * コントローラー。
	 */
	control: new aaoh.sora.ControlEx(),

	/**
	 * モデル。
	 */
	model:   new aaoh.sora.ModelEx(),

	/**
	 * メイン処理オブジェクト。
	 */
	main:    null,

	/**
	 * オプション処理オブジェクト。
	 */
	option:  null,

	/**
	 * 初期化。
	 *
	 * @param {String} target 初期化するターゲット
	 */
	init: function(target) {
		//if (
		//	target != null && target == aaoh.sora.App.control.MAIN_NM
		//) {
		//	aaoh.sora.App.main   = new aaoh.sora.MainEx();
		//	aaoh.sora.App.option = null;
		//} else if (
		//	target != null && target == aaoh.sora.App.control.OPTION_NM
		//) {
		//	aaoh.sora.App.main   = null;
		//	aaoh.sora.App.option = new aaoh.sora.OptionEx();
		//} else {
		//	aaoh.sora.App.main   = new aaoh.sora.MainEx();
		//	aaoh.sora.App.option = new aaoh.sora.OptionEx();
		//}
		//aaoh.sora.App.control.init();
	}
}
})();
