#ifndef MYSQL_CLIENT_H
#define MYSQL_CLIENT_H

#include <mysql.h>

class Mysql_client: public Client
{
protected:  
  MYSQL con;
public:
  Mysql_client():Client(){}
  ~Mysql_client() { clean_up(); }
  void do_connect();
  int safe_query(const char* query, int abort_on_error = 1);
  int escape_string(char* buf, const char* str, int str_len);

  void lose_result();
  void disconnect();
  int check_error(int fatal = 1);
  int compare_result(const char* cmp_file, int abort_on_error = 1) ;
  int dump_result(const char* dump_file, int abort_on_error = 1);
  int get_table_info(Table& t);
  int load_table_data(string& table_name, const char* data_file_name);
};
#endif
