#include "forms.h"
#include <stdio.h>
#include <ctype.h>
#include <sys/file.h>
#include <sys/fcntl.h>
#include <stdlib.h>
#include "xmysqladmin.h"
#include "xmysqladmin2.h"
#include "mysql.h"

struct readkey
{
  char table[33];
  char nonUnique[2];
  char keyName[33];
  char seq[3];
  char columnName[33];
  char collation[2];
  char cardinality[6];
  char subPart[6];
  struct readkey *next;
};



extern struct setup Setup;
extern struct stat Stat;
/* FD_createtable *f_createtable;
** struct createTable *ct;
*/

extern struct fields * ccomkey_fieldIndex(struct edittable *it, char *nom);
extern void createtable_setactive(struct edittable *it);
extern void createtable_freeList(struct edittable *it);
extern void createtable_setCT(struct edittable *it);
extern void createtable_setFieldBrowser(struct edittable *it);
extern char *createtable_indexToType(int type);
extern void createtable_varToObj(struct edittable *it);
extern int createtableNameExist(struct edittable *it, char *nom);
extern int createtableKeyExist(struct edittable *it, char *nom);
extern void createtable_copyfield(struct fields *dest, struct fields *src);
extern void createtable_freeList(struct edittable *it);
extern int createtable_typeToIndex(char *type);
extern void createtable_setCT(struct edittable *it);
extern void createtable_setFieldBrowser(struct edittable *it);
void altertable_init(struct edittable *it);
void altertableFree(struct edittable *it);
void altertable_getColumns(struct edittable *it);
void altertable_getKeys(struct edittable *it);
void altertable_setKeys(struct edittable *it, struct readkey *rkf);
void altertable_freeSQL(struct edittable *it);
void altertable_addSQL(struct edittable *it, char *sql);
void altertable_execSQL(struct edittable *it);

/*----------------------------------------------------------*/
/* prend la definition des champs et la place dans la liste */
/*----------------------------------------------------------*/
void altertable_getColumns(struct edittable *it)
{
  MYSQL connection;
  char sql[81];
  int index = 0;
  
  sprintf(sql, "show columns from %s", it->ct->table);
  if(g_mysql_connect(&connection, Setup.host, Setup.user, Setup.password))
  {
    MYSQL_RES *result;
    MYSQL_ROW row;
    char *error;
    
    mysql_select_db(&connection, it->ct->database);
    if(!mysql_query(&connection, sql))
    {
      result = mysql_store_result(&connection);

      while ((row=mysql_fetch_row(result)))
      {
	memset(it->buff, '\0', sizeof(struct fields));
	
	/* row[0] nom du champ */
	if(row[0]) strcpy(it->buff->name, row[0]);
/* if(row[0]) printf("row[0]= [%s]\n",row[0]); */
/* if(row[1]) printf("row[1]= [%s]\n",row[1]); */
/* if(row[2]) printf("row[2]= [%s]\n",row[2]); */
/* if(row[3]) printf("row[3]= [%s]\n",row[3]); */
/* if(row[4]) printf("row[4]= [%s]\n",row[4]); */
/* if(row[5]) printf("row[5]= [%s]\n",row[5]); */
	/* row[1] premier mot determine le type de champ */
	it->buff->type = createtable_typeToIndex(getSSubstr(row[1], " (),", 0));

	/* determine la longueur pour tous les types sauf set et enum */
	if(it->buff->type == 19 || it->buff->type == 20)
	{
	   /* copie les valeurs dans default */
	   int i = 1;
	   char *pt;
	   while(1)
	   {
	      pt = getSSubstr(row[1], " (),'", i);
	      if(!pt[0]) break;
	      strcat(it->buff->fdefault, pt);
	      strcat(it->buff->fdefault, " ");
	      i++;
	   }
	}
	else
	{
	   it->buff->length = atol(getSSubstr(row[1], " (),", 1));
	   it->buff->decimales = atoi(getSSubstr(row[1], " (),", 2));
	   if(row[1])
	   {
	      if(strstr(row[1], " unsigned"))
	      {
		 it->buff->funsigned = 1;
	      }
	      if(strstr(row[1], " zerofill"))
	      {
		 it->buff->zeroFill = 1;
	      }
	   }
	}
	/* null si YES */
	
	if(row[2])
	{
	   if(row[2][0] != 'Y')
	   {
	      it->buff->notNull = 1;
	   }
	}
	/* row[3] key */

	/* row[4] default */
	if(row[4] && it->buff->type != 19 && it->buff->type != 20)
	   strcpy(it->buff->fdefault, row[4]);

	/* row[5] extra */
	if(row[5])
	{
	   if(strstr(row[5], "increment"))
	   {
	      it->buff->autoIncrement = 1;
	      it->buff->keyType = 'P';
	   }
	}
	index++;
	/*-------------------------------*/
	/* ajoute le champ dans la liste */
	/*-------------------------------*/
	{
	  struct fields *cur;
	  cur = (struct fields *) calloc(1, sizeof(struct fields));
	  if(!it->firstf)
	  {
	    it->firstf = it->lastf = cur;
	  }
	  else
	  {
	    it->lastf->next = cur;
	    cur->prev = it->lastf;
	    it->lastf = cur;
	  }
	  /*--------------------------------*/
	  /* copie les informations saisies */
	  /*--------------------------------*/
	  createtable_copyfield(cur, it->buff);
	  cur->index = index;
	}
	
	  /*---------------------------------------*/
	  /* ajoute le champs dans la liste backup */
	  /*---------------------------------------*/
	{
	  struct fields *cur;
	  cur = (struct fields *) calloc(1, sizeof(struct fields));
	  if(!it->alter->firstf)
	  {
	    it->alter->firstf = it->alter->lastf = cur;
	  }
	  else
	  {
	    it->alter->lastf->next = cur;
	    cur->prev = it->alter->lastf;
	    it->alter->lastf = cur;
	  }
	  /*--------------------------------*/
	  /* copie les informations saisies */
	  /*--------------------------------*/
	  createtable_copyfield(cur, it->buff);
	  cur->index = index;
	}
      }  /* end while des lignes */
      
      mysql_free_result(result);
    }
    else
    {
      error = mysql_error(&connection);
      fl_show_alert(error, it->ct->table,"", 1);
    }
    mysql_close(&connection);
  }
  else
  {
    fl_show_alert("Cannot connect to database server","","", 1);
  }
}



/*-----------------------------------------------------*/
/* prend la definitions des index du serveur           */
/* et memorise dans la liste readkeys                  */
/*-----------------------------------------------------*/
void altertable_getKeys(struct edittable *it)
{
  char sql[81];
  MYSQL connection;
  struct readkey *rkf, *rkl, *rkp, rkc;

  rkf = rkl = NULL;
  memset(&rkc, '\0', sizeof(struct readkey));
  
  if(g_mysql_connect(&connection, Setup.host, Setup.user, Setup.password))
  {
    MYSQL_RES *result;
    MYSQL_ROW row;
    char *error;
    
    sprintf(sql, "show keys from %s", it->ct->table);
      
    mysql_select_db(&connection, it->ct->database);
    if(!mysql_query(&connection, sql))
    {
      result = mysql_store_result(&connection);
      while ((row=mysql_fetch_row(result)))
      {
	if(row[0]) strcpy(rkc.table,       row[0]);
	if(row[1]) strcpy(rkc.nonUnique,   row[1]);
	if(row[2]) strcpy(rkc.keyName,     row[2]);
	if(row[3]) strcpy(rkc.seq,         row[3]);
	if(row[4]) strcpy(rkc.columnName,  row[4]);
	if(row[5]) strcpy(rkc.collation,   row[5]);
	if(row[6])
	{
	   strcpy(rkc.cardinality, row[6]);
	}
	else
	{
	  strcpy(rkc.cardinality, "0");
	}
	if(row[7])
	{
	  strcpy(rkc.subPart, row[7]);
	}
	else
	{
	  strcpy(rkc.subPart, "0");
	}

        /* cree l'item dans la liste */
	rkp = (struct readkey *) calloc(1, sizeof(struct readkey));
	memcpy(rkp, &rkc, sizeof(struct readkey));
	if(!rkf)
	{
	  rkf = rkl = rkp;
	}
	else
	{
	  rkl->next = rkp;
	  rkl = rkp;
	}
	
      } /* endwhile fetchrow */

      mysql_free_result(result);
    }
    else
    {
      error = mysql_error(&connection);
      fl_show_alert(error, "Cannot retreive keys from", it->ct->table, 1);
    }
    mysql_close(&connection);
    
  }
  else
  {
    fl_show_alert("Cannot connect to database server","","", 1);
  }

  /*----------------------------------------------------------*/
  /* place les index dans la structure fields et compound key */
  /*----------------------------------------------------------*/
  altertable_setKeys(it, rkf);
  altertable_setKeys(it->alter, rkf);
  
  /*------------------------------------*/
  /* free la liste temporaire des clees */
  /*------------------------------------*/
  rkp = rkf;
  while(rkp)
  {
    rkf = rkf->next;
    free(rkp);
    rkp = rkf;
  }
}


/*-----------------------------------------------------*/
/* prend la liste readkeys (definition des index) et   */
/* place les index simples dans la liste des champs    */
/* place les index composes dans la liste de compounds */
/*-----------------------------------------------------*/
void altertable_setKeys(struct edittable *it, struct readkey *rkf)
{
  struct readkey *rkp;
  int indexc = 0;
  {
    struct readkey *courant;
    int qt;
    
    courant = rkf;
    while(courant)
    {
      indexc++;
      /*-------------------------------------------*/
      /* determine le nombre de parties de la clee */
      /*-------------------------------------------*/
      qt = 0;
      rkp = rkf;
      while(rkp)
      {
	if(!strcmp(rkp->keyName, courant->keyName))
	{
	  qt++;
	}
	rkp = rkp->next;
      }

      /*---------------------------------------------------------*/
      /* si une seule partie, place la clee dans la liste fields */
      /*---------------------------------------------------------*/
      if(qt == 1)
      {
	struct fields *fld;
	
	/* recherche le champ */
	fld = it->firstf;
	while(fld)
	{
	  if(!strcmp(fld->name, courant->columnName))
	  {
	    break;
	  }
	  fld = fld->next;
	}
	
	/* si le champ est trouve, ajoute index a l'element */
	if(fld)
	{
	  if(!strcmp(courant->keyName, "PRIMARY"))
	  {
	    fld->keyType = 'P';
	  }
	  else
	  {
	    if(courant->nonUnique[0] == '0')
	    {
	      fld->keyType = 'U';
	    }
	    else
	    {
	      fld->keyType = 'M';
	    }
	  }
	  
	  strcpy(fld->keyName, courant->keyName);
	  fld->keySize = atoi(courant->subPart);
	  if(!fld->keySize)
	  {
	    if(fld->type == 10 || fld->type == 11)
	    {
	      fld->keySize = (int) fld->length;
	    }
	  }
	} /* endif champ trouve */
	
      } /* endif qt == 1 */
      /*---------------------------------------------------------*/
      /* si plus d'une partie, place la clee dans les compounds  */
      /*---------------------------------------------------------*/
      if(qt > 1)
      {
	struct compoundkey *ck;
	
	/* cree la fiche header de compound */
	ck = (struct compoundkey *) calloc(1, sizeof(struct compoundkey));

	if(!strcmp(courant->keyName, "PRIMARY"))
	{
	  ck->type = 'P';
	}
	else
	{
	  if(courant->nonUnique[0] == '0')
	  {
	    ck->type = 'U';
	  }
	  else
	  {
	    ck->type = 'M';
	  }
	}
	  
	strcpy(ck->nom, courant->keyName);
	ck->index = indexc;
	
	if(!it->firstc)
	{
	  it->firstc = it->lastc = ck;
	}
	else
	{
	  it->lastc->next = ck;
	  ck->prev = it->lastc;
	  it->lastc = ck;
	}

	/*-----------------------------*/
      	/* cree les parties de la clef */
	/*-----------------------------*/
	{
	  int item;
	  struct partkey *pk;
	  
	  for(item = 0; item < qt; item++)
	  {
	    pk = (struct partkey *) calloc(1, sizeof(struct partkey));
	    strcpy(pk->nomField, courant->columnName);
	    pk->index = item + 1;
	    pk->size = atoi(courant->subPart);
	    if(!pk->size)
	    {
	      struct fields *fld;
	
	      /* recherche le champ */
	      fld = it->firstf;
	      while(fld)
	      {
		if(!strcmp(fld->name, courant->columnName))
		{
		  if(fld->type == 10 || fld->type == 11)
		  {
		    pk->size = (int) fld->length;
		  }
		  break;
		}
		fld = fld->next;
	      }
	    }
	    
	    if(!ck->first)
	    {
	      ck->first = ck->last = pk;
	    }
	    else
	    {
	      ck->last->next = pk;
	      pk->prev = ck->last;
	      ck->last = pk;
	    }
	    
	    if(item < qt - 1)
	    {
	      courant = courant->next;
	    }
	  } /* endfor scan de parties de la clef */
	} /* fin block cree les parties de la clef */
      } /* endif qt > 1 */
      
      courant = courant->next;
    } /* fin du scan readkey */
  } /* fin du placement des index */
}

/*-------------------------------------------------*/
/* efface les listes de champs et d'index composes */
/*-------------------------------------------------*/
void altertableFree(struct edittable *it)
{
  createtable_freeList(it);
  createtable_freeList(it->alter);
}

/*--------------------------------------*/
/* fonction appele au choix de database */
/*--------------------------------------*/
void altertable_init(struct edittable *it)
{
  altertableFree(it);

  /*---------------------------------------------------*/
  /* set le champ des choices par apport a la database */
  /*---------------------------------------------------*/
  if(it->ct->database[0])
  {
    fl_freeze_form(it->f_createtable->createtable);
    choice_getTables(it->f_createtable->tableToAlter, it->ct->database);
    fl_unfreeze_form(it->f_createtable->createtable);
  }

  createtable_setactive(it);
}

/*--------------------------------------------*/
/* appelee par le choix de la table           */
/* load les informations sur la table choisie */
/*--------------------------------------------*/
void createtable_tableToAlter(FL_OBJECT *obj, long data)
{
  struct edittable *it;
  FD_createtable *fd;
  fd = (FD_createtable *) obj->form->fdui;
  it = (struct edittable *) fd->vdata;

  if(fl_get_choice(obj) > 1)
  {
    altertableFree(it);
    strcpy(it->ct->table, fl_get_choice_text(obj));
    altertable_getColumns(it);
    altertable_getKeys(it);
    createtable_setCT(it);
    fl_freeze_form(it->f_createtable->createtable);
    createtable_setFieldBrowser(it);
    createtable_setactive(it);
    fl_unfreeze_form(it->f_createtable->createtable);
  }
}

/*----------------------------------*/
/* active par le bouton alter table */
/* compare l'ancienne definition    */
/* avec la nouvelle et fait les     */
/* changements appropries.          */
/*----------------------------------*/
void createtable_alter(FL_OBJECT *obj, long data)
{
   char *sql;
   struct edittable *it;
   FD_createtable *fd;
   fd = (FD_createtable *) obj->form->fdui;
   it = (struct edittable *) fd->vdata;

   it->fsql = it->lsql = NULL;
  
   sql = (char *) malloc(8192);
  
   /*----------------------------------------------------------------*/
   /* efface les clees modifies ou effacees dans la liste des champs */
   /*----------------------------------------------------------------*/
   {
      struct fields *fb, *fc;
    
      fb = it->alter->firstf;
      while(fb)
      {
	 fc = it->firstf;
	 while(fc)
	 {
	    if(fc->index == fb->index)
	    {
	       break;
	    }
	    fc = fc->next;
	 }

	 /*--------------------------------------------------------*/
	 /* item trouve, si clee exitait et changee efface la clef */
	 /*--------------------------------------------------------*/
	 if(fc)
	 {
	    if(fb->keyType && !fb->autoIncrement)
	    {
	       if(    fb->keyType != fc->keyType
		      || fb->keySize != fc->keySize
		      || strcmp(fb->keyName, fc->keyName))
	       {
		  if(fb->keyType != 'P')
		  {
		     sprintf(sql, "alter table %s drop index %s",
			     it->ct->table, fb->keyName);
		  }
		  else
		  {
		     sprintf(sql, "alter table %s drop primary key",
			     it->ct->table);
		  }
		  altertable_addSQL(it, sql);
	       }
	    }
	 }
      
	 fb = fb->next;
      }
   }

   /*------------------------------------------------------------------*/
   /* efface les clees modifies ou effacees dans la liste des compound */
   /*------------------------------------------------------------------*/
   {
      struct compoundkey *ckb, *ckc;
    
      ckb = it->alter->firstc;
      while(ckb)
      {
	 ckc = it->firstc;
	 while(ckc)
	 {
	    if(ckc->index == ckb->index)
	    {
	       break;
	    }
	    ckc = ckc->next;
	 }
      
	 /* si pas trouve la clef, efface l'ancienne */
	 if(!ckc)
	 {
	    if(ckb->type != 'P')
	    {
	       sprintf(sql, "alter table %s drop index %s",
		       it->ct->table, ckb->nom);
	    }
	    else
	    {
	       sprintf(sql, "alter table %s drop primary key",
		       it->ct->table);
	    }
	    altertable_addSQL(it, sql);
	 }
	 ckb = ckb->next;
      }
   }

   /*-----------------------------------*/
   /* efface les champs qui ont disparu */
   /*-----------------------------------*/
   {
      struct fields *fb, *fc;
    
      fb = it->alter->firstf;
      while(fb)
      {
	 fc = it->firstf;
	 while(fc)
	 {
	    if(fc->index == fb->index)
	    {
	       break;
	    }
	    fc = fc->next;
	 }

	 if(!fc)
	 {
	    sprintf(sql, "alter table %s drop column %s",
		    it->ct->table, fb->name);
	    altertable_addSQL(it, sql);
	 }
      
	 fb = fb->next;
      }
   }
  
   /*----------------------------------------*/
   /* change les champs qui ont ete modifies */
   /*----------------------------------------*/
   {
      struct fields *fb, *fc;
      int change;
    
      fb = it->alter->firstf;
      while(fb)
      {
	 change = 0;
	 fc = it->firstf;
	 while(fc)
	 {
	    if(fc->index == fb->index)
	    {
	       break;
	    }
	    fc = fc->next;
	 }

	 /* champ trouve, compare avec l'ancien */
	 if(fc)
	 {
	    char str[81];
	
	    if(    strcmp(fc->name,     fb->name)
		   || strcmp(fc->fdefault, fb->fdefault)
		   || fc->type          != fb->type
		   || fc->length        != fb->length
		   || fc->decimales     != fb->decimales
		   || fc->notNull       != fb->notNull
		   || fc->zeroFill      != fb->zeroFill
		   || fc->funsigned     != fb->funsigned
		   || fc->autoIncrement != fb->autoIncrement)
	    {
	       sprintf(sql, "alter table %s change column %s %s ",
		       it->ct->table, fb->name, fc->name);

	       /*****  type de champ *****/
	       strcat(sql, createtable_indexToType(fc->type));

	       /***** longueur du champ *****/
	       if(fc->type != 12 && fc->type != 13 && fc->type != 14 && fc->type != 15 /* blobs */
		  && fc->type != 17 && fc->type != 18 /* date and time */
		  && fc->type != 19 && fc->type != 20 && fc->type != 21 && fc->type != 22)
	       {
		  strcat(sql, "(");
		  sprintf(str, "%ld", fc->length);
		  strcat(sql,str);
	    
		  if(fc->decimales)
		  {
		     sprintf(str, ",%d) ",fc->decimales);
		     strcat(sql, str);
		  }
		  else
		  {
		     strcat(sql, ") ");
		  }
	       }
	       else
	       {
		  strcat(sql, " ");
	       }

	       /* definition pour enum et set */
	       if(fc->type == 19 || fc->type == 20)
	       {
		  int i = 0;
		  char *pt;
		  if(fc->fdefault[0])
		  {
		     strcat(sql, "(");
		     /* place les mots du champs defaut dans la liste enum ou set */
		     while((pt = getSSubstr(fc->fdefault, ",'() ", i)))
		     {
			if(!pt || pt[0] == '\0') break;
			i++;
			strcat(sql, "'");
			strcat(sql, pt);
			strcat(sql, "',");
		     }
		     sql[strlen(sql) - 1] = ')';
		     strcat(sql, " ");
		  }
	       }


	       /**** unsigned *****/
	       if(fc->funsigned)
	       {
		  strcat(sql, "unsigned ");
	       }

	       /***** zero fill *****/
	       if(fc->zeroFill)
	       {
		  strcat(sql, "zerofill ");
	       }

	       /***** null ou not null *****/
	       if(fc->notNull)
	       {
		  strcat(sql, "not null ");
	       }
	       else
	       {
		  strcat(sql, "null ");
	       }

	       /***** default, valeur par defaut du champ *****/
	       if(fc->fdefault[0] && fc->type != 19 && fc->type != 20)
	       {
		  strcat(sql, "default ");
		  strcat(sql, fc->fdefault);
		  strcat(sql, " ");
	       }

	       /***** si auto increment *****/
	       if(fc->autoIncrement)
	       {
		  strcat(sql, "auto_increment primary key");
	       }
	  
	       altertable_addSQL(it, sql);
	    } /* endif champs differents */
	 } /* endif champ correspondant trouve */
      
	 fb = fb->next;
      } /* fin scan des champs a possiblement modifier */
   } /* fin changement des champs */
  
   /*----------------------------*/
   /* ajoute les nouveaux champs */
   /*----------------------------*/
   {
      struct fields *fc;
    
      fc = it->firstf;
      while(fc)
      {
	 if(fc->index == 1000)
	 {
	    char str[81];
	
	    sprintf(sql, "alter table %s add column %s ",
		    it->ct->table, fc->name);

	    /*****  type de champ *****/
	    strcat(sql, createtable_indexToType(fc->type));

	    /***** longueur du champ *****/
	    if(fc->type != 12 && fc->type != 13 && fc->type != 14 && fc->type != 15 /* blobs */
	       && fc->type != 17 && fc->type != 18 /* date and time */
	       && fc->type != 19 && fc->type != 20 && fc->type != 21 && fc->type != 22)
	    {
	       strcat(sql, "(");
	       sprintf(str, "%ld", fc->length);
	       strcat(sql,str);
	  
	       if(fc->decimales)
	       {
		  sprintf(str, ",%d) ",fc->decimales);
		  strcat(sql, str);
	       }
	       else
	       {
		  strcat(sql, ") ");
	       }
	    }
	    else
	    {
	       strcat(sql, " ");
	    }

	    /* definition pour enum et set */
	    if(fc->fdefault[0] && (fc->type == 19 || fc->type == 20))
	    {
	       int i = 0;
	       char *pt;

	       strcat(sql, "(");
	       /* place les mots du champs defaut dans la liste enum ou set */
	       while((pt = getSSubstr(fc->fdefault, ",'() ", i)))
	       {
		  if(!pt || pt[0] == '\0') break;
		  i++;
		  strcat(sql, "'");
		  strcat(sql, pt);
		  strcat(sql, "',");
	       }
	       sql[strlen(sql) - 1] = ')';
	       strcat(sql, " ");
	    }

	    /**** unsigned *****/
	    if(fc->funsigned)
	    {
	       strcat(sql, "unsigned ");
	    }

	    /***** zero fill *****/
	    if(fc->zeroFill)
	    {
	       strcat(sql, "zerofill ");
	    }

	    /***** null ou not null *****/
	    if(fc->notNull)
	    {
	       strcat(sql, "not null ");
	    }
	    else
	    {
	       strcat(sql, "null ");
	    }

	    /***** default, valeur par defaut du champ *****/
	    if(fc->fdefault[0] && fc->type != 19 && fc->type != 20)
	    {
	       strcat(sql, "default ");
	       strcat(sql, fc->fdefault);
	       strcat(sql, " ");
	    }

	    /***** si auto increment *****/
	    if(fc->autoIncrement)
	    {
	       strcat(sql, "auto_increment primary key");
	    }
	  
	    altertable_addSQL(it, sql);
	 } /* endif index = 1000 */
      
	 fc = fc->next;
      } /* fin scan des champs a ajouter */
   } /* fin ajout des champs */
  
   /*--------------------------*/  
   /* ajout les index modifies */
   /*--------------------------*/  
   {
      struct fields *fb, *fc;
    
      fb = it->alter->firstf;
      while(fb)
      {
	 fc = it->firstf;
	 while(fc)
	 {
	    if(fc->index == fb->index)
	    {
	       break;
	    }
	    fc = fc->next;
	 }

	 /*--------------------------------------------------------*/
	 /* item trouve, si clee exitait et changee efface la clef */
	 /*--------------------------------------------------------*/
	 if(fc && fc->keyType && !fc->autoIncrement)
	 {
	    if(    fb->keyType != fc->keyType
		   || fb->keySize != fc->keySize
		   || strcmp(fb->keyName, fc->keyName))
	    {
	       char str[81];
	  
	       sprintf(sql, "alter table %s add ", it->ct->table);
	       if(fc->keyType == 'M')
	       {
		  strcat(sql, "index ");
	       }
	       else
	       {
		  if(fc->keyType == 'U')
		  {
		     strcat(sql, "unique ");
		  }
		  else
		  {
		     if(fc->keyType == 'P')
		     {
			strcat(sql, "primary key ");
		     }
		  }		
	       }

	       if(fc->keyType != 'P')
	       {
		  strcat(sql, fc->keyName);
	       }
	       strcat(sql, "(");
	       strcat(sql, fc->name);
	       if(fc->keySize)
	       {
		  sprintf(str, "(%d)) ", fc->keySize);
		  strcat(sql, str);
	       }
	       else
	       {
		  strcat(sql, ") ");
	       }

	       altertable_addSQL(it, sql);
	    }
	 }
      
	 fb = fb->next;
      }
   }

   /*--------------------------*/  
   /* ajout les nouveaux index */
   /*--------------------------*/  
   {
      struct fields *fc;
    
      fc = it->firstf;
      while(fc)
      {
	 if(fc->index == 1000 && fc->keyType && !fc->autoIncrement)
	 {
	    char str[81];
	  
	    sprintf(sql, "alter table %s add ", it->ct->table);
	    if(fc->keyType == 'M')
	    {
	       strcat(sql, "index ");
	    }
	    else
	    {
	       if(fc->keyType == 'U')
	       {
		  strcat(sql, "unique ");
	       }
	       else
	       {
		  if(fc->keyType == 'P')
		  {
		     strcat(sql, "primary key ");
		  }
	       }
	    }

	    if(fc->keyType != 'P')
	    {
	       strcat(sql, fc->keyName);
	    }
	    strcat(sql, "(");
	    strcat(sql, fc->name);
	    if(fc->keySize)
	    {
	       sprintf(str, "(%d)) ", fc->keySize);
	       strcat(sql, str);
	    }
	    else
	    {
	       strcat(sql, ") ");
	    }

	    altertable_addSQL(it, sql);
	 }
	 fc = fc->next;
      }
   }

   /*---------------------------*/
   /* ajoute les compounds keys */
   /*---------------------------*/
   {
      struct compoundkey *ckc;
    
      ckc = it->firstc;
      while(ckc)
      {
	 if(ckc->index == 1000)
	 {
	    struct partkey *pk;
	    int qt;
	    struct fields *fd;
    
	    /* verifie si au moins deux champs dans les parties */
	    qt = 0;
	    pk = ckc->first;
	    while(pk)
	    {
	       qt++;
	       pk = pk->next;
	    }
      
	    /* si compound key valide */
	    if(qt > 1)
	    {
	       char str[81];
	       sprintf(sql, "alter table %s add ",it->ct->table);

	       if(ckc->type == 'P')
	       {
		  strcat(sql, "primary key ");
	       }
	       else
	       {
		  if(ckc->type == 'U') /* index unique */
		  {
		     strcat(sql, "unique ");
		  }
		  else
		  {
		     strcat(sql, "index ");
		  }
	       }

	       if(ckc->type != 'P')
	       {
		  strcat(sql, ckc->nom);
	       }
	       strcat(sql, "(");
      
	       pk = ckc->first;
	       while(pk)
	       {
		  strcat(sql, pk->nomField);
		  fd = ccomkey_fieldIndex(it, pk->nomField);

		  if(pk->size && pk->size != (int) fd->length )
		  {
		     sprintf(str, "(%d)", pk->size);
		     strcat(sql, str);
		  }
		  if(pk->next)
		  {
		     strcat(sql, ",");
		  }
		  pk = pk->next;
	       }
	       strcat(sql, ")");
	       altertable_addSQL(it, sql);
	    } /* endif qt > 1 */
	 } /* fin index == 1000 */
	 ckc = ckc->next;
      } /* fin scan liste des compounds */
   } /* fin d'ajout de compound keys */
    
   free(sql);
   altertable_execSQL(it);
}


/*---------------------------------------*/
/* ajoute une commande sql dans la liste */
/*---------------------------------------*/
void altertable_addSQL(struct edittable *it, char *sql)
{
  struct sqlcommands *cur;

  cur = (struct sqlcommands *) calloc(1, sizeof(struct sqlcommands));
  
  if(!it->fsql)
  {
    it->fsql = it->lsql = cur;
  }
  else
  {
    it->lsql->next = cur;
    it->lsql = cur;
  }
  
  cur->sql = (char *) malloc(strlen(sql) + 1);
  strcpy(cur->sql, sql);
}

/*------------------------------------------------*/
/* efface de la memoire la liste de commandes sql */
/*------------------------------------------------*/
void altertable_freeSQL(struct edittable *it)
{
  struct sqlcommands *cur;
  cur = it->fsql;
  while(cur)
  {
    it->fsql = it->fsql->next;
    if(cur->sql)
    {
      free(cur->sql);
    }
    free(cur);
    cur = it->fsql;
  }
  it->fsql = it->lsql = NULL;
}

/*---------------------------------------*/
/* affiche la liste des commandes sql et */
/* demande confirmation avant d'executer */
/*---------------------------------------*/
void altertable_execSQL(struct edittable *it)
{
  struct sqlcommands *cur;
  char str[41];
  if(!it->fsql)
  {
    return;
  }
  
  /*----------------------------------------------------*/
  /* affiche la liste des commandes dans le command log */
  /*----------------------------------------------------*/
  fl_clear_command_log();
  cur = it->fsql;
  while(cur)
  {
    fl_addto_command_log(cur->sql);
    fl_addto_command_log("\n");
    cur = cur->next;
  }
  fl_show_command_log(FL_TRANSIENT);

  /*----------------------------------------*/
  /* demande a l'usager s'il veut continuer */
  /*----------------------------------------*/
  if(fl_show_question("This will alter the table.\nDo you really want to execute these commands?", 0))
  {
    /*------------------------------------------------------*/
    /* altere la table en envoyant les commandes au serveur */
    /*------------------------------------------------------*/
    MYSQL connection;
    fl_addto_command_log("\n");
    fl_addto_command_log("\n");
    fl_addto_command_log("Connecting to server...");
    if(g_mysql_connect(&connection, Setup.host, Setup.user, Setup.password))
    {
      MYSQL_RES *result;
      char *error;
      
      fl_addto_command_log(" OK\n");
      mysql_select_db(&connection, it->ct->database);
      fl_addto_command_log("Database \"");
      fl_addto_command_log(it->ct->database);
      fl_addto_command_log("\" selected...\n\n");

      cur = it->fsql;
      while(cur)
      {
	fl_addto_command_log("Executing \"");
	fl_addto_command_log(cur->sql);
	fl_addto_command_log("\" -> ");
	if(!mysql_query(&connection, cur->sql))
	{
	  fl_addto_command_log(" OK\n");
	  result = mysql_store_result(&connection);
	  sprintf(str, "%ld row(s) affected\n\n", 
		  (long) mysql_affected_rows(&connection));
	  fl_addto_command_log(str);
	  mysql_free_result(result);
	}
	else
	{
	  error = mysql_error(&connection);
	  fl_addto_command_log(" * ERROR *\n");
	  fl_addto_command_log(error);
	  fl_addto_command_log("\n\n");
	}
	cur = cur->next;
      }
      mysql_close(&connection);
      fl_addto_command_log("Connection closed.\n");
    }

    createtable_tableToAlter(it->f_createtable->tableToAlter, 0L);
  }
  
  altertable_freeSQL(it);
  
  
}

void main_altertable(FL_OBJECT *obj, long data)
{
  main_createtable(obj, 1000L);
}
