#include "udm_config.h"

#include <stdio.h>
#include <stdlib.h>

#include "udm_common.h"
#include "udm_socket.h"
#include "udm_host.h"
#include "udm_utils.h"
#include "udm_xmalloc.h"
#include "udm_http.h"


int http_connect(UDM_CONN *connp, char *hostname, int port, int timeout){
	int len;
    
        if (!connp)
                return -1;

        if (!hostname)
    		return -1;

	if (!port)
		return -1;
	connp->port = port;
	connp->timeout = timeout;

        len = strlen(hostname);
        connp->hostname = UdmXrealloc(connp->hostname, len+1);
        udm_snprintf(connp->hostname, len+1, "%s", hostname);

        if (host_lookup(connp))
                return -1;

        if (socket_open(connp))
                return -1;

        if (socket_connect(connp))
                return -1;
					        				
	return 0;
}
