#ifndef _UDM_COMMON_H
#define _UDM_COMMON_H

#include "udm_os.h"
#include <time.h>
#include <netinet/in.h>
#include "udm_crc32.h"

/* Some constants */
#define UDM_LANGPERDOC		16
#define UDM_URLSIZE		127
#define UDM_USER_AGENT		"UdmSearch"


/* Locking consts */
#define UDM_LOCK		1
#define UDM_UNLOCK		2
#define UDM_LOCK_USER		0
#define UDM_LOCK_MEXUSER	15
#define UDM_LOCK_ROBOTS		16
#define UDM_LOCK_QUERY		17
#define UDM_LOCK_TARGET		18
#define UDM_LOCK_RESOLVE	19
#define UDM_LOCK_MAX		19


/* storage types */
#define UDM_DBMODE_SINGLE	0
#define UDM_DBMODE_MULTI	1
#define UDM_DBMODE_SINGLE_CRC	2
#define UDM_DBMODE_WORD2URL	3
#define UDM_DBMODE_MULTI_CRC	4


/* database open modes */
#define UDM_OPEN_MODE_READ	0
#define UDM_OPEN_MODE_WRITE	1


/* search modes */
#define UDM_ORD_RATE		1
#define UDM_ORD_DATE		2
#define UDM_MOD_ALL		1
#define UDM_MOD_ANY		2


/* Indexer return codes */
#define IND_UNKNOWN		0
#define IND_OK			1
#define IND_ERROR		2
#define IND_NO_TARGET		3
#define IND_TERMINATED		4


/* Flags for indexing */
#define UDM_FLAG_REINDEX	1
#define UDM_FLAG_EXP_FIRST	2
#define UDM_FLAG_ADD_SERV	4
#define UDM_FLAG_MARK		8
#define UDM_FLAG_SPELL		16
#define UDM_FLAG_INSERT		32
#define UDM_FLAG_SORT_HOPS	64
#define UDM_FLAG_INIT		128
#define UDM_FLAG_SKIP_LOCKING	256

/* Tracking modes */
#define UDM_TRACK_QUERIES	1
#define UDM_TRACK_WORDS		2


/* URLFile actions */
#define UDM_URL_FILE_REINDEX	1
#define UDM_URL_FILE_CLEAR	2
#define UDM_URL_FILE_INSERT	3
#define UDM_URL_FILE_PARSE	4

/* Ispell modes */
#define UDM_ISPELL_MODE_TEXT	0
#define UDM_ISPELL_MODE_DB	1

/* UdmSearch types */

/* StopList unit */
typedef struct udm_stopword_struct {
	char *word;
	char lang[3];
} UDM_STOPWORD;


/* Word list unit */
typedef struct udm_word_struct {
	int count;
	char *word;
} UDM_WORD;


/* Language quesser structure for one language   */
/* We could use the type above instead of course */
typedef struct udm_lang_struct {
	int  count;
	char lang[3];
} UDM_LANG;


/* Structure to store server parameters */
typedef struct udm_server_struct {
	char *url;
	char *charset;
	char *proxy;
	char *basic_auth;
        char *user;
        char *passwd;
	char *htdb_list;
	char *htdb_doc;
	char *category;
	char *tag;
	int  proxy_port;
	int  period;
	int  net_errors;
	int  max_net_errors;
	int  read_timeout;
	int  outside;
	int  delete_no_server;
	int  maxhops;
	int  gindex;
	int  gfollow;
	int  deletebad;
	int  userobots;
	int  use_mirror;
	int  use_clones;
	int  bodyweight;
	int  titleweight;	
	int  urlweight;
	int  urlhostweight;
	int  urlpathweight;
	int  urlfileweight;
	int  descweight;
	int  keywordweight;
	int  correct_factor;
	int  incorrect_factor;
	int  number_factor;
	int  alnum_factor;
	int  min_word_length;
	int  max_word_length;
} UDM_SERVER;


/* All components in this structure correspondent */
/* to fields in the "url" table                   */

typedef struct udm_url_struct {
	int	url_id;
	int	status;
	int	size;
	int	rating;
	int	referrer;
	int	tag;
	int	hops;
	int	indexed; /* for own backend */
	char	*url;
	char	*content_type;
	time_t	last_mod_time;
	char	*title;
	char 	*text;
	char	*last_index_time;
	char	*next_index_time;
	char	*keywords;
	char	*description;
	udmcrc32_t	crc32;
	char	*category;
} UDM_DOCUMENT;

typedef struct udm_conn_struct {
        int status;
        int connected;
        int err;
        int retry;
        int conn_fd;
        int port;
        int timeout;
        char *hostname;
        FILE *in, *out;
        struct sockaddr_in sin;
        int buf_len;
        int buf_len_total;
        int len;
        char *buf;
        struct udm_conn_struct *connp;
        struct udm_indexer_struct *indexer;
} UDM_CONN;


/* Indexer */
typedef struct udm_indexer_struct{
	int handle;		/* Indexer handle for multithreaded version */
	int mwords;		/* Number of memory allocated for words     */
	int nwords;		/* Real number of words in list             */
	int swords;		/* Number of words in sorted list           */
	UDM_WORD *Word;		/* Word list  itself                        */
	int DBError;	
	int action;		/* Callback function may request action     */
	char state[128];	/* Currently unused                         */
        int buf_size;		/* Currently unused                         */
	char *buf;		/* Buffer for document                      */
	char *charset;		/* Charset string is stored here            */
	void * db;              /* Database handle                          */
	int local_charset;
	UDM_LANG lang[UDM_LANGPERDOC]; /* language guesser variable         */
	UDM_CONN *connp;
} UDM_INDEXER;


typedef struct udm_url {
	char schema[UDM_URLSIZE];
	char specific[UDM_URLSIZE];
	char hostinfo[UDM_URLSIZE];
	char auth[UDM_URLSIZE];
	char hostname[UDM_URLSIZE];
	char path[UDM_URLSIZE];
	char filename[UDM_URLSIZE];
	char anchor[UDM_URLSIZE];
	int  port;
} UDM_URL;


typedef struct udm_tag {
	char *tag;
	char *href;
	char *src;
	char *content;
	char *value;
	char *selected;
	char *name;
	char *type;
} UDM_TAG;


typedef struct udm_robots_struct {
	char *hostinfo;
	char *path;
} UDM_ROBOT;

typedef struct udm_cat {
	int   rec_id;
	char  path[128];
	char  link[128];
	char  name[128];
} UDM_CATEGORY;

#endif
