/**
*** Program jdbcMysqlField.java
***    in product twz1jdbcForMysql, 
***    Copyright 1997, 1998 by Terrence W. Zellers.
***   
***  All rights explicitly reserved.
***
***  See file "LICENSE" in this package for conditions of use.
**/


package twz1.jdbc.mysql;

final class jdbcMysqlField
{
/** column number (here beginning at zero */
int columnNumber;

/** Catalog name */
String catalog;

/** The table name */
String table;

/** The columnname */
String column;

/** Is column name unique */
boolean cunique;

/** Field type */
int ctype;

/** Field size. */
int size;


/** flags */
int cflags;

/** decimals */
int decimals; 


static final int NOT_NULL_FLAG          = 1;		
static final int PRI_KEY_FLAG           = 2;		
static final int UNIQUE_KEY_FLAG        = 4;		
static final int MULTIPLE_KEY_FLAG      = 8;		
static final int BLOB_FLAG              = 16;		
static final int UNSIGNED_FLAG          = 32;		
static final int ZEROFILL_FLAG          = 64;		
static final int BINARY_FLAG            = 128;
static final int ENUM_FLAG              = 256;
static final int PART_KEY_FLAG          = 512;	
static final int GROUP_FLAG             = 1024;	

static final int FIELD_TYPE_DECIMAL     = 0;
static final int FIELD_TYPE_TINY        = 1;
static final int FIELD_TYPE_CHAR        = 1;
static final int FIELD_TYPE_SHORT       = 2;
static final int FIELD_TYPE_LONG        = 3;
static final int FIELD_TYPE_FLOAT       = 4;
static final int FIELD_TYPE_DOUBLE      = 5; 
static final int FIELD_TYPE_NULL        = 6;
static final int FIELD_TYPE_TIMESTAMP   = 7;
static final int FIELD_TYPE_LONGLONG    = 8;
static final int FIELD_TYPE_INT24       = 9;
static final int FIELD_TYPE_DATE        = 10;   
static final int FIELD_TYPE_TIME        = 11;
static final int FIELD_TYPE_DATETIME    = 12;
static final int FIELD_TYPE_ENUM        = 247;
static final int FIELD_TYPE_INTERVAL    = 247; 
static final int FIELD_TYPE_SET         = 248;
static final int FIELD_TYPE_TINY_BLOB   = 249;
static final int FIELD_TYPE_MEDIUM_BLOB = 250;
static final int FIELD_TYPE_LONG_BLOB   = 251;
static final int FIELD_TYPE_BLOB        = 252;
static final int FIELD_TYPE_VAR_STRING  = 253;
static final int FIELD_TYPE_STRING      = 254;

jdbcMysqlField( int n)
    {
    this.columnNumber = n;
    this.table = null;
    this.column = null;
    this.cunique = true;
    this.ctype = 0;
    this.size = 255;
    this.cflags = 0;
    this.decimals = 0;
    }

int getColumnNumber() { return columnNumber; }
String getColumnCatalog() { return catalog; }
String getColumnTable() { return table; }
String getColumnName() { return column; }
boolean isNameUnique() { return cunique; }
int getColumnType() { return ctype; }
int getColumnSize() { return size; }
int getColumnFlags() { return cflags; }
int getColumnDecimals() { return decimals; }
void setColumnCatalog(String c) { catalog = c; }
void setColumnTable(String t) { table = t; }
void setColumnName(String n) { column = n; }
void setColumnType(int t) { ctype = t; }
void setColumnSize(int s) { size = s; }
void setColumnFlags(int t) { cflags = t; }
void setColumnDecimals(int t) { decimals = t; }
void setNameUnique(boolean v) { cunique = v; }
}
