/*
 * Decompiled with CFR 0.152.
 */
package twz1.jdbc.mysql;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Calendar;
import twz1.jdbc.mysql.jdbcMysqlBase;
import twz1.jdbc.mysql.jdbcMysqlDumpBuffer;
import twz1.jdbc.mysql.jdbcMysqlMutex;

final class jdbcMysqlDebug {
    private PrintWriter dfile;
    private String fileName;
    jdbcMysqlMutex guard;
    int myOID;
    private static final String hexlist = "0123456789abcdef";
    private static final String printable = "01234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ`~!@#$%^&*()_-+=[]{};:\"',.<>?/|\"\\ ";

    jdbcMysqlDebug(String string) {
        this.fileName = string;
        this.myOID = ++jdbcMysqlBase.xoid;
        this.guard = new jdbcMysqlMutex();
        this.open();
        Calendar calendar = Calendar.getInstance();
        String string2 = new String(String.valueOf(calendar.get(1)) + "/" + calendar.get(2) + "/" + calendar.get(5) + " " + calendar.get(10) + ":" + calendar.get(12) + ":" + calendar.get(13));
        this.iPut("------------------ Debug " + string2 + " -----------------");
        if (this.dfile != null) {
            this.dfile.close();
            this.open();
        }
    }

    public void put(String string) {
        this.guard.synch(this.myOID, true, 120);
        this.iPut(string);
        this.guard.synch(this.myOID, false, 120);
    }

    private void iPut(String string) {
        try {
            if (this.dfile != null) {
                this.dfile.println(string);
                return;
            }
        }
        catch (Exception exception) {}
    }

    public void put(String string, jdbcMysqlDumpBuffer jdbcMysqlDumpBuffer2) {
        jdbcMysqlDumpBuffer2.dumpBuffer.addElement(string);
    }

    public void put(jdbcMysqlDumpBuffer jdbcMysqlDumpBuffer2) {
        this.guard.synch(this.myOID, true, 120);
        try {
            this.iPut(jdbcMysqlDumpBuffer2);
        }
        catch (Exception exception) {}
        this.guard.synch(this.myOID, false, 120);
    }

    private void iPut(jdbcMysqlDumpBuffer jdbcMysqlDumpBuffer2) {
        String string = jdbcMysqlDumpBuffer2.get();
        while (string != null) {
            this.iPut(string);
            string = jdbcMysqlDumpBuffer2.get();
        }
        if (this.dfile != null) {
            this.dfile.close();
            this.open();
        }
    }

    public void flush() {
        this.guard.synch(this.myOID, true, 120);
        if (this.dfile != null) {
            this.dfile.close();
            this.open();
        }
        this.guard.synch(this.myOID, false, 120);
    }

    private void iFlush() {
        if (this.dfile == null) {
            return;
        }
        this.dfile.close();
        this.open();
    }

    private void open() {
        if (this.fileName != null) {
            try {
                this.dfile = new PrintWriter(new FileOutputStream(this.fileName, true));
                return;
            }
            catch (IOException iOException) {
                this.dfile = null;
                this.fileName = null;
                return;
            }
        }
    }

    public void dump(byte[] byArray, int n, int n2) {
        this.guard.synch(this.myOID, true, 120);
        try {
            this.iDump(byArray, n, n2, null);
        }
        catch (Exception exception) {}
        this.guard.synch(this.myOID, false, 120);
    }

    public void dump(byte[] byArray, int n, int n2, jdbcMysqlDumpBuffer jdbcMysqlDumpBuffer2) {
        if (jdbcMysqlDumpBuffer2 == null) {
            return;
        }
        try {
            this.iDump(byArray, n, n2, jdbcMysqlDumpBuffer2);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private void iDump(byte[] byArray, int n, int n2, jdbcMysqlDumpBuffer jdbcMysqlDumpBuffer2) {
        jdbcMysqlDumpBuffer jdbcMysqlDumpBuffer3 = jdbcMysqlDumpBuffer2 == null ? new jdbcMysqlDumpBuffer() : jdbcMysqlDumpBuffer2;
        int n3 = n2;
        int n4 = n;
        while (n3 > 0) {
            String string = new String("........" + n4);
            String string2 = string.substring(string.length() - 8, string.length());
            StringBuffer stringBuffer = new StringBuffer(48);
            StringBuffer stringBuffer2 = new StringBuffer(18);
            stringBuffer2.append('|');
            int n5 = 0;
            while (n5 < 16) {
                if (n3 > 0) {
                    int n6 = byArray[n4];
                    if (n6 < 0) {
                        n6 += 256;
                    }
                    int n7 = (n6 & 0xF0) >> 4;
                    stringBuffer.append(hexlist.charAt(n7));
                    n7 = n6 & 0xF;
                    stringBuffer.append(hexlist.charAt(n7));
                    stringBuffer.append(' ');
                    if (printable.indexOf(n6) > -1) {
                        stringBuffer2.append((char)n6);
                    } else {
                        stringBuffer2.append('.');
                    }
                } else {
                    stringBuffer.append(' ').append(' ').append(' ');
                    stringBuffer2.append(' ');
                }
                ++n4;
                --n3;
                ++n5;
            }
            stringBuffer2.append('|');
            String string3 = new String(stringBuffer);
            String string4 = new String(stringBuffer2);
            String string5 = String.valueOf(string2) + " " + string3 + " " + string4;
            jdbcMysqlDumpBuffer3.dumpBuffer.addElement(string5);
        }
        if (jdbcMysqlDumpBuffer2 == null) {
            this.iPut(jdbcMysqlDumpBuffer3);
        }
    }

    protected void finalize() {
        if (this.dfile != null) {
            this.dfile.close();
        }
    }
}

