/*****************************************************************************/
/*                                                                           */
/*                                 PASSWORD.C                                */
/*                                                                           */
/*                   password routines for mypasswd/mygroup                  */
/*                                                                           */
/*****************************************************************************/


#include <sys/types.h>
#include <sys/signal.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>

#include "mypasswd.h"


/* convert 0..63 => ascii - 64 */
void to64(register char *s, register long v, register int n)
{
static unsigned char itoa64[] =
   "./0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";

  while (--n >= 0) 
  {
    *s++ = itoa64[v&0x3f];
    v >>= 6;
   }
}


/* check if password is legal depending on enctype */
Flag checkPassword(const char *password, Flag enctype)
{
  if (password != NULL)
  {
    if (enctype == SCRAMBLED)
    {
      if (strspn(password, "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
                           "abcdefghijklmnopqrstuvwxyz"
                           "01234567890") == strlen(password))
        return(TRUE);
    }
    else
      return(TRUE);
  }
  return(FALSE);
}


/* encrypt password depending on enctype */
char *encryptPassword(char *crypted, const char *plaintext, Flag enctype)
{
  if ((crypted != NULL) && (plaintext != NULL))
  {
    if (enctype == SCRAMBLED)
    {
      make_scrambled_password(crypted, plaintext); 
    }
    else
    {
    char salt[3];
 
      srand((int) time(NULL));

      to64(&salt[0], rand(), 2);

      strcpy(crypted, crypt(plaintext, salt));
    } 
    return(crypted); 
  }
  return(NULL);
}


