/*****************************************************************************/
/*                                                                           */
/*                                 MYPASSWD.H                                */
/*                                                                           */
/*             set password/group membershif for mysql databases             */
/*                                                                           */
/*****************************************************************************/


#if !defined(__MYPASSWD_H)
#define __MYPASSWD_H

#define dSQLBuffer	2048

/* boolean values */
#if !defined(FALSE)
# define FALSE		0
# define TRUE		(!FALSE)
#endif
 
/* encryption type */
#define CRYPTED		1
#define SCRAMBLED	2

/* boolean type (kind of) */
typedef int	Flag;


/* functions from password.c */
char *crypt(const char *pw, const char *salt);
void to64(register char *s, register long v, register int n);
Flag checkPassword(const char *password, Flag enctype);
char *encryptPassword(char *crypted, const char *plaintext, Flag enctype);

/* functions from database.c */
Flag openDatabase(char *host, char *db, char *auth_user, char *auth_password);
Flag closeDatabase(void);
char *DatabaseError(void);
Flag SetEntry(char *table, char *userfield, char *otherfield, char *username, char *othername);
Flag DeleteEntry(char *table, char *userfield, char *otherfield, char *username, char *othername);

extern int verbose;

#endif /* !defined(__MYPASSWD_H) */
