/////////////////////////////////////////////////////////////////////
//
// CFX_MYDSN - Cold Fusion custom tag
//
// Copyright 2000. All Rights Reserved.
//
//


#include "stdafx.h"		// Standard MFC libraries
#include "afxpriv.h"	// MFC Unicode conversion macros
#include "cfx.h"		// CFX Custom Tag API
#include <windows.h>
#include <sql.h>
#include <sqlext.h>
#include <odbcinst.h>
#include <string.h>

// Constants
#define TAG_ERROR_HEADER	"Error occurred in tag CFX_MYDSN"

void AddMyDSN( CCFXRequest* pRequest ) ;
void RemoveMyDSN( CCFXRequest* pRequest ) ;

LPCSTR GetRequiredAttribute( CCFXRequest* pRequest, LPCSTR lpszParamName ) ;

/**************************************************************/

void ProcessTagRequest( CCFXRequest* pRequest ) 
{
    DWORD  returnValue;
    HKEY   registryKey;
	

	returnValue = RegOpenKeyEx (HKEY_LOCAL_MACHINE, "Software\\ODBC\\ODBCINST.INI\\MySQL", 0, KEY_ALL_ACCESS, &registryKey);

	try
	{
		
		CString strAction = GetRequiredAttribute( pRequest, "ACTION" ) ;
		if ( !strAction.CompareNoCase( "ADD" ) )
			AddMyDSN( pRequest ) ;
		else if ( !strAction.CompareNoCase( "REMOVE" ) )
           RemoveMyDSN( pRequest ) ;
		else if (returnValue != ERROR_SUCCESS)
		{
           	CString strErr =
				"The MyODBC driver isn't installed." ;
			pRequest->ThrowException( 
				TAG_ERROR_HEADER, strErr ) ;
		}
		else
		{
			CString strErr =
				"An invalid ACTION attribute (" + strAction + ") "
				"was specified. Valid attributes are ADD and REMOVE." ;
			pRequest->ThrowException( 
				TAG_ERROR_HEADER, strErr ) ;
		}		
	}

	// Catch Cold Fusion exceptions & re-raise them
	catch( CCFXException* e )
	{
		pRequest->ReThrowException( e ) ;
	}
	
	// Catch ALL other exceptions and throw them as 
	// Cold Fusion exceptions (DO NOT REMOVE! -- 
	// this prevents the server from crashing in 
	// case of an unexpected exception)
	catch( ... )
	{
		pRequest->ThrowException( 
			"Error occurred in tag CFX_MYDSN",
			"Unexpected error occurred while processing tag." ) ;
	}
}
/********************************************************************/
void RemoveMyDSN( CCFXRequest* pRequest )
{
  char	*MyDriver= "MySQL";
  // Get attribute values
  CString strDSN = GetRequiredAttribute( pRequest, "DSN" );
  strDSN+= '\0';
  
  
  SQLConfigDataSource( 
			NULL,
			ODBC_REMOVE_SYS_DSN,
			MyDriver, 
			strDSN );
  
}
/********************************************************************/
void AddMyDSN( CCFXRequest* pRequest )
{
  char	*MyDriver= "MySQL";
  // Get attribute values
  CString strDSN = GetRequiredAttribute( pRequest, "DSN" );
  strDSN+= '\0';
  strDSN+= GetRequiredAttribute( pRequest, "SERVER" );
  strDSN+= '\0';
  strDSN+= GetRequiredAttribute( pRequest, "DATABASE" );
  strDSN+= '\0';
  strDSN+= GetRequiredAttribute( pRequest, "USERNAME" );
  strDSN+= '\0';
  strDSN+= GetRequiredAttribute( pRequest, "PASSWORD" );
  strDSN+= '\0';
  strDSN+= GetRequiredAttribute( pRequest, "PORT" );
  strDSN+= '\0';
  strDSN+= GetRequiredAttribute( pRequest, "OPTION" );
  strDSN+= '\0';
  
  SQLConfigDataSource( 
			NULL,
			ODBC_REMOVE_SYS_DSN,
			MyDriver, 
			strDSN );
  if( ! SQLConfigDataSource(
			NULL,
			ODBC_ADD_SYS_DSN,
			MyDriver,
			strDSN) )
  {
    CString strErr =
				"There is a problem to create the DSN file." ;
			pRequest->ThrowException( 
				TAG_ERROR_HEADER, strErr ) ;

  }

}
/****************************************************************/
LPCSTR GetRequiredAttribute( CCFXRequest* pRequest, LPCSTR lpszAttribName ) 
{
	// Verify that the attribute exists (throw an exception
	// if it does not)
	if ( !pRequest->AttributeExists(lpszAttribName) )
	{
		CString strErr = 
			"The required attribute " + CString(lpszAttribName) +
			" was not passed to the tag. " ;
		pRequest->ThrowException( TAG_ERROR_HEADER, strErr ) ;	
	}

	// Return the attribute
	return pRequest->GetAttribute( lpszAttribName ) ;	
}

