#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <regex.h>
#include <string.h>

#include "udm_config.h"
#include "udm_common.h"
#include "udm_utils.h"
#include "udm_filter.h"
#include "udm_xmalloc.h"

/************ Allow/Disallow/CheckOnly  stuff *****************/

typedef struct filter_struct {
	regex_t filter;
	int     filter_type;
	int	flags;
	char	*regstr;
} UDM_FILTER;


__INDLIB__ int UdmAddFilter(UDM_ENV * Conf,char * filter,int filter_type,int flags){
#define ERRSTRSIZE 100
	char regerrstr[UDMSTRSIZ]="";
	int err;
	UDM_FILTER * Filter;

	if(Conf->nfilters>=Conf->mfilters){
		if(Conf->mfilters){
			Conf->mfilters+=16;
			Conf->Filter=(UDM_FILTER *)UdmXrealloc(Conf->Filter,Conf->mfilters*sizeof(UDM_FILTER));
		}else{
			Conf->mfilters=16;
			Conf->Filter=(UDM_FILTER *)UdmXmalloc(Conf->mfilters*sizeof(UDM_FILTER));
		}
	}
	Filter=(UDM_FILTER*)Conf->Filter;
	if(flags&UDM_FILTER_REGEX){
		if(flags&UDM_FILTER_CS){
			err=regcomp(&(Filter[Conf->nfilters].filter),filter,REG_EXTENDED);
		}else{
			err=regcomp(&(Filter[Conf->nfilters].filter),filter,REG_EXTENDED|REG_ICASE);
		}
		if(err){
			regerror(err, &(Filter[Conf->nfilters].filter), regerrstr, ERRSTRSIZE);
			Conf->errcode=1;
			sprintf(Conf->errstr,"Wrong regex in config file: %s: %s", filter,regerrstr);
			regfree(&(Filter[Conf->nfilters].filter));
			return(1);
		}
	}
	Filter[Conf->nfilters].filter_type=filter_type;
	Filter[Conf->nfilters].flags=flags;
	Filter[Conf->nfilters].regstr=strdup(filter);
	Conf->nfilters++;
	return(0);
}

int UdmAddFilterStr(UDM_ENV * Conf,char * str,int cmd){
	char *s,*lt;
	int flags=UDM_FILTER_MATCH;

	s=UdmGetToken(str," \t\r\n",&lt);
	while((s=UdmGetToken(NULL," \t\r\n",&lt))){
		if(!strcasecmp(s,"case"))flags|=UDM_FILTER_CS;
		else
		if(!strcasecmp(s,"nocase"))flags&=~UDM_FILTER_CS;
		else
		if(!strcasecmp(s,"regex"))flags|=UDM_FILTER_REGEX;
		else
		if(!strcasecmp(s,"regexp"))flags|=UDM_FILTER_REGEX;
		else
		if(!strcasecmp(s,"string"))flags&=~UDM_FILTER_REGEX;
		else
		if(!strcasecmp(s,"nomatch"))flags&=~UDM_FILTER_MATCH;
		else
		if(!strcasecmp(s,"match"))flags|=UDM_FILTER_MATCH;
		else
		if(UdmAddFilter(Conf,s,cmd,flags))
			return(1);
	}
	return(0);
}

void UdmFreeFilters(UDM_ENV * Conf){
	size_t i;
	UDM_FILTER * Filter;
	Filter=(UDM_FILTER*)Conf->Filter;
	for(i=0; i < Conf->nfilters; i++){
		if(Filter[i].flags&UDM_FILTER_REGEX){
			regfree(&(Filter[i].filter));
		}
		free(Filter[i].regstr);
	}
	UDM_FREE(Conf->Filter);
	Conf->nfilters=0;
	Conf->mfilters=0;
}

#define NS 10
int UdmFindFilter(UDM_ENV * Conf,char * param,char * reason){
	size_t i;
	regmatch_t subs[NS];
	int err;
	UDM_FILTER * Filter;

	Filter=(UDM_FILTER *)Conf->Filter;
	reason[0]=0;
	for(i=0;i<Conf->nfilters;i++){
		if(Filter[i].flags&UDM_FILTER_REGEX){
			err=regexec(&(Filter[i].filter),param,NS,subs,0);
		}else{
			if(Filter[i].flags&UDM_FILTER_CS){
				err=UdmStrMatch(param,Filter[i].regstr);
			}else{
				err=UdmStrCaseMatch(param,Filter[i].regstr);
			}
		}
		if((!(Filter[i].flags&UDM_FILTER_MATCH))&&(err))
			break;
		if((Filter[i].flags&UDM_FILTER_MATCH)&&(!err))
			break;
	}
	if(i<Conf->nfilters){
		switch(Filter[i].filter_type){
			case UDM_ALLOW:		strcpy(reason,"Allow");break;
			case UDM_DISALLOW:	strcpy(reason,"Disallow");break;
			case UDM_HEAD:		strcpy(reason,"CheckOnly");break;
			case UDM_HREFONLY:	strcpy(reason,"HrefOnly");break;
			default:		strcpy(reason,"Unknown");break;
		}
		strcpy(UDM_STREND(reason),(Filter[i].flags&UDM_FILTER_MATCH)?"":"NoMatch");
		strcpy(UDM_STREND(reason),(Filter[i].flags&UDM_FILTER_CS)?" Case ":" NoCase ");
		strcpy(UDM_STREND(reason),(Filter[i].flags&UDM_FILTER_REGEX)?" Regex ":" ");
		strcpy(UDM_STREND(reason),Filter[i].regstr?Filter[i].regstr:"");
		return(Filter[i].filter_type);
	}
	strcpy(reason,"Allow by default");
	return(UDM_ALLOW);
}
