#include "sqlscript.h"
#include "my_sql.h"
#include "stringlist.h"
#include "stringres.h"
#include <qmenudta.h>
#include <qpopmenu.h>
#include <kfiledialog.h>
#include <fstream>
#include <iostream>
#include <qfile.h>
#include <qfileinf.h>
#include <qtextstream.h> 
#include <qlayout.h>
#include <kmsgbox.h>
#include <qmsgbox.h>
#include <kapp.h>
#include <qkeycode.h>
#include "scriptsplit.h"
#include "TextInput.h"
#include <qregexp.h>

#include <string>

#define Inherited CSqlScriptData

#ifndef rcs_id
static const char rcs_id[]="$Id: sqlscript.cpp,v 2.5 1999/11/28 15:40:11 ral Exp $";
#endif

CSqlScript::CSqlScript(CMySql*_sql_server,QWidget* parent,const char* name)
    :Inherited( parent, name )
{
    QBoxLayout*MainLayout = CHILD(this,QBoxLayout,"MainLayout");
    ResultText = "";
    ScriptText = "";
    ErrorText = "";
    search_text = "";
    sql_server = new CMySql(*_sql_server);
    status_Timer = NULL;
    sql_server->set_message_call_back(this);
    CloseButton->setText(CStringRes::get_string(113));
    std::string desc = "&";
    desc+=CStringRes::get_string(132);
    SubmitButton->setText(desc.c_str());
    if (MainLayout) {
	MenuBar = new QMenuBar(this);
	CHECK_PTR(MenuBar);
	QPopupMenu*file = new QPopupMenu;
	CHECK_PTR(file);
	file->insertItem(CStringRes::get_string(135),this,SLOT(new_script()));
	file->insertItem(CStringRes::get_string(133),this,SLOT(save_script()));
	file->insertItem(CStringRes::get_string(134),this,SLOT(load_script()));
	file->insertSeparator();
	file->insertItem(CStringRes::get_string(140),this,SLOT(saveResult()));
	file->insertSeparator();
	file->insertItem(CStringRes::get_string(113),this,SLOT(close_You()));
	MenuBar->insertItem(CStringRes::get_string(109),file);
	file = new QPopupMenu;
	file->insertItem(CStringRes::get_string(98),this,SLOT(searchText()),CTRL+Key_S);
	file->insertItem(CStringRes::get_string(141),this,SLOT(searchAgain()),Key_F3);
	QString text = "&";
	text+=CStringRes::get_string(142);
	MenuBar->insertItem(text,file);
	MainLayout->setMenuBar(MenuBar);
    }
    sql_server->set_message_call_back(this);
    StatusText->setText(CStringRes::get_string(136));
    OutputWindow->setFocus();
    connect(OutputWindow,SIGNAL(cursormove()),SLOT(set_cursor_info()));
    QFont font("Courier",12,50,0);
    font.setStyleHint((QFont::StyleHint)0);
    font.setCharSet((QFont::CharSet)0);
    OutputWindow->setFont(font);
    TabSelected(0);
}

CSqlScript::~CSqlScript()
{
    if (sql_server)
	delete sql_server;
}

void CSqlScript::close_You()
{
    QDialog::hide();
}

void CSqlScript::TabSelected(int i)
{
    if (last_tab == 0) {
	ScriptText = OutputWindow->text();
    }
    last_tab = i;
    switch (i) {
    case 0:
	OutputWindow->setText(ScriptText.c_str());
	OutputWindow->setReadOnly(false);
	SubmitButton->setEnabled(true);
	OutputWindow->show();
	break;
    case 1:
	OutputWindow->setText(ResultText.c_str());
	OutputWindow->setReadOnly(true);
	SubmitButton->setEnabled(false);
	break;
    case 2:
    default:
	OutputWindow->setText(ErrorText.c_str());
	OutputWindow->setReadOnly(true);
	SubmitButton->setEnabled(false);
	break;
    }
    OutputWindow->setFocus();
}

void CSqlScript::submit()
{
    ScriptText=OutputWindow->text();
    ResultText = "";
    ErrorText = "";
    TabBar->setCurrentTab(1);
    stringlist target,sizes,headers;
    stringlist commands;

    std::string _temp_result = "";
    StatusText->setText(CStringRes::get_string(139));
    KApplication::getKApplication()->processEvents(100);

    split_commands(commands);
    if (commands.size() > 200) {
	OutputWindow->setAutoUpdate(false);
    }
    bool had_errors = false;
    for (unsigned int i = 0; i < commands.size();++i) {
	target.resize(0);
	sizes.resize(0);
	headers.resize(0);
	int update_counter = 0;
	KApplication::getKApplication()->processEvents(100);
	if (!sql_server->do_statement(commands[i].c_str(),target,sizes,headers,true)) {
	    had_errors = true;
	    break;
	}
	if (target.size()==0) {
	    _temp_result+="\n";
	}
	std::string _temp="";
	unsigned underline = 0;
	if (headers.size() > 0) {
	    _temp+="| ";
	    for (unsigned int j = 0;j < headers.size();++j) {
		_temp+=headers[j];
		if (j < headers.size()-1)
		    _temp+=" | ";
	    }
	    _temp+=" |"; underline = _temp.size();_temp+="\n";_temp_result += _temp;_temp="";
	    _temp.resize(underline,'-');_temp+="\n";_temp_result+=_temp;_temp_result.insert(0,_temp);
	    commands[i]+=":\n";_temp_result.insert(0,commands[i]);
	}
	if (target.size()>0) {
	    for (unsigned int j = 0;j < target.size();++j) {
		std::string t = "| ";t+=target[j];

		size_t pos = t.find("\t");
		while (pos !=std::string::npos) {
		    t.insert(pos,1,' ');
		    ++pos;
		    t.replace(pos,1,'|');
		    t.insert(pos+1,1,' ');
		    pos = t.find("\t");
		}
		_temp_result+=t;_temp_result+=" |\n";_temp_result+=_temp;
	    }
	}
	if (ResultText.size()==0) {
	    OutputWindow->setText(_temp_result.c_str());
	} else {
	    _temp_result+="\n";
	    OutputWindow->append(_temp_result.c_str());
	    if (++update_counter == 500) {
		update_counter = 0;
		OutputWindow->repaint();
		KApplication::getKApplication()->processEvents(10);
	    }
	}
	ResultText+=_temp_result;
	_temp_result="";
    }
    if (commands.size() > 200) {
	OutputWindow->setAutoUpdate(true);
	OutputWindow->repaint();
    }
    if (had_errors) {
	setStatusText(CStringRes::get_string(137),5000);
	TabBar->setCurrentTab(2);
    } else {
	setStatusText(CStringRes::get_string(138),3000);
    }
}

void CSqlScript::split_commands(stringlist&target)
{
    target.resize(0);
    std::string _temp_str="";
    std::string _temp_str2 = ScriptText;

    CScriptSplit splitter(&target,&_temp_str2);

    splitter.convert();
}

void CSqlScript::save_string(std::string*contents,bool text_only)
{
    QString file_name;
    if (!text_only) 
	file_name = KFileDialog::getSaveFileName(0,"*.sql *.txt");
    else
	file_name = KFileDialog::getSaveFileName(0,"*.txt");
    QString message;
    QFileInfo finfo;
    int i;

    if (file_name.isEmpty())
	return;
    finfo.setFile(file_name);
    if (finfo.isDir()) {
	QMessageBox::warning(this,CStringRes::get_string(83),
			     CStringRes::get_string(84));
	return;
    }

    if (QFile::exists(file_name)) {
	message = CStringRes::get_string(85);
	message+="\n\n";
	message+=file_name;message+="\n\n";
	message+=CStringRes::get_string(86);
	message+="\n";
	i = KMsgBox::yesNo( this, CStringRes::get_string(87),
			    message,KMsgBox::QUESTION);
	if (i != 1 )
	    return;

	if (!finfo.isWritable()) {
	    QMessageBox::warning(this,CStringRes::get_string(83),
				 CStringRes::get_string(88));
	    return;
	}
    }
    QFile outfile(file_name);
    outfile.open(IO_WriteOnly|IO_Truncate);
    if (!outfile.isOpen()) 
	return;
    QTextStream st(&outfile);
    st << contents->c_str();
    outfile.close();
}

void CSqlScript::load_script()
{
    QString file_name = KFileDialog::getOpenFileName(0,"*.sql *.txt");
    QFile ifs(file_name);
    if (!ifs.open(IO_ReadOnly) )
	return;
    ScriptText = "";
    QTextStream t(&ifs);
    while (!t.eof()) {
	ScriptText+=t.readLine();ScriptText+="\n";
    }
    ifs.close();
    TabBar->setCurrentTab(0);
    OutputWindow->setText(ScriptText.c_str());
}

void CSqlScript::save_script()
{
    if (TabBar->currentTab()==0) {
	ScriptText = OutputWindow->text();
	save_string(&ScriptText,false);
    } else {
	
    }
}

void CSqlScript::new_script()
{
    ScriptText = "";
    ResultText = "";
    ErrorText = "";
    TabBar->setCurrentTab(0);
    OutputWindow->setText(ScriptText.c_str());
}

void CSqlScript::append_message(const std::string&message)
{
    ErrorText+="\n";
    ErrorText+=message;
}

void CSqlScript::append_message(const char*message)
{
    if (message && strlen(message)) {
	ErrorText+="\n";
	ErrorText+=message;
    }
}

void CSqlScript::setStatusText(const char*text,unsigned int timeout)
{
    unsigned int iTimer = timeout;
    if (iTimer == 0)
	iTimer = 2000;
    if (!status_Timer) {
	status_Timer = new QTimer(this);
	connect( status_Timer, SIGNAL(timeout()), SLOT(statusTimeout()) );
    }
    if (text && strlen(text)>0)
	StatusText->setText(text);
    status_Timer->start(iTimer,TRUE);
}

void CSqlScript::statusTimeout()
{
    StatusText->setText(CStringRes::get_string(136));
}

void CSqlScript::saveResult()
{
    if (TabBar->currentTab()==1) {
	ResultText = OutputWindow->text();
	save_string(&ResultText,true);
    }
}

void CSqlScript::searchText()
{
    CTextInput textdlg(this);
    QString title = CStringRes::get_string(125);
    title+=CStringRes::get_string(143);
    textdlg.setCaption(title);
    textdlg.set_label_text(CStringRes::get_string(144));
    if (textdlg.exec()) {
	title = textdlg.get_text();
	if (title.isEmpty())
	    return;
	search_text = title;
	search_forward();
    }
}

void CSqlScript::searchAgain()
{
    if (search_text.size() == 0)
	return;
    search_forward();
}

void CSqlScript::search_forward()
{
    if (OutputWindow->numLines() <=1)
	return;
    int current_line, current_pos;

    QRegExp reg(search_text.c_str(),FALSE);

    OutputWindow->cursorPosition(&current_line,&current_pos);
    int i;
    int pos,length;
    for (i = current_line; i < OutputWindow->numLines(); ++i) {
	std::string _search = OutputWindow->textLine(i);
	pos = reg.match(_search.c_str(),current_pos,&length);
	current_pos = 0;
	if (pos > -1)
	    break;
    }
    if (pos != -1) {
	OutputWindow->setCursorPosition(i,pos);
	OutputWindow->setCursorPosition(i,pos+search_text.size(),TRUE);
    }
    set_cursor_info();
}

void CSqlScript::keyPressEvent(QKeyEvent*e)
{
    CSqlScriptData::keyPressEvent(e);
    set_cursor_info();
}

void CSqlScript::set_cursor_info()
{
    int line,col;
    OutputWindow->getCursorPosition(&line,&col);
    QString text;
    text.sprintf("Line: %i Col: %i",line,col);
    CursorPosText->setText(text);
}
